package com.ejianc.business.finance.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.finance.service.IPayContractService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedLongTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.ParsedSum;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

@RestController
@RequestMapping(value = "/report/")
public class ReportController {
    @Autowired
    private IPayContractService reportService;


    /***************  报表工具做不了的资金报表  *****************/


    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private RestHighLevelClient client;


    // 月度回款统计索引
    private final String INDEX_MONTH_RECEIVE_MNY = "month_receive_mny";


    // 年度计划资金收支
    private final String YEAR_FINANCE_PAY_REC = "year_finance_pay_rec";


    public final static Integer QUERY_TIMEOUT = 60;

    private static Map<Integer, String> MONTH_MAP = new HashMap<>();

    static {
        MONTH_MAP.put(1, "一月");
        MONTH_MAP.put(2, "二月");
        MONTH_MAP.put(3, "三月");
        MONTH_MAP.put(4, "四月");
        MONTH_MAP.put(5, "五月");
        MONTH_MAP.put(6, "六月");
        MONTH_MAP.put(7, "七月");
        MONTH_MAP.put(8, "八月");
        MONTH_MAP.put(9, "九月");
        MONTH_MAP.put(10, "十月");
        MONTH_MAP.put(11, "十一月");
        MONTH_MAP.put(12, "十二月");

    }


    // 年度计划资金收支
    List<String> YEAR_PAY_REC_KEY_LIST = Arrays.asList(
            "planPayMny",
            "actPayMny",
            "jihuashijichaezhichu",
            "planRecMny",
            "actRecMny",
            "jihuashijichaeshouru"
    );


    // 月度回款
    List<String> MONTH_REC_KEY_LIST = Arrays.asList(
            "recMny",
            "recCount",
            "openInvoiceMny",
            "openInvoiceCount",
            "contractTaxMny",
            "contractCount"
    );

    /**
     * @description: 年度计划资金收支
     *
     * @author songlx
     * @date: 2022/9/22
     */
    @RequestMapping(value = "/queryYearPayRec", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryYearPayRec(@RequestBody QueryParam param) {
        JSONObject resVO = this.queryYearPayRecData(param);
        return CommonResponse.success("年度计划资金收支！", resVO);
    }

    /**
     * @description: 导出年度计划资金收支
     * @return
     * @author songlx
     * @date: 2022/9/23
     */
    @RequestMapping(value = "/exportYearPayRec", method = RequestMethod.POST)
    @ResponseBody
    public void exportYearPayRec(@RequestBody QueryParam param, HttpServletResponse response) {
        JSONObject resVO = this.queryYearPayRecData(param);
        Object records = resVO.get("records");
        ArrayList<JSONObject> tableData = (ArrayList<JSONObject>) records;
        tableData = this.getSumRecords(tableData, YEAR_PAY_REC_KEY_LIST);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", tableData);
        ExcelExport.getInstance().export("year-pay-rec-export.xlsx", beans, response);
    }

    private JSONObject queryYearPayRecData(QueryParam param) {
        JSONObject resVO = new JSONObject();
        JSONObject echartData = new JSONObject();

        SearchRequest searchRequest = new SearchRequest(YEAR_FINANCE_PAY_REC);
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        boolQuery.must(QueryBuilders.termQuery("tenantId", InvocationInfoProxy.getTenantid().toString()));
        boolQuery.must(QueryBuilders.termsQuery("orgId", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        Parameter yyearPara = param.getParams().get("yyear");
        String yyear = yyearPara != null ? String.valueOf(yyearPara.getValue()) : null;
        if (StringUtils.isNotBlank(yyear)) {
            boolQuery.must(QueryBuilders.termQuery("yyear", yyear));
        }
        //分组
        TermsAggregationBuilder aggregation = AggregationBuilders.terms("timeGroup").field("mmonth");

        for (String key : YEAR_PAY_REC_KEY_LIST) {
            aggregation.subAggregation(AggregationBuilders.sum(key).field(key));
        }

        sourceBuilder.aggregation(aggregation);
        sourceBuilder.query(boolQuery);
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue(QUERY_TIMEOUT, TimeUnit.SECONDS)); //设置超时时间
        searchRequest.source(sourceBuilder);


        try {
            SearchResponse search = client.search(searchRequest, RequestOptions.DEFAULT);
            Aggregations aggregations = search.getAggregations();
            ParsedLongTerms terms = aggregations.get("timeGroup");
            List<? extends Terms.Bucket> buckets = terms.getBuckets();


            Map tableDataMap = new HashMap<Integer, JSONObject>();

            // 查询到的月份合计数据， key = 月份+ 字段名 ，val是合计值
            Map echartItemDataMap = new HashMap<String, BigDecimal>();

            BigDecimal[] planPayMnyArr = new BigDecimal[12];
            BigDecimal[] actPayMnyArr = new BigDecimal[12];
            BigDecimal[] planActPayDiffMnyArr = new BigDecimal[12];
            BigDecimal[] planRecMnyArr = new BigDecimal[12];
            BigDecimal[] actRecMnyArr = new BigDecimal[12];
            BigDecimal[] planActRecDiffMnyArr = new BigDecimal[12];


            for (Terms.Bucket bucket : buckets) {
                Integer mmonth = Integer.valueOf(String.valueOf(bucket.getKey()));
                Aggregations bucketAggregations = bucket.getAggregations();
                JSONObject itemObj = new JSONObject();
                itemObj.put("month", mmonth);
                itemObj.put("monthStr", MONTH_MAP.get(mmonth));
                for (String key : YEAR_PAY_REC_KEY_LIST) {
                    ParsedSum productionSumRes = bucketAggregations.get(key);
                    BigDecimal val = ComputeUtil.toBigDecimal(productionSumRes.getValue());
                    itemObj.put(key, val);
                    echartItemDataMap.put(mmonth + key, val);
                }
                tableDataMap.put(mmonth, itemObj);
            }

            Set<Map.Entry<Integer, String>> monEntry = MONTH_MAP.entrySet();
            for (Map.Entry<Integer, String> m : monEntry) {
                Integer mon = m.getKey();
                String monStr = m.getValue();
                //构建表格数据
                if (!tableDataMap.containsKey(mon)) {
                    JSONObject itemObj = new JSONObject();
                    itemObj.put("month", mon);
                    itemObj.put("monthStr", monStr);
                    for (String key : YEAR_PAY_REC_KEY_LIST) {
                        itemObj.put(key, BigDecimal.ZERO);
                    }
                    tableDataMap.put(mon, itemObj);
                }

                for (String key : YEAR_PAY_REC_KEY_LIST) {
                    BigDecimal val = ComputeUtil.nullToZero(ComputeUtil.toBigDecimal(echartItemDataMap.get(mon + key)));

                    if ("planPayMny".equals(key)) {
                        planPayMnyArr[mon - 1] = val;
                    } else if ("actPayMny".equals(key)) {
                        actPayMnyArr[mon - 1] = val;
                    } else if ("jihuashijichaezhichu".equals(key)) {
                        planActPayDiffMnyArr[mon - 1] = val;
                    } else if ("planRecMny".equals(key)) {
                        planRecMnyArr[mon - 1] = val;
                    } else if ("actRecMny".equals(key)) {
                        actRecMnyArr[mon - 1] = val;
                    } else if ("jihuashijichaeshouru".equals(key)) {
                        planActRecDiffMnyArr[mon - 1] = val;
                    }
                }
            }

            //表格数据按照月份排序
            ArrayList tableData = new ArrayList(tableDataMap.values());

            Collections.sort(tableData, (Comparator<JSONObject>) (o1, o2) -> {
                Integer m1 = Integer.valueOf(String.valueOf(o1.get("month")));
                Integer m2 = Integer.valueOf(String.valueOf(o2.get("month")));
                //升序
                return m1.compareTo(m2);
            });

            echartData.put("month", new ArrayList<>(MONTH_MAP.values()));

            echartData.put("planPayMny", planPayMnyArr);
            echartData.put("actPayMnyMny", actPayMnyArr);
            echartData.put("planActPayDiffMny", planActPayDiffMnyArr);

            echartData.put("planRecMny", planRecMnyArr);
            echartData.put("actRecMny", actRecMnyArr);
            echartData.put("planActRecDiffMny", planActRecDiffMnyArr);


            resVO.put("records", tableData);
            resVO.put("echartData", echartData);


        } catch (IOException e) {
            e.printStackTrace();
        }

        return resVO;
    }


    /**
     * @description: 月度回款统计
     *
     * @author songlx
     * @date: 2022/9/22
     */
    @RequestMapping(value = "/queryMonthRec", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryMonthRec(@RequestBody QueryParam param) {
        JSONObject resVO = this.queryMonthRecData(param);
        return CommonResponse.success("月度回款统计！", resVO);
    }

    /**
     * @description: 导出月度回款统计
     * @return
     * @author songlx
     * @date: 2022/9/23
     */
    @RequestMapping(value = "/exportMonthRec", method = RequestMethod.POST)
    @ResponseBody
    public void exportMonthRec(@RequestBody QueryParam param, HttpServletResponse response) {
        JSONObject resVO = this.queryMonthRecData(param);
        Object records = resVO.get("records");
        ArrayList<JSONObject> tableData = (ArrayList<JSONObject>) records;
        tableData = this.getSumRecords(tableData, MONTH_REC_KEY_LIST);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", tableData);
        ExcelExport.getInstance().export("month-receive-mny-export.xlsx", beans, response);
    }

    /**
     * @description: 给数据加入合计行
     * @param tableData
     * @param keyList
     * @return {@link java.util.ArrayList<com.alibaba.fastjson.JSONObject>}
     * @author songlx
     * @date: 2022/9/28
     */
    private ArrayList<JSONObject> getSumRecords(ArrayList<JSONObject> tableData, List<String> keyList) {
        JSONObject sumObj = new JSONObject();
        sumObj.put("monthStr", "合计");
        for (String dataKey : keyList) {
            Object v = sumObj.get(dataKey);
            BigDecimal sum = ComputeUtil.toBigDecimal(v);
            for (JSONObject tableDatum : tableData) {
                Object _add = tableDatum.get(dataKey);

                BigDecimal add = ComputeUtil.toBigDecimal(_add);
                sum = ComputeUtil.safeAdd(sum, add);
            }
            sumObj.put(dataKey, sum);
        }
        tableData.add(sumObj);
        return tableData;
    }

    private JSONObject queryMonthRecData(QueryParam param) {
        JSONObject resVO = new JSONObject();
        JSONObject echartData = new JSONObject();

        SearchRequest searchRequest = new SearchRequest(INDEX_MONTH_RECEIVE_MNY);
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        boolQuery.must(QueryBuilders.termQuery("tenantId", InvocationInfoProxy.getTenantid().toString()));
        boolQuery.must(QueryBuilders.termsQuery("orgId", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        Parameter yyearPara = param.getParams().get("yyear");
        String yyear = yyearPara != null ? String.valueOf(yyearPara.getValue()) : null;
        if (StringUtils.isNotBlank(yyear)) {
            boolQuery.must(QueryBuilders.termQuery("yyear", yyear));
        }
        //f分组
        TermsAggregationBuilder aggregation = AggregationBuilders.terms("timeGroup").field("mmonth");

        for (String key : MONTH_REC_KEY_LIST) {
            aggregation.subAggregation(AggregationBuilders.sum(key).field(key));
        }

        sourceBuilder.aggregation(aggregation);
        sourceBuilder.query(boolQuery);
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue(QUERY_TIMEOUT, TimeUnit.SECONDS)); //设置超时时间
        searchRequest.source(sourceBuilder);


        try {
            SearchResponse search = client.search(searchRequest, RequestOptions.DEFAULT);
            Aggregations aggregations = search.getAggregations();
            ParsedLongTerms terms = aggregations.get("timeGroup");
            List<? extends Terms.Bucket> buckets = terms.getBuckets();


            Map tableDataMap = new HashMap<Integer, JSONObject>();

            // 查询到的月份合计数据， key = 月份+ 字段名 ，val是合计值
            Map echartItemDataMap = new HashMap<String, BigDecimal>();
            BigDecimal[] recMnyArr = new BigDecimal[12];
            BigDecimal[] openInvoiceMnyArr = new BigDecimal[12];
            BigDecimal[] contractTaxMnyArr = new BigDecimal[12];


            for (Terms.Bucket bucket : buckets) {
                Integer mmonth = Integer.valueOf(String.valueOf(bucket.getKey()));
                Aggregations bucketAggregations = bucket.getAggregations();
                JSONObject itemObj = new JSONObject();
                itemObj.put("month", mmonth);
                itemObj.put("monthStr", MONTH_MAP.get(mmonth));
                for (String key : MONTH_REC_KEY_LIST) {
                    ParsedSum productionSumRes = bucketAggregations.get(key);
                    BigDecimal val = ComputeUtil.toBigDecimal(productionSumRes.getValue());
                    itemObj.put(key, val);
                    echartItemDataMap.put(mmonth + key, val);
                }
                tableDataMap.put(mmonth, itemObj);
            }

            Set<Map.Entry<Integer, String>> monEntry = MONTH_MAP.entrySet();
            for (Map.Entry<Integer, String> m : monEntry) {
                Integer mon = m.getKey();
                String monStr = m.getValue();
                //构建表格数据
                if (!tableDataMap.containsKey(mon)) {
                    JSONObject itemObj = new JSONObject();
                    itemObj.put("month", mon);
                    itemObj.put("monthStr", monStr);
                    for (String key : MONTH_REC_KEY_LIST) {
                        itemObj.put(key, BigDecimal.ZERO);
                    }
                    tableDataMap.put(mon, itemObj);
                }

                for (String key : MONTH_REC_KEY_LIST) {
                    BigDecimal val = ComputeUtil.nullToZero(ComputeUtil.toBigDecimal(echartItemDataMap.get(mon + key)));
                    if ("recMny".equals(key)) {
                        recMnyArr[mon - 1] = val;
                    } else if ("openInvoiceMny".equals(key)) {
                        openInvoiceMnyArr[mon - 1] = val;
                    } else if ("contractTaxMny".equals(key)) {
                        contractTaxMnyArr[mon - 1] = val;
                    }
                }
            }

            //表格数据按照月份排序
            ArrayList tableData = new ArrayList(tableDataMap.values());

            Collections.sort(tableData, (Comparator<JSONObject>) (o1, o2) -> {
                Integer m1 = Integer.valueOf(String.valueOf(o1.get("month")));
                Integer m2 = Integer.valueOf(String.valueOf(o2.get("month")));
                //升序
                return m1.compareTo(m2);
            });

            echartData.put("month", new ArrayList<>(MONTH_MAP.values()));
            echartData.put("recMny", recMnyArr);
            echartData.put("openInvoiceMny", openInvoiceMnyArr);
            echartData.put("contractTaxMny", contractTaxMnyArr);


            resVO.put("records", tableData);
            resVO.put("echartData", echartData);


        } catch (IOException e) {
            e.printStackTrace();
        }

        return resVO;
    }


    /***************  移动看板start  *****************/
    /**
     * 根据项目id，查询项目进度数据
     *
     * @return
     */
    @RequestMapping(value = "/projectProgress", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> projectProgress(@RequestParam(value = "projectId") Long projectId,
                                                      @RequestParam(value = "startDate", required = false) Date startDate,
                                                      @RequestParam(value = "endDate", required = false) Date endDate) {
        return CommonResponse.success("查询列表数据成功！", reportService.projectProgress(projectId, startDate, endDate));
    }

    /**
     * 根据项目id，查询项目收入数据
     *
     * @return
     */
    @RequestMapping(value = "/projectIncome", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> projectProgress(@RequestParam(value = "projectId") Long projectId) {
        return CommonResponse.success("查询列表数据成功！", reportService.projectIncome(projectId));
    }

    /**
     * 根据项目id，查询项目支出数据
     *
     * @return
     */
    @RequestMapping(value = "/projectOut", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> projectOut(@RequestParam(value = "projectId") Long projectId) {
        return CommonResponse.success("查询列表数据成功！", reportService.projectOut(projectId));
    }
    /***************  移动看板end    *****************/
}
