/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.accplat.consts.SystemCodeEnum;
import com.ejianc.business.finance.bean.BondUpDealEntity;
import com.ejianc.business.finance.bean.BondUpEntity;
import com.ejianc.business.finance.service.IBondUpDealService;
import com.ejianc.business.finance.service.IBondUpService;
import com.ejianc.business.finance.vo.BondUpDealRentVO;
import com.ejianc.business.finance.vo.BondUpDealVO;
import com.ejianc.business.voucher.api.IVoucherApi;
import com.ejianc.business.voucher.utils.DataConvertUtil;
import com.ejianc.business.voucher.vo.VoucherInfo;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bondUpDeal"})
public class BondUpDealController {
    @Autowired
    private IBondUpDealService bondUpDealService;
    @Autowired
    private IBondUpService bondUpService;
    @Autowired
    private IVoucherApi voucherApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BondUpDealVO> saveOrUpdate(@RequestBody BondUpDealVO bondUpDealVO) {
        BondUpDealVO backVO = this.bondUpDealService.insertOrUpdate(bondUpDealVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)backVO);
    }

    @RequestMapping(value={"/pushVoucher"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse pushVoucher(@RequestBody VoucherInfo voucherInfo) {
        Long billId = voucherInfo.getBillId();
        Assert.notNull((Object)billId, (String)"\u5355\u636ebillId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        BondUpDealEntity entity = (BondUpDealEntity)((Object)this.bondUpDealService.selectById(billId));
        BondUpEntity bondUpEntity = (BondUpEntity)((Object)this.bondUpService.selectById(entity.getBondId()));
        JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)entity)));
        jsonObject.put("orgId", (Object)bondUpEntity.getOrgId());
        VoucherParams voucherParams = VoucherParams.newInstanceByOrgId((String)"BT200622000000001", (Object)jsonObject, (SystemCodeEnum)SystemCodeEnum.FINANCE);
        CommonResponse response = this.voucherApi.handleVoucher(voucherParams, "save");
        if (response.isSuccess()) {
            this.logger.info("response: {}", (Object)DataConvertUtil.toPrettyFormat((Object)response));
            voucherInfo = (VoucherInfo)response.getData();
            LambdaUpdateWrapper lambda = new LambdaUpdateWrapper();
            lambda.eq(BaseEntity::getId, (Object)entity.getId());
            lambda.set(BondUpDealEntity::getVoucherInfo, (Object)DataConvertUtil.objToString((Object)voucherInfo));
            lambda.set(BondUpDealEntity::getVoucherFlag, (Object)voucherInfo.getVoucherFlag());
            boolean update = this.bondUpDealService.update((Wrapper)lambda);
            this.logger.info("update: {}", (Object)update);
        }
        return response;
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BondUpDealRentVO> queryDetail(Long id) {
        BondUpDealRentVO backVO = this.bondUpDealService.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)backVO);
    }
}

