/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.ejianc.business.finance.bean.BondDownDealEntity;
import com.ejianc.business.finance.bean.BondDownEntity;
import com.ejianc.business.finance.mapper.BondDownDealMapper;
import com.ejianc.business.finance.service.IBondDownDealService;
import com.ejianc.business.finance.service.IBondDownService;
import com.ejianc.business.finance.vo.BondDownDealRentVO;
import com.ejianc.business.finance.vo.BondDownDealVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BondDownDealServiceImpl
extends BaseServiceImpl<BondDownDealMapper, BondDownDealEntity>
implements IBondDownDealService {
    private static final String BONGDOWN_DEAL = "BONGDOWN_DEAL";
    @Autowired
    private IBondDownService bondDownService;
    @Autowired
    private IBillCodeApi billCodeApi;

    @Override
    public BondDownDealVO insertOrUpdate(BondDownDealVO bondDownDealVO) {
        LambdaQueryWrapper lambda;
        Long tenantId = InvocationInfoProxy.getTenantid();
        List entities = null;
        if (StringUtils.isEmpty((CharSequence)bondDownDealVO.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BONGDOWN_DEAL, tenantId);
            if (billCode.isSuccess()) {
                bondDownDealVO.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        BondDownDealEntity entity = (BondDownDealEntity)((Object)BeanMapper.map((Object)bondDownDealVO, BondDownDealEntity.class));
        if (null != bondDownDealVO.getId() && bondDownDealVO.getId() > 0L) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BondDownDealEntity::getBillCode, (Object)bondDownDealVO.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)bondDownDealVO.getId());
            entities = super.list((Wrapper)lambda);
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)entity.getId());
            updateWrapper.set(BondDownDealEntity::getDealStatus, (Object)"2");
            super.update((Wrapper)updateWrapper);
            entity.setId(null);
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(BondDownDealEntity::getBillCode, (Object)bondDownDealVO.getBillCode());
            entities = super.list((Wrapper)lambda);
        }
        if (entities != null && entities.size() > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        entity.setDealStatus("1");
        entity.setDealTime(new Date());
        super.saveOrUpdate((Object)entity, false);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)entity.getBondId());
        updateWrapper.set(BondDownEntity::getBondStatus, (Object)"1");
        updateWrapper.set(BondDownEntity::getBeginDate, (Object)entity.getBeginDate());
        updateWrapper.set(BondDownEntity::getEndDate, (Object)entity.getEndDate());
        updateWrapper.set(BondDownEntity::getEmployeeId, (Object)entity.getEmployeeId());
        updateWrapper.set(BondDownEntity::getEmployeeName, (Object)entity.getEmployeeName());
        updateWrapper.set(BondDownEntity::getPayMny, (Object)entity.getBondMny());
        updateWrapper.set(BondDownEntity::getBondType, (Object)entity.getBondType());
        updateWrapper.set(BondDownEntity::getDealTime, (Object)entity.getDealTime());
        this.bondDownService.update((Wrapper)updateWrapper);
        return (BondDownDealVO)BeanMapper.map((Object)((Object)entity), BondDownDealVO.class);
    }

    @Override
    public BondDownDealRentVO queryDetail(Long id) {
        BondDownDealRentVO vo = new BondDownDealRentVO();
        BondDownEntity upEntity = (BondDownEntity)((Object)this.bondDownService.selectById(id));
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(BondDownDealEntity::getBondId, (Object)id);
        lambda.orderBy(true, true, (Object[])new SFunction[]{BondDownDealEntity::getDealStatus});
        List list = super.list((Wrapper)lambda);
        vo = (BondDownDealRentVO)BeanMapper.map((Object)((Object)upEntity), BondDownDealRentVO.class);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            vo.setDealRecord(BeanMapper.mapList((Iterable)list, BondDownDealVO.class));
        }
        return vo;
    }
}

