package com.ejianc.business.finance.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 付款申请记录实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_finance_pay_record")
public class PayRecordEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="payapply_id")
    private Long payapplyId; // 付款申请主键
    @TableField(value="apply_type")
    private String applyType; // 付款申请类型：合同付款，零星采购，报销，押金
    @TableField(value="contract_id")
    private Long contractId; // 合同主键
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField("contract_type")
    private Long contractType;// 合同类型：1-分包,2-设备采购,3-设备租赁,4-物资采购,5-物资租赁
    @TableField(value="fee_type")
    private Long feeType; // 支付类型：1-预付款，2-过程款，3-其他
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="confirm_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private java.util.Date confirmTime; // 经办时间
    @TableField(value="approve_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private java.util.Date approveTime; // 审批时间
    @TableField(value="this_pay_mny")
    private java.math.BigDecimal thisPayMny; // 本期支付金额
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="apply_user_id")
    private Long applyUserId; // 申请人
    @TableField(value="apply_user_name")
    private String applyUserName; // 申请人名称
    @TableField(value="apply_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private java.util.Date applyTime; // 申请时间
    @TableField(value="apply_mny")
    private java.math.BigDecimal applyMny; // 申请金额
    @TableField(value="not_credited_mny")
    private java.math.BigDecimal notCreditedMny; // 不入账金额
    @TableField(value="receive_unit_id")
    private Long receiveUnitId; // 收款单位
    @TableField(value="receive_unit_name")
    private String receiveUnitName; // 收款单位名称
    @TableField(value="receive_notes_id")
    private Long receiveNotesId; // 应收票据
    @TableField(value="receive_notes_name")
    private String receiveNotesName; // 应收票据
    @TableField(value="pay_notes_id")
    private Long payNotesId; // 应付票据
    @TableField(value="pay_notes_name")
    private String payNotesName; // 应付票据
    @TableField(value="billing_room_id")
    private Long billingRoomId; // 抵账房
    @TableField(value="billing_room_name")
    private String billingRoomName; // 抵账房
    @TableField(value="car_model_id")
    private Long carModelId; // 车辆型号
    @TableField(value="car_model_name")
    private String carModelName; // 车辆型号
    @TableField(value="material_info")
    private String materialInfo; // 物品信息
    @TableField(value="account_id")
    private Long accountId; // 付款账户名
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="payRecordSettleService",pidName = "recordId")
    private List<PayRecordSettleEntity> settleList = new ArrayList<>(); // 付款申请记录结算实体

    @TableField(value="account_name")
    private String accountName; // 账户名称
    @TableField(value="account_num")
    private String accountNum; // 银行账号
    @TableField(value="account_bank")
    private String accountBank; // 开户行
    @TableField(value="pay_way")
    private Long payWay; // 付款方式
    @TableField(value="pay_way_name")
    private String payWayName; // 付款方式名称

    /**
     * 推送凭证标识
     */
    @TableField("voucher_flag")
    private Integer voucherFlag;

    /**
     * 凭证信息json
     */
    @TableField("voucher_info")
    private String voucherInfo;


    public Integer getVoucherFlag() {
        return voucherFlag;
    }

    public void setVoucherFlag(Integer voucherFlag) {
        this.voucherFlag = voucherFlag;
    }

    public String getVoucherInfo() {
        return voucherInfo;
    }

    public void setVoucherInfo(String voucherInfo) {
        this.voucherInfo = voucherInfo;
    }

    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getAccountNum() {
        return accountNum;
    }

    public void setAccountNum(String accountNum) {
        this.accountNum = accountNum;
    }

    public String getAccountBank() {
        return accountBank;
    }

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public void setAccountBank(String accountBank) {
        this.accountBank = accountBank;
    }

    public Long getReceiveNotesId() {
        return receiveNotesId;
    }

    public void setReceiveNotesId(Long receiveNotesId) {
        this.receiveNotesId = receiveNotesId;
    }

    public String getReceiveNotesName() {
        return receiveNotesName;
    }

    public void setReceiveNotesName(String receiveNotesName) {
        this.receiveNotesName = receiveNotesName;
    }

    public Long getPayNotesId() {
        return payNotesId;
    }

    public BigDecimal getNotCreditedMny() {
        return notCreditedMny;
    }

    public void setNotCreditedMny(BigDecimal notCreditedMny) {
        this.notCreditedMny = notCreditedMny;
    }

    public void setPayNotesId(Long payNotesId) {
        this.payNotesId = payNotesId;
    }

    public String getPayNotesName() {
        return payNotesName;
    }

    public void setPayNotesName(String payNotesName) {
        this.payNotesName = payNotesName;
    }

    public Long getBillingRoomId() {
        return billingRoomId;
    }

    public void setBillingRoomId(Long billingRoomId) {
        this.billingRoomId = billingRoomId;
    }

    public String getBillingRoomName() {
        return billingRoomName;
    }

    public void setBillingRoomName(String billingRoomName) {
        this.billingRoomName = billingRoomName;
    }

    public Long getCarModelId() {
        return carModelId;
    }

    public void setCarModelId(Long carModelId) {
        this.carModelId = carModelId;
    }

    public String getCarModelName() {
        return carModelName;
    }

    public void setCarModelName(String carModelName) {
        this.carModelName = carModelName;
    }

    public String getMaterialInfo() {
        return materialInfo;
    }

    public void setMaterialInfo(String materialInfo) {
        this.materialInfo = materialInfo;
    }

    /**
     * 付款申请主键
     */
    public Long getPayapplyId() {
        return payapplyId;
    }

    /**
     * 付款申请主键
     */
    public void setPayapplyId(Long payapplyId) {
        this.payapplyId = payapplyId;
    }
    /**
     * 付款申请类型：合同付款，零星采购，报销，押金
     */
    public String getApplyType() {
        return applyType;
    }

    /**
     * 付款申请类型：合同付款，零星采购，报销，押金
     */
    public void setApplyType(String applyType) {
        this.applyType = applyType;
    }
    /**
     * 合同主键
     */
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同主键
     */
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同类型：1-分包,2-设备采购,3-设备租赁,4-物资采购,5-物资租赁
     */
    public Long getContractType() {
        return contractType;
    }

    /**
     * 合同类型：1-分包,2-设备采购,3-设备租赁,4-物资采购,5-物资租赁
     */
    public void setContractType(Long contractType) {
        this.contractType = contractType;
    }
    /**
     * 支付类型：1-预付款，2-过程款，3-其他
     */
    public Long getFeeType() {
        return feeType;
    }

    /**
     * 支付类型：1-预付款，2-过程款，3-其他
     */
    public void setFeeType(Long feeType) {
        this.feeType = feeType;
    }
    /**
     * 经办人
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 经办时间
     */
    public java.util.Date getConfirmTime() {
        return confirmTime;
    }

    /**
     * 经办时间
     */
    public void setConfirmTime(java.util.Date confirmTime) {
        this.confirmTime = confirmTime;
    }
    /**
     * 审批时间
     */
    public java.util.Date getApproveTime() {
        return approveTime;
    }

    /**
     * 审批时间
     */
    public void setApproveTime(java.util.Date approveTime) {
        this.approveTime = approveTime;
    }
    /**
     * 本期支付金额
     */
    public java.math.BigDecimal getThisPayMny() {
        return thisPayMny;
    }

    /**
     * 本期支付金额
     */
    public void setThisPayMny(java.math.BigDecimal thisPayMny) {
        this.thisPayMny = thisPayMny;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 项目
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 申请人
     */
    public Long getApplyUserId() {
        return applyUserId;
    }

    /**
     * 申请人
     */
    public void setApplyUserId(Long applyUserId) {
        this.applyUserId = applyUserId;
    }
    /**
     * 申请人名称
     */
    public String getApplyUserName() {
        return applyUserName;
    }

    /**
     * 申请人名称
     */
    public void setApplyUserName(String applyUserName) {
        this.applyUserName = applyUserName;
    }
    /**
     * 申请时间
     */
    public java.util.Date getApplyTime() {
        return applyTime;
    }

    /**
     * 申请时间
     */
    public void setApplyTime(java.util.Date applyTime) {
        this.applyTime = applyTime;
    }
    /**
     * 申请金额
     */
    public BigDecimal getApplyMny() {
        return applyMny;
    }

    /**
     * 申请金额
     */
    public void setApplyMny(BigDecimal applyMny) {
        this.applyMny = applyMny;
    }
    /**
     * 收款单位
     */
    public Long getReceiveUnitId() {
        return receiveUnitId;
    }

    /**
     * 收款单位
     */
    public void setReceiveUnitId(Long receiveUnitId) {
        this.receiveUnitId = receiveUnitId;
    }
    /**
     * 收款单位名称
     */
    public String getReceiveUnitName() {
        return receiveUnitName;
    }

    /**
     * 收款单位名称
     */
    public void setReceiveUnitName(String receiveUnitName) {
        this.receiveUnitName = receiveUnitName;
    }

    public Long getPayWay() {
        return payWay;
    }

    public void setPayWay(Long payWay) {
        this.payWay = payWay;
    }

    public String getPayWayName() {
        return payWayName;
    }

    public void setPayWayName(String payWayName) {
        this.payWayName = payWayName;
    }

    /**
     * 付款申请记录结算实体
     */
    public List<PayRecordSettleEntity> getSettleList() {
        return settleList;
    }

    /**
     * 付款申请记录结算实体
     */
    public void setSettleList(List<PayRecordSettleEntity> settleList) {
        this.settleList = settleList;
    }
}
