package com.ejianc.business.finance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.accplat.consts.SystemCodeEnum;
import com.ejianc.business.finance.bean.BondUpDealEntity;
import com.ejianc.business.finance.bean.BondUpEntity;
import com.ejianc.business.finance.bean.DeductionEntity;
import com.ejianc.business.finance.mapper.BondUpDealMapper;
import com.ejianc.business.finance.service.IBondUpDealService;
import com.ejianc.business.finance.service.IBondUpService;
import com.ejianc.business.finance.vo.BondUpDealRentVO;
import com.ejianc.business.finance.vo.BondUpDealVO;
import com.ejianc.business.voucher.api.IVoucherApi;
import com.ejianc.business.voucher.callable.AccplatVoucherCallable;
import com.ejianc.business.voucher.callable.VoucherCallable;
import com.ejianc.business.voucher.consts.VoucherFlag;
import com.ejianc.business.voucher.consts.VoucherOptFlag;
import com.ejianc.business.voucher.utils.DataConvertUtil;
import com.ejianc.business.voucher.vo.VoucherInfo;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;

import javax.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * <p>
 * 保证金办理表 服务实现类
 * </p>
 *
 * @author sunyj
 * @since 2020-06-16
 */
@Service
public class BondUpDealServiceImpl extends BaseServiceImpl<BondUpDealMapper, BondUpDealEntity> implements IBondUpDealService {

    private static final String BONGUP_DEAL = "BONGUP_DEAL";

    @Autowired
    private IBondUpService bondUpService;

    @Autowired
    private IBillCodeApi billCodeApi;
    // 是否推送凭证
    private static final String VOUCHER_PARAM = "P-h5UC6769";

    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IVoucherApi voucherApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private IBondUpDealService bondUpDealService;
    @Override
    public BondUpDealVO insertOrUpdate(BondUpDealVO bondUpDealVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<BondUpDealEntity> entities = null;
        if(StringUtils.isEmpty(bondUpDealVO.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BONGUP_DEAL,tenantId);
            if(billCode.isSuccess()) {
                bondUpDealVO.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        BondUpDealEntity entity = BeanMapper.map(bondUpDealVO, BondUpDealEntity.class);
        if(null!=bondUpDealVO.getId()&&bondUpDealVO.getId()>0){
            //编辑
            LambdaQueryWrapper<BondUpDealEntity> lambda = Wrappers.<BondUpDealEntity>lambdaQuery();
            lambda.eq(BondUpDealEntity::getBillCode, bondUpDealVO.getBillCode());
            lambda.eq(BondUpDealEntity::getTenantId, tenantId);
            lambda.ne(BondUpDealEntity::getId, bondUpDealVO.getId());
            entities = super.list(lambda);
            //需要将本次数据新增，将之前数据改为作废
            LambdaUpdateWrapper<BondUpDealEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(BondUpDealEntity::getId,entity.getId());
            updateWrapper.set(BondUpDealEntity::getDealStatus,"2");
            super.update(updateWrapper);
            entity.setId(null);
        }else{
            //新增
            //校验合同编号是否重复
            LambdaQueryWrapper<BondUpDealEntity> lambda = Wrappers.<BondUpDealEntity>lambdaQuery();
            lambda.eq(BondUpDealEntity::getTenantId, tenantId);
            lambda.eq(BondUpDealEntity::getBillCode, bondUpDealVO.getBillCode());
            entities = super.list(lambda);
        }
        if(entities != null && entities.size() > 0 ) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }
        entity.setDealStatus("1");
        entity.setDealTime(new Date());
        super.saveOrUpdate(entity,false);
        //回写申请单
        LambdaUpdateWrapper<BondUpEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(BondUpEntity::getId,entity.getBondId());
        updateWrapper.set(BondUpEntity::getBondStatus,"1");
        updateWrapper.set(BondUpEntity::getBeginDate,entity.getBeginDate());
        updateWrapper.set(BondUpEntity::getEndDate,entity.getEndDate());
        updateWrapper.set(BondUpEntity::getEmployeeId,entity.getEmployeeId());
        updateWrapper.set(BondUpEntity::getEmployeeName,entity.getEmployeeName());
        updateWrapper.set(BondUpEntity::getPayMny,entity.getBondMny());
        updateWrapper.set(BondUpEntity::getBondType,entity.getBondType());
        updateWrapper.set(BondUpEntity::getDealTime,entity.getDealTime());
        bondUpService.update(updateWrapper);

        CommonResponse<ParamRegisterSetVO> byCode = paramConfigApi.getByCode(VOUCHER_PARAM);
        if (byCode.isSuccess() && null != byCode.getData()) {
            ParamRegisterSetVO paramRegisterSetVO = byCode.getData();
            String valueData = paramRegisterSetVO.getValueData();
            BondUpEntity bondUpEntity =bondUpService.selectById(entity.getBondId());
            Long projectId = bondUpEntity.getProjectId();
            if (valueData.equals(String.valueOf(projectId)) || "是".equals(valueData)) {
                ExecutorService threadPool = Executors.newFixedThreadPool(1);
                String authority = request.getHeader("authority");
                if (authority == null) {
                    logger.info("request-authority为空");
                    authority = (String) InvocationInfoProxy.getExtendAttribute("authority");
                }
                try {
                    JSONObject jsonObject = JSONObject.parseObject(JSONObject.toJSONString(entity));
                    jsonObject.put("orgId",bondUpEntity.getOrgId());
                    VoucherParams voucherParams = VoucherParams.newInstanceByOrgId("BT200622000000001", jsonObject, SystemCodeEnum.FINANCE);
                    Callable<CommonResponse> voucherCallable = new AccplatVoucherCallable(voucherApi, bondUpDealService, voucherParams, VoucherOptFlag.SAVE, RequestContextHolder.getRequestAttributes(), authority);
                    threadPool.submit(voucherCallable);
                } catch (Exception e) {
                    logger.error("对上保证金办理推送凭证异常, ", e);
                } finally {
                    threadPool.shutdown();
                }

            }
        }

        return BeanMapper.map(entity, BondUpDealVO.class);
    }

    @Override
    public BondUpDealRentVO queryDetail(Long id) {
        BondUpDealRentVO vo = new BondUpDealRentVO();
        BondUpEntity upEntity = bondUpService.selectById(id);
        LambdaQueryWrapper<BondUpDealEntity> lambda = Wrappers.<BondUpDealEntity>lambdaQuery();
        lambda.eq(BondUpDealEntity::getBondId, id);
        lambda.orderBy(true,true,BondUpDealEntity::getDealStatus);
        List<BondUpDealEntity> list = super.list(lambda);
        vo = BeanMapper.map(upEntity,BondUpDealRentVO.class);
        if(CollectionUtils.isNotEmpty(list)){
            vo.setDealRecord(BeanMapper.mapList(list,BondUpDealVO.class));
        }
        return vo;
    }
}
