/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.accplat.consts.SystemCodeEnum;
import com.ejianc.business.voucher.api.IVoucherApi;
import com.ejianc.business.voucher.utils.DataConvertUtil;
import com.ejianc.business.voucher.vo.VoucherInfo;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class FinanceVoucherHandleService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IVoucherApi voucherApi;

    public CommonResponse handleVoucher(IBaseService billService, VoucherInfo voucherInfo, String voucherOptFlag, String billTypeCode) {
        Long billId = voucherInfo.getBillId();
        Assert.notNull((Object)billId, (String)"\u5355\u636ebillId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Object entity = billService.selectById((Serializable)billId);
        VoucherParams voucherParams = VoucherParams.newInstanceByOrgId((String)billTypeCode, (Object)entity, (SystemCodeEnum)SystemCodeEnum.FINANCE);
        CommonResponse response = this.voucherApi.handleVoucher(voucherParams, voucherOptFlag);
        VoucherInfo voucherInfoRes = (VoucherInfo)response.getData();
        Integer voucherFlag = voucherInfoRes.getVoucherFlag();
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"id", (Object)billId);
        String voucherInfoStr = DataConvertUtil.objToString((Object)voucherInfoRes);
        updateWrapper.set((Object)"voucher_flag", (Object)voucherFlag);
        updateWrapper.set((Object)"voucher_info", (Object)voucherInfoStr);
        billService.update((Wrapper)updateWrapper);
        return response;
    }

    public CommonResponse handleVoucherWithVoucherParams(IBaseService billService, VoucherParams voucherParams, String voucherOptFlag) {
        Long billId = voucherParams.getBillId();
        Assert.notNull((Object)billId, (String)"\u5355\u636ebillId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        CommonResponse response = this.voucherApi.handleVoucher(voucherParams, voucherOptFlag);
        VoucherInfo voucherInfoRes = (VoucherInfo)response.getData();
        Integer voucherFlag = voucherInfoRes.getVoucherFlag();
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"id", (Object)billId);
        String voucherInfoStr = DataConvertUtil.objToString((Object)voucherInfoRes);
        updateWrapper.set((Object)"voucher_flag", (Object)voucherFlag);
        updateWrapper.set((Object)"voucher_info", (Object)voucherInfoStr);
        billService.update((Wrapper)updateWrapper);
        return response;
    }
}

