package com.ejianc.business.finance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.accplat.consts.SystemCodeEnum;
import com.ejianc.business.finance.bean.BondUpBackEntity;
import com.ejianc.business.finance.bean.BondUpBackEntity;
import com.ejianc.business.finance.bean.BondUpEntity;
import com.ejianc.business.finance.mapper.BondUpBackMapper;
import com.ejianc.business.finance.service.IBondUpBackService;
import com.ejianc.business.finance.service.IBondUpService;
import com.ejianc.business.finance.vo.BondUpBackVO;
import com.ejianc.business.finance.vo.BondUpDealRentVO;
import com.ejianc.business.voucher.api.IVoucherApi;
import com.ejianc.business.voucher.callable.AccplatVoucherCallable;
import com.ejianc.business.voucher.callable.VoucherCallable;
import com.ejianc.business.voucher.consts.VoucherFlag;
import com.ejianc.business.voucher.consts.VoucherOptFlag;
import com.ejianc.business.voucher.utils.DataConvertUtil;
import com.ejianc.business.voucher.vo.VoucherInfo;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * <p>
 * 保证金退还表 服务实现类
 * </p>
 *
 * @author sunyj
 * @since 2020-06-16
 */
@Service
public class BondUpBackServiceImpl extends BaseServiceImpl<BondUpBackMapper, BondUpBackEntity> implements IBondUpBackService {

    private static final String BONGUP_BACK = "BONGUP_BACK";

    @Autowired
    private IBondUpService bondUpService;
    @Autowired
    private IBondUpBackService bondUpBackService;

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IVoucherApi voucherApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    // 是否推送凭证
    private static final String VOUCHER_PARAM = "P-h5UC6769";

    @Autowired
    private IParamConfigApi paramConfigApi;

    @Autowired
    private HttpServletRequest request;
    @Override
    public BondUpBackVO insertOrUpdate(BondUpBackVO bondUpBackVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<BondUpBackEntity> entities = null;
        if(StringUtils.isEmpty(bondUpBackVO.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BONGUP_BACK,tenantId);
            if(billCode.isSuccess()) {
                bondUpBackVO.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        BondUpBackEntity entity = BeanMapper.map(bondUpBackVO, BondUpBackEntity.class);
        if(null!=bondUpBackVO.getId()&&bondUpBackVO.getId()>0){
            //编辑
            LambdaQueryWrapper<BondUpBackEntity> lambda = Wrappers.<BondUpBackEntity>lambdaQuery();
            lambda.eq(BondUpBackEntity::getBillCode, bondUpBackVO.getBillCode());
            lambda.eq(BondUpBackEntity::getTenantId, tenantId);
            lambda.ne(BondUpBackEntity::getId, bondUpBackVO.getId());
            entities = super.list(lambda);
        }else{
            //新增
            //校验合同编号是否重复
            LambdaQueryWrapper<BondUpBackEntity> lambda = Wrappers.<BondUpBackEntity>lambdaQuery();
            lambda.eq(BondUpBackEntity::getTenantId, tenantId);
            lambda.eq(BondUpBackEntity::getBillCode, bondUpBackVO.getBillCode());
            entities = super.list(lambda);
        }
        if(entities != null && entities.size() > 0 ) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }
        entity.setBackTime(new Date());
        super.saveOrUpdate(entity,false);
        //回写申请单
        BondUpEntity upentity= bondUpService.selectById(bondUpBackVO.getBondId());
        BigDecimal sumBackMny = upentity.getBackMny()==null?BigDecimal.ZERO:upentity.getBackMny();
        BigDecimal applyMny = upentity.getApplyMny()==null?BigDecimal.ZERO:upentity.getApplyMny();
        if(applyMny.compareTo(sumBackMny.add(entity.getBackMny()))<0){
            throw new BusinessException("本次退还金额不能超过剩余金额!");
        }
        LambdaUpdateWrapper<BondUpEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(BondUpEntity::getId,entity.getBondId());
        updateWrapper.set(BondUpEntity::getBackMny,sumBackMny.add(entity.getBackMny()));
        bondUpService.update(updateWrapper);

        CommonResponse<ParamRegisterSetVO> byCode = paramConfigApi.getByCode(VOUCHER_PARAM);
        if (byCode.isSuccess() && null != byCode.getData()) {
            ParamRegisterSetVO paramRegisterSetVO = byCode.getData();
            String valueData = paramRegisterSetVO.getValueData();
            Long projectId = upentity.getProjectId();
            if (valueData.equals(String.valueOf(projectId)) || "是".equals(valueData)) {
                ExecutorService threadPool = Executors.newFixedThreadPool(1);
                String authority = request.getHeader("authority");
                if (authority == null) {
                    logger.info("request-authority为空");
                    authority = (String) InvocationInfoProxy.getExtendAttribute("authority");
                }
                try {
                    JSONObject jsonObject = JSONObject.parseObject(JSONObject.toJSONString(entity));
                    jsonObject.put("orgId",upentity.getOrgId());
                    VoucherParams voucherParams = VoucherParams.newInstanceByOrgId("BT200622000000002", jsonObject, SystemCodeEnum.FINANCE);
                    Callable<CommonResponse> voucherCallable = new AccplatVoucherCallable(voucherApi, bondUpBackService, voucherParams, VoucherOptFlag.SAVE, RequestContextHolder.getRequestAttributes(), authority);
                    threadPool.submit(voucherCallable);
                } catch (Exception e) {
                    logger.error("对上保证金退还推送凭证异常, ", e);
                } finally {
                    threadPool.shutdown();
                }

            }
        }

        return BeanMapper.map(entity, BondUpBackVO.class);
    }

    @Override
    public BondUpDealRentVO queryDetail(Long id) {
        BondUpDealRentVO vo = new BondUpDealRentVO();
        BondUpEntity upEntity = bondUpService.selectById(id);
        LambdaQueryWrapper<BondUpBackEntity> lambda = Wrappers.<BondUpBackEntity>lambdaQuery();
        lambda.eq(BondUpBackEntity::getBondId, id);
        lambda.orderBy(true,false,BondUpBackEntity::getBackTime);
        List<BondUpBackEntity> list = super.list(lambda);
        vo.setId(id);
        vo.setBondStatus(upEntity.getBondStatus());
        vo.setContractId(upEntity.getContractId());
        vo.setContractName(upEntity.getContractName());
        vo.setApplyMny(upEntity.getApplyMny()==null?BigDecimal.ZERO:upEntity.getApplyMny());
        vo.setContractTaxMny(upEntity.getContractTaxMny()==null?BigDecimal.ZERO:upEntity.getContractTaxMny());
        vo.setBackMny(upEntity.getBackMny()==null?BigDecimal.ZERO:upEntity.getBackMny());
        vo.setSurplusMny(vo.getApplyMny().subtract(vo.getBackMny()));
        if(CollectionUtils.isNotEmpty(list)){
            vo.setBackRecord(BeanMapper.mapList(list,BondUpBackVO.class));
        }
        return vo;
    }
}
