package com.ejianc.business.finance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.finance.bean.PayReimburseEntity;
import com.ejianc.business.finance.bean.ReimburseShareDetailEntity;
import com.ejianc.business.finance.bean.ReimburseShareEntity;
import com.ejianc.business.finance.service.IPayReimburseService;
import com.ejianc.business.finance.service.IReimburseShareDetailService;
import com.ejianc.business.finance.service.IReimburseShareService;
import com.ejianc.business.finance.vo.ParamsCheckSpreadVO;
import com.ejianc.business.finance.vo.PayReimburseVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@Service("reimburseShare") 
public class ReimburseShareBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	private static final String REIM_PAYAPPLY_BILL_CODE = "REIM_PAYAPPLY";
    @Autowired
    private IBillTypeApi billTypeApi;
	@Autowired
	private IPayReimburseService payReimburseService;
	@Autowired
	private IReimburseShareService service;
	@Autowired
	private IReimburseShareDetailService reimburseShareDetailService;
	@Autowired
	private IBillCodeApi billCodeApi;



	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		ReimburseShareEntity reimburseShareEntity = service.selectById(billId);
		if (reimburseShareEntity!=null){
			logger.info("累加回写对应费用报销信息:"+JSONObject.toJSONString(reimburseShareEntity));
			CommonResponse<PayReimburseVO> payReimburseVOCommonResponse = payReimburseService.updateShareMoney(reimburseShareEntity.getReimburseId(), reimburseShareEntity.getSumShareMny());
			if (!payReimburseVOCommonResponse.isSuccess()){
				CommonResponse.success(payReimburseVOCommonResponse.getMsg());
			}
			logger.info("累加回写对应费用报销信息结果:"+payReimburseVOCommonResponse.isSuccess());
			List<ReimburseShareDetailEntity> reimburseShareDetailList = reimburseShareEntity.getReimburseShareDetailList();
			if (CollectionUtils.isNotEmpty(reimburseShareDetailList)){
				for (ReimburseShareDetailEntity entity : reimburseShareDetailList) {
					PayReimburseEntity payReimburseEntity = new PayReimburseEntity();
					payReimburseEntity.setDependOnProject("1");
					payReimburseEntity.setOrgId(entity.getOrgId());
					payReimburseEntity.setOrgName(entity.getOrgName());
					payReimburseEntity.setOrgCode(entity.getOrgCode());
					payReimburseEntity.setProjectId(entity.getProjectId());
					payReimburseEntity.setProjectName(entity.getProjectName());
					payReimburseEntity.setApplyMny(entity.getBodyShareMny());
					payReimburseEntity.setApplyMnyCn(entity.getBodyShareMnyCn());
					payReimburseEntity.setApplyMnyCn(entity.getBodyShareMnyCn());
					//申请日期
					payReimburseEntity.setApplyTime(reimburseShareEntity.getBliDate());
					payReimburseEntity.setIsShareFlag(1);
					payReimburseEntity.setPayMny(entity.getBodyShareMny());
					payReimburseEntity.setBillState(1);
					payReimburseEntity.setCreateTime(entity.getCreateTime());
					payReimburseEntity.setCreateUserCode(entity.getCreateUserCode());
					payReimburseEntity.setFeeType(reimburseShareEntity.getFeeType());
					payReimburseEntity.setPayType(1);
					//设置默认值
					payReimburseEntity.setProportionFlag("0");
					payReimburseEntity.setRelationFlag("0");
					payReimburseEntity.setPayReason(reimburseShareEntity.getReimburseReason());
					payReimburseEntity.setApproveTime(new Date());
					payReimburseEntity.setApplyUserId(entity.getReimburseId());
					payReimburseEntity.setApplyUserName(reimburseShareEntity.getEmployeeName());
					payReimburseEntity.setEmployeeId(reimburseShareEntity.getEmployeeId());
					payReimburseEntity.setEmployeeName(reimburseShareEntity.getEmployeeName());
					Long tenantId = InvocationInfoProxy.getTenantid();
					CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(REIM_PAYAPPLY_BILL_CODE, tenantId);
					if(billCode.isSuccess()) {
							payReimburseEntity.setBillCode(billCode.getData());
					}else{
							throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
					}
					logger.info(" 推送信息参数:"+JSONObject.toJSONString(payReimburseEntity));
					boolean b = payReimburseService.saveOrUpdate(payReimburseEntity);
					logger.info(" 推送信息结果:"+b);
					Long reimburseId = payReimburseEntity.getId();
					LambdaUpdateWrapper<ReimburseShareDetailEntity> updateWrapper = new LambdaUpdateWrapper<>();
					updateWrapper.eq(ReimburseShareDetailEntity::getId,entity.getId());
					updateWrapper.set(ReimburseShareDetailEntity::getReimburseId,reimburseId);
					reimburseShareDetailService.update(updateWrapper);
			}
			}
		}

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		ReimburseShareEntity reimburseShareEntity = service.selectById(billId);
		logger.info("减少回写对应费用报销信息:"+JSONObject.toJSONString(reimburseShareEntity));
		CommonResponse<PayReimburseVO> payReimburseVOCommonResponse = payReimburseService.updateShareMoney(reimburseShareEntity.getReimburseId(), ComputeUtil.safeSub(BigDecimal.ZERO,reimburseShareEntity.getSumShareMny()));
		if (!payReimburseVOCommonResponse.isSuccess()){
		  return 	CommonResponse.error(payReimburseVOCommonResponse.getMsg());
		}
		List<ReimburseShareDetailEntity> reimburseShareDetailList = reimburseShareEntity.getReimburseShareDetailList();
        if (CollectionUtils.isNotEmpty(reimburseShareDetailList)){
			List<Long> reimburseIds =
					reimburseShareDetailList.stream().map(ReimburseShareDetailEntity::getReimburseId).collect(Collectors.toList());
			payReimburseService.removeByIds(reimburseIds);
		}
		return CommonResponse.success();
	}

}
