/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.accplat.consts.SystemCodeEnum;
import com.ejianc.business.finance.bean.DeductionEntity;
import com.ejianc.business.finance.bean.LoadApplyEntity;
import com.ejianc.business.finance.bean.PayContractDeductionEntity;
import com.ejianc.business.finance.bean.PayContractEntity;
import com.ejianc.business.finance.bean.PayRecordEntity;
import com.ejianc.business.finance.bean.PayReimburseEntity;
import com.ejianc.business.finance.service.FinanceVoucherHandleService;
import com.ejianc.business.finance.service.IDeductionService;
import com.ejianc.business.finance.service.ILoadApplyService;
import com.ejianc.business.finance.service.IPayContractDeductionService;
import com.ejianc.business.finance.service.IPayContractService;
import com.ejianc.business.finance.service.IPayRecordService;
import com.ejianc.business.finance.service.IPayReimburseService;
import com.ejianc.business.finance.vo.LoadApplyVO;
import com.ejianc.business.finance.vo.PayContractVO;
import com.ejianc.business.finance.vo.PayRecordVO;
import com.ejianc.business.finance.vo.PayReimburseVO;
import com.ejianc.business.voucher.utils.DataConvertUtil;
import com.ejianc.business.voucher.vo.VoucherInfo;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"payRecord"})
public class PayRecordController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPayRecordService service;
    @Autowired
    private FinanceVoucherHandleService financeVoucherHandleService;
    @Autowired
    private IPayContractService payContractService;
    @Autowired
    private IPayReimburseService payReimburseService;
    @Autowired
    private ILoadApplyService loadApplyService;
    @Autowired
    private IPayContractDeductionService contractDeductionService;
    @Autowired
    private IDeductionService deductionService;

    @RequestMapping(value={"/pushVoucher"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse pushVoucher(@RequestBody VoucherInfo voucherInfo) {
        PayReimburseVO vo;
        Long billId = voucherInfo.getBillId();
        PayRecordEntity recordEntity = (PayRecordEntity)((Object)this.service.getById(billId));
        Long payapplyId = recordEntity.getPayapplyId();
        String applyType = recordEntity.getApplyType();
        VoucherParams voucherParams = null;
        Map recordMap = DataConvertUtil.objToMap((Object)((Object)recordEntity));
        ArrayList<VoucherParams> voucherParams4DedList = new ArrayList<VoucherParams>();
        if ("\u5408\u540c\u4ed8\u6b3e".equals(applyType)) {
            PayContractEntity payContractEntity = (PayContractEntity)((Object)this.payContractService.selectById(payapplyId));
            PayContractVO payContractVO = (PayContractVO)BeanMapper.map((Object)((Object)payContractEntity), PayContractVO.class);
            payContractVO.set_payRecordId(recordMap);
            voucherParams = VoucherParams.newInstanceByOrgId((String)"BT200611000000017", (Object)payContractVO, (SystemCodeEnum)SystemCodeEnum.FINANCE);
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"payapply_id", (Object)payapplyId);
            List payContractDeductionEntityList = this.contractDeductionService.list((Wrapper)wrapper);
            if (CollectionUtils.isNotEmpty((Collection)payContractDeductionEntityList)) {
                List dedIdList = payContractDeductionEntityList.stream().map(PayContractDeductionEntity::getDeductionId).collect(Collectors.toList());
                List deductionEntities = (List)this.deductionService.listByIds(dedIdList);
                for (int a = 0; a < deductionEntities.size(); ++a) {
                    DeductionEntity deductionEntity = (DeductionEntity)((Object)deductionEntities.get(a));
                    VoucherParams voucherParamsDed = VoucherParams.newInstanceByOrgId((String)"BT210924000000001", (Object)((Object)deductionEntity), (SystemCodeEnum)SystemCodeEnum.FINANCE);
                    voucherParams4DedList.add(voucherParamsDed);
                }
            }
        } else if ("\u62a5\u9500".equals(applyType)) {
            PayReimburseEntity reimburseEntity = (PayReimburseEntity)((Object)this.payReimburseService.selectById(payapplyId));
            vo = (PayReimburseVO)BeanMapper.map((Object)((Object)reimburseEntity), PayReimburseVO.class);
            vo.set_payRecordId(recordMap);
            voucherParams = VoucherParams.newInstanceByOrgId((String)"BT200529000000002", (Object)vo, (SystemCodeEnum)SystemCodeEnum.FINANCE);
        } else if ("\u5907\u7528\u91d1".equals(applyType)) {
            LoadApplyEntity applyEntity = (LoadApplyEntity)((Object)this.loadApplyService.selectById(payapplyId));
            vo = (LoadApplyVO)BeanMapper.map((Object)((Object)applyEntity), LoadApplyVO.class);
            vo.set_payRecordId(recordMap);
            voucherParams = VoucherParams.newInstanceByOrgId((String)"BT200629000000001", (Object)vo, (SystemCodeEnum)SystemCodeEnum.FINANCE);
        }
        if (voucherParams == null) {
            throw new BusinessException("\u63a8\u9001\u51ed\u8bc1\u5f02\u5e38\uff1a\u7533\u8bf7\u5355\u4e0d\u5b58\u5728\uff01");
        }
        voucherParams.setBillId(billId);
        if (CollectionUtils.isNotEmpty(voucherParams4DedList)) {
            for (VoucherParams params : voucherParams4DedList) {
                CommonResponse response = this.financeVoucherHandleService.handleVoucherWithVoucherParams(this.deductionService, params, "save");
                if (response.isSuccess()) continue;
                return response;
            }
        }
        return this.financeVoucherHandleService.handleVoucherWithVoucherParams(this.service, voucherParams, "save");
    }

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PayRecordVO> saveOrUpdate(@RequestBody PayRecordVO saveorUpdateVO) {
        PayRecordVO vo = this.service.insertOrUpdate(saveorUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PayRecordVO> queryDetail(Long id) {
        PayRecordEntity entity = (PayRecordEntity)((Object)this.service.selectById(id));
        PayRecordVO vo = (PayRecordVO)BeanMapper.map((Object)((Object)entity), PayRecordVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PayRecordVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PayRecordVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PayRecordVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/returnPayment"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PayRecordVO> returnPayment(@RequestBody PayRecordVO payRecordVO) {
        return CommonResponse.success((String)"\u4ed8\u6b3e\u9000\u56de\u6210\u529f\uff01", (Object)this.service.returnPayment(payRecordVO));
    }
}

