package com.ejianc.business.finance.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.accplat.consts.SystemCodeEnum;
import com.ejianc.business.equipment.vo.RentSettlementVO;
import com.ejianc.business.finance.bean.*;
import com.ejianc.business.finance.service.ILoadReimburseService;
import com.ejianc.business.finance.service.IloadInvoiceService;
import com.ejianc.business.finance.vo.LoadApplyVO;
import com.ejianc.business.finance.vo.LoadReimburseVO;
import com.ejianc.business.finance.vo.ParamsCheckSpreadVO;
import com.ejianc.business.material.vo.ParamsCheckVO;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.business.tax.vo.InvoiceReceiveFlagVO;
import com.ejianc.business.voucher.api.IVoucherApi;
import com.ejianc.business.voucher.consts.VoucherOptFlag;
import com.ejianc.business.voucher.utils.DataConvertUtil;
import com.ejianc.business.voucher.vo.VoucherInfo;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 借款报销
 *
 * @author generator
 */
@Controller
@RequestMapping("loadReimburse")
public class LoadReimburseController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ILoadReimburseService service;

    @Autowired
    private IloadInvoiceService loadInvoiceService;
    @Autowired
    private IVoucherApi voucherApi;
    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IInvoiceApi invoiceApi;

    @Autowired
    private IDefdocApi defdocApi;


    private static String COST_TYPE_DEFDOC_CODE = "load-reimburse-costType";

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<LoadReimburseVO> saveOrUpdate(@RequestBody LoadReimburseVO saveorUpdateVO) {
        LoadReimburseVO vo = service.insertOrUpdate(saveorUpdateVO);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }
    /**
     * @description: 推送凭证
     *
     * @param voucherInfo
     * @return {@link CommonResponse}
     * @author songlx
     * @date: 2024/1/12
     */
    @RequestMapping(value = "/pushVoucher", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse pushVoucher(@RequestBody VoucherInfo voucherInfo) {
        Long billId = voucherInfo.getBillId();
        Assert.notNull(billId, "单据billId不能为空！");
        LoadReimburseEntity entity = service.selectById(billId);
        VoucherParams voucherParams = VoucherParams.newInstanceByOrgId("BT200629000000002", entity, SystemCodeEnum.FINANCE);
        CommonResponse<VoucherInfo> response = voucherApi.handleVoucher(voucherParams, VoucherOptFlag.SAVE);
        if (response.isSuccess()) {
            logger.info("response: {}", DataConvertUtil.toPrettyFormat(response));
            voucherInfo = response.getData();
            LambdaUpdateWrapper<LoadReimburseEntity> lambda = new LambdaUpdateWrapper<>();
            lambda.eq(LoadReimburseEntity::getId, entity.getId());
            lambda.set(LoadReimburseEntity::getVoucherInfo, DataConvertUtil.objToString(voucherInfo));
            lambda.set(LoadReimburseEntity::getVoucherFlag, voucherInfo.getVoucherFlag());
            boolean update = service.update(lambda);
            logger.info("update: {}", update);
        }
        return response;
    }
    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<LoadReimburseVO> queryDetail(Long id) {
        LoadReimburseEntity entity = service.selectById(id);
        LoadReimburseVO vo = BeanMapper.map(entity, LoadReimburseVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<LoadReimburseVO> vos) {
        if (CollectionUtils.isNotEmpty(vos)) {
            List<Long> ids = vos.stream().map(LoadReimburseVO::getId).collect(Collectors.toList());
            loadInvoiceService.updateInvoiceUsedMnyByDel(ids);
            service.removeByIds(ids, true);
        }
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");

        ComplexParam c1 = new ComplexParam();
        c1.setLogic(ComplexParam.AND);
        ComplexParam c2 = new ComplexParam();
        c2.setLogic(ComplexParam.OR);
        c2.getParams().put("applyEmployeeId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getEmployeeId()));
        c1.getComplexParams().add(c2);
        ComplexParam c3 = new ComplexParam();
        c3.setLogic(ComplexParam.OR);
        c3.getParams().put("employeeId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getEmployeeId()));
        c1.getComplexParams().add(c3);
        param.getComplexParams().add(c1);

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<LoadReimburseEntity> pageData = service.queryPage(param, false);
        com.alibaba.fastjson.JSONObject res = new com.alibaba.fastjson.JSONObject();
        res.put("records", BeanMapper.mapList(pageData.getRecords(), LoadReimburseVO.class));
        res.put("total", pageData.getTotal());
        res.put("current", pageData.getCurrent());
        res.put("size", pageData.getSize());
        res.put("pages", pageData.getPages());
        return CommonResponse.success("查询列表数据成功！", res);
    }

    /**
     * @param param
     * @Description queryList 查询台账列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryReportList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryReportList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("applyEmployeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<Long> commonOrgIds = new ArrayList<>();
        List<Integer> billstate = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            return CommonResponse.success("列表查询失败, 查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("bill_state", new Parameter(QueryParam.IN, billstate));
        IPage<LoadReimburseEntity> pageData = service.queryPage(param, false);
        com.alibaba.fastjson.JSONObject res = new com.alibaba.fastjson.JSONObject();
        res.put("records", BeanMapper.mapList(pageData.getRecords(), LoadReimburseVO.class));
        res.put("total", pageData.getTotal());
        res.put("current", pageData.getCurrent());
        res.put("size", pageData.getSize());
        res.put("pages", pageData.getPages());
        return CommonResponse.success("查询列表数据成功！", res);
//        return CommonResponse.success("查询列表数据成功！",BeanMapper.map(service.queryPage(param,false), IPage.class));
    }

    /**
     * @param id
     * @Description queryPrint 查询打印详情
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryPrint", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryPrint(Long id) {
        JSONObject json = new JSONObject();
        json.put("LoadReimburse", service.selectById(id));
        return CommonResponse.success("查询打印数据成功！", json);
    }

    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List<LoadReimburseVO> list = new ArrayList<>();
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("applyEmployeeId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getEmployeeId()));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<LoadReimburseEntity> pageData = service.queryPage(param, false);
        if (CollectionUtils.isNotEmpty(pageData.getRecords())) {
            list = BeanMapper.mapList(pageData.getRecords(), LoadReimburseVO.class);
        }
        Map<Long, String> defDocMap = new HashMap<>();
        CommonResponse<List<DefdocDetailVO>> defDocByDefCode = defdocApi.getDefDocByDefCode(COST_TYPE_DEFDOC_CODE);
        if (defDocByDefCode.isSuccess() && CollectionUtils.isNotEmpty(defDocByDefCode.getData())) {
            List<DefdocDetailVO> data = defDocByDefCode.getData();
            defDocMap = data.stream().collect(Collectors.toMap(DefdocDetailVO::getId, DefdocDetailVO::getName, (key1, key2) -> key2));
        }

        for (LoadReimburseVO vo : list) {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            vo.setCostTypeName(defDocMap.get(vo.getCostType()));
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("loadReimburseExport.xlsx", beans, response);
    }

    @RequestMapping(value = "/excelExportReport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportReport(@RequestBody QueryParam param, HttpServletResponse response) {
        List<LoadReimburseVO> list = new ArrayList<>();
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<Long> commonOrgIds = new ArrayList<>();
        List<Integer> billstate = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            throw new BusinessException("列表查询失败, 查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("bill_state", new Parameter(QueryParam.IN, billstate));
        IPage<LoadReimburseEntity> pageData = service.queryPage(param, false);
        if (CollectionUtils.isNotEmpty(pageData.getRecords())) {
            list = BeanMapper.mapList(pageData.getRecords(), LoadReimburseVO.class);
        }
        Map<Long, String> defDocMap = new HashMap<>();
        CommonResponse<List<DefdocDetailVO>> defDocByDefCode = defdocApi.getDefDocByDefCode(COST_TYPE_DEFDOC_CODE);
        if (defDocByDefCode.isSuccess() && CollectionUtils.isNotEmpty(defDocByDefCode.getData())) {
            List<DefdocDetailVO> data = defDocByDefCode.getData();
            defDocMap = data.stream().collect(Collectors.toMap(DefdocDetailVO::getId, DefdocDetailVO::getName, (key1, key2) -> key2));
        }

        for (LoadReimburseVO vo : list) {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            vo.setCostTypeName(defDocMap.get(vo.getCostType()));
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("loadReimburseExport.xlsx", beans, response);
    }

    /**
     * 成本改造
     * 关联保存接口
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/pushCost", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<LoadReimburseVO> pushCost(@RequestBody LoadReimburseVO loadReimburseVO) {
        return service.pushCost(loadReimburseVO);
    }

    /**
     * @param projectId
     * @param money
     * @Author xuannl
     * @Date 2021/11/08
     * @Description checkParams 校验是否超额
     */
    @RequestMapping(value = "/checkParams", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ParamsCheckSpreadVO> checkParams(Long projectId, BigDecimal money) {
        ParamsCheckSpreadVO paramsCheckVO = service.checkParams(projectId, money);
        return CommonResponse.success("查询打印数据成功！", paramsCheckVO);
    }

    /**
     * @param vo
     * @description: 更新是否含有发票
     * @return: com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.finance.vo.PayContractVO>
     * @author jiangyikai
     * @date: 2022/7/22
     */
    @RequestMapping(value = "/updateInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<LoadReimburseVO> updateInfo(@RequestBody LoadReimburseVO vo) {
        if (vo.getId() != null && vo.getInvoiceFlag() != null) {
            //更新是否含有发票
            LambdaUpdateWrapper<LoadReimburseEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(LoadReimburseEntity::getId, vo.getId());
            updateWrapper.set(LoadReimburseEntity::getInvoiceFlag, vo.getInvoiceFlag());
            service.update(updateWrapper);
        }
        return CommonResponse.success("修改成功！", vo);
    }
}
