package com.ejianc.business.finance.controller;


import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.bean.BondDownDealEntity;
import com.ejianc.business.finance.bean.BondDownEntity;
import com.ejianc.business.finance.service.IBondDownDealService;
import com.ejianc.business.finance.service.IBondDownService;
import com.ejianc.business.finance.vo.BondDownVO;
import com.ejianc.business.finance.vo.BondUpVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.*;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * <p>
 * 保证金对下申请表 前端控制器
 * </p>
 *
 * @author sunyj
 * @since 2020-06-16
 */
@RestController
@RequestMapping("/bondDown")
public class BondDownController {
    @Autowired
    private IBondDownService bondDownService;

    @Autowired
    private IBondDownDealService bondDownDealService;

    @Autowired
    private IOrgApi orgApi;

    /**
     * @Author sunyj
     * @Date 2020/5/28
     * @Description saveOrDowndate 新增或者修改
     * @param bondDownVO
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BondDownVO> saveOrDowndate(@RequestBody BondDownVO bondDownVO) {
        return bondDownService.insertOrUpdate(bondDownVO);
    }
    /**
     * @Author sunyj
     * @Date 2020/5/28
     * @Description saveOrDowndate 查询详情
     * @param id
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BondDownVO> queryDetail(Long id) {
        BondDownVO backVO = bondDownService.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！", backVO);
    }

    /**
     * @Author sunyj
     * @Date 2020/5/28
     * @Description saveOrDowndate 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenantId", new Parameter("eq", InvocationInfoProxy.getTenantid()));
        List<Long> commonOrgIds = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if(!orgListResp.isSuccess()) {
            return CommonResponse.success("列表查询失败, 查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        Page<BondDownEntity> page = new Page<>((long)param.getPageIndex(), (long)param.getPageSize());
        Parameter backType = param.getParams().get("backType");
        Parameter payType = param.getParams().get("payType");
        param.getParams().remove("backType");
        param.getParams().remove("payType");
        QueryWrapper wrapper = changeToQueryWrapper(param);
        if(null!=backType&&"1".equals(backType.getValue())){
            wrapper.apply("IFNULL(back_mny,0) = IFNULL(apply_mny,0)");
        }else if(null!=backType&&"2".equals(backType.getValue())){
            wrapper.apply("IFNULL(back_mny,0) < IFNULL(apply_mny,0)");
        }
        if(null!=payType&&"1".equals(payType.getValue())){
            wrapper.apply("IFNULL(pay_mny,0) <= 0");
        }else if(null!=payType&&"2".equals(payType.getValue())){
            wrapper.apply("IFNULL(pay_mny,0) > 0");
        }
        IPage<BondDownEntity> pageData = bondDownService.selectPage(page,wrapper);
        com.alibaba.fastjson.JSONObject res = new com.alibaba.fastjson.JSONObject();
        res.put("records", BeanMapper.mapList(pageData.getRecords(), BondDownVO.class));
        res.put("total", pageData.getTotal());
        res.put("current", pageData.getCurrent());
        res.put("size", pageData.getSize());
        res.put("pages", pageData.getPages());
        return CommonResponse.success("查询列表数据成功！", res);
    }

    /**
     * @Author sunyj
     * @Date 2020/5/28
     * @Description saveOrDowndate 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryListManage", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryListManage(@RequestBody QueryParam param) {
        List<BondDownVO> list = new ArrayList<>();
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenantId", new Parameter("eq", InvocationInfoProxy.getTenantid()));
        param.getParams().put("bondStatus", new Parameter("eq", "1"));
        List<Long> commonOrgIds = new ArrayList<>();
        List<Integer> billstate = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if(!orgListResp.isSuccess()) {
            return CommonResponse.success("列表查询失败, 查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("bill_state",new Parameter(QueryParam.IN,billstate));
        Page<BondDownEntity> page = new Page<>((long)param.getPageIndex(), (long)param.getPageSize());
        Parameter backType = param.getParams().get("backType");
        Parameter bondState = param.getParams().get("bondState");
        param.getParams().remove("backType");
        param.getParams().remove("bondState");
        QueryWrapper wrapper = changeToQueryWrapper(param);
        if(null!=backType&&"1".equals(backType.getValue())){
            wrapper.apply("IFNULL(back_mny,0) = IFNULL(apply_mny,0)");
        }else if(null!=backType&&"2".equals(backType.getValue())){
            wrapper.apply("IFNULL(back_mny,0) < IFNULL(apply_mny,0)");
        }

        if(null!=bondState&&"1".equals(bondState.getValue())){
            wrapper.apply("CURRENT_DATE() <= end_date");
        }else if(null!=bondState&&"2".equals(bondState.getValue())){
            wrapper.apply("CURRENT_DATE() > end_date");
        }
        IPage<BondDownEntity> pageData = bondDownService.selectPage(page,wrapper);
        if(CollectionUtils.isNotEmpty(pageData.getRecords())){
            list = BeanMapper.mapList(pageData.getRecords(), BondDownVO.class);
            list.forEach(vo -> {
                if(new Date().after(vo.getEndDate())){
                    vo.setDealStatus("已到期");
                }else{
                    vo.setDealStatus("有效");
                }
            });
        }
        com.alibaba.fastjson.JSONObject res = new com.alibaba.fastjson.JSONObject();
        res.put("records", list);
        res.put("total", pageData.getTotal());
        res.put("current", pageData.getCurrent());
        res.put("size", pageData.getSize());
        res.put("pages", pageData.getPages());
        return CommonResponse.success("查询列表数据成功！", res);
    }

    /**
     * @Author sunyj
     * @Date 2020/5/28
     * @Description delete 批量删除单据
     * @Param [ids]
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BondDownVO> vos) {
        List<Long> ids = vos.stream().map(BondDownVO::getId).collect(Collectors.toList());
        bondDownService.removeByIds(ids,false);
        return CommonResponse.success("删除成功");
    }

    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List<BondDownVO> list = new ArrayList<>();
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("tenantId", new Parameter("eq", InvocationInfoProxy.getTenantid()));
        List<Long> commonOrgIds = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if(!orgListResp.isSuccess()) {
            throw new BusinessException("列表查询失败, 查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        Page<BondDownEntity> page = new Page<>((long)param.getPageIndex(), (long)param.getPageSize());
        Parameter backType = param.getParams().get("backType");
        Parameter payType = param.getParams().get("payType");
        param.getParams().remove("backType");
        param.getParams().remove("payType");
        QueryWrapper wrapper = changeToQueryWrapper(param);
        if(null!=backType&&"1".equals(backType.getValue())){
            wrapper.apply("IFNULL(back_mny,0) = IFNULL(apply_mny,0)");
        }else if(null!=backType&&"2".equals(backType.getValue())){
            wrapper.apply("IFNULL(back_mny,0) < IFNULL(apply_mny,0)");
        }
        if(null!=payType&&"1".equals(payType.getValue())){
            wrapper.apply("IFNULL(pay_mny,0) <= 0");
        }else if(null!=payType&&"2".equals(payType.getValue())){
            wrapper.apply("IFNULL(pay_mny,0) > 0");
        }
        IPage<BondDownEntity> pageData = bondDownService.selectPage(page,wrapper);
        if(CollectionUtils.isNotEmpty(pageData.getRecords())){
            list = BeanMapper.mapList(pageData.getRecords(), BondDownVO.class);
        }
        list.forEach(vo -> {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            if(new Date().after(vo.getEndDate())){
                vo.setDealStatus("已到期");
            }else{
                vo.setDealStatus("有效");
            }
        });
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("bondDownExport.xlsx", beans, response);
    }

    @RequestMapping(value = "/excelExports", method = RequestMethod.POST)
    @ResponseBody
    public void excelExports(@RequestBody QueryParam param, HttpServletResponse response) {
        List<BondDownVO> list = new ArrayList<>();
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("tenantId", new Parameter("eq", InvocationInfoProxy.getTenantid()));
        param.getParams().put("bondStatus", new Parameter("eq", "1"));
        List<Long> commonOrgIds = new ArrayList<>();
        List<Integer> billstate = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if(!orgListResp.isSuccess()) {
            throw new BusinessException("列表查询失败, 查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("bill_state",new Parameter(QueryParam.IN,billstate));
        Page<BondDownEntity> page = new Page<>((long)param.getPageIndex(), (long)param.getPageSize());
        Parameter backType = param.getParams().get("backType");
        Parameter bondState = param.getParams().get("bondState");
        param.getParams().remove("backType");
        param.getParams().remove("bondState");
        QueryWrapper wrapper = changeToQueryWrapper(param);
        if(null!=backType&&"1".equals(backType.getValue())){
            wrapper.apply("IFNULL(back_mny,0) = IFNULL(apply_mny,0)");
        }else if(null!=backType&&"2".equals(backType.getValue())){
            wrapper.apply("IFNULL(back_mny,0) < IFNULL(apply_mny,0)");
        }

        if(null!=bondState&&"1".equals(bondState.getValue())){
            wrapper.apply("CURRENT_DATE() <= end_date");
        }else if(null!=bondState&&"2".equals(bondState.getValue())){
            wrapper.apply("CURRENT_DATE() > end_date");
        }
        IPage<BondDownEntity> pageData = bondDownService.selectPage(page,wrapper);
        if(CollectionUtils.isNotEmpty(pageData.getRecords())){
            list = BeanMapper.mapList(pageData.getRecords(), BondDownVO.class);
        }
        list.forEach(vo -> {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            if(new Date().after(vo.getEndDate())){
                vo.setDealStatus("已到期");
            }else{
                vo.setDealStatus("有效");
            }
        });
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("bondDownManageExport.xlsx", beans, response);
    }
}
