package com.ejianc.business.finance.service;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.accplat.consts.SystemCodeEnum;
import com.ejianc.business.voucher.api.IVoucherApi;
import com.ejianc.business.voucher.utils.DataConvertUtil;
import com.ejianc.business.voucher.vo.VoucherInfo;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import org.apache.poi.ss.formula.functions.T;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

/**
 * @description: FInanceVoucherHandleService
 * @author songlx
 * @date 2024/1/24
 * @version 1.0
 */
@Service
public class FinanceVoucherHandleService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IVoucherApi voucherApi;


    public CommonResponse handleVoucher(IBaseService billService, VoucherInfo voucherInfo, String voucherOptFlag, String billTypeCode) {
        Long billId = voucherInfo.getBillId();
        Assert.notNull(billId, "单据billId不能为空！");
        Object entity = billService.selectById(billId);
        VoucherParams voucherParams = VoucherParams.newInstanceByOrgId(billTypeCode, entity, SystemCodeEnum.FINANCE);
        CommonResponse<VoucherInfo> response = voucherApi.handleVoucher(voucherParams, voucherOptFlag);
        VoucherInfo voucherInfoRes = response.getData();
        if (voucherInfoRes != null) {
            Integer voucherFlag = voucherInfoRes.getVoucherFlag();
            UpdateWrapper<T> updateWrapper = new UpdateWrapper<>();
            updateWrapper.eq("id", billId);
            String voucherInfoStr = DataConvertUtil.objToString(voucherInfoRes);
            updateWrapper.set("voucher_flag", voucherFlag);
            updateWrapper.set("voucher_info", voucherInfoStr);
            billService.update(updateWrapper);
        }
        return response;
    }


    public CommonResponse handleVoucherWithVoucherParams(IBaseService billService, VoucherParams voucherParams, String voucherOptFlag) {
//        Long billId = voucherParams.getBillId();
//        Assert.notNull(billId, "单据billId不能为空！");
        CommonResponse<VoucherInfo> response = voucherApi.handleVoucher(voucherParams, voucherOptFlag);
        VoucherInfo voucherInfoRes = response.getData();
        if (voucherInfoRes != null) {
            Integer voucherFlag = voucherInfoRes.getVoucherFlag();
            UpdateWrapper<T> updateWrapper = new UpdateWrapper<>();
            updateWrapper.eq("id", voucherInfoRes.getBillId());
            String voucherInfoStr = DataConvertUtil.objToString(voucherInfoRes);
            updateWrapper.set("voucher_flag", voucherFlag);
            updateWrapper.set("voucher_info", voucherInfoStr);
            billService.update(updateWrapper);
        }
        return response;
    }
}
