/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.ejianc.business.finance.bean.LoadInvoiceEntity;
import com.ejianc.business.finance.mapper.LoadInvoiceMapper;
import com.ejianc.business.finance.service.IloadInvoiceService;
import com.ejianc.business.finance.utils.BigDecimalUtil;
import com.ejianc.business.finance.vo.LoadInvoiceVO;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.business.tax.vo.InvoiceReceiveFlagVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="loadInvoiceService")
public class LoadInvoiceServiceImpl
extends BaseServiceImpl<LoadInvoiceMapper, LoadInvoiceEntity>
implements IloadInvoiceService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IInvoiceApi invoiceApi;

    @Override
    public CommonResponse<String> updateInvoiceUsedMnyBySave(List<LoadInvoiceVO> voList, Long id) {
        List oldInvoiceList;
        CommonResponse res = CommonResponse.success();
        QueryParam param = new QueryParam();
        param.getParams().put("reimburseId", new Parameter("eq", (Object)id));
        List list = oldInvoiceList = id != null ? this.queryList(param, false) : null;
        if (CollectionUtils.isNotEmpty(voList)) {
            Map invoiceEntityMap = CollectionUtils.isNotEmpty((Collection)oldInvoiceList) ? oldInvoiceList.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity())) : null;
            ArrayList<InvoiceReceiveFlagVO> updates = new ArrayList<InvoiceReceiveFlagVO>();
            voList.forEach(t -> {
                BigDecimal old = t.getId() != null && invoiceEntityMap != null && invoiceEntityMap.get(t.getId()) != null ? ((LoadInvoiceEntity)((Object)((Object)invoiceEntityMap.get(t.getId())))).getUsedInvoiceTaxMny() : BigDecimal.ZERO;
                InvoiceReceiveFlagVO v = new InvoiceReceiveFlagVO();
                v.setId(t.getInvoiceId());
                if ("del".equals(t.getRowState()) && t.getId() != null) {
                    v.setNowUesdInvoiceTaxMny(BigDecimalUtil.convertToMinusNumber(old));
                } else {
                    v.setNowUesdInvoiceTaxMny(BigDecimalUtil.safeSub(t.getUsedInvoiceTaxMny(), old));
                }
                updates.add(v);
            });
            if (invoiceEntityMap != null && invoiceEntityMap.size() > 0) {
                List newInoviceIds = voList.stream().filter(s -> s.getId() != null).map(BaseVO::getId).collect(Collectors.toList());
                for (Map.Entry m : invoiceEntityMap.entrySet()) {
                    if (newInoviceIds.contains(m.getKey())) continue;
                    LoadInvoiceEntity t2 = (LoadInvoiceEntity)((Object)m.getValue());
                    InvoiceReceiveFlagVO v = new InvoiceReceiveFlagVO();
                    v.setId(t2.getInvoiceId());
                    v.setNowUesdInvoiceTaxMny(BigDecimalUtil.convertToMinusNumber(t2.getUsedInvoiceTaxMny()));
                    updates.add(v);
                }
            }
            res = this.invoiceApi.updateUsedInvoiceMny(updates);
        } else if (CollectionUtils.isNotEmpty((Collection)oldInvoiceList)) {
            ArrayList updates = new ArrayList();
            oldInvoiceList.forEach(t -> {
                InvoiceReceiveFlagVO v = new InvoiceReceiveFlagVO();
                v.setId(t.getInvoiceId());
                v.setNowUesdInvoiceTaxMny(BigDecimalUtil.convertToMinusNumber(t.getUsedInvoiceTaxMny()));
                updates.add(v);
            });
            res = this.invoiceApi.updateUsedInvoiceMny(updates);
        }
        if (!res.isSuccess()) {
            this.logger.error("\u56de\u5199\u6536\u7968\u5df2\u4f7f\u7528\u91d1\u989d\u5931\u8d25\uff1a" + res.getMsg());
        }
        return res;
    }

    @Override
    public CommonResponse<String> updateInvoiceUsedMnyByDel(List<Long> ids) {
        QueryParam param = new QueryParam();
        param.getParams().put("reimburseId", new Parameter("in", ids));
        List invoiceEntityList = this.queryList(param, false);
        if (CollectionUtils.isNotEmpty((Collection)invoiceEntityList)) {
            ArrayList updates = new ArrayList();
            invoiceEntityList.forEach(t -> {
                InvoiceReceiveFlagVO v = new InvoiceReceiveFlagVO();
                v.setId(t.getInvoiceId());
                v.setNowUesdInvoiceTaxMny(BigDecimalUtil.convertToMinusNumber(t.getUsedInvoiceTaxMny()));
                updates.add(v);
            });
            CommonResponse res = this.invoiceApi.updateUsedInvoiceMny(updates);
            if (!res.isSuccess()) {
                this.logger.error("\u4ed8\u6b3e\u7533\u8bf7\u5220\u9664\u9006\u56de\u5199\u6536\u7968\u5df2\u4f7f\u7528\u91d1\u989d\u62a5\u9519\uff1a" + res.getMsg());
            }
        }
        return CommonResponse.success();
    }
}

