package com.ejianc.business.finance.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @description: 收入类型下拉枚举
 * @author songlx
 * @date: 2021/8/31
 */
public enum ReceiveTypeEnum {


    CONTRACT(1275321308270993409L, "工程合同收款"),
    OTHER(1275321354706132993L, "其他收款"),
    CLAIM(1432591258004422658L, "变更签证索赔收款"),
    ZHI_BAO_JIN(723940510485454923L, "质保金");

    private final Long code;
    private final String name;
    private static Map<Integer, ReceiveTypeEnum> enumMap = new HashMap();

    private ReceiveTypeEnum(Long code, String name) {
        this.code = code;
        this.name = name;
    }

    public Long getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public static String getNameByCode(Long code) {
        ReceiveTypeEnum receiveTypeEnum = enumMap.get(code);
        return receiveTypeEnum != null ? receiveTypeEnum.getName() : null;
    }

    static {
        enumMap = (Map) EnumSet.allOf(ReceiveTypeEnum.class).stream().collect(Collectors.toMap(ReceiveTypeEnum::getCode, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }
}
