package com.ejianc.business.finance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.equipment.api.IEquipmentContractApi;
import com.ejianc.business.equipment.vo.EquipmentReportVo;
import com.ejianc.business.finance.bean.*;
import com.ejianc.business.finance.controller.SqlParam;
import com.ejianc.business.finance.enums.ConstantTypeEnum;
import com.ejianc.business.finance.enums.ContractTypeConst;
import com.ejianc.business.finance.mapper.PayContractMapper;
import com.ejianc.business.finance.pub.vo.PubContractSettleVO;
import com.ejianc.business.finance.pub.vo.PubContractSubQueryVO;
import com.ejianc.business.finance.pub.vo.PubWarnQueryVO;
import com.ejianc.business.finance.service.*;
import com.ejianc.business.finance.util.BillTypeCodeEnum;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.finance.util.NoticeEnum;
import com.ejianc.business.finance.util.ValidateUtil;
import com.ejianc.business.finance.utils.*;
import com.ejianc.business.finance.vo.*;
import com.ejianc.business.income.api.IContractReportApi;
import com.ejianc.business.income.api.IIncomeContractApi;
import com.ejianc.business.income.vo.ContractVo;
import com.ejianc.business.income.vo.report.IncomeReportMnyVo;
import com.ejianc.business.income.vo.report.ProjectReportVo;
import com.ejianc.business.material.api.IMaterialContractApi;
import com.ejianc.business.material.api.IMaterialSettlementApi;
import com.ejianc.business.material.vo.MaterialReportVo;
import com.ejianc.business.prjfinance.api.IPrjRiskMarginApi;
import com.ejianc.business.prjfinance.api.IProjectDutyLetterApi;
import com.ejianc.business.sub.api.ISubContractForPayApi;
import com.ejianc.business.sub.api.ISubReportApi;
import com.ejianc.business.sub.vo.SubProjectReportVo;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.business.tax.vo.InvoiceReceiveVO;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author yqls
 * @since 2020-06-04
 */
@Service
public class PayContractServiceImpl extends BaseServiceImpl<PayContractMapper, PayContractEntity> implements IPayContractService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String PAY_CONTRACT_BILL_CODE = "PAY_CONTRACT";
    private static final String CHECK_PARAM_CODE = "P-v1U24318";

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IDefdocApi defdocApi;

    @Autowired
    private IPayInvoiceService invoiceService;

    @Autowired
    private IPayContractSettleService settleService;


    @Autowired
    private IPayContractDeductionService contractDeductionService;

    @Autowired
    private IPayRecordService payRecordService;

    @Autowired
    private IPaySporadicService sporadicService;

    @Autowired
    private IPayReimburseService reimburseService;

    @Autowired
    private IPayForegiftService foregiftService;

    @Autowired
    private IPayForegiftRecordService recordService;

    @Autowired
    private IPayForegiftPlanService planService;

    @Autowired
    private IReceiveService receiveService;

    @Autowired
    private ISubContractForPayApi subApi;

    @Autowired
    private IEquipmentContractApi equipmentApi;

    @Autowired
    private IMaterialSettlementApi materialApi;

    @Autowired
    private IIncomeContractApi incomeApi;

    @Autowired
    private ILoadReimburseService loadReimburseService;
    @Autowired
    private IContractReportApi contractReportApi;// 移动看板,收入合同
    @Autowired
    private ISubReportApi subReportApi;// 移动看板，分包合同
    @Autowired
    private IMaterialContractApi materialContractApi;// 移动看板，物资合同
    @Autowired
    private IInvoiceApi invoiceApi;// 移动看板，开票

    @Autowired
    private IParamConfigApi paramConfigApi;

    @Autowired
    private FeignUtil feignUtil;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private ILoadApplyService loadApplyService;

    @Autowired
    private IPrjRiskMarginApi prjRiskMarginApi;


    @Autowired
    private IProjectDutyLetterApi projectDutyLetterApi;

    @Autowired
    private IDeductionService deductionService;

    @Autowired
    private PayRecordMessageService payRecordMessageService;


    /**
     * @param projectId
     * @description: 根据项目获取合同收款（收入类型工程合同）、累计收款（合同收款+其他收款） 、累计付款
     * @return: com.ejianc.business.finance.vo.ManageDetailVO
     * @author songlx
     * @date: 2021/7/29
     */
    public ManageDetailVO getManageDetailPlus(Long projectId) {
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        //已生效状态的单据
        param.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
        // 收入管理
        List<ReceiveEntity> receiveList = receiveService.queryList(param, false);
        BigDecimal sumReceiveMny = null;
        BigDecimal sumContractReceiveMny = BigDecimal.ZERO;
        for (ReceiveEntity receive : receiveList) {
            if (receive.getReceiveType() != null && String.valueOf(receive.getReceiveType()).equals("1275321308270993409")) {
                sumContractReceiveMny = MathUtil.safeAdd(sumContractReceiveMny, receive.getReceiveMny());
            }
            sumReceiveMny = MathUtil.safeAdd(sumReceiveMny, receive.getReceiveMny());
        }
        // 合同付款
        List<PayContractEntity> contractList = super.queryList(param, false);
        BigDecimal sumPayMny = null;
        for (PayContractEntity contract : contractList) {
            sumPayMny = MathUtil.safeAdd(sumPayMny, contract.getPayMny());
        }
        ManageDetailVO vo = new ManageDetailVO();
        vo.setProjectId(projectId);
        vo.setSumReceiveMny(sumReceiveMny);
        vo.setSumContractReceiveMny(sumContractReceiveMny);
        vo.setSumPayMny(sumPayMny);
        return vo;
    }

    @Override
    public ProjectFinanceVO getProFinance(Long projectId) {
        ProjectFinanceVO vo = new ProjectFinanceVO(projectId);
        CommonResponse<JSONObject> resProject = incomeApi.projectProgress(projectId);
        if (resProject.isSuccess()) {
            JSONObject data = resProject.getData();
            /***
             * projectDepartmentId 项目 orgId
             //合同额  contractMoney
             private BigDecimal proContractMoney;
             //产值   outputMoney
             private BigDecimal proOutputMoney;

             //日期进度  dateProgress
             private BigDecimal proDateProgress;

             //产值进度  outputProgress
             private BigDecimal proOutputProgress;
             */
            //项目类型
            vo.setProjectType(data.getString("type"));

            vo.setProContractMny(BigDecimalUtil.nullToZero(data.getBigDecimal("contractMoney")));
            vo.setProOutputMny(BigDecimalUtil.nullToZero(data.getBigDecimal("outputMoney")));
            String dateProgressStr = data.getString("dateProgress");
            vo.setProDateProgress(BigDecimalUtil.nullToZero(BigDecimalUtil.toBigDecimal(dateProgressStr)));
            String outputProgress = data.getString("outputProgress");
            vo.setProOutputProgress(BigDecimalUtil.nullToZero(BigDecimalUtil.toBigDecimal(outputProgress)));

            ManageDetailVO manageDetailPlus = this.getManageDetailPlus(projectId);
            //累计收款 = 合同收款 + 其他收款
            vo.setProReceiveMny(BigDecimalUtil.nullToZero(manageDetailPlus.getSumReceiveMny()));
            //累计合同收款
            vo.setProContractReceiveMny(BigDecimalUtil.nullToZero(manageDetailPlus.getSumContractReceiveMny()));


            Long projectDepartmentId = data.getLong("projectDepartmentId");
            if (projectDepartmentId != null) {
                Page<LoadApplyVO> page = new Page<>(1, -1);
                QueryParam param = new QueryParam();
                param.getParams().put("orgId", new Parameter("eq", projectDepartmentId));
                QueryWrapper wrapper = changeToQueryWrapper(param);
                List<LoadApplyVO> list = loadApplyService.queryAllReport(page, wrapper);
                BigDecimal surplusMny = BigDecimal.ZERO;
                if (CollectionUtils.isNotEmpty(list)) {
                    for (LoadApplyVO ap : list) {
                        surplusMny = BigDecimalUtil.safeAdd(surplusMny, ap.getSurplusMny());
                    }
                }
                //备用金结余
                vo.setProPettyCash(BigDecimalUtil.nullToZero(surplusMny));
            }
        } else {
            logger.error("查询项目资金费用清单结余失败(from income)：" + resProject.getMsg());
        }

        //data. costListBalance	费用清单结余	获取实时的
        CommonResponse<BigDecimal> costMoneyByProjectId = projectDutyLetterApi.getCostMoneyByProjectId(projectId);
        if (costMoneyByProjectId.isSuccess()) {
            vo.setProCostListSurplus(costMoneyByProjectId.getData());
        } else {
            logger.error("查询项目资金费用清单结余失败(from prjfinance)：" + costMoneyByProjectId.getMsg());
        }

        CommonResponse<Map> resPrjFinanceData = prjRiskMarginApi.getPrjFinanceData(projectId);
        if (resPrjFinanceData.isSuccess()) {
            Map dataMap = resPrjFinanceData.getData();
            /***
             data. riskMarginBalance	风险保证金结余	是	BigDecimal
             data. otherReturns	其他费用返还	是	BigDeciaml
             data. otherDeductions	其他费用扣除	是	BigDecimal
             data. costListBalance	费用清单结余	是	BigDecimal
             data. managementExpense	管理费比例（小数）	是	BigDecimal
             data. amerce	罚款	是	BigDecimal
             data. prjAdvancePaymentBalance	项目待转款结余	是	BigDecimal
             data. loanBalance	借款结余	是	BigDecimal
             data. loanInterests	借款利息	是	BigDecimal
             */
            vo.setProRiskMarginSurplus(BigDecimalUtil.nullToZero(BigDecimalUtil.toBigDecimal(dataMap.get("riskMarginBalance"))));
            vo.setProOtherFeeBack(BigDecimalUtil.nullToZero(BigDecimalUtil.toBigDecimal(dataMap.get("otherReturns"))));
            vo.setProOtherFeeDeduct(BigDecimalUtil.nullToZero(BigDecimalUtil.toBigDecimal(dataMap.get("otherDeductions"))));
            BigDecimal managementExpense = BigDecimalUtil.toBigDecimal(dataMap.get("managementExpense"));
            vo.setProManageScale(BigDecimalUtil.nullToZero(managementExpense));
            // 管理费 = 合同收款 * 管理费比例
            vo.setProManageFee(BigDecimalUtil.nullToZero(BigDecimalUtil.safeMultiply(vo.getProContractReceiveMny(), managementExpense)));
            vo.setProAmerce(BigDecimalUtil.nullToZero(BigDecimalUtil.toBigDecimal(dataMap.get("amerce"))));
            vo.setProTransferSurplus(BigDecimalUtil.nullToZero(BigDecimalUtil.toBigDecimal(dataMap.get("prjAdvancePaymentBalance"))));
            vo.setProLoanBalance(BigDecimalUtil.nullToZero(BigDecimalUtil.toBigDecimal(dataMap.get("loanBalance"))));
            vo.setProLoanInterest(BigDecimalUtil.nullToZero(BigDecimalUtil.toBigDecimal(dataMap.get("loadInterests"))));
        } else {
            logger.error("查询项目风险保证金结余、其他费用返还等金额失败(from prjfinance)：" + resPrjFinanceData.getMsg());
        }
        ProjectFinancePayVO projectApplyPayInfo = baseMapper.getProjectApplyPayInfo(projectId);
        if (null != projectApplyPayInfo) {
            vo.setProApplyUnpayMny(BigDecimalUtil.nullToZero(BigDecimalUtil.safeSub(projectApplyPayInfo.getSumApplyMny(), projectApplyPayInfo.getSumPayMny())));
            //累计付款
            vo.setProPayMny(projectApplyPayInfo.getSumPayMny());
        }
        //累计付款 还包含 备用金报销
        Map<String, Object> resMap = loadReimburseService.countAmt(InvocationInfoProxy.getTenantid(), Collections.singletonList(projectId));
        BigDecimal amt = BigDecimalUtil.toBigDecimal(resMap.get("amt"));
        vo.setProPayMny(BigDecimalUtil.nullToZero(BigDecimalUtil.safeAdd(vo.getProPayMny(), amt)));
        //项目可用资金：累计收款—合同付款—其他付款—费用清单结余—管理费—罚款—风险保证金结余—借款利息—备用金额结余—其他扣除
        // +项目代转款结余
        // +其他返还
        // +借款结余
        BigDecimal subMny = BigDecimalUtil.safeSub(vo.getProReceiveMny(), vo.getProPayMny(), vo.getProCostListSurplus(), vo.getProManageFee()
                , vo.getProAmerce(), vo.getProRiskMarginSurplus(), vo.getProLoanInterest(), vo.getProPettyCash(), vo.getProOtherFeeDeduct());
        BigDecimal proSurPlusMny = BigDecimalUtil.safeAdd(subMny, vo.getProTransferSurplus(), vo.getProOtherFeeBack(), vo.getProLoanBalance());
        vo.setProSurplusMny(BigDecimalUtil.nullToZero(proSurPlusMny));
        //剩余可申请金额=项目可用资金—该项目下已申请未支付金额；
        vo.setProSurplusApplyMny(BigDecimalUtil.scaleTwo(BigDecimalUtil.nullToZero(BigDecimalUtil.safeSub(vo.getProSurplusMny(), vo.getProApplyUnpayMny()))));
        return vo;
    }

    @Override
    public List<ProjectReimburseVO> getProjectReimburse(List<Long> projectIds, List<Integer> billStates) {
        return this.baseMapper.getProjectReimburse(projectIds, billStates);
    }

    @Override
    public List<FinanceWarnV0> getProjectPayMny() {
        return baseMapper.getProjectPayMny();
    }


    @Override
    public PayContractVO insertOrUpdate(PayContractVO vo) {
        PayContractEntity entity = BeanMapper.map(vo, PayContractEntity.class);
        // 设置默认是否需要发票
        /*if (StringUtils.isEmpty(entity.getInvoiceFlag())) {
            entity.setInvoiceFlag("3");
        }*/

//        // 是否需要回写
//        boolean writeFlag = this.getWriteFlag(vo);
//        if(!vo.getManageFlag()){
//            // 校验同合同、同组织下只能有一张未生效单据
//            this.validateBeforeSave(entity);
//        }
        // 校验同合同、同组织下只能有一张未生效单据, 已生效单据不做此校验 modifyby CJ 2021年7月21日 16:53:05
        if (!BillStateEnum.COMMITED_STATE.getBillStateCode().equals(vo.getBillState()) && !BillStateEnum.PASSED_STATE.getBillStateCode().equals(vo.getBillState())) {
            this.validateBeforeSave(entity);
        }
        // 保存时校验合同version是否一致
        String billTypeCode = BillTypeCodeEnum.getContractBillTypeCode(vo.getContractType());
        if (!ValidateUtil.validateUpstreamVersion(String.valueOf(vo.getContractId()), billTypeCode, vo.getContractVersion())) {
            throw new BusinessException("该合同已被更新，请刷新后重做！");
        }

        //判断扣款单是否是该项目+供应商下
        List<PayContractDeductionVO> deductionVOList = vo.getDeductionVOList();
        if (!CollectionUtils.isEmpty(deductionVOList)){
            List<Long> dedIds = deductionVOList.stream().map(PayContractDeductionVO::getDeductionId).collect(Collectors.toList());
            QueryWrapper<DeductionEntity> dedQueryWrapper = new QueryWrapper();
            dedQueryWrapper.in("id",dedIds);
            List<DeductionEntity> dedList = deductionService.list(dedQueryWrapper);
            for (DeductionEntity deductionEntity : dedList) {
                if (!deductionEntity.getSupplierId().equals(vo.getReceiveUnitId()) || !deductionEntity.getProjectId().equals(vo.getProjectId())){
                    throw new BusinessException("请选择同一项目，同一供应商下的扣款单！");
                }
            }
        }

        List<PayInvoiceVO> voList = vo.getInvoiceVOList();
        if (CollectionUtils.isNotEmpty(voList)) {
            for (PayInvoiceVO invoiceVO : voList) {
                // 保存时校验version是否一致
                if (!ValidateUtil.validateUpstreamVersion(String.valueOf(invoiceVO.getInvoiceId()),
                        BillTypeCodeEnum.税务收票.getBillTypeCode(), invoiceVO.getInvoiceVersion())) {
                    throw new BusinessException("发票已被更新，请刷新后重做！");
                }
            }
        }
        CommonResponse<String> usedMnyRes = invoiceService.updateInvoiceUsedMnyBySave(voList, entity.getId());
        if (!usedMnyRes.isSuccess()) {
            throw new BusinessException(usedMnyRes.getMsg());
        }
        // 自动生成编码
        this.autoSetBillCode(entity);
        // 保存主表
        super.saveOrUpdateNoES(entity);
        Long id = entity.getId();
        // 更新发票
        List<PayInvoiceVO> invoiceVOList = this.updateInvoiceVOS(vo, id);
        // 更新结算
        List<PayContractSettleVO> settleVOList = this.updateSettleVOS(vo, id);
        // 更新扣款单
        List<PayContractDeductionVO> payContractDeductionVOS = this.updateDeductionVOS(vo, id);


//        // 确认支付回写累计付款与累计预付款金额
//        if(writeFlag){
//            this.writeBackSumPayMny(id, entity, true);
//        }
        // 返回VO
        if (entity.getId() != null) {
            QueryWrapper wrapper = new QueryWrapper<PayInvoiceEntity>();
            wrapper.eq("payapply_id", entity.getId());
            invoiceVOList = invoiceService.list(wrapper);
        }
        PayContractEntity payContractEntity = super.getById(id);
        PayContractVO backVO = BeanMapper.map(payContractEntity, PayContractVO.class);
        backVO.setInvoiceVOList(invoiceVOList);// 发票列表
        backVO.setSettleVOList(settleVOList);// 结算列表
        backVO.setDeductionVOList(payContractDeductionVOS);
        ProjectFinanceVO v = BeanMapper.map(payContractEntity, ProjectFinanceVO.class);
        backVO.setProjectFinanceVO(v);
        return backVO;
    }

    @Override
    public PayContractVO queryDetail(Long id) {
        // 查询主表
        PayContractEntity entity = this.selectById(id);
        PayContractVO vo = BeanMapper.map(entity, PayContractVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("payapplyId", new Parameter(QueryParam.EQ, vo.getId()));
        queryParam.getOrderMap().put("createTime", "desc");
        // 查询关联发票
        List<PayInvoiceEntity> invoiceEntityList = invoiceService.queryList(queryParam, false);
        vo.setInvoiceVOList(BeanMapper.mapList(invoiceEntityList, PayInvoiceVO.class));
        // 查询关联结算
        List<PayContractSettleEntity> settleEntityList = settleService.queryList(queryParam, false);
        vo.setSettleVOList(BeanMapper.mapList(settleEntityList, PayContractSettleVO.class));
        // 查询关联扣款
        List<PayContractDeductionEntity> payContractDeductionEntities = contractDeductionService.queryList(queryParam, false);
        vo.setDeductionVOList(BeanMapper.mapList(payContractDeductionEntities, PayContractDeductionVO.class));

        // 查询付款记录
        List<PayRecordEntity> recordList = payRecordService.queryList(queryParam);
        vo.setRecordList(BeanMapper.mapList(recordList, PayRecordVO.class));
        //项目资金详情
        vo.setProjectFinanceVO(BeanMapper.map(vo, ProjectFinanceVO.class));
        if(null != vo.getPayMny()){
            vo.setPayMnyCn(NumberToCN.number2CN(vo.getPayMny()));
        }
        return vo;
    }

    @Override
    public List<PayContractVO> queryExportList(QueryParam param) {
        param.setPageIndex(0);
        param.setPageSize(-1);
        List<PayContractVO> resVos = (List<PayContractVO>) queryPageJson(param, false).get("records");
        if (!resVos.isEmpty()) {
            for (int i = 0; i < resVos.size(); i++) {
                PayContractVO vo = resVos.get(i);
                vo.setFeeTypeName(ConstantTypeEnum.getEnumByCode(vo.getFeeType()).getName());
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            }
        }
        return resVos;
    }

    @Override
    public String delete(List<Long> ids) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter(QueryParam.IN, ids));
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<PayContractEntity> entityList = super.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty(entityList)) {
            super.removeByIds(ids, false);

            invoiceService.updateInvoiceUsedMnyByDel(ids);

            // 删除发票
            invoiceService.remove(new QueryWrapper<PayInvoiceEntity>().in("payapply_id", ids), false);

            // 删除结算
            settleService.remove(new QueryWrapper<PayContractSettleEntity>().in("payapply_id", ids), false);

            // 删除关联扣款单
            QueryWrapper wrapper = new QueryWrapper<PayContractDeductionEntity>();
            wrapper.in("payapply_id", ids);
            List<PayContractDeductionEntity> list = contractDeductionService.list(wrapper);
            if (CollectionUtils.isNotEmpty(list)) {
                List<Long> dedIds = list.stream().map(PayContractDeductionEntity::getDeductionId).collect(Collectors.toList());
                if (this.updateDeductionUseFlag(dedIds, 0)) {
                    contractDeductionService.remove(new QueryWrapper<PayContractDeductionEntity>().in("payapply_id", ids), false);
                }
            }
        }
        return "删除成功！";
    }

    private boolean updateDeductionUseFlag(List<Long> dedIds, int flag) {
        LambdaUpdateWrapper<DeductionEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(DeductionEntity::getId, dedIds);
        updateWrapper.set(DeductionEntity::getIsUse, flag);
        return deductionService.update(updateWrapper);
    }


    @Override
    public JSONObject queryPageJson(QueryParam param, boolean isEs) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("receiveUnitName");
        fuzzyFields.add("applyUserName");
        fuzzyFields.add("accountName");
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        // 组织本下
        param.getParams().put("org_id", new Parameter("in", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        Parameter parameterFlag = param.getParams().get("relationInvoiceFlag");
        param.getParams().remove("relationInvoiceFlag");
        String flag = parameterFlag == null ? null : parameterFlag.getValue().toString();

        Page<PayContractVO> pages = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<PayContractVO> list = baseMapper.queryPageList(pages, wrapper, flag);

        list.forEach(vo -> {
            if (null != vo.getApplyMny()) {
                vo.setUnpaidMny(vo.getApplyMny().subtract(vo.getPayMny() == null ? BigDecimal.ZERO : vo.getPayMny()));
            }
            vo.setApplyHasPenaltyMny(ComputeUtil.safeAdd(vo.getApplyMny(), vo.getCurPenaltyMoney()));
        });

        JSONObject page = new JSONObject();
        page.put("records", list);
        page.put("total", pages.getTotal());
        page.put("current", pages.getCurrent());
        page.put("size", pages.getSize());
        page.put("pages", pages.getPages());
        return page;
    }

    @Override
    public JSONObject querySettleRefer(QueryParam param, Integer contractType) {
        CommonResponse<JSONObject> apiContract = null;
        if (contractType != null) {
            switch (contractType) {
                case 1://分包
                    break;
                case 2://设备采购
                    apiContract = equipmentApi.getContractSettle(param);
                    break;
                case 3://设备租赁
                    apiContract = equipmentApi.getRentSettle(param);
                    break;
                case 4://物资采购
                    break;
                case 5://物资租赁
                    break;
            }
        }
        JSONObject page = new JSONObject();
        if (apiContract.isSuccess()) {
            page = apiContract.getData();
            apiContract.getData().get("records");
            ObjectMapper mapper = new ObjectMapper();
            List<PubContractSettleVO> settleVOList = mapper.convertValue(apiContract.getData().get("records"), new TypeReference<List<PubContractSettleVO>>() {
            });
            // 处理申请金额
            if (!settleVOList.isEmpty()) {
                Map<Long, PubContractSettleVO> settleMap = settleVOList.stream().collect(Collectors.toMap(PubContractSettleVO::getId, Function.identity()));
                List<Long> ids = settleVOList.stream().map(PubContractSettleVO::getId).collect(Collectors.toList());
                QueryWrapper wrapper = new QueryWrapper<PayContractSettleEntity>().in("settle_id", ids);
                wrapper.last("and payapply_id in (select id from ejc_finance_pay_contract where dr = 0 and bill_state in (1,3))");
                List<PayContractSettleEntity> entityList = settleService.list(wrapper);
                for (PayContractSettleEntity entity : entityList) {
                    if (settleMap.containsKey(entity.getSettleId())) {
                        PubContractSettleVO vo = settleMap.get(entity.getSettleId());
                        vo.setSumApplyMny(MathUtil.safeAdd(vo.getSumApplyMny(), entity.getBodyApplyMny()));
                    }
                }
                for (Long id : settleMap.keySet()) {
                    PubContractSettleVO vo = settleMap.get(id);
                    vo.setSurplusApplyMny(MathUtil.safeSub(vo.getSettleMny(), vo.getSumApplyMny()));
                    // 过滤剩余申请金额=0的结算单
                    if (vo.getSurplusApplyMny().compareTo(new BigDecimal(0)) == 0) {
                        settleMap.remove(id);
                    }
                }
                page.put("records", new ArrayList(settleMap.values()));
            }
        } else {
            throw new BusinessException("网络异常， 请稍后再试");
        }
        return page;
    }

    @Override
    public SumPayMnyVO getSumPayMny(Long contractId, Long orgId) {
        QueryParam param = new QueryParam();
        param.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        if (orgId != null) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        }
        //param.getParams().put("payStatus", new Parameter(QueryParam.EQ, 2));//已支付
        //已生效状态的单据
        param.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
        List<PayContractEntity> entityList = super.queryList(param, false);
        SumPayMnyVO vo = new SumPayMnyVO();
        vo.setContractId(contractId);
        vo.setOrgId(orgId);
        BigDecimal sumPayMny = null;
        BigDecimal sumPrePayMny = null;
        BigDecimal sumApplyMny = null;
        for (PayContractEntity entity : entityList) {
            if (2 == entity.getPayStatus()) {
                sumPayMny = MathUtil.safeAdd(sumPayMny, entity.getPayMny());
            }
            if (entity.getFeeType() == 1) {
                sumPrePayMny = MathUtil.safeAdd(sumPrePayMny, entity.getApplyMny());
            }
            //累计已申请金额=申请金额+扣款金额
            sumApplyMny = ComputeUtil.safeAdd(sumApplyMny, entity.getApplyMny(), entity.getCurPenaltyMoney());
        }
        vo.setSumApplyMny(sumApplyMny);
        vo.setSumPrePayMny(sumPrePayMny);
        vo.setSumPayMny(sumPayMny);
        return vo;
    }

    @Override
    public SumPayMnyVO getSumPayMnyVOList(Long contractId, Long orgId) {
        QueryParam param = new QueryParam();
        param.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        if (orgId == null) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        // 组织本下
        param.getParams().put("orgId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        //param.getParams().put("payStatus", new Parameter(QueryParam.EQ, 2));//已支付
        // 已生效状态的单据
        param.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
        param.getOrderMap().put("createTime", QueryParam.DESC);
        List<PayContractEntity> entityList = super.queryList(param, false);
        // 累计付款金额
        BigDecimal sumPayMny = null;
        //累计付款申请金额
        BigDecimal sumApplyMny = null;
        //累计扣款金额
        BigDecimal sumDeductionMny = null;
        for (PayContractEntity entity : entityList) {
            sumPayMny = MathUtil.safeAdd(sumPayMny, entity.getPayMny());
            sumApplyMny = MathUtil.safeAdd(sumApplyMny, entity.getApplyMny());
            sumDeductionMny = MathUtil.safeAdd(sumDeductionMny, entity.getCurPenaltyMoney());
        }
        SumPayMnyVO vo = new SumPayMnyVO();
        vo.setContractId(contractId);
        vo.setOrgId(orgId);
        vo.setSumPayMny(sumPayMny);
        vo.setSumApplyMny(sumApplyMny);
        vo.setSumDeductionMny(sumDeductionMny);
        vo.setContractVOList(BeanMapper.mapList(entityList, PayContractVO.class));
        return vo;
    }

    @Override
    public JSONObject queryPendingPageJson(QueryParam param, boolean isEs) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("receiveUnitName");
        fuzzyFields.add("applyUserName");
        fuzzyFields.add("accountName");
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        // 组织本下
        param.getParams().put("orgId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        //已生效状态的单据
        param.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
//        param.getParams().put("payStatus",new Parameter(QueryParam.EQ, 1));//未支付
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));//未删除
        //param.getOrderMap().put("approveTime", QueryParam.DESC);

        // 转换报销筛选条件
        transformReimburse(param);
        Page<PayApplyPubVO> pages = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        QueryWrapper<PayApplyPubVO> wrapper = changeToQueryWrapper(param);
        // 未支付或者支付金额小于申请金额为待处理,并且未关闭的
        wrapper.and(x -> x.last("(pay_status = 1 or IFNULL(pay_mny,0) < apply_mny) AND IFNULL(close_flag,0) = 0"));
        List<PayApplyPubVO> list = baseMapper.queryPendingList(pages, wrapper);
        Map<Long, String> defdocMap = feignUtil.getDefdocMap(324875125018329093L);
        if (!list.isEmpty()) {
            for (PayApplyPubVO vo : list) {
                // 翻译报销
                if ("报销".equals(vo.getApplyType()) && defdocMap.containsKey(vo.getFeeTypeId())) {
                    vo.setFeeType("报销-" + defdocMap.get(vo.getFeeTypeId()));
                }
            }
        }
        list.forEach(vo -> {
            if(null != vo.getApplyMny()){
                vo.setUnpaidMny(vo.getApplyMny().subtract(vo.getPayMny() == null ? BigDecimal.ZERO : vo.getPayMny()));
            }
        });
        JSONObject page = new JSONObject();
        page.put("records", list);
        page.put("total", pages.getTotal());
        page.put("current", pages.getCurrent());
        page.put("size", pages.getSize());
        page.put("pages", pages.getPages());
        return page;
    }

    @Override
    public List<PayApplyPubVO> queryExportPendingList(QueryParam param) {
        param.setPageIndex(0);
        param.setPageSize(-1);
        List<PayApplyPubVO> records = (List<PayApplyPubVO>) queryPendingPageJson(param, false).get("records");
        return records;
    }

//    @Override
//    public String batchConfirm(List<PayApplyPubVO> vos) {
//        for(PayApplyPubVO vo : vos){
//            if("合同付款".equals(vo.getApplyType())){
//                PayContractVO updateVO = this.queryDetail(vo.getId());
//                updateVO.setEmployeeId(vo.getEmployeeId());
//                updateVO.setEmployeeName(vo.getEmployeeName());
//                updateVO.setConfirmTime(vo.getConfirmTime());
//                updateVO.setPayMny(vo.getPayMny());
//                updateVO.setPayStatus(vo.getPayStatus());
//                this.insertOrUpdate(updateVO);
//            }
//            if("零星采购".equals(vo.getApplyType())){
//                PaySporadicVO updateVO = sporadicService.queryDetail(vo.getId());
//                updateVO.setEmployeeId(vo.getEmployeeId());
//                updateVO.setEmployeeName(vo.getEmployeeName());
//                updateVO.setConfirmTime(vo.getConfirmTime());
//                updateVO.setPayMny(vo.getPayMny());
//                updateVO.setPayStatus(vo.getPayStatus());
//                sporadicService.insertOrUpdate(updateVO);
//            }
//            if("报销".equals(vo.getApplyType())){
//                PayReimburseVO updateVO = reimburseService.queryDetail(vo.getId());
//                updateVO.setEmployeeId(vo.getEmployeeId());
//                updateVO.setEmployeeName(vo.getEmployeeName());
//                updateVO.setConfirmTime(vo.getConfirmTime());
//                updateVO.setPayMny(vo.getPayMny());
//                updateVO.setPayStatus(vo.getPayStatus());
//                reimburseService.insertOrUpdate(updateVO);
//            }
//            if("押金".equals(vo.getApplyType())){
//                PayForegiftVO updateVO = foregiftService.queryDetail(vo.getId());
//                updateVO.setEmployeeId(vo.getEmployeeId());
//                updateVO.setEmployeeName(vo.getEmployeeName());
//                updateVO.setConfirmTime(vo.getConfirmTime());
//                updateVO.setPayMny(vo.getPayMny());
//                updateVO.setPayStatus(vo.getPayStatus());
//                foregiftService.insertOrUpdate(updateVO);
//            }
//        }
//        return "批量支付成功！";
//    }

    /**
     * 分批支付改造
     *
     * @param vos
     * @return
     */
    @Override
    public String batchConfirm(List<PayApplyPubVO> vos) {
        for (PayApplyPubVO vo : vos) {
            PayRecordVO record = new PayRecordVO();
            BigDecimal msgPayMny = BigDecimal.ZERO;
            if ("合同付款".equals(vo.getApplyType())) {
                PayContractVO data = this.queryDetail(vo.getId());
                //PayRecordVO record = new PayRecordVO();
                record.setBillCode(data.getBillCode());// 单据编号
                record.setPayapplyId(data.getId());// 申请单主键
                record.setContractId(data.getContractId());
                ;// 合同
                record.setContractName(data.getContractName());
                record.setContractType(data.getContractType());// 合同类型
                record.setProjectId(data.getProjectId());// 项目
                record.setProjectName(data.getProjectName());
                record.setOrgId(data.getOrgId());// 组织
                record.setOrgName(data.getOrgName());
                record.setApplyUserId(data.getApplyUserId());// 申请人
                record.setApplyUserName(data.getApplyUserName());
                record.setApplyTime(data.getApplyTime());// 申请时间
                record.setApplyMny(data.getApplyMny());// 申请金额
                BigDecimal surplusPayMny = MathUtil.safeSub(data.getApplyMny(), data.getPayMny());// 剩余可支付金额
                record.setThisPayMny(surplusPayMny);// 本期支付金额默认等于剩余可支付金额
                record.setReceiveUnitId(data.getReceiveUnitId());// 收款单位
                record.setReceiveUnitName(data.getReceiveUnitName());
                record.setApplyType("合同付款");// 付款类型
                record.setFeeType(data.getFeeType());
                ;//付款-预付款
                record.setEmployeeId(vo.getEmployeeId());
                record.setEmployeeName(vo.getEmployeeName());
                record.setConfirmTime(vo.getConfirmTime());
                record.setAccountName(vo.getAccountName());
                record.setAccountNum(vo.getAccountNum());
                record.setAccountBank(vo.getAccountBank());
                record.setPayWay(vo.getPayWay());
                record.setPayWayName(vo.getPayWayName());
                record.setMemo(vo.getMemo());
                record.setPayNotesId(vo.getPayNotesId());
                record.setPayNotesName(vo.getPayNotesName());
                record.setReceiveNotesId(vo.getReceiveNotesId());
                record.setReceiveNotesName(vo.getReceiveNotesName());
                record.setBillingRoomId(vo.getBillingRoomId());
                record.setBillingRoomName(vo.getBillingRoomName());
                record.setAccountId(vo.getAccountId());
                record.setCarModelId(vo.getCarModelId());
                record.setCarModelName(vo.getCarModelName());
                record.setMaterialInfo(vo.getMaterialInfo());
                payRecordService.insertOrUpdate(record);
                msgPayMny = ComputeUtil.safeAdd(data.getPayMny(),record.getThisPayMny());
            }
            if ("零星采购".equals(vo.getApplyType())) {
                PaySporadicVO data = sporadicService.queryDetail(vo.getId());
                //PayRecordVO record = new PayRecordVO();
                record.setBillCode(data.getBillCode());// 单据编号
                record.setPayapplyId(data.getId());// 申请单主键
                record.setProjectId(data.getProjectId());// 项目
                record.setProjectName(data.getProjectName());
                record.setOrgId(data.getOrgId());// 组织
                record.setOrgName(data.getOrgName());
                record.setApplyUserId(data.getApplyUserId());// 申请人
                record.setApplyUserName(data.getApplyUserName());
                record.setApplyTime(data.getApplyTime());// 申请时间
                record.setApplyMny(data.getApplyMny());// 申请金额
                BigDecimal surplusPayMny = MathUtil.safeSub(data.getApplyMny(), data.getPayMny());// 剩余可支付金额
                record.setThisPayMny(surplusPayMny);// 本期支付金额默认等于剩余可支付金额
                record.setApplyType("零星采购");// 付款类型
                record.setEmployeeId(vo.getEmployeeId());
                record.setEmployeeName(vo.getEmployeeName());
                record.setConfirmTime(vo.getConfirmTime());
                record.setAccountName(vo.getAccountName());
                record.setAccountNum(vo.getAccountNum());
                record.setAccountBank(vo.getAccountBank());
                record.setPayWay(vo.getPayWay());
                record.setPayWayName(vo.getPayWayName());
                record.setMemo(vo.getMemo());
                record.setPayNotesId(vo.getPayNotesId());
                record.setPayNotesName(vo.getPayNotesName());
                record.setReceiveNotesId(vo.getReceiveNotesId());
                record.setReceiveNotesName(vo.getReceiveNotesName());
                record.setBillingRoomId(vo.getBillingRoomId());
                record.setBillingRoomName(vo.getBillingRoomName());
                record.setAccountId(vo.getAccountId());
                record.setCarModelId(vo.getCarModelId());
                record.setCarModelName(vo.getCarModelName());
                record.setMaterialInfo(vo.getMaterialInfo());
                payRecordService.insertOrUpdate(record);
                msgPayMny = ComputeUtil.safeAdd(data.getPayMny(),record.getThisPayMny());
            }
            if ("报销".equals(vo.getApplyType())) {
                PayReimburseVO data = reimburseService.queryDetail(vo.getId());
                //PayRecordVO record = new PayRecordVO();
                record.setBillCode(data.getBillCode());// 单据编号
                record.setPayapplyId(data.getId());// 申请单主键
                record.setProjectId(data.getProjectId());// 项目
                record.setProjectName(data.getProjectName());
                record.setOrgId(data.getOrgId());// 组织
                record.setOrgName(data.getOrgName());
                record.setApplyUserId(data.getApplyUserId());// 申请人
                record.setApplyUserName(data.getApplyUserName());
                record.setApplyTime(data.getApplyTime());// 申请时间
                record.setApplyMny(data.getApplyMny());// 申请金额
                BigDecimal surplusPayMny = MathUtil.safeSub(data.getApplyMny(), data.getPayMny());// 剩余可支付金额
                record.setThisPayMny(surplusPayMny);// 本期支付金额默认等于剩余可支付金额
                record.setApplyType("报销");// 付款类型
                record.setFeeType(data.getFeeType());
                ;//报销类型
                record.setEmployeeId(vo.getEmployeeId());
                record.setEmployeeName(vo.getEmployeeName());
                record.setConfirmTime(vo.getConfirmTime());
                record.setAccountName(vo.getAccountName());
                record.setAccountNum(vo.getAccountNum());
                record.setAccountBank(vo.getAccountBank());
                record.setPayWay(vo.getPayWay());
                record.setPayWayName(vo.getPayWayName());
                record.setMemo(vo.getMemo());
                record.setPayNotesId(vo.getPayNotesId());
                record.setPayNotesName(vo.getPayNotesName());
                record.setReceiveNotesId(vo.getReceiveNotesId());
                record.setReceiveNotesName(vo.getReceiveNotesName());
                record.setBillingRoomId(vo.getBillingRoomId());
                record.setBillingRoomName(vo.getBillingRoomName());
                record.setAccountId(vo.getAccountId());
                record.setCarModelId(vo.getCarModelId());
                record.setCarModelName(vo.getCarModelName());
                record.setMaterialInfo(vo.getMaterialInfo());
                payRecordService.insertOrUpdate(record);
                msgPayMny = ComputeUtil.safeAdd(data.getPayMny(),record.getThisPayMny());
            }
            if ("押金".equals(vo.getApplyType())) {
                PayForegiftVO data = foregiftService.queryDetail(vo.getId());
                //PayRecordVO record = new PayRecordVO();
                record.setBillCode(data.getBillCode());// 单据编号
                record.setPayapplyId(data.getId());// 申请单主键
                record.setContractId(data.getContractId());
                ;// 合同
                record.setContractName(data.getContractName());
                record.setContractType(data.getContractType());// 合同类型
                record.setProjectId(data.getProjectId());// 项目
                record.setProjectName(data.getProjectName());
                record.setOrgId(data.getOrgId());// 组织
                record.setOrgName(data.getOrgName());
                record.setApplyUserId(data.getApplyUserId());// 申请人
                record.setApplyUserName(data.getApplyUserName());
                record.setApplyTime(data.getApplyTime());// 申请时间
                record.setApplyMny(data.getApplyMny());// 申请金额
                BigDecimal surplusPayMny = MathUtil.safeSub(data.getApplyMny(), data.getPayMny());// 剩余可支付金额
                record.setThisPayMny(surplusPayMny);// 本期支付金额默认等于剩余可支付金额
                record.setReceiveUnitId(data.getReceiveUnitId());// 收款单位
                record.setReceiveUnitName(data.getReceiveUnitName());
                record.setApplyType("押金");// 付款类型
                record.setEmployeeId(vo.getEmployeeId());
                record.setEmployeeName(vo.getEmployeeName());
                record.setConfirmTime(vo.getConfirmTime());
                record.setAccountName(vo.getAccountName());
                record.setAccountNum(vo.getAccountNum());
                record.setAccountBank(vo.getAccountBank());
                record.setPayWay(vo.getPayWay());
                record.setPayWayName(vo.getPayWayName());
                record.setMemo(vo.getMemo());
                record.setPayNotesId(vo.getPayNotesId());
                record.setPayNotesName(vo.getPayNotesName());
                record.setReceiveNotesId(vo.getReceiveNotesId());
                record.setReceiveNotesName(vo.getReceiveNotesName());
                record.setBillingRoomId(vo.getBillingRoomId());
                record.setBillingRoomName(vo.getBillingRoomName());
                record.setAccountId(vo.getAccountId());
                record.setCarModelId(vo.getCarModelId());
                record.setCarModelName(vo.getCarModelName());
                record.setMaterialInfo(vo.getMaterialInfo());
                payRecordService.insertOrUpdate(record);
                msgPayMny = ComputeUtil.safeAdd(data.getPayMny(),record.getThisPayMny());
            }
            if ("备用金".equals(vo.getApplyType())) {
                LoadApplyEntity data = loadApplyService.selectById(vo.getId());
                //PayRecordVO record = new PayRecordVO();
                record.setBillCode(data.getBillCode());// 单据编号
                record.setPayapplyId(data.getId());// 申请单主键
                record.setProjectId(data.getProjectId());// 项目
                record.setProjectName(data.getProjectName());
                record.setOrgId(data.getOrgId());// 组织
                record.setOrgName(data.getOrgName());
                record.setApplyUserId(data.getApplyEmployeeId());// 申请人
                record.setApplyUserName(data.getApplyEmployeeName());
                record.setApplyTime(data.getApplyTime());// 申请时间
                record.setApplyMny(data.getApplyMny());// 申请金额
                BigDecimal surplusPayMny = MathUtil.safeSub(data.getApplyMny(), data.getPayMny());// 剩余可支付金额
                record.setThisPayMny(surplusPayMny);// 本期支付金额默认等于剩余可支付金额
                record.setApplyType("备用金");// 付款类型
                record.setEmployeeId(vo.getEmployeeId());
                record.setEmployeeName(vo.getEmployeeName());
                record.setConfirmTime(vo.getConfirmTime());
                record.setAccountName(vo.getAccountName());
                record.setAccountNum(vo.getAccountNum());
                record.setAccountBank(vo.getAccountBank());
                record.setPayWay(vo.getPayWay());
                record.setPayWayName(vo.getPayWayName());
                record.setMemo(vo.getMemo());
                record.setPayNotesId(vo.getPayNotesId());
                record.setPayNotesName(vo.getPayNotesName());
                record.setReceiveNotesId(vo.getReceiveNotesId());
                record.setReceiveNotesName(vo.getReceiveNotesName());
                record.setBillingRoomId(vo.getBillingRoomId());
                record.setBillingRoomName(vo.getBillingRoomName());
                record.setAccountId(vo.getAccountId());
                record.setCarModelId(vo.getCarModelId());
                record.setCarModelName(vo.getCarModelName());
                record.setMaterialInfo(vo.getMaterialInfo());
                payRecordService.insertOrUpdate(record);
                msgPayMny = ComputeUtil.safeAdd(data.getPayMny(),record.getThisPayMny());
            }
            //批量支付成功后发送消息给申请人
            record.setMsgPayMny(msgPayMny);
            record.setMsgBillCode(record.getBillCode());
            record.setMsgId(record.getId());
            String [] receivers = String.valueOf(record.getApplyUserId()).split(",");
            payRecordMessageService.sendMsg(record,receivers, NoticeEnum.PAY_SUCCESS);
        }
        return "批量支付成功！";
    }

    @Override
    public ManageDetailVO getManageDetail(Long projectId) {
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        //已生效状态的单据
        param.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
        // 收入管理
        List<ReceiveEntity> receiveList = receiveService.queryList(param, false);
        BigDecimal sumReceiveMny = null;
        for (ReceiveEntity receive : receiveList) {
            sumReceiveMny = MathUtil.safeAdd(sumReceiveMny, receive.getReceiveMny());
        }
        // 合同付款
        List<PayContractEntity> contractList = super.queryList(param, false);
        BigDecimal sumPayMny = null;
        for (PayContractEntity contract : contractList) {
            sumPayMny = MathUtil.safeAdd(sumPayMny, contract.getPayMny());
        }
        // 管理费比例
        BigDecimal manageFeeRate = null;
        BigDecimal manageFee = null;
        CommonResponse<ContractVo> incomeContract = incomeApi.searchContract(projectId);
        if (incomeContract.isSuccess() && incomeContract.getData() != null) {
            manageFeeRate = incomeContract.getData().getManageChargeRate();
            // 管理费 = 已收金额 * 管理费比例 / 100
            manageFee = MathUtil.safeMultiply(sumReceiveMny, MathUtil.safeDiv(manageFeeRate, new BigDecimal(100)));
        }
        // 剩余可支付金额 = 已收金额 - 管理费 - 已支付金额
        BigDecimal surplusPayMny = MathUtil.safeSub(MathUtil.safeSub(sumReceiveMny, manageFee), sumPayMny);
        ManageDetailVO vo = new ManageDetailVO();
        vo.setProjectId(projectId);
        vo.setSumReceiveMny(sumReceiveMny);
        vo.setManageFeeRate(manageFeeRate);
        vo.setManageFee(manageFee);
        vo.setSumPayMny(sumPayMny);
        vo.setSurplusPayMny(surplusPayMny);
        return vo;
    }

    @Override
    public SumMnyStatisticVO getStatisticsMny() {
        QueryParam param = new QueryParam();
        // 组织本下
        List<Long> orgIds = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        param.getParams().put("orgId", new Parameter(QueryParam.IN, orgIds));
        //已生效状态的单据
        param.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
        List<PayContractEntity> contractList = super.queryList(param, false);
        List<PaySporadicEntity> sporadicList = sporadicService.queryList(param, false);
        List<PayReimburseEntity> reimburseList = reimburseService.queryList(param, false);
        List<PayForegiftEntity> foregiftList = foregiftService.queryList(param, false);

        BigDecimal sumApplyMny = null;// 累计申请金额
        BigDecimal sumPayMny = null;// 累计付款金额
        BigDecimal sumContractPayMny = null;// 累计合同付款金额
        BigDecimal sumSporadicPayMny = null;// 累计零星付款金额
        BigDecimal sumReimbursePayMny = null;// 累计报销付款金额
        BigDecimal sumForegiftPayMny = null;// 累计押金付款金额

        for (PayContractEntity contract : contractList) {
            sumApplyMny = MathUtil.safeAdd(sumApplyMny, contract.getApplyMny());// 累计申请金额
            sumPayMny = MathUtil.safeAdd(sumPayMny, contract.getPayMny());// 累计付款金额
            sumContractPayMny = MathUtil.safeAdd(sumContractPayMny, contract.getPayMny());// 累计合同付款金额
        }
        for (PaySporadicEntity sporadic : sporadicList) {
            sumApplyMny = MathUtil.safeAdd(sumApplyMny, sporadic.getApplyMny());// 累计申请金额
            sumPayMny = MathUtil.safeAdd(sumPayMny, sporadic.getPayMny());// 累计付款金额
            sumSporadicPayMny = MathUtil.safeAdd(sumSporadicPayMny, sporadic.getPayMny());// 累计零星付款金额
        }
        for (PayReimburseEntity reimburse : reimburseList) {
            sumApplyMny = MathUtil.safeAdd(sumApplyMny, reimburse.getApplyMny());// 累计申请金额
            sumPayMny = MathUtil.safeAdd(sumPayMny, reimburse.getPayMny());// 累计付款金额
            sumReimbursePayMny = MathUtil.safeAdd(sumReimbursePayMny, reimburse.getPayMny());// 累计报销付款金额
        }
        for (PayForegiftEntity foregift : foregiftList) {
            sumApplyMny = MathUtil.safeAdd(sumApplyMny, foregift.getApplyMny());// 累计申请金额
            sumPayMny = MathUtil.safeAdd(sumPayMny, foregift.getPayMny());// 累计付款金额
            sumForegiftPayMny = MathUtil.safeAdd(sumForegiftPayMny, foregift.getPayMny());// 累计押金付款金额
        }
        List<Long> payapplyIds = foregiftList.stream().map(PayForegiftEntity::getId).collect(Collectors.toList());
        // 累计押金返还金额
        BigDecimal sumReturnMny = null;
        // 累计计划返还金额
        BigDecimal sumPlanMny = null;
        if (!payapplyIds.isEmpty()) {
            List<PayForegiftRecordEntity> recordList = recordService.list(new QueryWrapper<PayForegiftRecordEntity>().in("payapply_id", payapplyIds));
            for (PayForegiftRecordEntity record : recordList) {
                sumReturnMny = MathUtil.safeAdd(sumReturnMny, record.getReturnMny());// 累计押金返还金额
            }
            QueryWrapper<PayForegiftPlanEntity> wrapper = new QueryWrapper<>();
            wrapper.in("payapply_id", payapplyIds);
            wrapper.between("plan_time", getTime("min"), getTime("max"));//当月
            List<PayForegiftPlanEntity> planList = planService.list(wrapper);
            for (PayForegiftPlanEntity plan : planList) {
                sumPlanMny = MathUtil.safeAdd(sumPlanMny, plan.getPlanMny());// 累计计划返还金额
            }
        }
        BigDecimal sumUnPayMny = MathUtil.safeSub(sumApplyMny, sumPayMny);// 累计待付款金额
        SumMnyStatisticVO vo = new SumMnyStatisticVO();
        vo.setOrgIds(orgIds);
        vo.setSumApplyMny(sumApplyMny);
        vo.setSumPayMny(sumPayMny);
        vo.setSumUnPayMny(sumUnPayMny);
        vo.setSumContractPayMny(sumContractPayMny);
        vo.setSumSporadicPayMny(sumSporadicPayMny);
        vo.setSumReimbursePayMny(sumReimbursePayMny);
        vo.setSumForegiftPayMny(sumForegiftPayMny);
        vo.setSumReturnMny(sumReturnMny);
        vo.setSumPlanMny(sumPlanMny);
        return vo;
    }

    @Override
    public Map<String, Object> countAmt(Long tenantId, List<Long> projectIds) {
        QueryWrapper<PayContractEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.select("ifnull(sum(pay_mny),0) as amt");

        queryWrapper.eq("tenant_id", tenantId);
        queryWrapper.eq("dr", BaseVO.DR_UNDELETE);
//        付款类型：1-组织付款 2-项目付款
        queryWrapper.eq("pay_type", 2);
//        支付状态：1-未支付 2-已支付
        queryWrapper.eq("pay_status", 2);

        if (CollectionUtils.isNotEmpty(projectIds)) {
            queryWrapper.in("project_id", projectIds);
        }
//        已生效的单据
        queryWrapper.in("bill_state",
                Arrays.asList(new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()}));

        List<Long> orgIds = new ArrayList<>();
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse =
                    orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                            collect(Collectors.toList()));
            orgIds = authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        }  else {
            orgIds = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        }
        if(ListUtil.isNotEmpty(orgIds)){
            queryWrapper.in("org_id", orgIds);
        }
        return super.getMap(queryWrapper);
    }

    @Override
    public List<FinanceMonthVO> getMonthInfo(Long projectId,String timeRange) {
        Date startDate = MonthUtil.monthFAdd(new Date(), -999);
        Date endDate = new Date();
        if("3month".equals(timeRange)){
            startDate = MonthUtil.monthFAdd(new Date(), -2);
        }else if("6month".equals(timeRange)){
            startDate = MonthUtil.monthFAdd(new Date(), -5);
        }else if("thisYear".equals(timeRange)){
            startDate = MonthUtil.monthFAdd(new Date(), -new Date().getMonth());
        }else if("lastYear".equals(timeRange)){
            startDate = MonthUtil.monthFAdd(new Date(), -new Date().getMonth()-12);
            endDate = MonthUtil.monthFAdd(new Date(), -new Date().getMonth());
        }
        String startStr = DateUtil.format(startDate, "yyyy-MM-dd");
        String endStr = DateUtil.format(endDate, "yyyy-MM-dd HH:mm:ss");
        logger.info("startDate:"+startStr);
        logger.info("endDate:"+endStr);

        //按月份获取收入金额
        List<FinanceMonthVO> listReceive = baseMapper.getMonthReceiveMny(projectId,startStr,endStr);
        List<FinanceMonthVO> listOut = baseMapper.getMonthOutMny(projectId,startStr,endStr);
        //区间去重,获取总区间
        Map<String, FinanceMonthVO> map = listReceive.stream().collect(Collectors.toMap(FinanceMonthVO::getTerm, Function.identity()));
        if (ListUtil.isNotEmpty(listOut)) {
            listOut.forEach(financeMonthVO -> {
                if (map.containsKey(financeMonthVO.getTerm())) {
                    map.get(financeMonthVO.getTerm()).setSumOutMny(financeMonthVO.getSumOutMny());
                } else {
                    map.put(financeMonthVO.getTerm(), financeMonthVO);
                }
            });
        }
        List<FinanceMonthVO> financeMonthVOList = map.entrySet().stream().map(et -> et.getValue()).collect(Collectors.toList());
        for (FinanceMonthVO financeMonthVO : financeMonthVOList) {
            financeMonthVO.setProfit(financeMonthVO.getSumReceiveMny().subtract(financeMonthVO.getSumOutMny()));
        }
        List<FinanceMonthVO> bodys = financeMonthVOList.stream().filter(s -> !s.getSumOutMny().equals(BigDecimal.ZERO) || !s.getSumReceiveMny().equals(BigDecimal.ZERO)).collect(Collectors.toList());
        List<FinanceMonthVO> collect = bodys.stream().sorted(Comparator.comparing(FinanceMonthVO::getTerm)).collect(Collectors.toList());
        Map<String,FinanceMonthVO> collectMap = new HashMap<>();
        for (FinanceMonthVO vo:collect
             ) {
            collectMap.put(vo.getTerm(),vo);
        }
        // 2022-01-01   要减去一个月份 取值
        if("lastYear".equals(timeRange)){
            endDate = MonthUtil.monthFAdd(endDate, -1);
            endStr = DateUtil.format(endDate, "yyyy-MM-dd");
        }
        List<String> monthList = MonthUtil.getMonthList(startStr, endStr);
        List<FinanceMonthVO> newCollect = new ArrayList<>();
        for (int i = 0; i < monthList.size(); i++) {
            FinanceMonthVO financeMonthVO = collectMap.get(monthList.get(i));
            if(null == financeMonthVO){
                FinanceMonthVO vo = new FinanceMonthVO();
                vo.setSumReceiveMny(BigDecimal.ZERO);
                vo.setProfit(BigDecimal.ZERO);
                vo.setSumOutMny(BigDecimal.ZERO);
                vo.setTerm(monthList.get(i));
                vo.setMonthTerm(monthList.get(i).substring(2,7));
                newCollect.add(vo);
            }else{
                newCollect.add(financeMonthVO);
            }
        }
        return newCollect;
    }

    @Override
    public List<FinanceCostVO> getCostInfo(Long projectId, String year) {
        List<FinanceCostVO> listReceive = baseMapper.getCostInfo(projectId, year);
        return listReceive;
    }

    @Override
    public Map<String, BigDecimal> getSubSettlePay(PubContractSubQueryVO pubContractSubQueryVO) {
        BigDecimal thisMny = baseMapper.selectSubThisPay(pubContractSubQueryVO.getContractId(), pubContractSubQueryVO.getProjectId(), pubContractSubQueryVO.getSettleId());
        BigDecimal sumMny = baseMapper.selectSubSumPay(pubContractSubQueryVO.getContractId(), pubContractSubQueryVO.getProjectId(), pubContractSubQueryVO.getSettleDate(), pubContractSubQueryVO.getSettleIdList());
        Map<String, BigDecimal> map = new HashMap<>();
        map.put("thisMny", thisMny != null ? thisMny : BigDecimal.ZERO);
        map.put("sumMny", sumMny != null ? sumMny : BigDecimal.ZERO);
        return map;
    }

    @Override
    public Map<String, PayMnyWarnVO> getPayMnyByTenantIds(PubWarnQueryVO pubWarnQueryVO) {
        if (null == pubWarnQueryVO.getContractType()) {
            throw new BusinessException("合同类型不能为空！");
        }
        Map<String, PayMnyWarnVO> map = new HashMap<>();
        List<PayMnyWarnVO> list = baseMapper.getPayMnyByTenantIds(pubWarnQueryVO);
        for (PayMnyWarnVO payMnyWarnVO : list) {
            map.put(payMnyWarnVO.getTenantId() + "@" + payMnyWarnVO.getOrgId() + "@" + payMnyWarnVO.getContractId(), payMnyWarnVO);
        }
        return map;
    }

    @Override
    public Map<Long, PayAndReceiveMnyWarnVO> getSumPayMnyMap(List<Long> tenantIds) {
        Map<Long, PayAndReceiveMnyWarnVO> map = new HashMap<>();
        // 1.查询合同付款
        this.transPayContractToMap(map, tenantIds);
        // 2.查询零星付款
        this.transPaySporadicToMap(map, tenantIds);
        // 3.查询报销付款
        this.transPayReimburseToMap(map, tenantIds);
        // 4.查询借款报销
        this.transLoadReimburseToMap(map, tenantIds);
        return map;
    }

    /**
     * 查询合同付款构造转换VO
     *
     * @param map
     * @param tenantIds
     */
    private void transPayContractToMap(Map<Long, PayAndReceiveMnyWarnVO> map, List<Long> tenantIds) {
        LambdaQueryWrapper<PayContractEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(PayContractEntity::getPayStatus, 2);
        lambda.in(PayContractEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        lambda.in(PayContractEntity::getTenantId, tenantIds);
        List<PayContractEntity> list = super.list(lambda);
        for (PayContractEntity entity : list) {
            Long projectId = entity.getProjectId();
            if (projectId != null) {
                PayAndReceiveMnyWarnVO vo = new PayAndReceiveMnyWarnVO();
                if (!map.containsKey(projectId)) {
                    vo.setProjectId(projectId);
                    vo.setProjectName(entity.getProjectName());
                    vo.setOrgId(entity.getOrgId());
                    vo.setOrgName(entity.getOrgName());
                    vo.setTenantId(entity.getTenantId());
                    vo.setSumPayMny(entity.getPayMny());
                    map.put(projectId, vo);
                } else {
                    vo = map.get(projectId);
                    vo.setSumPayMny(MathUtil.safeAdd(vo.getSumPayMny(), entity.getPayMny()));
                }
            }
        }
    }

    /**
     * 查询零星付款构造转换VO
     *
     * @param map
     * @param tenantIds
     */
    private void transPaySporadicToMap(Map<Long, PayAndReceiveMnyWarnVO> map, List<Long> tenantIds) {
        LambdaQueryWrapper<PaySporadicEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(PaySporadicEntity::getPayStatus, 2);
        lambda.in(PaySporadicEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        lambda.in(PaySporadicEntity::getTenantId, tenantIds);
        List<PaySporadicEntity> list = sporadicService.list(lambda);
        for (PaySporadicEntity entity : list) {
            Long projectId = entity.getProjectId();
            if (projectId != null) {
                PayAndReceiveMnyWarnVO vo = new PayAndReceiveMnyWarnVO();
                if (!map.containsKey(projectId)) {
                    vo.setProjectId(projectId);
                    vo.setProjectName(entity.getProjectName());
                    vo.setOrgId(entity.getOrgId());
                    vo.setOrgName(entity.getOrgName());
                    vo.setTenantId(entity.getTenantId());
                    vo.setSumPayMny(entity.getPayMny());
                    map.put(projectId, vo);
                } else {
                    vo = map.get(projectId);
                    vo.setSumPayMny(MathUtil.safeAdd(vo.getSumPayMny(), entity.getPayMny()));
                }
            }
        }
    }

    /**
     * 查询报销付款构造转换VO
     *
     * @param map
     * @param tenantIds
     */
    private void transPayReimburseToMap(Map<Long, PayAndReceiveMnyWarnVO> map, List<Long> tenantIds) {
        LambdaQueryWrapper<PayReimburseEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(PayReimburseEntity::getPayStatus, 2);
        lambda.in(PayReimburseEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        lambda.in(PayReimburseEntity::getTenantId, tenantIds);
        List<PayReimburseEntity> list = reimburseService.list(lambda);
        for (PayReimburseEntity entity : list) {
            Long projectId = entity.getProjectId();
            if (projectId != null) {
                PayAndReceiveMnyWarnVO vo = new PayAndReceiveMnyWarnVO();
                if (!map.containsKey(projectId)) {
                    vo.setProjectId(projectId);
                    vo.setProjectName(entity.getProjectName());
                    vo.setOrgId(entity.getOrgId());
                    vo.setOrgName(entity.getOrgName());
                    vo.setTenantId(entity.getTenantId());
                    vo.setSumPayMny(entity.getPayMny());
                    map.put(projectId, vo);
                } else {
                    vo = map.get(projectId);
                    vo.setSumPayMny(MathUtil.safeAdd(vo.getSumPayMny(), entity.getPayMny()));
                }
            }
        }
    }

    /**
     * 查询借款报销构造转换VO
     *
     * @param map
     * @param tenantIds
     */
    private void transLoadReimburseToMap(Map<Long, PayAndReceiveMnyWarnVO> map, List<Long> tenantIds) {
        LambdaQueryWrapper<LoadReimburseEntity> lambda = new LambdaQueryWrapper<>();
        lambda.in(LoadReimburseEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        lambda.in(LoadReimburseEntity::getTenantId, tenantIds);
        List<LoadReimburseEntity> list = loadReimburseService.list(lambda);
        for (LoadReimburseEntity entity : list) {
            Long projectId = entity.getProjectId();
            if (projectId != null) {
                PayAndReceiveMnyWarnVO vo = new PayAndReceiveMnyWarnVO();
                if (!map.containsKey(projectId)) {
                    vo.setProjectId(projectId);
                    vo.setProjectName(entity.getProjectName());
                    vo.setOrgId(entity.getOrgId());
                    vo.setOrgName(entity.getOrgName());
                    vo.setTenantId(entity.getTenantId());
                    vo.setSumPayMny(entity.getReimburseMny());
                    map.put(projectId, vo);
                } else {
                    vo = map.get(projectId);
                    vo.setSumPayMny(MathUtil.safeAdd(vo.getSumPayMny(), entity.getReimburseMny()));
                }
            }
        }
    }

    @Override
    public Map<Long, PayAndReceiveMnyWarnVO> getSumReceiveMnyMap(List<Long> tenantIds) {
        // 查询收款金额
        LambdaQueryWrapper<ReceiveEntity> lambda = new LambdaQueryWrapper<>();
        lambda.in(ReceiveEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        lambda.in(ReceiveEntity::getTenantId, tenantIds);
        List<ReceiveEntity> list = receiveService.list(lambda);
        Map<Long, PayAndReceiveMnyWarnVO> map = new HashMap<>();
        for (ReceiveEntity entity : list) {
            Long projectId = entity.getProjectId();
            if (projectId != null) {
                PayAndReceiveMnyWarnVO vo = new PayAndReceiveMnyWarnVO();
                if (!map.containsKey(projectId)) {
                    vo.setProjectId(projectId);
                    vo.setProjectName(entity.getProjectName());
                    vo.setOrgId(entity.getOrgId());
                    vo.setOrgName(entity.getOrgName());
                    vo.setTenantId(entity.getTenantId());
                    vo.setSumReceiveMny(entity.getReceiveMny());
                    map.put(projectId, vo);
                } else {
                    vo = map.get(projectId);
                    vo.setSumReceiveMny(MathUtil.safeAdd(vo.getSumReceiveMny(), entity.getReceiveMny()));
                }
            }
        }
        return map;
    }

    @Override
    public Map<Long, PayAndReceiveMnyWarnVO> getSumReimburseMnyMap(List<Long> tenantIds) {
        Map<Long, PayAndReceiveMnyWarnVO> map = new HashMap<>();
        // 累计报销金额，放入sumPayMny，为了复用代码
        // 3.查询报销付款
        this.transPayReimburseToMap(map, tenantIds);
        // 4.查询借款报销
        this.transLoadReimburseToMap(map, tenantIds);
        return map;
    }

    @Override
    public List<Map<String, Object>> queryBondExpireWarn(List<SqlParam> sqlParamList) {
        List<Map<String, Object>> upList = baseMapper.queryBondUpExpireWarn(sqlParamList);
        List<Map<String, Object>> downList = baseMapper.queryBondDownExpireWarn(sqlParamList);
        upList.addAll(downList);
        return upList;
    }

    /******************  移动看板 start ******************/
    @Override
    public JSONObject projectProgress(Long projectId, Date startDate, Date endDate) {
        Integer lastDay = 29;//每月28号统计相关数据
        List<String> label = new ArrayList<>();//时间维度数据
        List<BigDecimal> baseValue = new ArrayList<>();//基准值
        List<BigDecimal> outputValue = new ArrayList<>();//产值进度
        List<BigDecimal> payment = new ArrayList<>();//回款进度
        List<BigDecimal> cost = new ArrayList<>();//成本进度
        JSONObject jsonObject = new JSONObject();
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM");
        String now = sf.format(new Date());//当前年月
        String start = null;//起始月份
        String end = null;//结束月份
        ProjectReportVo sumVo = new ProjectReportVo();
        CommonResponse<ProjectReportVo> res = contractReportApi.projectMonth(projectId, lastDay);
        if (res.isSuccess()) {
            sumVo = res.getData();
        } else {
            logger.error("起始结束日期查询失败");
            throw new BusinessException("基准值查询失败");
        }
        if (sumVo.getContractCount() <= 0) {
            logger.debug("合同为空或起始结束日期查询为空");
            jsonObject.put("speedLineData", new ReportAppVo());
            return jsonObject;
        }
        // 合同开始跟结束任何一个没有   值都设为0
        if (StringUtils.isEmpty(sumVo.getStartDate())) {
            logger.debug("合同起始日期为空");
            jsonObject.put("speedLineData", new ReportAppVo());
            return jsonObject;
        } else {
            if (MonthUtil.compareTime(sumVo.getStartDate(), now) > 0) {// 起始日期大于当前日期
                logger.debug("合同起始日期大于当前日期");
                jsonObject.put("speedLineData", new ReportAppVo());
                return jsonObject;
            }
            start = sumVo.getStartDate();
        }
        if (StringUtils.isEmpty(sumVo.getEndDate())) {
            logger.debug("合同结束日期为空");
            jsonObject.put("speedLineData", new ReportAppVo());
            return jsonObject;
        } else {
            end = sumVo.getEndDate();
        }
        String lastMon = null;//统计截止月份
//        if (endDate == null) {// 没有结束日期，全部统计
//            lastMon = now;
//        } else {// 有结束日期，只统计项目结束日期加6的日期数据
//            String maxmon = sf.format(MonthUtil.monthAdd(endDate, 6));
//            lastMon = MonthUtil.compareTime(maxmon, now) >= 1 ? now : maxmon;
//        }
        String maxmon = MonthUtil.monthAdd(sf, end, 6);
        lastMon = MonthUtil.compareTime(maxmon, now) >= 1 ? now : maxmon;

        // 基准值
        // 合同金额
        BigDecimal contractTaxMny = BigDecimal.ZERO;
        CommonResponse<BigDecimal> res1 = contractReportApi.sumContractMny(projectId);
        if (res1.isSuccess()) {
            contractTaxMny = res1.getData();
        } else {
            logger.error("合同金额查询失败");
            throw new BusinessException("合同金额查询失败");
        }
        // 产值金额
        List<ProjectReportVo> productionList = new ArrayList<>();
        CommonResponse<List<ProjectReportVo>> res2 = contractReportApi.getMonthProductionMny(projectId, lastDay);
        if (res2.isSuccess()) {
            productionList = res2.getData();
        } else {
            logger.error("产值金额查询失败");
            throw new BusinessException("产值金额查询失败");
        }
        Map<String, BigDecimal> czMap1 = new HashMap<>();// 产值
        for (ProjectReportVo rv : productionList) {
            BigDecimal a = rv.getMny() == null ? BigDecimal.ZERO : rv.getMny();
            if (czMap1.containsKey(rv.getFinishMonth())) {
                BigDecimal mny = czMap1.get(rv.getFinishMonth());
                czMap1.put(rv.getFinishMonth(), mny.add(a));
            } else {
                czMap1.put(rv.getFinishMonth(), a);
            }
        }
        // 合同收款
        List<ProjectAppVo> receiveList = baseMapper.getReceiveMny(projectId, lastDay);
        Map<String, BigDecimal> skMap1 = new HashMap<>();// 收款
        for (ProjectAppVo rv : receiveList) {
            BigDecimal a = rv.getMny() == null ? BigDecimal.ZERO : rv.getMny();
            if (skMap1.containsKey(rv.getFinishMonth())) {
                BigDecimal mny = skMap1.get(rv.getFinishMonth());
                skMap1.put(rv.getFinishMonth(), mny.add(a));
            } else {
                skMap1.put(rv.getFinishMonth(), a);
            }
        }
        // 实际成本
        Map<String, BigDecimal> cbMap1 = getCostMonth(projectId, lastDay);

        List<String> list1 = new ArrayList<>(czMap1.keySet());
        List<String> list2 = new ArrayList<>(skMap1.keySet());
        List<String> list3 = new ArrayList<>(cbMap1.keySet());
        List<String> bigmonthList = new ArrayList<>();
        for (String s : list1) {
            bigmonthList.add(s);
        }
        for (String s : list2) {
            bigmonthList.add(s);
        }
        for (String s : list3) {
            bigmonthList.add(s);
        }
        String bigMonth = MonthUtil.mostDate(bigmonthList, 0);

        List<String> monthList = new ArrayList<>();
        if (MonthUtil.compareTime(bigMonth, lastMon) >= 0) {
            monthList = MonthUtil.getMonthList(start, bigMonth);
        } else {
            monthList = MonthUtil.getMonthList(start, lastMon);
        }

        Map<String, BigDecimal> czMap = new HashMap<>();// 产值
        for (String month : monthList) {
            BigDecimal a = BigDecimal.ZERO;
            for (String m : czMap1.keySet()) {
                if (MonthUtil.compareTime(m, month) <= 0) {
                    a = a.add(czMap1.get(m));
                }
            }
            czMap.put(month, a);
        }

        Map<String, BigDecimal> skMap = new HashMap<>();// 收款
        for (String month : monthList) {
            BigDecimal a = BigDecimal.ZERO;
            for (String m : skMap1.keySet()) {
                if (MonthUtil.compareTime(m, month) <= 0) {
                    a = a.add(skMap1.get(m));
                }
            }
            skMap.put(month, a);
        }

        Map<String, BigDecimal> cbMap = new HashMap<>();// 实际成本
        for (String month : monthList) {
            BigDecimal a = BigDecimal.ZERO;
            for (String m : cbMap1.keySet()) {
                if (MonthUtil.compareTime(m, month) <= 0) {
                    a = a.add(cbMap1.get(m));
                }
            }
            cbMap.put(month, a);
        }

        // 统计期间有多少月份
        List<String> monthList1 = MonthUtil.getMonthList(start, lastMon);
        Integer zq = MonthUtil.getSubMonth(start, end);//项目周期

        for (String mon : monthList1) {
            BigDecimal cz = czMap.get(mon);
            BigDecimal sk = skMap.get(mon);
            BigDecimal cb = cbMap.get(mon);

            BigDecimal output = BigDecimal.ZERO;
            BigDecimal pay = BigDecimal.ZERO;
            BigDecimal costmny = BigDecimal.ZERO;
            if (contractTaxMny.compareTo(BigDecimal.ZERO) != 0) {
                output = cz == null ?
                        BigDecimal.ZERO : cz.divide(contractTaxMny, 8, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(100));
                pay = sk == null ?
                        BigDecimal.ZERO : sk.divide(contractTaxMny, 8, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(100));
                costmny = cb == null ?
                        BigDecimal.ZERO : cb.divide(contractTaxMny, 8, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(100));
            }
            if (zq == 0) {// 100
                baseValue.add(new BigDecimal("100.00"));
            } else {
                Integer subMonth = MonthUtil.getSubMonth(start, mon);
                if (subMonth / (zq * 1.0) >= 1.0) {
                    baseValue.add(new BigDecimal("100.00"));
                } else {
                    Double f = (subMonth / (zq * 1.0)) * 100.00;
                    BigDecimal b = new BigDecimal(f);
                    BigDecimal bigDecimal = b.setScale(2, BigDecimal.ROUND_HALF_UP);
                    baseValue.add(bigDecimal);
                }
            }
            label.add(mon);
            outputValue.add(output.setScale(2, BigDecimal.ROUND_HALF_UP));
            payment.add(pay.setScale(2, BigDecimal.ROUND_HALF_UP));
            cost.add(costmny.setScale(2, BigDecimal.ROUND_HALF_UP));
        }
        ReportAppVo rvo = new ReportAppVo();
        rvo.setLabel(label);
        rvo.setBaseValue(baseValue);
        rvo.setOutputValue(outputValue);
        rvo.setPayment(payment);
        rvo.setCost(cost);
        jsonObject.put("speedLineData", rvo);
        return jsonObject;
    }

    @Override
    public JSONObject projectIncome(Long projectId) {
        IncomeReportMnyVo inVo = new IncomeReportMnyVo();
        CommonResponse<IncomeReportMnyVo> res1 = contractReportApi.getIncomeMny(projectId);
        if (res1.isSuccess()) {
            inVo = res1.getData();
        } else {
            logger.error("收入数据查询失败");
            throw new BusinessException("收入数据查询失败");
        }
        List<ProjectReportVo> pList = new ArrayList<>();
        CommonResponse<List<ProjectReportVo>> res2 = contractReportApi.getMonthProduction(projectId);
        if (res2.isSuccess()) {
            pList = res2.getData();
        } else {
            logger.error("月度产值查询失败");
            throw new BusinessException("月度产值查询失败");
        }
        //billingContract: xxx,//合同开票
        BigDecimal billingContract = BigDecimal.ZERO;
        CommonResponse<BigDecimal> res3 = invoiceApi.sumContractMny(projectId);
        if (res3.isSuccess()) {
            billingContract = res3.getData();
        } else {
            logger.error("合同开票查询失败");
            throw new BusinessException("合同开票查询失败");
        }
        BigDecimal contractReceived = BigDecimal.ZERO;//收款金额
        List<Integer> billStatus = new ArrayList<>();
        billStatus.add(1);
        billStatus.add(3);
        LambdaQueryWrapper<ReceiveEntity> lambda = Wrappers.<ReceiveEntity>lambdaQuery();
        lambda.eq(ReceiveEntity::getProjectId, projectId);
        lambda.eq(ReceiveEntity::getDr, 0);
        lambda.in(ReceiveEntity::getBillState, billStatus);
        List<ReceiveEntity> quoteEntities = receiveService.list(lambda);
        for (ReceiveEntity ce : quoteEntities) {
            contractReceived = contractReceived.add(ce.getReceiveMny());
        }
        BigDecimal totalAmount = roundTwoPre(inVo.getContractAmount()).add(roundTwoPre(inVo.getVisaAmount()));//（合同+签证）金额
        Map inMap = new HashMap();
        inMap.put("contractQuantity", roundTwoPre(inVo.getContractQuantity()));
        inMap.put("visasNumber", roundTwoPre(inVo.getVisasNumber()));
        inMap.put("contractAmount", roundTwoPre(inVo.getContractAmount()));
        inMap.put("visaAmount", roundTwoPre(inVo.getVisaAmount()));
        inMap.put("totalAmount", roundTwoPre(totalAmount));
        Map payMap = new HashMap();
        if (totalAmount.compareTo(BigDecimal.ZERO) == 0) {
            payMap.put("paymentProgress", 0.00);
        } else {
            payMap.put("paymentProgress", contractReceived.divide(totalAmount, 8, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(100)));
        }
        payMap.put("contractReceived", roundTwoPre(contractReceived));
        payMap.put("uncollectedContractVisa", totalAmount.subtract(contractReceived));
        payMap.put("outputAmount", roundTwoPre(inVo.getOutputAmount()));
        payMap.put("batchAmount", roundTwoPre(inVo.getBatchAmount()));
        payMap.put("billingContract", roundTwoPre(billingContract));
        payMap.put("contractCollection", roundTwoPre(contractReceived));
        Map monthValue = new HashMap();
        List<String> label = new ArrayList<>();
        List<BigDecimal> value = new ArrayList<>();
        for (ProjectReportVo pr : pList) {
            label.add(pr.getFinishMonth());
            value.add(roundTwoPre(pr.getMny()));
        }
        monthValue.put("label", label);
        monthValue.put("value", value);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("revenueManagement", inMap);
        jsonObject.put("paymentProgress", payMap);
        jsonObject.put("monthlyOutputValue", monthValue);
        return jsonObject;
    }

    @Override
    public JSONObject projectOut(Long projectId) {
        //分包合同
        SubProjectReportVo sub = new SubProjectReportVo();
        CommonResponse<SubProjectReportVo> res1 = subReportApi.getSubContract(projectId);
        if (res1.isSuccess()) {
            sub = res1.getData();
        } else {
            logger.error("分包合同查询失败");
            throw new BusinessException("分包合同查询失败");
        }
        //物资采购合同
        MaterialReportVo material = new MaterialReportVo();
        CommonResponse<MaterialReportVo> res2 = materialContractApi.getMaterialContract(projectId);
        if (res2.isSuccess()) {
            material = res2.getData();
        } else {
            logger.error("物资采购合同查询失败");
            throw new BusinessException("物资采购合同查询失败");
        }
        //设备采购合同
        //设备租赁合同
        List<EquipmentReportVo> equipment = new ArrayList<>();//1采购，2租赁
        CommonResponse<List<EquipmentReportVo>> res3 = equipmentApi.getEquipment(projectId);
        if (res3.isSuccess()) {
            equipment = res3.getData();
        } else {
            logger.error("设备租赁/采购合同查询失败");
            throw new BusinessException("设备租赁/采购合同查询失败");
        }
        EquipmentReportVo cg = equipment.get(0);
        EquipmentReportVo zl = equipment.get(1);
        //其他费用
        List<InvoiceReceiveVO> taxInvoice = new ArrayList<>();
        CommonResponse<List<InvoiceReceiveVO>> res4 = invoiceApi.getTaxReceive(projectId);
        if (res4.isSuccess()) {
            taxInvoice = res4.getData();
        } else {
            logger.error("合同收票查询失败");
            throw new BusinessException("合同收票查询失败");
        }
        Map<String, BigDecimal> withMap = new HashMap<>();//有合同，1-分包,2-设备采购,3-设备租赁,4-物资采购,5-物资租赁
        BigDecimal without = BigDecimal.ZERO;//无合同
        for (InvoiceReceiveVO pc : taxInvoice) {
            if (pc.getType() != null && pc.getType() == 1) {//有合同
                if (withMap.containsKey(pc.getContractType())) {
                    BigDecimal a = withMap.get(pc.getContractType()) == null ? BigDecimal.ZERO : withMap.get(pc.getContractType());
                    BigDecimal b = pc.getInvoiceTaxMny() == null ? BigDecimal.ZERO : pc.getInvoiceTaxMny();
                    BigDecimal payMny = a.add(b);
                    withMap.put(pc.getContractType(), payMny);
                } else {
                    withMap.put(pc.getContractType(), pc.getInvoiceTaxMny());
                }
            }
            if (pc.getType() != null && pc.getType() == 2) {//无合同
                BigDecimal b = pc.getInvoiceTaxMny() == null ? BigDecimal.ZERO : pc.getInvoiceTaxMny();
                without = without.add(b);
            }
        }
        // 已付金额
        List<Integer> billStatus = new ArrayList<>();
        billStatus.add(1);
        billStatus.add(3);
        LambdaQueryWrapper<PayContractEntity> lambda = Wrappers.<PayContractEntity>lambdaQuery();
        lambda.eq(PayContractEntity::getProjectId, projectId);
        lambda.eq(PayContractEntity::getDr, 0);
        lambda.eq(PayContractEntity::getPayStatus, 2);
        lambda.in(PayContractEntity::getBillState, billStatus);
        List<PayContractEntity> payContractEntities = super.list(lambda);
        Map<Long, BigDecimal> payMap = new HashMap<>();//1-分包,2-设备采购,3-设备租赁,4-物资采购,5-物资租赁
        BigDecimal cumulativePayment = BigDecimal.ZERO;
        for (PayContractEntity pc : payContractEntities) {
            if (payMap.containsKey(pc.getContractType())) {
                BigDecimal a = payMap.get(pc.getContractType()) == null ? BigDecimal.ZERO : payMap.get(pc.getContractType());
                BigDecimal b = pc.getPayMny() == null ? BigDecimal.ZERO : pc.getPayMny();
                BigDecimal payMny = a.add(b);
                payMap.put(pc.getContractType(), payMny);
            } else {
                payMap.put(pc.getContractType(), pc.getPayMny() == null ? BigDecimal.ZERO : pc.getPayMny());
            }
            BigDecimal b = pc.getPayMny() == null ? BigDecimal.ZERO : pc.getPayMny();
            cumulativePayment = cumulativePayment.add(b);
        }
        //其他费用已付金额,零星材料付款+报销付款+借款报销
        BigDecimal projectCollection = baseMapper.projectCollection(projectId);

        Map target = new HashMap();//指标
        BigDecimal c = sub.getMny() == null ? BigDecimal.ZERO : sub.getMny();
        BigDecimal d = material.getMny() == null ? BigDecimal.ZERO : material.getMny();
        BigDecimal e = cg.getMny() == null ? BigDecimal.ZERO : cg.getMny();
        BigDecimal f = zl.getMny() == null ? BigDecimal.ZERO : zl.getMny();
        BigDecimal g = sub.getSettleMny() == null ? BigDecimal.ZERO : sub.getSettleMny();
        BigDecimal h = material.getSettleMny() == null ? BigDecimal.ZERO : material.getSettleMny();
        BigDecimal k = cg.getSettleMny() == null ? BigDecimal.ZERO : cg.getSettleMny();
        BigDecimal l = zl.getSettleMny() == null ? BigDecimal.ZERO : zl.getSettleMny();
        BigDecimal m = projectCollection == null ? BigDecimal.ZERO : projectCollection;
        target.put("expenditureContractAmount", c.add(d).add(e).add(f));//支出合同金额
        target.put("contractSettlementAmount", g.add(h).add(k).add(l));//合同结算金额
        target.put("otherPayments", roundTwoPre(projectCollection));//其他付款
        target.put("cumulativePayment", cumulativePayment.add(m));//累计付款

        Map subcontract = new HashMap();//分包合同
        subcontract.put("number", roundTwoPre(sub.getNum()));//项目下已生效分包合同的数量
        subcontract.put("contractAmount", roundTwoPre(sub.getMny()));//合同金额
        subcontract.put("settlementAmount", roundTwoPre(sub.getSettleMny()));//结算金额
        subcontract.put("amountPaid", roundTwoPre(payMap.get(ContractTypeConst.SUB)));//已付金额
        subcontract.put("inputInvoice", roundTwoPre(withMap.get("1")));//进项发票

        Map materialPurchaseContract = new HashMap();//物资采购合同
        materialPurchaseContract.put("number", roundTwoPre(material.getNum()));//项目下已生效物资采购合同的数量
        materialPurchaseContract.put("contractAmount", roundTwoPre(material.getMny()));//合同金额
        materialPurchaseContract.put("settlementAmount", roundTwoPre(material.getSettleMny()));//结算金额
        materialPurchaseContract.put("amountPaid", roundTwoPre(payMap.get(ContractTypeConst.MATERIAL)));//已付金额
        materialPurchaseContract.put("inputInvoice", roundTwoPre(withMap.get("4")));//进项发票

        Map equipmentProcurementContract = new HashMap();//设备采购合同
        equipmentProcurementContract.put("number", roundTwoPre(cg.getNum()));//项目下已生效物资采购合同的数量
        equipmentProcurementContract.put("contractAmount", roundTwoPre(cg.getMny()));//合同金额
        equipmentProcurementContract.put("settlementAmount", roundTwoPre(cg.getSettleMny()));//结算金额
        equipmentProcurementContract.put("amountPaid", roundTwoPre(payMap.get(ContractTypeConst.EQUIPMENT_PURCHASE)));//已付金额
        equipmentProcurementContract.put("inputInvoice", roundTwoPre(withMap.get("2")));//进项发票

        Map equipmentLeasingContract = new HashMap();//设备租赁合同
        equipmentLeasingContract.put("number", roundTwoPre(zl.getNum()));//项目下已生效物资采购合同的数量
        equipmentLeasingContract.put("contractAmount", roundTwoPre(zl.getMny()));//合同金额
        equipmentLeasingContract.put("settlementAmount", roundTwoPre(zl.getSettleMny()));//结算金额
        equipmentLeasingContract.put("amountPaid", roundTwoPre(payMap.get(ContractTypeConst.EQUIPMENT_RENT)));//已付金额
        equipmentLeasingContract.put("inputInvoice", roundTwoPre(withMap.get("3")));//进项发票

        Map otherExpenses = new HashMap();//其他费用
        otherExpenses.put("projectCollection", roundTwoPre(projectCollection));//工程收款
        otherExpenses.put("salesInvoice", roundTwoPre(without));//销项发票

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("target", target);
        jsonObject.put("subcontract", subcontract);
        jsonObject.put("materialPurchaseContract", materialPurchaseContract);
        jsonObject.put("equipmentLeasingContract", equipmentLeasingContract);
        jsonObject.put("equipmentProcurementContract", equipmentProcurementContract);
        jsonObject.put("otherExpenses", otherExpenses);
        return jsonObject;
    }

    @Override
    public Map<String, PayMnyWarnVO> warnPayMny(PubWarnQueryVO pubWarnQueryVO) {
        if (null == pubWarnQueryVO.getContractType()) {
            throw new BusinessException("合同类型不能为空！");
        }
        Map<String, PayMnyWarnVO> map = new HashMap<>();
        List<PayMnyWarnVO> list = baseMapper.warnPayMny(pubWarnQueryVO);
        for (PayMnyWarnVO payMnyWarnVO : list) {
            map.put(payMnyWarnVO.getTenantId() + "@" + payMnyWarnVO.getOrgId() + "@" + payMnyWarnVO.getContractId(), payMnyWarnVO);
        }
        return map;
    }

    @Override
    public Map<String, PayMnyWarnVO> warnMaterialPayMny(PubWarnQueryVO pubWarnQueryVO) {
        if (null == pubWarnQueryVO.getContractType()) {
            throw new BusinessException("合同类型不能为空！");
        }
        Map<String, PayMnyWarnVO> map = new HashMap<>();
        List<PayMnyWarnVO> list = baseMapper.warnMaterialPayMny(pubWarnQueryVO);
        for (PayMnyWarnVO payMnyWarnVO : list) {
            map.put(payMnyWarnVO.getTenantId() + "@" + payMnyWarnVO.getContractId(), payMnyWarnVO);
        }
        return map;
    }

    @Override
    public Map<String, PayMnyWarnVO> warnMaterialPrePayMny(PubWarnQueryVO pubWarnQueryVO) {
        if (null == pubWarnQueryVO.getContractType()) {
            throw new BusinessException("合同类型不能为空！");
        }
        Map<String, PayMnyWarnVO> map = new HashMap<>();
        List<PayMnyWarnVO> list = baseMapper.warnMaterialPrePayMny(pubWarnQueryVO);
        for (PayMnyWarnVO payMnyWarnVO : list) {
            map.put(payMnyWarnVO.getTenantId() + "@" + payMnyWarnVO.getContractId(), payMnyWarnVO);
        }
        return map;
    }

    @Override
    public TotalColumnVO getTotalColumnInfo(QueryParam param, boolean isEs) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("receiveUnitName");
        fuzzyFields.add("applyUserName");
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        // 组织本下
        param.getParams().put("org_id", new Parameter("in", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        Parameter parameterFlag = param.getParams().get("relationInvoiceFlag");
        param.getParams().remove("relationInvoiceFlag");

        String flag = parameterFlag == null ? null : parameterFlag.getValue().toString();
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<PayContractVO> list = baseMapper.queryPageList(null, wrapper, flag);

        // 过滤为空的数据并求和
        BigDecimal sumApplyMny = list.stream().filter(entity -> entity.getApplyMny() != null)
                .map(PayContractVO::getApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumPayMny = list.stream().filter(entity -> entity.getPayMny() != null)
                .map(PayContractVO::getPayMny).reduce(BigDecimal.ZERO, BigDecimal::add);

        TotalColumnVO vo = new TotalColumnVO();
        vo.setSumApplyMny(sumApplyMny);
        vo.setSumPayMny(sumPayMny);

        return vo;
    }

    @Override
    public TotalColumnVO getApproveTotalColumnInfo(QueryParam param, boolean isEs) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("receiveUnitName");
        fuzzyFields.add("applyUserName");
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        // 组织本下
        param.getParams().put("org_id", new Parameter("in", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        Parameter parameterFlag = param.getParams().get("relationInvoiceFlag");
        param.getParams().remove("relationInvoiceFlag");
        String flag = parameterFlag == null ? null : parameterFlag.getValue().toString();

        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<PayContractVO> list = baseMapper.queryPageList(null, wrapper, flag);

        // 过滤为空的数据并求和
        BigDecimal sumApplyMny = list.stream().filter(entity -> entity.getApplyMny() != null)
                .map(PayContractVO::getApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumPayMny = list.stream().filter(entity -> entity.getPayMny() != null)
                .map(PayContractVO::getPayMny).reduce(BigDecimal.ZERO, BigDecimal::add);

        TotalColumnVO vo = new TotalColumnVO();
        vo.setSumApplyMny(sumApplyMny);
        vo.setSumPayMny(sumPayMny);

        return vo;
    }

    @Override
    public TotalColumnVO getPendingTotalColumnInfo(QueryParam param, boolean isEs) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("receiveUnitName");
        fuzzyFields.add("applyUserName");
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        // 组织本下
        param.getParams().put("orgId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        //已生效状态的单据
        param.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
//        param.getParams().put("payStatus",new Parameter(QueryParam.EQ, 1));//未支付
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));//未删除
        param.getOrderMap().put("approveTime", QueryParam.DESC);

        // 转换报销筛选条件
        transformReimburse(param);

        QueryWrapper<PayApplyPubVO> wrapper = changeToQueryWrapper(param);
        // 未支付或者支付金额小于申请金额为待处理
        wrapper.and(x -> x.last("pay_status = 1 or pay_mny < apply_mny"));
        List<PayApplyPubVO> list = baseMapper.queryPendingList(null, wrapper);

        // 过滤为空的数据并求和
        BigDecimal sumApplyMny = list.stream().filter(entity -> entity.getApplyMny() != null)
                .map(PayApplyPubVO::getApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumPayMny = list.stream().filter(entity -> entity.getPayMny() != null)
                .map(PayApplyPubVO::getPayMny).reduce(BigDecimal.ZERO, BigDecimal::add);

        TotalColumnVO vo = new TotalColumnVO();
        vo.setSumApplyMny(sumApplyMny);
        vo.setSumPayMny(sumPayMny);

        return vo;
    }

    @Override
    public ParamsCheckVO checkParams(Integer purchaseType, BigDecimal sumPayMny, BigDecimal payMny, BigDecimal contractMny) {
        String[] paramsArray = {"none", "warn", "alert"};
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
        CommonResponse<BillParamVO> billParamByCode = paramConfigApi.getBillParamByCode(CHECK_PARAM_CODE);
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            BillParamVO billParamVO = billParamByCode.getData();
            BigDecimal roleValue = billParamVO.getRoleValue();
            BigDecimal sumPayWithThisMny = sumPayMny.add(payMny);
            BigDecimal comMny = contractMny.multiply(roleValue.divide(BigDecimal.valueOf(100)));
            if (2 == purchaseType) {//集采合同直接赋值为不控制
                paramsCheckVO.setWarnType(paramsArray[0]);
                return paramsCheckVO;
            } else {
                paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
            }
            if (sumPayWithThisMny.compareTo(comMny) > 0) {
                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                paramsCheckDsVO.setWarnItem("合同超付");
                paramsCheckDsVO.setWarnName("付款金额大于合同金额");
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("本次申请金额：").append(payMny.toString()).append("元，合同金额*").append(roleValue).append("%:").append(comMny).append("元。超出金额：").append(sumPayWithThisMny.subtract(comMny)).append("元");
                paramsCheckDsVO.setContent(stringBuffer.toString());
                checkDsVOS.add(paramsCheckDsVO);
            }
            paramsCheckVO.setDataSource(checkDsVOS);
        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVO;
    }


    /**
     * 查询实际成本
     *
     * @param projectId
     * @param lastDay
     * @return
     */
    private Map<String, BigDecimal> getCostMonth(Long projectId, Integer lastDay) {
        // 实际成本：取项目下已生效的分包合同结算+物资合同结算+设备采购结算+设备租赁结算+已办理的报销+零星材料付款+借款报销
        // 分包
        List<SubProjectReportVo> subList = new ArrayList<>();
        CommonResponse<List<SubProjectReportVo>> res3 = subReportApi.getMonthSubMny(projectId, lastDay);
        if (res3.isSuccess()) {
            subList = res3.getData();
        } else {
            logger.error("分包结算查询失败");
            throw new BusinessException("分包结算查询失败");
        }
        // 物资合同结算
        List<MaterialReportVo> materialList = new ArrayList<>();
        CommonResponse<List<MaterialReportVo>> res4 = materialContractApi.getMonthMaterialMny(projectId, lastDay);
        if (res4.isSuccess()) {
            materialList = res4.getData();
        } else {
            logger.error("物资结算查询失败");
            throw new BusinessException("物资结算查询失败");
        }
        // 设备采购结算+设备租赁结算
        List<EquipmentReportVo> equipmentList = new ArrayList<>();
        CommonResponse<List<EquipmentReportVo>> res5 = equipmentApi.getMonthEquipmentMny(projectId, lastDay);
        if (res5.isSuccess()) {
            equipmentList = res5.getData();
        } else {
            logger.error("设备采购租赁查询失败");
            throw new BusinessException("实际成本查询失败");
        }
        List<ProjectAppVo> costList = baseMapper.getMonthCostMny(projectId, lastDay);

        Map<String, BigDecimal> cbMap = new HashMap<>();// 成本
        for (SubProjectReportVo rv : subList) {
            BigDecimal a = rv.getMny() == null ? BigDecimal.ZERO : rv.getMny();
            if (cbMap.containsKey(rv.getFinishMonth())) {
                BigDecimal mny = cbMap.get(rv.getFinishMonth());
                cbMap.put(rv.getFinishMonth(), mny.add(a));
            } else {
                cbMap.put(rv.getFinishMonth(), a);
            }
        }
        for (MaterialReportVo rv : materialList) {
            BigDecimal a = rv.getMny() == null ? BigDecimal.ZERO : rv.getMny();
            if (cbMap.containsKey(rv.getFinishMonth())) {
                BigDecimal mny = cbMap.get(rv.getFinishMonth());
                cbMap.put(rv.getFinishMonth(), mny.add(a));
            } else {
                cbMap.put(rv.getFinishMonth(), a);
            }
        }
        for (EquipmentReportVo rv : equipmentList) {
            BigDecimal a = rv.getMny() == null ? BigDecimal.ZERO : rv.getMny();
            if (cbMap.containsKey(rv.getFinishMonth())) {
                BigDecimal mny = cbMap.get(rv.getFinishMonth());
                cbMap.put(rv.getFinishMonth(), mny.add(a));
            } else {
                cbMap.put(rv.getFinishMonth(), a);
            }
        }
        for (ProjectAppVo rv : costList) {
            BigDecimal a = rv.getMny() == null ? BigDecimal.ZERO : rv.getMny();
            if (cbMap.containsKey(rv.getFinishMonth())) {
                BigDecimal mny = cbMap.get(rv.getFinishMonth());
                cbMap.put(rv.getFinishMonth(), mny.add(a));
            } else {
                cbMap.put(rv.getFinishMonth(), a);
            }
        }
        return cbMap;
    }

    public static BigDecimal roundTwoPre(BigDecimal src) {
        return src == null ? new BigDecimal("0.00") : src.setScale(2, BigDecimal.ROUND_HALF_EVEN);
    }

    public static Integer roundTwoPre(Integer src) {
        return src == null ? 0 : src;
    }
    /******************  移动看板 end  ******************/

    /**
     * 校验同合同、同组织下只能有一张未生效单据
     *
     * @param entity
     */
    private void validateBeforeSave(PayContractEntity entity) {
        LambdaQueryWrapper<PayContractEntity> lambda = Wrappers.lambdaQuery();
        lambda.eq(PayContractEntity::getContractId, entity.getContractId());
        lambda.eq(PayContractEntity::getOrgId, entity.getOrgId());
        lambda.eq(PayContractEntity::getTenantId, InvocationInfoProxy.getTenantid());
        lambda.ne(entity.getId() != null && entity.getId() > 0, PayContractEntity::getId, entity.getId());
        lambda.orderByDesc(PayContractEntity::getApplyTime);
        List<PayContractEntity> entityList = super.list(lambda);
        if (CollectionUtils.isNotEmpty(entityList)) {
            for (PayContractEntity p : entityList) {
                List<Integer> effectState = Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(),
                        BillStateEnum.PASSED_STATE.getBillStateCode());
                if (!effectState.contains(p.getBillState())) {
                    throw new BusinessException("该合同在同一组织下存在未生效单据,不允许新增!");
                }
            }
            PayContractEntity late = entityList.get(0);
            Date applyTime = late.getApplyTime();
            Date _applyTime = entity.getApplyTime();

            if (_applyTime != null && applyTime != null && _applyTime.getTime() <= applyTime.getTime()) {
                String applyTimeStr = MonthUtil.dateFormatStrTMDHMS(applyTime);
                String _applyTimeStr = MonthUtil.dateFormatStrTMDHMS(_applyTime);
                throw  new BusinessException("当前申请时间必须大于最新的申请时间，最新时间：" + applyTimeStr + "，当前申请时间：" + _applyTimeStr + " !");

            }
        }
    }


    /**
     * 是否需要回写
     *
     * @param vo
     * @return
     */
    private boolean getWriteFlag(PayContractVO vo) {
        boolean writeFlag = false;
        if (vo.getId() != null) {
            PayContractEntity data = super.selectById(vo.getId());
            Integer payStatus = data.getPayStatus();
            // 确认支付
            if (payStatus != vo.getPayStatus() && vo.getPayStatus() == 2) {
                writeFlag = true;
            }
        }
        return writeFlag;
    }

    /**
     * 更新发票
     *
     * @param vo
     * @param id
     * @return
     */
    private List<PayInvoiceVO> updateInvoiceVOS(PayContractVO vo, Long id) {
        // 新增
        List<PayInvoiceVO> voList = vo.getInvoiceVOList();
        if (voList != null && !voList.isEmpty()) {
            for (PayInvoiceVO invoiceVO : voList) {
                invoiceVO.setPayapplyId(id);
            }
            List<PayInvoiceEntity> entityList = BeanMapper.mapList(voList, PayInvoiceEntity.class);
            invoiceService.saveOrUpdateBatch(entityList, entityList.size(), false);
            voList = BeanMapper.mapList(entityList, PayInvoiceVO.class);
        }
        // 删除
        QueryWrapper wrapper = new QueryWrapper<PayInvoiceEntity>();
        wrapper.eq("payapply_id", id);
        if (CollectionUtils.isNotEmpty(voList)) {
            List<Long> ids = voList.stream().map(PayInvoiceVO::getId).collect(Collectors.toList());
            wrapper.notIn(!ids.isEmpty(), "id", ids);
        }
        invoiceService.remove(wrapper, false);
        return voList;
    }

    /**
     * @param vo
     * @param id
     * @description: 更新扣款单
     * @return: java.util.List<com.ejianc.business.finance.vo.PayContractDeductionVO>
     * @author songlx
     * @date: 2021/9/26
     */
    private List<PayContractDeductionVO> updateDeductionVOS(PayContractVO vo, Long id) {
        // 新增
        List<PayContractDeductionVO> vos = vo.getDeductionVOList();
        if (CollectionUtils.isNotEmpty(vos)) {
            for (PayContractDeductionVO deductionVO : vos) {
                deductionVO.setPayapplyId(id);
            }
            List<PayContractDeductionEntity> entityList = BeanMapper.mapList(vos, PayContractDeductionEntity.class);
            boolean updateBatch = contractDeductionService.saveOrUpdateBatch(entityList);
            vos = BeanMapper.mapList(entityList, PayContractDeductionVO.class);
            if (updateBatch) {
                List<Long> dedIds = vos.stream().map(PayContractDeductionVO::getDeductionId).collect(Collectors.toList());
                //扣款单占用
                this.updateDeductionUseFlag(dedIds, 1);
            }
            // 删除
            List<Long> ids = vos.stream().map(PayContractDeductionVO::getId).collect(Collectors.toList());
            QueryWrapper<PayContractDeductionEntity> wrapper = new QueryWrapper<>();
            wrapper.eq("payapply_id", id);
            wrapper.notIn(!ids.isEmpty(), "id", ids);
            List<PayContractDeductionEntity> oldList = contractDeductionService.list(wrapper);
            if(CollectionUtils.isNotEmpty(oldList)){
                List<Long> oldDedIds = oldList.stream().map(PayContractDeductionEntity::getDeductionId).collect(Collectors.toList());
                this.updateDeductionUseFlag(oldDedIds, 0);
                contractDeductionService.remove(wrapper, false);
            }
        } else{
            QueryWrapper<PayContractDeductionEntity> wrapper = new QueryWrapper<>();
            wrapper.eq("payapply_id", id);
            List<PayContractDeductionEntity> oldList = contractDeductionService.list(wrapper);
            if(CollectionUtils.isNotEmpty(oldList)){
                List<Long> oldDedIds = oldList.stream().map(PayContractDeductionEntity::getDeductionId).collect(Collectors.toList());
                this.updateDeductionUseFlag(oldDedIds, 0);
                contractDeductionService.remove(wrapper, false);
            }
        }
        return vos;
    }


    /**
     * 更新结算
     *
     * @param vo
     * @param id
     * @return
     */
    private List<PayContractSettleVO> updateSettleVOS(PayContractVO vo, Long id) {
        // 新增
        List<PayContractSettleVO> vos = vo.getSettleVOList();
        if (vos != null && !vos.isEmpty()) {
            String billTypeCode = BillTypeCodeEnum.getSettleBillTypeCode(vo.getContractType());
            for (PayContractSettleVO settleVO : vos) {
                // 保存时校验version是否一致
                if (!ValidateUtil.validateUpstreamVersion(String.valueOf(settleVO.getSettleId()), billTypeCode, settleVO.getSettleVersion())) {
                    throw new BusinessException("结算单已被更新，请刷新后重做！");
                }
                settleVO.setPayapplyId(id);
            }
            List<PayContractSettleEntity> entityList = BeanMapper.mapList(vos, PayContractSettleEntity.class);
            settleService.saveOrUpdateBatch(entityList, entityList.size(), false);
            vos = BeanMapper.mapList(entityList, PayContractSettleVO.class);
        }
        // 删除
        QueryWrapper wrapper = new QueryWrapper<PayInvoiceEntity>();
        wrapper.eq("payapply_id", id);
        if (CollectionUtils.isNotEmpty(vos)) {
            List<Long> ids = vos.stream().map(PayContractSettleVO::getId).collect(Collectors.toList());
            wrapper.notIn(!ids.isEmpty(), "id", ids);
        }
        settleService.remove(wrapper, false);
        return vos;
    }

    /**
     * 回写合同累计付款、累计预付款金额与结算单累计付款金额
     *
     * @param billId
     * @param entity
     * @param flag
     */
    public boolean writeBackSumPayMny(Long billId, PayContractEntity entity, boolean flag) {
        // 本期付款金额   true为回写，false为逆回写
        BigDecimal payMny = flag ? entity.getPayMny() : MathUtil.safeSub(new BigDecimal(0), entity.getPayMny());
        // 预付款时等于本期付款金额
        BigDecimal prepayMny = entity.getFeeType() == 1 ? payMny : BigDecimal.ZERO;
        List<PayContractSettleEntity> settleEntityList = settleService.list(new QueryWrapper<PayContractSettleEntity>().eq("payapply_id", billId));
        // 结算单对应支付金额回写
        Map<Long, BigDecimal> settlePayMnyMap = new HashMap<>();
        for (PayContractSettleEntity settleEntity : settleEntityList) {
            // 本期支付金额   true为回写，false为逆回写
            BigDecimal settlePayMny = flag ? settleEntity.getSumPayMny() : MathUtil.safeSub(new BigDecimal(0), settleEntity.getSumPayMny());
            settlePayMnyMap.put(settleEntity.getSettleId(), ComputeUtil.nullToZero(settlePayMny));
        }
        if (entity.getContractType() == 1) {//分包
            subApi.updateSubContractSumPayMny(entity.getContractId(), payMny, prepayMny);//合同
            for (PayContractSettleEntity settleEntity : settleEntityList) {
                subApi.updateSubSettleSumPayMny(settleEntity.getSettleId(), settlePayMnyMap.get(settleEntity.getSettleId()));//结算单
            }
        }
        if (entity.getContractType() == 2) {//设备采购
            equipmentApi.updatePurchaseContractSumPayMny(entity.getContractId(), payMny, prepayMny);//合同
            for (PayContractSettleEntity settleEntity : settleEntityList) {
                equipmentApi.updatePurchaseSettleSumPayMny(settleEntity.getSettleId(), settlePayMnyMap.get(settleEntity.getSettleId()));//结算单
            }
        }
        if (entity.getContractType() == 3) {//设备租赁
            equipmentApi.updateRentContractSumPayMny(entity.getContractId(), payMny, prepayMny);//合同
            for (PayContractSettleEntity settleEntity : settleEntityList) {
                equipmentApi.updateRentSettleSumPayMny(settleEntity.getSettleId(), settlePayMnyMap.get(settleEntity.getSettleId()));//结算单
            }
        }
        if (entity.getContractType() == 4) {//物资采购
            for (PayContractSettleEntity settleEntity : settleEntityList) {
                materialApi.updateSettlementBillAlreadyPaidAmount(settleEntity.getSettleId(), settlePayMnyMap.get(settleEntity.getSettleId()));//结算单
            }
        }
        if (entity.getContractType() == 5) {//物资租赁
            //TODO
        }
        return true;
    }

    /**
     * 自动生成编码
     *
     * @param entity
     */
    private void autoSetBillCode(PayContractEntity entity) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (StringUtils.isEmpty(entity.getBillCode())) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(PAY_CONTRACT_BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //修改  校验合同编号是否重复
        LambdaQueryWrapper<PayContractEntity> lambda = Wrappers.lambdaQuery();
        lambda.eq(PayContractEntity::getBillCode, entity.getBillCode());
        lambda.eq(PayContractEntity::getTenantId, tenantId);
        lambda.ne(entity.getId() != null && entity.getId() > 0, PayContractEntity::getId, entity.getId());
        List<PayContractEntity> entityList = super.list(lambda);
        if (entityList != null && entityList.size() > 0) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }
    }

    /**
     * 获取当月开始时间与结束时间
     *
     * @param limit min：开始时间    max：结束时间
     * @return
     */
    private static Date getTime(String limit) {
        Calendar cal = Calendar.getInstance();
        cal.add(Calendar.MONTH, 0);//当前月份
        if ("min".equals(limit)) {
            //设置本月起始日的年月日时分秒格式
            cal.set(cal.get(Calendar.YEAR), cal.get(Calendar.MONDAY),
                    cal.getActualMinimum(Calendar.DAY_OF_MONTH), 00, 00, 00);
        } else if ("max".equals(limit)) {
            //设置本月结束日的年月日时分秒格式
            cal.set(cal.get(Calendar.YEAR), cal.get(Calendar.MONDAY),
                    cal.getActualMaximum(Calendar.DAY_OF_MONTH), 23, 59, 59);
        }
        return cal.getTime();
    }

    /*
     *
     * @description: 转换报销筛选条件
     * @author: 曹鹏辉
     * @date: 2021/5/21 10:59
     * @param: param
     * @return: void
     */
    private void transformReimburse(QueryParam param) {
        // 判断筛选条件是否携带报销信息
        Parameter feeType = param.getParams().get("feeType");
        if (!Objects.equals(feeType, null)) {
            String value = feeType.getValue().toString();

            if (StringUtils.contains(value, "报销-")) {
                // 查询资金-付款申请-报销费用类别
                CommonResponse<List<DefdocDetailVO>> listCommonResponse = defdocApi.getDefDocByDefId(324875125018329093L);
                List<DefdocDetailVO> data = listCommonResponse.getData();
                String[] split = value.split(",");
                for (int i = 0; i < split.length; i++) {
                    String feeTypeName = split[i];
                    if (StringUtils.contains(feeTypeName, "报销-")) {
                        List<DefdocDetailVO> list = data.stream()
                                .filter(vo -> vo.getName().equals(feeTypeName.substring(3)))
                                .collect(Collectors.toList());

                        split[i] = list.get(0).getId().toString();
                    }
                }

                value = StringUtils.join(split, ",");
                // 重新赋值
                feeType.setValue(value);
            }
        }
    }

    /**
     * 付款关闭
     *
     * @param id 付款申请id
     */
    @Override
    public void closePayment(Long id) {
        Assert.notNull(id, "付款申请id不能为空");
        PayContractEntity entity = super.selectById(id);
        if (entity == null) {
            throw new BusinessException("付款申请不存在");
        }

        // 【本期申请金额】修改为【已支付金额】
        entity.setApplyMnyBeforeClose(entity.getApplyMny());
        entity.setApplyMny(entity.getPayMny());
        entity.setApplyMnyCn(NumberToCN.number2CN(entity.getApplyMny()));

        // 表体【本期申请金额】修改为【本期支付金额】回写结算单
        LambdaQueryWrapper<PayContractSettleEntity> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(PayContractSettleEntity::getPayapplyId, id);
        List<PayContractSettleEntity> list = settleService.list(wrapper);
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(settle -> {
                // 保留关闭前的本期申请金额
                settle.setBodyApplyMnyBeforeClose(settle.getBodyApplyMny());
                settle.setBodyApplyMny(settle.getSumPayMny());
            });
            settleService.updateBatchById(list);
        }

        // 付款关闭确认后 【关闭状态】=已关闭；【关闭人】=当前登录人；【关闭时间】=当前时间；
        entity.setCloseFlag(Boolean.TRUE);
        entity.setCloseState("已关闭");
        entity.setCloseTime(new Date());
        entity.setCloseUser(sessionManager.getUserContext().getUserName());

        super.updateById(entity);

        // 回写结算单累计申请金额、剩余可申请金额
        writeBackSumApplyMny(id, entity, false);

    }


    /**
     * 回写结算单累计申请金额、剩余可申请金额
     * @param billId
     * @param entity
     * @param flag
     */
    public boolean writeBackSumApplyMny(Long billId, PayContractEntity entity, boolean flag) {
        List<PayContractSettleEntity> settleEntityList = settleService.list(new QueryWrapper<PayContractSettleEntity>().eq("payapply_id", billId));
        // 结算单对应本期申请金额
        Map<Long, BigDecimal> settleApplyMnyMap  = new HashMap<>();
        for(PayContractSettleEntity settleEntity : settleEntityList){
            // 本期申请金额   true为回写，false为逆回写
            BigDecimal applyMny = flag ? settleEntity.getBodyApplyMny() : MathUtil.safeSub(settleEntity.getBodyApplyMny(), settleEntity.getBodyApplyMnyBeforeClose());
            settleApplyMnyMap.put(settleEntity.getSettleId(), applyMny);
        }
        if(entity.getContractType() == 1){//分包
            for(PayContractSettleEntity settleEntity : settleEntityList){
                subApi.updateSubSettleSumApplyMny(settleEntity.getSettleId(), settleApplyMnyMap.get(settleEntity.getSettleId()));//结算单
            }
        }
        if(entity.getContractType() == 2){//设备采购
            for(PayContractSettleEntity settleEntity : settleEntityList){
                equipmentApi.updatePurchaseSettleSumApplyMny(settleEntity.getSettleId(), settleApplyMnyMap.get(settleEntity.getSettleId()));//结算单
            }
        }
        if(entity.getContractType() == 3){//设备租赁
            for(PayContractSettleEntity settleEntity : settleEntityList){
                equipmentApi.updateRentSettleSumApplyMny(settleEntity.getSettleId(), settleApplyMnyMap.get(settleEntity.getSettleId()));//结算单
            }
        }
        if(entity.getContractType() == 4){//物资采购
            for(PayContractSettleEntity settleEntity : settleEntityList){
                materialApi.updateSettlementBillAlreadyApplyAmount(settleEntity.getSettleId(), settleApplyMnyMap.get(settleEntity.getSettleId()));//结算单
            }
        }
        return true;
    }
}
