package com.ejianc.business.finance.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 收入管理甲方报量实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_finance_receive_qute_detail")
public class ReceiveQuteDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="receive_id")
    private Long receiveId; // 收款登记主表id
    @TableField(value="quote_id")
    private Long quoteId; // 甲方报量Id
    @TableField("contract_id")
    private Long contractId;//合同主键
    @TableField(value="quote_code")
    private String quoteCode; // 甲方报量编码
    @TableField(value="contract_tax_mny")
    private BigDecimal contractTaxMny; // 合同金额
    @TableField(value="quote_tax_mny")
    private BigDecimal quoteTaxMny; // 本期报量金额
    @TableField(value="receive_tax_mny")
    private BigDecimal receiveTaxMny; // 收款金额
    @TableField(value="total_receive_tax_mny")
    private BigDecimal totalReceiveTaxMny; // 含本期累计收款金额
    @TableField(value="last_receive_tax_mny")
    private BigDecimal lastReceiveTaxMny; // 不含本期累计收款金额
    @TableField(value="surplus_receive_mny")
    private BigDecimal surplusReceiveMny; // 剩余收款金额
    @TableField(value="sum_quote_tax_mny")
    private BigDecimal sumQuoteTaxMny; // 累计报量金额
    @TableField(value="total_contract_receive_tax_mny")
    private BigDecimal totalContractReceiveTaxMny; // 合同含本期累计收款金额
    @TableField(value="last_contract_receive_tax_mny")
    private BigDecimal lastContractReceiveTaxMny; // 合同不含本期累计收款金额
    @TableField(value="sum_surplus_receive_tax_mny")
    private BigDecimal sumSurplusReceiveTaxMny; // 总剩余收款金额
    @TableField(value="memo")
    private String memo; // 描述

    
    
    

    public Long getReceiveId() {
        return receiveId;
    }

    public void setReceiveId(Long receiveId) {
        this.receiveId = receiveId;
    }
    public Long getQuoteId() {
        return quoteId;
    }

    public void setQuoteId(Long quoteId) {
        this.quoteId = quoteId;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getQuoteCode() {
        return quoteCode;
    }

    public void setQuoteCode(String quoteCode) {
        this.quoteCode = quoteCode;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public BigDecimal getQuoteTaxMny() {
        return quoteTaxMny;
    }

    public void setQuoteTaxMny(BigDecimal quoteTaxMny) {
        this.quoteTaxMny = quoteTaxMny;
    }
    public BigDecimal getReceiveTaxMny() {
        return receiveTaxMny;
    }

    public void setReceiveTaxMny(BigDecimal receiveTaxMny) {
        this.receiveTaxMny = receiveTaxMny;
    }
    public BigDecimal getTotalReceiveTaxMny() {
        return totalReceiveTaxMny;
    }

    public void setTotalReceiveTaxMny(BigDecimal totalReceiveTaxMny) {
        this.totalReceiveTaxMny = totalReceiveTaxMny;
    }
    public BigDecimal getLastReceiveTaxMny() {
        return lastReceiveTaxMny;
    }

    public void setLastReceiveTaxMny(BigDecimal lastReceiveTaxMny) {
        this.lastReceiveTaxMny = lastReceiveTaxMny;
    }
    public BigDecimal getSurplusReceiveMny() {
        return surplusReceiveMny;
    }

    public void setSurplusReceiveMny(BigDecimal surplusReceiveMny) {
        this.surplusReceiveMny = surplusReceiveMny;
    }
    public BigDecimal getSumQuoteTaxMny() {
        return sumQuoteTaxMny;
    }

    public void setSumQuoteTaxMny(BigDecimal sumQuoteTaxMny) {
        this.sumQuoteTaxMny = sumQuoteTaxMny;
    }
    public BigDecimal getTotalContractReceiveTaxMny() {
        return totalContractReceiveTaxMny;
    }

    public void setTotalContractReceiveTaxMny(BigDecimal totalContractReceiveTaxMny) {
        this.totalContractReceiveTaxMny = totalContractReceiveTaxMny;
    }
    public BigDecimal getLastContractReceiveTaxMny() {
        return lastContractReceiveTaxMny;
    }

    public void setLastContractReceiveTaxMny(BigDecimal lastContractReceiveTaxMny) {
        this.lastContractReceiveTaxMny = lastContractReceiveTaxMny;
    }
    public BigDecimal getSumSurplusReceiveTaxMny() {
        return sumSurplusReceiveTaxMny;
    }

    public void setSumSurplusReceiveTaxMny(BigDecimal sumSurplusReceiveTaxMny) {
        this.sumSurplusReceiveTaxMny = sumSurplusReceiveTaxMny;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
}
