package com.ejianc.business.finance.controller;


import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.accplat.consts.SystemCodeEnum;
import com.ejianc.business.finance.bean.*;
import com.ejianc.business.finance.service.FinanceVoucherHandleService;
import com.ejianc.business.finance.service.IBondUpBackService;
import com.ejianc.business.finance.service.IBondUpService;
import com.ejianc.business.finance.vo.BondUpBackVO;
import com.ejianc.business.finance.vo.BondUpDealRentVO;
import com.ejianc.business.voucher.api.IVoucherApi;
import com.ejianc.business.voucher.consts.VoucherOptFlag;
import com.ejianc.business.voucher.utils.DataConvertUtil;
import com.ejianc.business.voucher.vo.VoucherInfo;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 保证金退还表 前端控制器
 * </p>
 *
 * @author sunyj
 * @since 2020-06-16
 */
@RestController
@RequestMapping("/bondUpBack")
public class BondUpBackController {
    @Autowired
    private IBondUpBackService bondUpBackService;
    @Autowired
    private IVoucherApi voucherApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private FinanceVoucherHandleService financeVoucherHandleService;
    @Autowired
    private IBondUpService bondUpService;
    /**
     * @Author sunyj
     * @Date 2020/5/28
     * @Description saveOrUpdate 新增或者修改
     * @param bondUpBackVO
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BondUpBackVO> saveOrUpdate(@RequestBody BondUpBackVO bondUpBackVO) {
        BondUpBackVO backVO = bondUpBackService.insertOrUpdate(bondUpBackVO);
        return CommonResponse.success("保存或修改单据成功！", backVO);
    }

    /**
     * @description: 推送凭证
     *
     * @param voucherInfo
     * @return {@link CommonResponse}
     * @author songlx
     * @date: 2024/1/12
     */
    @RequestMapping(value = "/pushVoucher", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse pushVoucher(@RequestBody VoucherInfo voucherInfo) {
        Long billId = voucherInfo.getBillId();
        Assert.notNull(billId, "单据billId不能为空！");
        BondUpBackEntity entity = bondUpBackService.selectById(billId);
        BondUpEntity bondUpEntity = bondUpService.selectById(entity.getBondId());
        VoucherParams voucherParams = VoucherParams.newInstance("BT200622000000002",bondUpEntity.getOrgId(),entity, SystemCodeEnum.FINANCE);
        return financeVoucherHandleService.handleVoucherWithVoucherParams(bondUpBackService, voucherParams, VoucherOptFlag.SAVE);

    }

    /**
     * @Author sunyj
     * @Date 2020/5/28
     * @Description saveOrUpdate 查询详情
     * @param id
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BondUpDealRentVO> queryDetail(Long id) {
        BondUpDealRentVO backVO = bondUpBackService.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！", backVO);
    }
}
