package com.ejianc.business.finance.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author yqls
 * @since 2020-06-04
 */
@TableName("ejc_finance_pay_contract")
public class PayContractEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 单据编号
     */
    @TableField("bill_code")
    private String billCode;

    /**
     * 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
     */
    @TableField("bill_state")
    private Integer billState;

    /**
     * 经办人
     */
    @TableField("employee_id")
    private Long employeeId;

    /**
     * 经办人名称
     */
    @TableField("employee_name")
    private String employeeName;

    /**
     * 经办时间
     */
    @TableField("confirm_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date confirmTime;

    /**
     * 备注
     */
    @TableField("memo")
    private String memo;

    /**
     * 付款类型：1-组织付款 2-项目付款
     */
    @TableField("pay_type")
    private Integer payType;

    /**
     * 支付状态：1-未支付 2-已支付
     */
    @TableField("pay_status")
    private Integer payStatus;

    /**
     * 支付金额
     */
    @TableField("pay_mny")
    private BigDecimal payMny;

    /**
     * 合同主键
     */
    @TableField("contract_id")
    private Long contractId;

    /**
     * 合同类型：1-分包,2-设备采购,3-设备租赁,4-物资采购,5-物资租赁
     */
    @TableField("contract_type")
    private Long contractType;

    /**
     * 合同编码
     */
    @TableField("contract_code")
    private String contractCode;

    /**
     * 合同名称
     */
    @TableField("contract_name")
    private String contractName;

    /**
     * 项目
     */
    @TableField("project_id")
    private Long projectId;

    /**
     * 项目名称
     */
    @TableField("project_name")
    private String projectName;

    /**
     * 项目类型：1-自营，2-联营
     */
    @TableField("project_type")
    private String projectType;

    /**
     * 组织
     */
    @TableField("org_id")
    private Long orgId;

    /**
     * 组织名称
     */
    @TableField("org_name")
    private String orgName;

    /**
     * 分包类型
     */
    @TableField("sub_contract_type_id")
    private Long subContractTypeId;

    /**
     * 分包类型名称
     */
    @TableField("sub_contract_type")
    private String subContractType;

    /**
     * 支付类型：1-预付款，2-过程款，3-其他
     */
    @TableField("fee_type")
    private Long feeType;

    /**
     * 付款事由
     */
    @TableField("pay_reason")
    private String payReason;

    /**
     * 收款单位
     */
    @TableField("receive_unit_id")
    private Long receiveUnitId;

    /**
     * 收款单位名称
     */
    @TableField("receive_unit_name")
    private String receiveUnitName;


    /**
     * 付款单位
     */
    @TableField("pay_unit_id")
    private Long payUnitId;

    /**
     * 付款单位名称
     */
    @TableField("pay_unit_name")
    private String payUnitName;

    /**
     * 合同金额
     */
    @TableField("contract_mny")
    private BigDecimal contractMny;

    /**
     * 已结算金额
     */
    @TableField("sum_settle_mny")
    private BigDecimal sumSettleMny;

    /**
     * 累计已付
     */
    @TableField("sum_pay_mny")
    private BigDecimal sumPayMny;

    /**
     * 已收票金额
     */
    @TableField("sum_invoice_mny")
    private BigDecimal sumInvoiceMny;

    /**
     * 申请人
     */
    @TableField("apply_user_id")
    private Long applyUserId;

    /**
     * 申请人名称
     */
    @TableField("apply_user_name")
    private String applyUserName;

    /**
     * 申请时间
     */
    @TableField("apply_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date applyTime;

    /**
     * 申请金额
     */
    @TableField("apply_mny")
    private BigDecimal applyMny;

    /**
     * 账户名称
     */
    @TableField("account_name")
    private String accountName;

    /**
     * 银行账号
     */
    @TableField("account_num")
    private String accountNum;

    /**
     * 开户行
     */
    @TableField("account_bank")
    private String accountBank;

    /**
     * 发票金额
     */
    @TableField("invoice_mny")
    private BigDecimal invoiceMny;

    /**
     * 撤回原因
     */
    @TableField("back_reason")
    private String backReason;

    /**
     * 撤回时间
     */
    @TableField("back_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date backTime;

    /**
     * 合同支付比例
     */
    @TableField("pay_scale")
    private BigDecimal payScale;

    /**
     * 已支付比例
     */
    @TableField("be_pay_scale")
    private BigDecimal bePayScale;

    /**
     * 截止本期申请比例（按结算）
     */
    @TableField("endthis_pay_scale")
    private BigDecimal endthisPayScale;

    /**
     * 审批时间
     */
    @TableField("approve_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date approveTime;

    /**
     * 采购类型 1-自采，2-集采
     */
    @TableField("purchase_type")
    private String purchaseType;

    /**
     * 属于项目:1-是，0-否
     */
    @TableField("depend_on_project")
    private String dependOnProject;

    /**
     * 项目类型名称
     */
    @TableField("project_type_name")
    private String projectTypeName;

    /**
     * 是否需要发票：1 需要，2 不需要，3 不确定
     */
    private String invoiceFlag;


    /**
     * 截止本期申请比例（按合同）
     */
    @TableField("endthis_pay_scale_by_contract")
    private BigDecimal endthisPayScaleByContract;

    /**
     * 对甲回款比例
     */
    @TableField("collect_ratio")
    private BigDecimal collectRatio;

    /**
     * 项目收款总额
     */
    @TableField("sum_collect_mny")
    private BigDecimal sumCollectMny;

    /**
     * 累计完成产值
     */
    @TableField("sum_production_tax_mny")
    private BigDecimal sumProductionTaxMny;

    /**
     * 截止上期已申请
     */
    @TableField("sum_apply_mny")
    private BigDecimal sumApplyMny;

    /**
     * 申请金额大写
     */
    @TableField("apply_mny_cn")
    private String applyMnyCn;
    @TableField("wait_deduct_Mny")
    private BigDecimal waitDeductMny;//据主表选择项目+供应商，查询这个供应商+合项目下所有已生效未被引用过的累计扣款单金额

    /**
     *************start************************项目资金改造***************************start*******************************
     */

    @TableField(value="pro_contract_mny")
    private java.math.BigDecimal proContractMny; // 收入合同金额
    @TableField(value="pro_output_mny")
    private java.math.BigDecimal proOutputMny; // 完成产值
    @TableField(value="pro_date_progress")
    private java.math.BigDecimal proDateProgress; // 日期进度
    @TableField(value="pro_output_progress")
    private java.math.BigDecimal proOutputProgress; // 产值进度
    @TableField(value="pro_contract_receive_mny")
    private java.math.BigDecimal proContractReceiveMny; // 合同累计收款金额
    @TableField(value="pro_receive_mny")
    private java.math.BigDecimal proReceiveMny; // 累计收款
    @TableField(value="pro_pay_mny")
    private java.math.BigDecimal proPayMny; // 累计付款
    @TableField(value="pro_cost_list_surplus")
    private java.math.BigDecimal proCostListSurplus; // 费用清单结余
    @TableField(value="pro_transfer_surplus")
    private java.math.BigDecimal proTransferSurplus; // 项目代转款款结余
    @TableField(value="pro_risk_margin_surplus")
    private java.math.BigDecimal proRiskMarginSurplus; // 风险保证金结余
    @TableField(value="pro_loan_balance")
    private java.math.BigDecimal proLoanBalance; // 借款结余
    @TableField(value="pro_loan_interest")
    private java.math.BigDecimal proLoanInterest; // 借款利息
    @TableField(value="pro_other_fee_deduct")
    private java.math.BigDecimal proOtherFeeDeduct; // 其他费用扣除
    @TableField(value="pro_other_fee_back")
    private java.math.BigDecimal proOtherFeeBack; // 其他费用退还
    @TableField(value="pro_surplus_mny")
    private java.math.BigDecimal proSurplusMny; // 项目可用资金
    @TableField(value="pro_surplus_apply_mny")
    private java.math.BigDecimal proSurplusApplyMny; // 剩余可申请金额release
    @TableField(value="pro_petty_cash")
    private java.math.BigDecimal proPettyCash; // 备用金结余
    @TableField(value="pro_manage_scale")
    private java.math.BigDecimal proManageScale; // 管理费比例
    @TableField(value="pro_manage_fee")
    private java.math.BigDecimal proManageFee; // 管理费
    @TableField(value="pro_amerce")
    private java.math.BigDecimal proAmerce; // 罚款
    @TableField(value="pro_apply_unpay_mny")
    private java.math.BigDecimal proApplyUnpayMny; // 已申请未支付金额

    public BigDecimal getProApplyUnpayMny() {
        return proApplyUnpayMny;
    }

    public void setProApplyUnpayMny(BigDecimal proApplyUnpayMny) {
        this.proApplyUnpayMny = proApplyUnpayMny;
    }

    /**
     *************end************************项目资金改造***************************end*******************************
     */


    @TableField(value="contract_stage_id")
    private Long contractStageId; // 合同付款阶段id
    @TableField(value="contract_stage_scale")
    private BigDecimal contractStageScale; // 合同付款阶段比例
    @TableField(value="contract_stage_name")
    private String contractStageName; // 合同付款阶段名称
    @TableField(value="cur_penalty_money")
    private BigDecimal curPenaltyMoney; // 本期扣款金额合计
    @TableField(value="cur_settle_money")
    private BigDecimal curSettleMoney; // 本期结算金额合计
    @TableField(value="cur_contract_pay_money")
    private BigDecimal curContractPayMoney; // 本期合同应付金额合计

    /**
     * 世纪阳光字段 付款类型 1-保温，2-饰面，3-自有劳务********************************************************
     */
    @TableField("payment_type")
    private Integer paymentType;

    public Integer getPaymentType() {
        return paymentType;
    }

    public void setPaymentType(Integer paymentType) {
        this.paymentType = paymentType;
    }

    /**
     * 世纪阳光字段 付款类型 end*******************************************************************************
     */

    @TableField(value="income_code")
    private String incomeCode; // 施工合同编号

    /**
     * 剩余申请金额
     */
    @TableField("sum_surplus_apply_mny")
    private BigDecimal sumSurplusApplyMny;

    /**
     * 关闭前的本期申请金额
     */
    @TableField("apply_mny_before_close")
    private BigDecimal applyMnyBeforeClose;

    /**
     * 关闭状态
     */
    @TableField("close_state")
    private String closeState;

    /**
     * 关闭时间
     */
    @TableField("close_time")
    private Date closeTime;

    /**
     * 关闭人
     */
    @TableField("close_user")
    private String closeUser;

    /**
     * 是否关闭
     */
    @TableField("close_flag")
    private Boolean closeFlag;

    @TableField("pay_focus_id")
    private Long payFocusId;

    public BigDecimal getApplyMnyBeforeClose() {
        return applyMnyBeforeClose;
    }

    public void setApplyMnyBeforeClose(BigDecimal applyMnyBeforeClose) {
        this.applyMnyBeforeClose = applyMnyBeforeClose;
    }

    public String getCloseState() {
        return closeState;
    }

    public void setCloseState(String closeState) {
        this.closeState = closeState;
    }

    public Date getCloseTime() {
        return closeTime;
    }

    public void setCloseTime(Date closeTime) {
        this.closeTime = closeTime;
    }

    public Long getPayFocusId() {
        return payFocusId;
    }

    public void setPayFocusId(Long payFocusId) {
        this.payFocusId = payFocusId;
    }

    public String getCloseUser() {
        return closeUser;
    }

    public void setCloseUser(String closeUser) {
        this.closeUser = closeUser;
    }

    public Boolean getCloseFlag() {
        return closeFlag;
    }

    public void setCloseFlag(Boolean closeFlag) {
        this.closeFlag = closeFlag;
    }

    public BigDecimal getSumSurplusApplyMny() {
        return sumSurplusApplyMny;
    }

    public void setSumSurplusApplyMny(BigDecimal sumSurplusApplyMny) {
        this.sumSurplusApplyMny = sumSurplusApplyMny;
    }

    public String getIncomeCode() {
        return incomeCode;
    }

    public void setIncomeCode(String incomeCode) {
        this.incomeCode = incomeCode;
    }

    public Long getPayUnitId() {
        return payUnitId;
    }

    public void setPayUnitId(Long payUnitId) {
        this.payUnitId = payUnitId;
    }

    public String getPayUnitName() {
        return payUnitName;
    }

    public void setPayUnitName(String payUnitName) {
        this.payUnitName = payUnitName;
    }

    public Long getContractStageId() {
        return contractStageId;
    }

    public void setContractStageId(Long contractStageId) {
        this.contractStageId = contractStageId;
    }

    public BigDecimal getContractStageScale() {
        return contractStageScale;
    }

    public void setContractStageScale(BigDecimal contractStageScale) {
        this.contractStageScale = contractStageScale;
    }

    public String getContractStageName() {
        return contractStageName;
    }

    public void setContractStageName(String contractStageName) {
        this.contractStageName = contractStageName;
    }

    public BigDecimal getCurPenaltyMoney() {
        return curPenaltyMoney;
    }

    public void setCurPenaltyMoney(BigDecimal curPenaltyMoney) {
        this.curPenaltyMoney = curPenaltyMoney;
    }

    public BigDecimal getCurSettleMoney() {
        return curSettleMoney;
    }

    public void setCurSettleMoney(BigDecimal curSettleMoney) {
        this.curSettleMoney = curSettleMoney;
    }

    public BigDecimal getCurContractPayMoney() {
        return curContractPayMoney;
    }

    public void setCurContractPayMoney(BigDecimal curContractPayMoney) {
        this.curContractPayMoney = curContractPayMoney;
    }

    @TableField(exist=false)
    private List<PayRecordEntity> recordList = new ArrayList<>(); // 付款申请记录实体

    public BigDecimal getProContractMny() {
        return proContractMny;
    }

    public void setProContractMny(BigDecimal proContractMny) {
        this.proContractMny = proContractMny;
    }

    public BigDecimal getProOutputMny() {
        return proOutputMny;
    }

    public void setProOutputMny(BigDecimal proOutputMny) {
        this.proOutputMny = proOutputMny;
    }

    public BigDecimal getProDateProgress() {
        return proDateProgress;
    }

    public void setProDateProgress(BigDecimal proDateProgress) {
        this.proDateProgress = proDateProgress;
    }

    public BigDecimal getProOutputProgress() {
        return proOutputProgress;
    }

    public void setProOutputProgress(BigDecimal proOutputProgress) {
        this.proOutputProgress = proOutputProgress;
    }

    public BigDecimal getProContractReceiveMny() {
        return proContractReceiveMny;
    }

    public void setProContractReceiveMny(BigDecimal proContractReceiveMny) {
        this.proContractReceiveMny = proContractReceiveMny;
    }

    public BigDecimal getProReceiveMny() {
        return proReceiveMny;
    }

    public void setProReceiveMny(BigDecimal proReceiveMny) {
        this.proReceiveMny = proReceiveMny;
    }

    public BigDecimal getProPayMny() {
        return proPayMny;
    }

    public void setProPayMny(BigDecimal proPayMny) {
        this.proPayMny = proPayMny;
    }

    public BigDecimal getProCostListSurplus() {
        return proCostListSurplus;
    }

    public void setProCostListSurplus(BigDecimal proCostListSurplus) {
        this.proCostListSurplus = proCostListSurplus;
    }

    public BigDecimal getProTransferSurplus() {
        return proTransferSurplus;
    }

    public void setProTransferSurplus(BigDecimal proTransferSurplus) {
        this.proTransferSurplus = proTransferSurplus;
    }

    public BigDecimal getProRiskMarginSurplus() {
        return proRiskMarginSurplus;
    }

    public void setProRiskMarginSurplus(BigDecimal proRiskMarginSurplus) {
        this.proRiskMarginSurplus = proRiskMarginSurplus;
    }

    public BigDecimal getProLoanBalance() {
        return proLoanBalance;
    }

    public void setProLoanBalance(BigDecimal proLoanBalance) {
        this.proLoanBalance = proLoanBalance;
    }

    public BigDecimal getProLoanInterest() {
        return proLoanInterest;
    }

    public void setProLoanInterest(BigDecimal proLoanInterest) {
        this.proLoanInterest = proLoanInterest;
    }

    public BigDecimal getProOtherFeeDeduct() {
        return proOtherFeeDeduct;
    }

    public void setProOtherFeeDeduct(BigDecimal proOtherFeeDeduct) {
        this.proOtherFeeDeduct = proOtherFeeDeduct;
    }

    public BigDecimal getProOtherFeeBack() {
        return proOtherFeeBack;
    }

    public void setProOtherFeeBack(BigDecimal proOtherFeeBack) {
        this.proOtherFeeBack = proOtherFeeBack;
    }

    public BigDecimal getProSurplusMny() {
        return proSurplusMny;
    }

    public void setProSurplusMny(BigDecimal proSurplusMny) {
        this.proSurplusMny = proSurplusMny;
    }

    public BigDecimal getProSurplusApplyMny() {
        return proSurplusApplyMny;
    }

    public void setProSurplusApplyMny(BigDecimal proSurplusApplyMny) {
        this.proSurplusApplyMny = proSurplusApplyMny;
    }

    public BigDecimal getProPettyCash() {
        return proPettyCash;
    }

    public void setProPettyCash(BigDecimal proPettyCash) {
        this.proPettyCash = proPettyCash;
    }

    public BigDecimal getProManageScale() {
        return proManageScale;
    }

    public void setProManageScale(BigDecimal proManageScale) {
        this.proManageScale = proManageScale;
    }

    public BigDecimal getProManageFee() {
        return proManageFee;
    }

    public void setProManageFee(BigDecimal proManageFee) {
        this.proManageFee = proManageFee;
    }

    public BigDecimal getProAmerce() {
        return proAmerce;
    }

    public void setProAmerce(BigDecimal proAmerce) {
        this.proAmerce = proAmerce;
    }

    public List<PayRecordEntity> getRecordList() {
        return recordList;
    }

    public BigDecimal getEndthisPayScaleByContract() {
        return endthisPayScaleByContract;
    }

    public void setEndthisPayScaleByContract(BigDecimal endthisPayScaleByContract) {
        this.endthisPayScaleByContract = endthisPayScaleByContract;
    }

    public BigDecimal getCollectRatio() {
        return collectRatio;
    }

    public void setCollectRatio(BigDecimal collectRatio) {
        this.collectRatio = collectRatio;
    }

    public BigDecimal getSumCollectMny() {
        return sumCollectMny;
    }

    public void setSumCollectMny(BigDecimal sumCollectMny) {
        this.sumCollectMny = sumCollectMny;
    }

    public BigDecimal getSumProductionTaxMny() {
        return sumProductionTaxMny;
    }

    public void setSumProductionTaxMny(BigDecimal sumProductionTaxMny) {
        this.sumProductionTaxMny = sumProductionTaxMny;
    }

    public BigDecimal getSumApplyMny() {
        return sumApplyMny;
    }

    public void setSumApplyMny(BigDecimal sumApplyMny) {
        this.sumApplyMny = sumApplyMny;
    }

    public String getApplyMnyCn() {
        return applyMnyCn;
    }

    public void setApplyMnyCn(String applyMnyCn) {
        this.applyMnyCn = applyMnyCn;
    }


    public BigDecimal getWaitDeductMny() {
        return waitDeductMny;
    }

    public void setWaitDeductMny(BigDecimal waitDeductMny) {
        this.waitDeductMny = waitDeductMny;
    }

    public void setRecordList(List<PayRecordEntity> recordList) {
        this.recordList = recordList;
    }

    public Long getSubContractTypeId() {
        return subContractTypeId;
    }

    public void setSubContractTypeId(Long subContractTypeId) {
        this.subContractTypeId = subContractTypeId;
    }

    public String getSubContractType() {
        return subContractType;
    }

    public void setSubContractType(String subContractType) {
        this.subContractType = subContractType;
    }

    public String getProjectTypeName() {
        return projectTypeName;
    }

    public void setProjectTypeName(String projectTypeName) {
        this.projectTypeName = projectTypeName;
    }

    public String getDependOnProject() {
        return dependOnProject;
    }

    public void setDependOnProject(String dependOnProject) {
        this.dependOnProject = dependOnProject;
    }

    public String getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(String purchaseType) {
        this.purchaseType = purchaseType;
    }

    public Date getApproveTime() {
        return approveTime;
    }

    public void setApproveTime(Date approveTime) {
        this.approveTime = approveTime;
    }

    public BigDecimal getPayScale() {
        return payScale;
    }

    public void setPayScale(BigDecimal payScale) {
        this.payScale = payScale;
    }

    public BigDecimal getBePayScale() {
        return bePayScale;
    }

    public void setBePayScale(BigDecimal bePayScale) {
        this.bePayScale = bePayScale;
    }

    public BigDecimal getEndthisPayScale() {
        return endthisPayScale;
    }

    public void setEndthisPayScale(BigDecimal endthisPayScale) {
        this.endthisPayScale = endthisPayScale;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Date getConfirmTime() {
        return confirmTime;
    }

    public void setConfirmTime(Date confirmTime) {
        this.confirmTime = confirmTime;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Integer getPayType() {
        return payType;
    }

    public void setPayType(Integer payType) {
        this.payType = payType;
    }

    public Integer getPayStatus() {
        return payStatus;
    }

    public void setPayStatus(Integer payStatus) {
        this.payStatus = payStatus;
    }

    public BigDecimal getPayMny() {
        return payMny;
    }

    public void setPayMny(BigDecimal payMny) {
        this.payMny = payMny;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Long getContractType() {
        return contractType;
    }

    public void setContractType(Long contractType) {
        this.contractType = contractType;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectType() {
        return projectType;
    }

    public void setProjectType(String projectType) {
        this.projectType = projectType;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getFeeType() {
        return feeType;
    }

    public void setFeeType(Long feeType) {
        this.feeType = feeType;
    }

    public String getPayReason() {
        return payReason;
    }

    public void setPayReason(String payReason) {
        this.payReason = payReason;
    }

    public Long getReceiveUnitId() {
        return receiveUnitId;
    }

    public void setReceiveUnitId(Long receiveUnitId) {
        this.receiveUnitId = receiveUnitId;
    }

    public String getReceiveUnitName() {
        return receiveUnitName;
    }

    public void setReceiveUnitName(String receiveUnitName) {
        this.receiveUnitName = receiveUnitName;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getSumSettleMny() {
        return sumSettleMny;
    }

    public void setSumSettleMny(BigDecimal sumSettleMny) {
        this.sumSettleMny = sumSettleMny;
    }

    public BigDecimal getSumPayMny() {
        return sumPayMny;
    }

    public void setSumPayMny(BigDecimal sumPayMny) {
        this.sumPayMny = sumPayMny;
    }

    public BigDecimal getSumInvoiceMny() {
        return sumInvoiceMny;
    }

    public void setSumInvoiceMny(BigDecimal sumInvoiceMny) {
        this.sumInvoiceMny = sumInvoiceMny;
    }

    public Long getApplyUserId() {
        return applyUserId;
    }

    public void setApplyUserId(Long applyUserId) {
        this.applyUserId = applyUserId;
    }

    public String getApplyUserName() {
        return applyUserName;
    }

    public void setApplyUserName(String applyUserName) {
        this.applyUserName = applyUserName;
    }

    public Date getApplyTime() {
        return applyTime;
    }

    public void setApplyTime(Date applyTime) {
        this.applyTime = applyTime;
    }

    public BigDecimal getApplyMny() {
        return applyMny;
    }

    public void setApplyMny(BigDecimal applyMny) {
        this.applyMny = applyMny;
    }

    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getAccountNum() {
        return accountNum;
    }

    public void setAccountNum(String accountNum) {
        this.accountNum = accountNum;
    }

    public String getAccountBank() {
        return accountBank;
    }

    public void setAccountBank(String accountBank) {
        this.accountBank = accountBank;
    }

    public BigDecimal getInvoiceMny() {
        return invoiceMny;
    }

    public void setInvoiceMny(BigDecimal invoiceMny) {
        this.invoiceMny = invoiceMny;
    }

    public String getBackReason() {
        return backReason;
    }

    public void setBackReason(String backReason) {
        this.backReason = backReason;
    }

    public Date getBackTime() {
        return backTime;
    }

    public void setBackTime(Date backTime) {
        this.backTime = backTime;
    }

    public String getInvoiceFlag() {
        return invoiceFlag;
    }

    public void setInvoiceFlag(String invoiceFlag) {
        this.invoiceFlag = invoiceFlag;
    }
}
