/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.finance.bean.PaySporadicEntity;
import com.ejianc.business.finance.service.IPaySporadicOtherService;
import com.ejianc.business.finance.service.IPaySporadicService;
import com.ejianc.business.finance.vo.PayRecordVO;
import com.ejianc.business.finance.vo.PaySporadicVO;
import com.ejianc.business.finance.vo.TotalColumnVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/paySporadic"})
public class PaySporadicController {
    @Autowired
    private IPaySporadicService paySporadicService;
    @Autowired
    private IPaySporadicOtherService paySporadicOtherService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PaySporadicVO> saveOrUpdate(@RequestBody PaySporadicVO paySporadicVO) {
        PaySporadicVO backVO = this.paySporadicService.insertOrUpdate(paySporadicVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)backVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PaySporadicVO> queryDetail(Long id) {
        PaySporadicVO backVO = this.paySporadicService.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)backVO);
    }

    @RequestMapping(value={"/queryPrint"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryPrint(Long id) {
        JSONObject json = new JSONObject();
        json.put("PaySporadic", (Object)this.paySporadicService.queryDetail(id));
        return CommonResponse.success((String)"\u67e5\u8be2\u6253\u5370\u6570\u636e\u6210\u529f\uff01", (Object)json);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        param.getOrderMap().put("createTime", "desc");
        JSONObject page = this.paySporadicService.queryPageJson(param, false);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/queryApproveList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryApproveList(@RequestBody QueryParam param) {
        param.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        param.getOrderMap().put("approveTime", "desc");
        JSONObject page = this.paySporadicService.queryPageJson(param, false);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PaySporadicVO> vos) {
        List<Long> ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        String msg = this.paySporadicService.delete(ids);
        return CommonResponse.success((String)msg);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        List<PaySporadicVO> supplierVos = this.paySporadicService.queryExportList(queryParam);
        supplierVos.forEach(vo -> {
            if (null != vo.getApplyMny()) {
                vo.setUnpaidMny(vo.getApplyMny().subtract(vo.getPayMny() == null ? BigDecimal.ZERO : vo.getPayMny()));
            }
        });
        HashMap<String, List<PaySporadicVO>> beans = new HashMap<String, List<PaySporadicVO>>();
        beans.put("records", supplierVos);
        ExcelExport.getInstance().export("sporadic-payapply-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/queryReceiveInfo"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PaySporadicVO> queryReceiveInfo(Long supplierId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("supplierId", new Parameter("eq", (Object)supplierId));
        queryParam.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        queryParam.getOrderMap().put("createTime", "desc");
        List entityList = this.paySporadicService.queryList(queryParam, false);
        PaySporadicVO backVO = !entityList.isEmpty() ? (PaySporadicVO)BeanMapper.map(entityList.get(0), PaySporadicVO.class) : new PaySporadicVO();
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)backVO);
    }

    @RequestMapping(value={"/pushCost"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PaySporadicVO> pushCost(@RequestBody PaySporadicVO paySporadicVO) {
        return this.paySporadicService.pushCost(paySporadicVO);
    }

    @RequestMapping(value={"getTotalColumnInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<TotalColumnVO> getTotalColumnInfo(@RequestBody QueryParam param) {
        param.getOrderMap().put("createTime", "desc");
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)this.paySporadicService.getTotalColumnInfo(param, false));
    }

    @RequestMapping(value={"getApproveTotalColumnInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<TotalColumnVO> getApproveTotalColumnInfo(@RequestBody QueryParam param) {
        param.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        param.getOrderMap().put("approveTime", "desc");
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)this.paySporadicService.getApproveTotalColumnInfo(param, false));
    }

    @RequestMapping(value={"/updateInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PaySporadicVO> updateInfo(@RequestBody PaySporadicVO vo) {
        PaySporadicEntity entity = (PaySporadicEntity)((Object)BeanMapper.map((Object)vo, PaySporadicEntity.class));
        if (vo.getId() != null && vo.getInvoiceFlag() != null) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)entity.getId());
            updateWrapper.set(PaySporadicEntity::getInvoiceFlag, (Object)entity.getInvoiceFlag());
            this.paySporadicService.update((Wrapper)updateWrapper);
        }
        return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01", (Object)vo);
    }

    @PostMapping(value={"exportPaySporadicOtherList"})
    public void exportPaySporadicOtherList(@RequestBody PaySporadicVO paySporadicVO, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"payapply_id", (Object)paySporadicVO.getId());
        List list = this.paySporadicOtherService.list((Wrapper)queryWrapper);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("sporadic-other-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/closePayRecord"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse closePayRecord(@RequestParam(value="id") Long id) {
        this.paySporadicService.closePayRecord(id);
        return CommonResponse.success((String)"\u4ed8\u6b3e\u5173\u95ed\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/returnPayRecord"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse returnPayRecord(@RequestBody PayRecordVO vo) {
        this.paySporadicService.returnPayRecord(vo);
        return CommonResponse.success((String)"\u4ed8\u6b3e\u5173\u95ed\u6210\u529f\uff01");
    }
}

