package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.accplat.consts.SystemCodeEnum;
import com.ejianc.business.equipment.api.IEquipmentContractApi;
import com.ejianc.business.finance.bean.*;
import com.ejianc.business.finance.mapper.PayRecordMapper;
import com.ejianc.business.finance.service.*;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.finance.util.NoticeEnum;
import com.ejianc.business.finance.vo.*;
import com.ejianc.business.material.api.IMaterialSettlementApi;
import com.ejianc.business.sub.api.ISubContractForPayApi;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.business.voucher.api.IVoucherApi;
import com.ejianc.business.voucher.callable.AccplatVoucherCallable;
import com.ejianc.business.voucher.consts.VoucherOptFlag;
import com.ejianc.business.voucher.utils.DataConvertUtil;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;

/**
 * 付款申请记录实体
 * 
 * @author generator
 * 
 */
@Service("payRecordService")
public class PayRecordServiceImpl extends BaseServiceImpl<PayRecordMapper, PayRecordEntity> implements IPayRecordService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IPayContractService contractService;

    @Autowired
    private IPaySporadicService sporadicService;

    @Autowired
    private IPayReimburseService reimburseService;

    @Autowired
    private IPayForegiftService foregiftService;

    @Autowired
    private ILoadApplyService loadApplyService;

    @Autowired
    private IPayContractSettleService contracctSettleService;

    @Autowired
    private IPayRecordSettleService settleService;

    @Autowired
    private ISubContractForPayApi subApi;

    @Autowired
    private IEquipmentContractApi equipmentApi;

    @Autowired
    private IMaterialSettlementApi materialApi;


    @Autowired
    private PayRecordMessageService payRecordMessageService;

    @Autowired
    private HttpServletRequest request;

    // 是否推送凭证
    private static final String VOUCHER_PARAM = "P-h5UC6769";

    @Autowired
    private IParamConfigApi paramConfigApi;

    @Autowired
    private IVoucherApi voucherApi;

    @Autowired
    private IPayContractDeductionService contractDeductionService;

    @Autowired
    private IDeductionService deductionService;

    @Override
    public PayRecordVO insertOrUpdate(PayRecordVO vo) {
        PayRecordEntity entity = BeanMapper.map(vo, PayRecordEntity.class);
        BigDecimal msgPayMny = BigDecimal.ZERO;
        // 支付记录推送凭证
        VoucherParams voucherParams = null;
        // 扣款单凭证参数
        List<VoucherParams> voucherParams4DedList = new ArrayList<>();
        if("合同付款".equals(vo.getApplyType())){
            PayContractEntity contract = contractService.selectById(entity.getPayapplyId());
            entity.setBillCode(contract.getBillCode());// 单据编号
            entity.setContractId(contract.getContractId());;// 合同
            entity.setContractName(contract.getContractName());
            entity.setContractType(contract.getContractType());// 合同类型
            entity.setProjectId(contract.getProjectId());// 项目
            entity.setProjectName(contract.getProjectName());
            entity.setOrgId(contract.getOrgId());// 组织
            entity.setOrgName(contract.getOrgName());
            entity.setApplyUserId(contract.getApplyUserId());// 申请人
            entity.setApplyUserName(contract.getApplyUserName());
            entity.setApplyTime(contract.getApplyTime());// 申请时间
            entity.setApplyMny(contract.getApplyMny());// 申请金额
            entity.setReceiveUnitId(contract.getReceiveUnitId());// 收款单位
            entity.setReceiveUnitName(contract.getReceiveUnitName());
            entity.setFeeType(contract.getFeeType());;//付款-预付款
            // 保存主表
            boolean b = super.saveOrUpdate(entity);

            // 凭证参数
            if (b) {
                Map<String, Object> recordMap = DataConvertUtil.objToMap(entity);
                PayContractVO payContractVoucherVO = BeanMapper.map(contract, PayContractVO.class);
                // 凭证平台依据此来记录了来源单据id，此处来源单据id应该是支付记录id
                payContractVoucherVO.setId(entity.getId());
                payContractVoucherVO.set_payRecordId(recordMap);

                // 如果是分包类型
                Long contractType = payContractVoucherVO.getContractType();
                if(contractType != null && contractType.intValue() == 1){
                    Map<String, Object> customField = payContractVoucherVO.getCustomField();
                    BigDecimal diaoLanMny = customField != null ? ComputeUtil.toBigDecimal(customField.get("DLFY")) : BigDecimal.ZERO;
                    // 如果是第一次支付，并且吊兰费大于0，收款单位取吊兰供应商
                    if(ComputeUtil.isLessOrEqual(payContractVoucherVO.getPayMny(), BigDecimal.ZERO) && ComputeUtil.isGreaterThan(diaoLanMny, BigDecimal.ZERO)){
                        Long basketSupplierId = payContractVoucherVO.getBasketSupplierId();
                        String basketSupplierName = payContractVoucherVO.getBasketSupplierName();
                        payContractVoucherVO.setReceiveUnitId(basketSupplierId);
                        payContractVoucherVO.setReceiveUnitName(basketSupplierName);
                    }
                }

                voucherParams = VoucherParams.newInstanceByOrgId(PayContractVO.BILL_TYPE_CODE, payContractVoucherVO, SystemCodeEnum.FINANCE);

                QueryWrapper wrapper = new QueryWrapper<PayContractDeductionEntity>();
                wrapper.eq("payapply_id", entity.getPayapplyId());
                List<PayContractDeductionEntity> payContractDeductionEntityList = contractDeductionService.list(wrapper);
                if (CollectionUtils.isNotEmpty(payContractDeductionEntityList)) {
                    List<Long> dedIdList = payContractDeductionEntityList.stream().map(PayContractDeductionEntity::getDeductionId).collect(Collectors.toList());
                    List<DeductionEntity> deductionEntities = (List<DeductionEntity>) deductionService.listByIds(dedIdList);
                    for (int a = 0; a < deductionEntities.size(); a++) {
                        DeductionEntity deductionEntity = deductionEntities.get(a);
                        VoucherParams voucherParamsDed = VoucherParams.newInstanceByOrgId(DeductionVO.BILL_TYPE_CODE, deductionEntity, SystemCodeEnum.FINANCE);
                        voucherParams4DedList.add(voucherParamsDed);
                    }
                }
            }

            contract.setPayStatus(2);// 已支付
            contract.setConfirmTime(entity.getConfirmTime());// 确认时间
            contract.setEmployeeId(entity.getEmployeeId());// 经办人
            contract.setEmployeeName(entity.getEmployeeName());
            contract.setPayMny(MathUtil.safeAdd(contract.getPayMny(), entity.getThisPayMny()));// 累计支付金额
            msgPayMny = contract.getPayMny();
            // 保存
            contractService.saveOrUpdate(contract);

            // 计算结算单支付金额并保存
            List<PayRecordSettleEntity> settleList = this.calculateSettlePayMny(entity);

            // 确认支付回写累计付款与累计预付款金额
            this.writeBackSumPayMny(entity.getPayapplyId(), entity, settleList, true);

        } else if("零星采购".equals(vo.getApplyType())) {
            PaySporadicEntity sporadic = sporadicService.selectById(entity.getPayapplyId());
            entity.setBillCode(sporadic.getBillCode());// 单据编号
            entity.setProjectId(sporadic.getProjectId());// 项目
            entity.setProjectName(sporadic.getProjectName());
            entity.setOrgId(sporadic.getOrgId());// 组织
            entity.setOrgName(sporadic.getOrgName());
            entity.setApplyUserId(sporadic.getApplyUserId());// 申请人
            entity.setApplyUserName(sporadic.getApplyUserName());
            entity.setApplyTime(sporadic.getApplyTime());// 申请时间
            entity.setApplyMny(sporadic.getApplyMny());// 申请金额
            // 保存主表
            super.saveOrUpdate(entity);

            sporadic.setPayStatus(2);// 已支付
            sporadic.setConfirmTime(entity.getConfirmTime());// 确认时间
            sporadic.setEmployeeId(entity.getEmployeeId());// 经办人
            sporadic.setEmployeeName(entity.getEmployeeName());
            sporadic.setPayMny(MathUtil.safeAdd(sporadic.getPayMny(), entity.getThisPayMny()));// 累计支付金额
            msgPayMny = sporadic.getPayMny();
            // 保存
            sporadicService.saveOrUpdate(sporadic);
            // 如果全部支付，则推送成本
            if(MathUtil.safeCompareTo(sporadic.getPayMny(), sporadic.getApplyMny()) >= 0){
                // 设置默认值
                sporadic.setProportionFlag("0");
                sporadic.setRelationFlag("0");
                sporadicService.costPush(sporadic);
            }
        } else if("报销".equals(vo.getApplyType())) {
            PayReimburseEntity reimburse = reimburseService.selectById(entity.getPayapplyId());
            entity.setBillCode(reimburse.getBillCode());// 单据编号
            entity.setProjectId(reimburse.getProjectId());// 项目
            entity.setProjectName(reimburse.getProjectName());
            entity.setOrgId(reimburse.getOrgId());// 组织
            entity.setOrgName(reimburse.getOrgName());
            entity.setApplyUserId(reimburse.getApplyUserId());// 申请人
            entity.setApplyUserName(reimburse.getApplyUserName());
            entity.setApplyTime(reimburse.getApplyTime());// 申请时间
            entity.setApplyMny(reimburse.getApplyMny());// 申请金额
            entity.setFeeType(reimburse.getFeeType());;//付款类型
            // 保存主表
            boolean b = super.saveOrUpdate(entity);

            // 凭证参数
            if (b) {
                Map<String, Object> recordMap = DataConvertUtil.objToMap(entity);
                PayReimburseVO payReimburseVoucherVO = BeanMapper.map(reimburse, PayReimburseVO.class);
                payReimburseVoucherVO.set_payRecordId(recordMap);
                // 凭证平台依据此来记录了来源单据id，此处来源单据id应该是支付记录id
                payReimburseVoucherVO.setId(entity.getId());
                voucherParams = VoucherParams.newInstanceByOrgId(PayReimburseVO.BILL_TYPE_CODE, payReimburseVoucherVO, SystemCodeEnum.FINANCE);
            }

            reimburse.setPayStatus(2);// 已支付
            reimburse.setConfirmTime(entity.getConfirmTime());// 确认时间
            reimburse.setEmployeeId(entity.getEmployeeId());// 经办人
            reimburse.setEmployeeName(entity.getEmployeeName());
            reimburse.setPayMny(MathUtil.safeAdd(reimburse.getPayMny(), entity.getThisPayMny()));// 累计支付金额
            msgPayMny = reimburse.getPayMny();
            // 保存
            reimburseService.saveOrUpdate(reimburse);
            // 如果全部支付，则推送成本
            if(MathUtil.safeCompareTo(reimburse.getPayMny(), reimburse.getApplyMny()) >= 0){
                // 设置默认值
                reimburse.setProportionFlag("0");
                reimburse.setRelationFlag("0");
                reimburseService.costPush(reimburse);
            }


        } else if("押金".equals(vo.getApplyType())) {
            PayForegiftEntity foregift = foregiftService.selectById(entity.getPayapplyId());
            entity.setBillCode(foregift.getBillCode());// 单据编号
            entity.setContractId(foregift.getContractId());;// 合同
            entity.setContractName(foregift.getContractName());
            entity.setContractType(foregift.getContractType());// 合同类型
            entity.setProjectId(foregift.getProjectId());// 项目
            entity.setProjectName(foregift.getProjectName());
            entity.setOrgId(foregift.getOrgId());// 组织
            entity.setOrgName(foregift.getOrgName());
            entity.setApplyUserId(foregift.getApplyUserId());// 申请人
            entity.setApplyUserName(foregift.getApplyUserName());
            entity.setApplyTime(foregift.getApplyTime());// 申请时间
            entity.setApplyMny(foregift.getApplyMny());// 申请金额
            entity.setReceiveUnitId(foregift.getReceiveUnitId());// 收款单位
            entity.setReceiveUnitName(foregift.getReceiveUnitName());
            // 保存主表
            super.saveOrUpdate(entity);

            foregift.setPayStatus(2);// 已支付
            foregift.setConfirmTime(entity.getConfirmTime());// 确认时间
            foregift.setEmployeeId(entity.getEmployeeId());// 经办人
            foregift.setEmployeeName(entity.getEmployeeName());
            foregift.setPayMny(MathUtil.safeAdd(foregift.getPayMny(), entity.getThisPayMny()));// 累计支付金额
            msgPayMny = foregift.getPayMny();
            // 保存
            foregiftService.saveOrUpdate(foregift);
        } else if("备用金".equals(vo.getApplyType())) {
            LoadApplyEntity loadApplyEntity = loadApplyService.selectById(entity.getPayapplyId());
            entity.setBillCode(loadApplyEntity.getBillCode());// 单据编号
            entity.setProjectId(loadApplyEntity.getProjectId());// 项目
            entity.setProjectName(loadApplyEntity.getProjectName());
            entity.setOrgId(loadApplyEntity.getOrgId());// 组织
            entity.setOrgName(loadApplyEntity.getOrgName());
            entity.setApplyUserId(loadApplyEntity.getApplyEmployeeId());// 申请人
            entity.setApplyUserName(loadApplyEntity.getApplyEmployeeName());
            entity.setApplyTime(loadApplyEntity.getApplyTime());// 申请时间
            entity.setApplyMny(loadApplyEntity.getApplyMny());// 申请金额
            // 保存主表
            boolean b = super.saveOrUpdate(entity);
            // 凭证参数
            if (b) {
                Map<String, Object> recordMap = DataConvertUtil.objToMap(entity);
                LoadApplyVO loadApplyVoucherVO = BeanMapper.map(loadApplyEntity, LoadApplyVO.class);
                loadApplyVoucherVO.set_payRecordId(recordMap);
                // 凭证平台依据此来记录了来源单据id，此处来源单据id应该是支付记录id
                loadApplyVoucherVO.setId(entity.getId());
                voucherParams = VoucherParams.newInstanceByOrgId(LoadApplyVO.BILL_TYPE_CODE, loadApplyVoucherVO, SystemCodeEnum.FINANCE);
            }

            loadApplyEntity.setPayStatus(2);// 已支付
            loadApplyEntity.setConfirmTime(entity.getConfirmTime());// 确认时间
            loadApplyEntity.setEmployeeId(entity.getEmployeeId());// 经办人
            loadApplyEntity.setEmployeeName(entity.getEmployeeName());
            loadApplyEntity.setPayMny(MathUtil.safeAdd(loadApplyEntity.getPayMny(), entity.getThisPayMny()));// 累计支付金额
            msgPayMny = loadApplyEntity.getPayMny();
            // 保存
            loadApplyService.saveOrUpdate(loadApplyEntity);
        }
        //支付成功后发送消息给申请人
        PayRecordVO payRecordVO = BeanMapper.map(entity, PayRecordVO.class);
        payRecordVO.setMsgPayMny(msgPayMny);//含本期累计支付金额
        payRecordVO.setMsgBillCode(entity.getBillCode());
        payRecordVO.setMsgId(entity.getId());
        String [] receivers = String.valueOf(payRecordVO.getApplyUserId()).split(",");
        payRecordMessageService.sendMsg(payRecordVO,receivers, NoticeEnum.PAY_SUCCESS);

        if(voucherParams != null){
            // 推送凭证
            CommonResponse<ParamRegisterSetVO> byCode = paramConfigApi.getByCode(VOUCHER_PARAM);
            if (byCode.isSuccess() && null != byCode.getData()) {
                ParamRegisterSetVO paramRegisterSetVO = byCode.getData();
                String valueData = paramRegisterSetVO.getValueData();
                Long projectId = entity.getProjectId();
                if (valueData.equals(String.valueOf(projectId)) || "是".equals(valueData)) {
                    ExecutorService threadPool = Executors.newFixedThreadPool(1 + voucherParams4DedList.size());
                    String authority = request.getHeader("authority");
                    if (authority == null) {
                        logger.info("request-authority为空");
                        authority = (String) InvocationInfoProxy.getExtendAttribute("authority");
                    }
                    try {
                        Callable<CommonResponse> voucherCallable = new AccplatVoucherCallable(voucherApi, this, voucherParams, VoucherOptFlag.SAVE, RequestContextHolder.getRequestAttributes(), authority);
                        threadPool.submit(voucherCallable);
                        for (VoucherParams params : voucherParams4DedList) {
                            Callable<CommonResponse> voucherCallable1 = new AccplatVoucherCallable(voucherApi, deductionService, params, VoucherOptFlag.SAVE, RequestContextHolder.getRequestAttributes(), authority);
                            threadPool.submit(voucherCallable1);
                        }
                    } catch (Exception e) {
                        logger.error(this.getClass() + "推送凭证异常, ", e);
                    } finally {
                        threadPool.shutdown();
                    }
                }
            }
        }
        return payRecordVO;
    }

    /**
     * 计算结算单支付金额并保存
     * @param entity
     */
    private List<PayRecordSettleEntity> calculateSettlePayMny(PayRecordEntity entity) {
        BigDecimal pendPayMny = entity.getThisPayMny();// 待结算单分摊付款金额。初始值为本期支付金额
        List<PayContractSettleEntity> contractSettleList = contracctSettleService.list(new QueryWrapper<PayContractSettleEntity>().eq("payapply_id", entity.getPayapplyId()));
        List<PayRecordSettleEntity> settleLsit = new ArrayList<>();
        for(PayContractSettleEntity contractSettle : contractSettleList){
            BigDecimal surplusPayMny = MathUtil.safeSub(contractSettle.getBodyApplyMny(), contractSettle.getSumPayMny());// 剩余可支付金额
            // 如果有待支付且该结算单有剩余可支付金额
            if(MathUtil.safeCompareTo(pendPayMny, BigDecimal.ZERO) > 0 && MathUtil.safeCompareTo(surplusPayMny, BigDecimal.ZERO) > 0){
                PayRecordSettleEntity settle = new PayRecordSettleEntity();
                settle.setRecordId(entity.getId());
                settle.setPayapplyId(entity.getPayapplyId());
                settle.setSettleId(contractSettle.getSettleId());
                settle.setSettleApplyMny(contractSettle.getBodyApplyMny());
                if(MathUtil.safeCompareTo(pendPayMny, surplusPayMny) > 0){// 待支付大于剩余可支付
                    settle.setSettlePayMny(surplusPayMny);// 支付剩余可支付金额
                } else {
                    settle.setSettlePayMny(pendPayMny);// 支付所有待支付金额
                }
                pendPayMny = MathUtil.safeSub(pendPayMny, settle.getSettlePayMny());// 待支付减去已支付金额
                contractSettle.setSumPayMny(MathUtil.safeAdd(contractSettle.getSumPayMny(), settle.getSettlePayMny()));// 结算单累计已支付金额
                settleLsit.add(settle);
            }
        }
        if(CollectionUtils.isNotEmpty(settleLsit)){
            settleService.saveOrUpdateBatch(settleLsit);
            contracctSettleService.saveOrUpdateBatch(contractSettleList);
        }
        return settleLsit;
    }

    /**
     * 回写合同累计付款、累计预付款金额与结算单累计付款金额
     * @param billId
     * @param entity
     * @param settleList
     * @param flag
     */
    public boolean writeBackSumPayMny(Long billId, PayRecordEntity entity, List<PayRecordSettleEntity> settleList, boolean flag) {
        // 本期付款金额   true为回写，false为逆回写
        BigDecimal payMny = flag ? entity.getThisPayMny() : MathUtil.safeSub(new BigDecimal(0), entity.getThisPayMny());
        // 预付款时等于本期付款金额
        BigDecimal prepayMny = null != entity.getFeeType() && entity.getFeeType() == 1 ? payMny : BigDecimal.ZERO;
//        List<PayRecordSettleEntity> settleList = settleService.list(new QueryWrapper<PayRecordSettleEntity>().eq("record_id", billId));
        // 结算单对应本期申请金额
        Map<Long, BigDecimal> settleMnyMap  = new HashMap<>();
        BigDecimal pendPayMny = payMny;// 待结算单分摊付款金额。初始值为本期支付金额
        for(PayRecordSettleEntity settle : settleList){
            // 本期申请金额   true为回写，false为逆回写
            BigDecimal applyMny = flag ? settle.getSettlePayMny() : MathUtil.safeSub(new BigDecimal(0), settle.getSettlePayMny());
            settleMnyMap.put(settle.getSettleId(), applyMny);
        }
        if(entity.getContractType() == 1){//分包
            subApi.updateSubContractSumPayMny(entity.getContractId(), payMny, prepayMny);//合同
            for(PayRecordSettleEntity settle : settleList){
                subApi.updateSubSettleSumPayMny(settle.getSettleId(), settleMnyMap.get(settle.getSettleId()));//结算单
            }
        }
        if(entity.getContractType() == 2){//设备采购
            equipmentApi.updatePurchaseContractSumPayMny(entity.getContractId(), payMny, prepayMny);//合同
            for(PayRecordSettleEntity settle : settleList){
                equipmentApi.updatePurchaseSettleSumPayMny(settle.getSettleId(), settleMnyMap.get(settle.getSettleId()));//结算单
            }
        }
        if(entity.getContractType() == 3){//设备租赁
            equipmentApi.updateRentContractSumPayMny(entity.getContractId(), payMny, prepayMny);//合同
            for(PayRecordSettleEntity settle : settleList){
                equipmentApi.updateRentSettleSumPayMny(settle.getSettleId(), settleMnyMap.get(settle.getSettleId()));//结算单
            }
        }
        if(entity.getContractType() == 4){//物资采购
            for(PayRecordSettleEntity settle : settleList){
                materialApi.updateSettlementBillAlreadyPaidAmount(settle.getSettleId(), settleMnyMap.get(settle.getSettleId()));//结算单
            }
        }
        if(entity.getContractType() == 5){//物资租赁
            //TODO
        }
        return true;
    }


    /**
     * 付款退回
     *
     * @param vo 付款申请记录
     *
     * @return {@link PayRecordVO}
     */
    @Override
    public PayRecordVO returnPayment(PayRecordVO vo) {
        BigDecimal msgPayMny = BigDecimal.ZERO;
        PayRecordEntity entity = BeanMapper.map(vo, PayRecordEntity.class);

        // 支付记录推送凭证
        VoucherParams voucherParams = null;
        if ("合同付款".equals(vo.getApplyType())) {
            // 增加一个负数的付款记录单；
            entity.setThisPayMny(entity.getThisPayMny().negate());
            PayContractEntity contract = contractService.selectById(entity.getPayapplyId());
            entity.setBillCode(contract.getBillCode());// 单据编号
            entity.setContractId(contract.getContractId());// 合同
            entity.setContractName(contract.getContractName());
            entity.setContractType(contract.getContractType());// 合同类型
            entity.setProjectId(contract.getProjectId());// 项目
            entity.setProjectName(contract.getProjectName());
            entity.setOrgId(contract.getOrgId());// 组织
            entity.setOrgName(contract.getOrgName());
            entity.setApplyUserId(contract.getApplyUserId());// 申请人
            entity.setApplyUserName(contract.getApplyUserName());
            entity.setApplyTime(contract.getApplyTime());// 申请时间
            entity.setApplyMny(contract.getApplyMny());// 申请金额
            entity.setReceiveUnitId(contract.getReceiveUnitId());// 收款单位
            entity.setReceiveUnitName(contract.getReceiveUnitName());
            entity.setFeeType(contract.getFeeType());//付款-预付款
            boolean b = super.saveOrUpdate(entity);

            // 退回后回写合同付款申请单
            contract.setPayStatus(2);// 已支付
            contract.setConfirmTime(entity.getConfirmTime());// 确认时间
            contract.setEmployeeId(entity.getEmployeeId());// 经办人
            contract.setEmployeeName(entity.getEmployeeName());
            // 【已付款金额】修改为【已付款金额】-【退回金额】 即：【已付款金额】=【已付款金额】+ （-【退回金额】）
            contract.setPayMny(MathUtil.safeAdd(contract.getPayMny(), entity.getThisPayMny()));// 累计支付金额
            msgPayMny = contract.getPayMny();

            contractService.saveOrUpdate(contract);

            // 付款退回修改表体每个结算单的【本期支付金额】：按照结算单时间，后进先出进行回退重新分摊
            List<PayRecordSettleEntity> settleList = this.calcSettlePayMnyAfterReturnPayment(entity);

            // 确认支付回写累计付款与累计预付款金额
            this.writeBackSumPayMnyAfterReturnPayment(entity, settleList);

            // 付款关闭
            if (vo.getClosed()) {
                contractService.closePayment(vo.getPayapplyId());
            }

            if (b) {
                Map<String, Object> recordMap = DataConvertUtil.objToMap(entity);
                PayContractVO payContractVoucherVO = BeanMapper.map(contract, PayContractVO.class);
                // 凭证平台依据此来记录了来源单据id，此处来源单据id应该是支付记录id
                payContractVoucherVO.setId(entity.getId());
                payContractVoucherVO.set_payRecordId(recordMap);
                voucherParams = VoucherParams.newInstanceByOrgId(PayContractVO.BILL_TYPE_CODE, payContractVoucherVO, "付款退回", SystemCodeEnum.FINANCE);
            }
        }


        if(voucherParams != null){
            // 推送凭证
            CommonResponse<ParamRegisterSetVO> byCode = paramConfigApi.getByCode(VOUCHER_PARAM);
            if (byCode.isSuccess() && null != byCode.getData()) {
                ParamRegisterSetVO paramRegisterSetVO = byCode.getData();
                String valueData = paramRegisterSetVO.getValueData();
                Long projectId = entity.getProjectId();
                if (valueData.equals(String.valueOf(projectId)) || "是".equals(valueData)) {
                    ExecutorService threadPool = Executors.newFixedThreadPool(1);
                    String authority = request.getHeader("authority");
                    if (authority == null) {
                        logger.info("request-authority为空");
                        authority = (String) InvocationInfoProxy.getExtendAttribute("authority");
                    }
                    try {
                        Callable<CommonResponse> voucherCallable = new AccplatVoucherCallable(voucherApi, this, voucherParams, VoucherOptFlag.SAVE, RequestContextHolder.getRequestAttributes(), authority);
                        threadPool.submit(voucherCallable);
                    } catch (Exception e) {
                        logger.error(this.getClass() + "推送凭证异常, ", e);
                    } finally {
                        threadPool.shutdown();
                    }
                }
            }
        }
        //支付成功后发送消息给申请人
        PayRecordVO payRecordVO = BeanMapper.map(entity, PayRecordVO.class);

        return payRecordVO;
    }

    /**
     * 付款退回后重新分摊
     *
     * @param entity 付款申请记录
     *
     * @return {@link List}<{@link PayRecordSettleEntity}>
     */
    private List<PayRecordSettleEntity> calcSettlePayMnyAfterReturnPayment(PayRecordEntity entity) {
        List<PayRecordSettleEntity> settleLsit = new ArrayList<>();
        BigDecimal pendPayMny = entity.getThisPayMny().negate();// 待结算单分摊付款金额。初始值为本期支付金额
        // 按照结算单时间，后进先出进行回退
        List<PayContractSettleEntity> contractSettleList = contracctSettleService.list(new LambdaQueryWrapper<PayContractSettleEntity>()
                .eq(PayContractSettleEntity::getPayapplyId, entity.getPayapplyId())
                .orderByDesc(PayContractSettleEntity::getCreateTime));

        for (PayContractSettleEntity contractSettle : contractSettleList) {
            if (MathUtil.safeCompareTo(pendPayMny, BigDecimal.ZERO) > 0) {
                PayRecordSettleEntity settle = new PayRecordSettleEntity();
                settle.setRecordId(entity.getId());
                settle.setPayapplyId(entity.getPayapplyId());
                settle.setSettleId(contractSettle.getSettleId());
                settle.setSettleApplyMny(contractSettle.getBodyApplyMny());
                // 够摊
                if (MathUtil.safeCompareTo(contractSettle.getSumPayMny(), pendPayMny) >= 0) {
                    settle.setReturnPayMny(pendPayMny);
                    contractSettle.setSumPayMny(MathUtil.safeSub(contractSettle.getSumPayMny(), pendPayMny));
                    pendPayMny = BigDecimal.ZERO;
                } else {
                    settle.setReturnPayMny(contractSettle.getSumPayMny());
                    pendPayMny = MathUtil.safeSub(pendPayMny, contractSettle.getSumPayMny());// 待支付减去已支付金额
                    contractSettle.setSumPayMny(BigDecimal.ZERO);
                }
                settle.setSettlePayMny(contractSettle.getSumPayMny());
                settleLsit.add(settle);
            }
        }
        if (CollectionUtils.isNotEmpty(settleLsit)) {
            settleService.saveOrUpdateBatch(settleLsit);
            contracctSettleService.saveOrUpdateBatch(contractSettleList);
        }
        return settleLsit;
    }


    /**
     * 回写合同累计付款、累计预付款金额与结算单累计付款金额
     * @param entity
     * @param settleList
     */
    public boolean writeBackSumPayMnyAfterReturnPayment(PayRecordEntity entity, List<PayRecordSettleEntity> settleList) {
        BigDecimal payMny = entity.getThisPayMny();
        BigDecimal prepayMny = null != entity.getFeeType() && entity.getFeeType() == 1 ? payMny : BigDecimal.ZERO;
        Map<Long, BigDecimal> settleMnyMap = new HashMap<>();
        BigDecimal pendPayMny = payMny;// 待结算单分摊付款金额。初始值为本期支付金额
        for (PayRecordSettleEntity settle : settleList) {
            settleMnyMap.put(settle.getSettleId(), settle.getReturnPayMny().negate());
        }
        if (entity.getContractType() == 1) {//分包
            subApi.updateSubContractSumPayMny(entity.getContractId(), payMny, prepayMny);//合同
            for (PayRecordSettleEntity settle : settleList) {
                subApi.updateSubSettleSumPayMny(settle.getSettleId(), settleMnyMap.get(settle.getSettleId()));//结算单
            }
        }
        if (entity.getContractType() == 2) {//设备采购
            equipmentApi.updatePurchaseContractSumPayMny(entity.getContractId(), payMny, prepayMny);//合同
            for (PayRecordSettleEntity settle : settleList) {
                equipmentApi.updatePurchaseSettleSumPayMny(settle.getSettleId(), settleMnyMap.get(settle.getSettleId()));//结算单
            }
        }
        if (entity.getContractType() == 3) {//设备租赁
            equipmentApi.updateRentContractSumPayMny(entity.getContractId(), payMny, prepayMny);//合同
            for (PayRecordSettleEntity settle : settleList) {
                equipmentApi.updateRentSettleSumPayMny(settle.getSettleId(), settleMnyMap.get(settle.getSettleId()));//结算单
            }
        }
        if (entity.getContractType() == 4) {//物资采购
            for (PayRecordSettleEntity settle : settleList) {
                materialApi.updateSettlementBillAlreadyPaidAmount(settle.getSettleId(), settleMnyMap.get(settle.getSettleId()));//结算单
            }
        }
        return true;
    }
    
}
