package com.ejianc.business.finance.bean;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 借款报销发票信息
 * 
 * @author generator
 * 
 */
 @TableName("ejc_finance_load_invoice")
public class LoadInvoiceEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="reimburse_id")
    private java.lang.Long reimburseId; // 报销单主键
    @TableField(value="invoice_id")
    private java.lang.Long invoiceId; // 来源发票主键
    @TableField(value="invoice_number")
    private java.lang.String invoiceNumber; // 发票号码
    @TableField(value="invoice_code")
    private java.lang.String invoiceCode; // 发票代码
    @TableField(value="invoice_mny")
    private java.math.BigDecimal invoiceMny; // 发票金额
    @TableField(value="tax_mny")
    private java.math.BigDecimal taxMny; // 税金
    @TableField(value="invoice_tax_mny")
    private java.math.BigDecimal invoiceTaxMny; // 价税合计
    @TableField(value="invoice_date")
    private java.util.Date invoiceDate; // 开票日期
    @TableField(value="create_user_name")
    private java.lang.String createUserName; // 创建者名称
    @TableField(value="use_flag")
    private java.lang.Integer useFlag; // 是否占用：1 未占用， 2 已占用

    /**
     * 本期发票金额
     */
    @TableField("used_invoice_tax_mny")
    private BigDecimal usedInvoiceTaxMny;

    /**
     * 剩余发票金额
     */
    @TableField("surplus_invoice_tax_mny")
    private BigDecimal surplusInvoiceTaxMny;

    public BigDecimal getUsedInvoiceTaxMny() {
        return usedInvoiceTaxMny;
    }

    public void setUsedInvoiceTaxMny(BigDecimal usedInvoiceTaxMny) {
        this.usedInvoiceTaxMny = usedInvoiceTaxMny;
    }

    public BigDecimal getSurplusInvoiceTaxMny() {
        return surplusInvoiceTaxMny;
    }

    public void setSurplusInvoiceTaxMny(BigDecimal surplusInvoiceTaxMny) {
        this.surplusInvoiceTaxMny = surplusInvoiceTaxMny;
    }

    public Long getReimburseId() {
        return reimburseId;
    }

    public void setReimburseId(Long reimburseId) {
        this.reimburseId = reimburseId;
    }

    public Long getInvoiceId() {
        return invoiceId;
    }

    public void setInvoiceId(Long invoiceId) {
        this.invoiceId = invoiceId;
    }

    public String getInvoiceNumber() {
        return invoiceNumber;
    }

    public void setInvoiceNumber(String invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
    }

    public String getInvoiceCode() {
        return invoiceCode;
    }

    public void setInvoiceCode(String invoiceCode) {
        this.invoiceCode = invoiceCode;
    }

    public BigDecimal getInvoiceMny() {
        return invoiceMny;
    }

    public void setInvoiceMny(BigDecimal invoiceMny) {
        this.invoiceMny = invoiceMny;
    }

    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    public BigDecimal getInvoiceTaxMny() {
        return invoiceTaxMny;
    }

    public void setInvoiceTaxMny(BigDecimal invoiceTaxMny) {
        this.invoiceTaxMny = invoiceTaxMny;
    }

    public Date getInvoiceDate() {
        return invoiceDate;
    }

    public void setInvoiceDate(Date invoiceDate) {
        this.invoiceDate = invoiceDate;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public Integer getUseFlag() {
        return useFlag;
    }

    public void setUseFlag(Integer useFlag) {
        this.useFlag = useFlag;
    }
}
