/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.bean.BidBondEntity;
import com.ejianc.business.finance.service.IBidBondService;
import com.ejianc.business.finance.vo.BidBondReportVO;
import com.ejianc.business.finance.vo.BidBondVO;
import com.ejianc.business.finance.vo.BondUpVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"bidBond"})
public class BidBondController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "FINANCE_BID_BOND";
    @Autowired
    private IBidBondService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BidBondVO> saveOrUpdate(@RequestBody BidBondVO saveOrUpdateVO) {
        if (StringUtils.isNotBlank((CharSequence)saveOrUpdateVO.getBillCode())) {
            BidBondVO voByCode = this.service.queryByCode(saveOrUpdateVO.getBillCode());
            if (!(null == voByCode || null != saveOrUpdateVO.getId() && voByCode.getId().equals(saveOrUpdateVO.getId()))) {
                return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u7f16\u7801\u91cd\u590d\uff01");
            }
        } else {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                saveOrUpdateVO.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        BidBondEntity entity = (BidBondEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, BidBondEntity.class));
        entity.setBondStatus("0");
        this.service.saveOrUpdate((Object)entity, false);
        BidBondVO vo = (BidBondVO)BeanMapper.map((Object)((Object)entity), BidBondVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BidBondVO> queryDetail(Long id) {
        BidBondEntity entity = (BidBondEntity)((Object)this.service.selectById(id));
        BidBondVO vo = (BidBondVO)BeanMapper.map((Object)((Object)entity), BidBondVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryReceiveInfo"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BidBondVO> queryReceiveInfo(QueryParam queryParam) {
        queryParam.getParams().put("applyEmployeeId", new Parameter("eq", (Object)InvocationInfoProxy.getEmployeeId()));
        queryParam.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        queryParam.getOrderMap().put("createTime", "desc");
        List entityList = this.service.queryList(queryParam, false);
        BidBondVO backVO = !entityList.isEmpty() ? (BidBondVO)BeanMapper.map(entityList.get(0), BidBondVO.class) : new BidBondVO();
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)backVO);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BidBondVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (BidBondVO bidBondVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("opportunityName");
        fuzzyFields.add("applyEmployeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        ArrayList commonOrgIds = new ArrayList();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgListResp = this.iOrgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            return CommonResponse.success((String)"\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        Parameter aa = (Parameter)param.getParams().get("backType");
        Parameter bb = (Parameter)param.getParams().get("payType");
        param.getParams().remove("backType");
        param.getParams().remove("payType");
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        if (null != aa && "1".equals(aa.getValue())) {
            wrapper.apply("IFNULL(back_mny,0) = IFNULL(apply_mny,0)", new Object[0]);
        } else if (null != aa && "2".equals(aa.getValue())) {
            wrapper.apply("IFNULL(back_mny,0) < IFNULL(apply_mny,0)", new Object[0]);
        }
        if (null != bb && "1".equals(bb.getValue())) {
            wrapper.apply("IFNULL(pay_mny,0) <= 0", new Object[0]);
        } else if (null != bb && "2".equals(bb.getValue())) {
            wrapper.apply("IFNULL(pay_mny,0) > 0", new Object[0]);
        }
        IPage<BidBondEntity> pageData = this.service.selectPage((Page<BidBondEntity>)page, wrapper);
        JSONObject res = new JSONObject();
        res.put("records", (Object)BeanMapper.mapList((Iterable)pageData.getRecords(), BidBondVO.class));
        res.put("total", (Object)pageData.getTotal());
        res.put("current", (Object)pageData.getCurrent());
        res.put("size", (Object)pageData.getSize());
        res.put("pages", (Object)pageData.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    @RequestMapping(value={"/queryListManage"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryListManage(@RequestBody QueryParam param) {
        List list = new ArrayList();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("opportunityName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("bondStatus", new Parameter("eq", (Object)"1"));
        ArrayList commonOrgIds = new ArrayList();
        ArrayList<Integer> billstate = new ArrayList<Integer>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgListResp = this.iOrgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            return CommonResponse.success((String)"\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        }
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("bill_state", new Parameter("in", billstate));
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        Parameter backType = (Parameter)param.getParams().get("backType");
        Parameter bondState = (Parameter)param.getParams().get("bondState");
        param.getParams().remove("backType");
        param.getParams().remove("bondState");
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        if (null != backType && "1".equals(backType.getValue())) {
            wrapper.apply("IFNULL(back_mny,0) = IFNULL(apply_mny,0)", new Object[0]);
        } else if (null != backType && "2".equals(backType.getValue())) {
            wrapper.apply("IFNULL(back_mny,0) < IFNULL(apply_mny,0)", new Object[0]);
        }
        if (null != bondState && "1".equals(bondState.getValue())) {
            wrapper.apply("CURRENT_DATE() <= end_date", new Object[0]);
        } else if (null != bondState && "2".equals(bondState.getValue())) {
            wrapper.apply("CURRENT_DATE() > end_date", new Object[0]);
        }
        IPage<BidBondEntity> pageData = this.service.selectPage((Page<BidBondEntity>)page, wrapper);
        if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            list = BeanMapper.mapList((Iterable)pageData.getRecords(), BidBondVO.class);
            list.forEach(vo -> {
                if (new Date().after(vo.getEndDate())) {
                    vo.setDealStatus("\u5df2\u5230\u671f");
                } else {
                    vo.setDealStatus("\u6709\u6548");
                }
            });
        }
        JSONObject res = new JSONObject();
        res.put("records", list);
        res.put("total", (Object)pageData.getTotal());
        res.put("current", (Object)pageData.getCurrent());
        res.put("size", (Object)pageData.getSize());
        res.put("pages", (Object)pageData.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    @RequestMapping(value={"/queryDealList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryDealList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("opportunityName");
        fuzzyFields.add("applyEmployeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        ArrayList commonOrgIds = new ArrayList();
        ArrayList<Integer> billstate = new ArrayList<Integer>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgListResp = this.iOrgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            return CommonResponse.success((String)"\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        }
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("bill_state", new Parameter("in", billstate));
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<BidBondVO> list = this.service.queryDealList((Page<BidBondVO>)page, wrapper);
        JSONObject res = new JSONObject();
        res.put("records", list);
        res.put("total", (Object)page.getTotal());
        res.put("current", (Object)page.getCurrent());
        res.put("size", (Object)page.getSize());
        res.put("pages", (Object)page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    @RequestMapping(value={"/queryBondMny"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BidBondReportVO> queryBondMny(@RequestBody QueryParam param) {
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        ArrayList commonOrgIds = new ArrayList();
        ArrayList<Integer> billstate = new ArrayList<Integer>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgListResp = this.iOrgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            return CommonResponse.success((String)"\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        }
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("bill_state", new Parameter("in", billstate));
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        BidBondReportVO reportVO = this.service.queryBondReport(wrapper);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)reportVO);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List list = new ArrayList();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("customerName");
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        ArrayList commonOrgIds = new ArrayList();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgListResp = this.iOrgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            throw new BusinessException("\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        Parameter aa = (Parameter)param.getParams().get("backType");
        Parameter bb = (Parameter)param.getParams().get("payType");
        param.getParams().remove("backType");
        param.getParams().remove("payType");
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        if (null != aa && "1".equals(aa.getValue())) {
            wrapper.apply("IFNULL(back_mny,0) = IFNULL(apply_mny,0)", new Object[0]);
        } else if (null != aa && "2".equals(aa.getValue())) {
            wrapper.apply("IFNULL(back_mny,0) < IFNULL(apply_mny,0)", new Object[0]);
        }
        if (null != bb && "1".equals(bb.getValue())) {
            wrapper.apply("IFNULL(pay_mny,0) <= 0", new Object[0]);
        } else if (null != bb && "2".equals(bb.getValue())) {
            wrapper.apply("IFNULL(pay_mny,0) > 0", new Object[0]);
        }
        IPage<BidBondEntity> pageData = this.service.selectPage((Page<BidBondEntity>)page, wrapper);
        if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            list = BeanMapper.mapList((Iterable)pageData.getRecords(), BidBondVO.class);
        }
        list.forEach(vo -> {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            if (new Date().after(vo.getEndDate())) {
                vo.setDealStatus("\u5df2\u5230\u671f");
            } else {
                vo.setDealStatus("\u6709\u6548");
            }
        });
        HashMap beans = new HashMap();
        beans.put("records", list);
        ExcelExport.getInstance().export("bidBondExport.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExports"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExports(@RequestBody QueryParam param, HttpServletResponse response) {
        List list = new ArrayList();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("customerName");
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("bondStatus", new Parameter("eq", (Object)"1"));
        ArrayList commonOrgIds = new ArrayList();
        ArrayList<Integer> billstate = new ArrayList<Integer>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgListResp = this.iOrgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            throw new BusinessException("\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        }
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("bill_state", new Parameter("in", billstate));
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        Parameter backType = (Parameter)param.getParams().get("backType");
        Parameter bondState = (Parameter)param.getParams().get("bondState");
        param.getParams().remove("backType");
        param.getParams().remove("bondState");
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        if (null != backType && "1".equals(backType.getValue())) {
            wrapper.apply("IFNULL(back_mny,0) = IFNULL(apply_mny,0)", new Object[0]);
        } else if (null != backType && "2".equals(backType.getValue())) {
            wrapper.apply("IFNULL(back_mny,0) < IFNULL(apply_mny,0)", new Object[0]);
        }
        if (null != bondState && "1".equals(bondState.getValue())) {
            wrapper.apply("CURRENT_DATE() <= end_date", new Object[0]);
        } else if (null != bondState && "2".equals(bondState.getValue())) {
            wrapper.apply("CURRENT_DATE() > end_date", new Object[0]);
        }
        IPage<BidBondEntity> pageData = this.service.selectPage((Page<BidBondEntity>)page, wrapper);
        if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            list = BeanMapper.mapList((Iterable)pageData.getRecords(), BondUpVO.class);
        }
        list.forEach(vo -> {
            if (new Date().after(vo.getEndDate())) {
                vo.setDealStatus("\u5df2\u5230\u671f");
            } else {
                vo.setDealStatus("\u6709\u6548");
            }
        });
        HashMap beans = new HashMap();
        beans.put("records", list);
        ExcelExport.getInstance().export("bidBondManageExport.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportUn"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportsUn(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("customerName");
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        ArrayList commonOrgIds = new ArrayList();
        ArrayList<Integer> billstate = new ArrayList<Integer>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgListResp = this.iOrgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            throw new BusinessException("\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        }
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("bill_state", new Parameter("in", billstate));
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<BidBondVO> list = this.service.queryDealList((Page<BidBondVO>)page, wrapper);
        List listExport = new ArrayList();
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(vo -> vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription()));
            listExport = BeanMapper.mapList(list, BidBondVO.class);
        }
        HashMap beans = new HashMap();
        beans.put("records", listExport);
        ExcelExport.getInstance().export("bidBondUnManageExport.xlsx", beans, response);
    }
}

