package com.ejianc.business.finance.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 *
 * </p>
 *
 * @author yqls
 * @since 2020-06-05
 */
@TableName("ejc_finance_pay_reimburse")
public class PayReimburseEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 单据编号
     */
    @TableField("bill_code")
    private String billCode;

    /**
     * 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
     */
    @TableField("bill_state")
    private Integer billState;

    /**
     * 备注
     */
    @TableField("memo")
    private String memo;

    /**
     * 经办人
     */
    @TableField("employee_id")
    private Long employeeId;

    /**
     * 经办人名称
     */
    @TableField("employee_name")
    private String employeeName;

    /**
     * 经办时间
     */
    @TableField("confirm_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date confirmTime;

    /**
     * 付款类型：1-组织付款，2- 项目付款
     */
    @TableField("pay_type")
    private Integer payType;

    /**
     * 支付状态：1-未支付，2-已支付
     */
    @TableField("pay_status")
    private Integer payStatus;

    /**
     * 项目
     */
    @TableField("project_id")
    private Long projectId;

    /**
     * 项目名称
     */
    @TableField("project_name")
    private String projectName;

    /**
     * 组织
     */
    @TableField("org_id")
    private Long orgId;

    /**
     * 组织名称
     */
    @TableField("org_name")
    private String orgName;

    /**
     * 费用类型
     */
    @TableField("fee_type")
    private Long feeType;

    /**
     * 费用承担部门id
     */
    @TableField("bear_dept_id")
    private Long bearDeptId;
    /**
     * 费用承担部门
     */
    @TableField("bear_dept")
    private String bearDept;

    /**
     * 付款单位
     */
    @TableField("pay_unit_id")
    private Long payUnitId;

    /**
     * 付款单位名称
     */
    @TableField("pay_unit_name")
    private String payUnitName;

    /**
     * 付款事由
     */
    @TableField("pay_reason")
    private String payReason;

    /**
     * 申请人
     */
    @TableField("apply_user_id")
    private Long applyUserId;

    /**
     * 申请人名称
     */
    @TableField("apply_user_name")
    private String applyUserName;

    /**
     * 申请时间
     */
    @TableField("apply_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date applyTime;

    /**
     * 申请金额
     */
    @TableField("apply_mny")
    private BigDecimal applyMny;

    /**
     * 支付金额
     */
    @TableField("pay_mny")
    private BigDecimal payMny;

    /**
     * 发票金额
     */
    @TableField("invoice_mny")
    private BigDecimal invoiceMny;

    /**
     * 账户名称
     */
    @TableField("account_name")
    private String accountName;

    /**
     * 银行账号
     */
    @TableField("account_num")
    private String accountNum;

    /**
     * 开户行
     */
    @TableField("account_bank")
    private String accountBank;

    /**
     * 撤回原因
     */
    @TableField("back_reason")
    private String backReason;

    /**
     * 撤回时间
     */
    @TableField("back_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date backTime;

    /**
     * 审批时间
     */
    @TableField("approve_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date approveTime;

    /**
     * 属于项目:1-是，0-否
     */
    @TableField("depend_on_project")
    private String dependOnProject;

    /**
     * 成本科目主键
     */
    @TableField(value = "subject_id")
    private Long subjectId;
    /**
     * 成本科目名称
     */
    @TableField("subject_name")
    private String subjectName;
    /**
     * 关联状态(1:是，0：否)
     */
    @TableField("relation_flag")
    private String relationFlag;
    /**
     * 分摊状态(1:是，0：否)
     */
    @TableField("proportion_flag")
    private String proportionFlag;

    @TableField(value="reimburse_mmy")
    private BigDecimal reimburseMmy; // 报销费用（报销费用=付款申请中的报销费用+备用金报销）
    @TableField(value="manage_mmy")
    private BigDecimal manageMmy; //  管理费(预算中的管理费)
    @TableField(value="cumulative_mny")
    private BigDecimal cumulativeMny; //  累计报销

    @TableField(value="is_share_flag")
    private Integer isShareFlag; // 是否项目分摊：0否，1是

    /**
     * 是否需要发票：1 需要，2 不需要，3 不确定
     */
    private String invoiceFlag;

    @TableField(value="org_code")
    private String orgCode; // 组织编码

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    /**
     *************start************************项目资金改造***************************start*******************************
     */

    @TableField(value="pro_contract_mny")
    private BigDecimal proContractMny; // 收入合同金额
    @TableField(value="pro_output_mny")
    private BigDecimal proOutputMny; // 完成产值
    @TableField(value="pro_date_progress")
    private BigDecimal proDateProgress; // 日期进度
    @TableField(value="pro_output_progress")
    private BigDecimal proOutputProgress; // 产值进度
    @TableField(value="pro_contract_receive_mny")
    private BigDecimal proContractReceiveMny; // 合同累计收款金额
    @TableField(value="pro_receive_mny")
    private BigDecimal proReceiveMny; // 累计收款
    @TableField(value="pro_pay_mny")
    private BigDecimal proPayMny; // 累计付款
    @TableField(value="pro_cost_list_surplus")
    private BigDecimal proCostListSurplus; // 费用清单结余
    @TableField(value="pro_transfer_surplus")
    private BigDecimal proTransferSurplus; // 项目代转款款结余
    @TableField(value="pro_risk_margin_surplus")
    private BigDecimal proRiskMarginSurplus; // 风险保证金结余
    @TableField(value="pro_loan_balance")
    private BigDecimal proLoanBalance; // 借款结余
    @TableField(value="pro_loan_interest")
    private BigDecimal proLoanInterest; // 借款利息
    @TableField(value="pro_other_fee_deduct")
    private BigDecimal proOtherFeeDeduct; // 其他费用扣除
    @TableField(value="pro_other_fee_back")
    private BigDecimal proOtherFeeBack; // 其他费用退还
    @TableField(value="pro_surplus_mny")
    private BigDecimal proSurplusMny; // 项目可用资金
    @TableField(value="pro_surplus_apply_mny")
    private BigDecimal proSurplusApplyMny; // 剩余可申请金额release
    @TableField(value="pro_petty_cash")
    private BigDecimal proPettyCash; // 备用金结余
    @TableField(value="pro_manage_scale")
    private BigDecimal proManageScale; // 管理费比例
    @TableField(value="pro_manage_fee")
    private BigDecimal proManageFee; // 管理费
    @TableField(value="pro_amerce")
    private BigDecimal proAmerce; // 罚款

    @TableField(value="pro_apply_unpay_mny")
    private BigDecimal proApplyUnpayMny; // 已申请未支付金额

    /**
     * 申请金额大写
     */
    @TableField("apply_mny_cn")
    private String applyMnyCn;

    /**
     * 累计分摊金额
     */
    @TableField("count_share_mny")
    private BigDecimal countShareMny;

    /**
     * 关闭前的本期申请金额
     */
    @TableField("apply_mny_before_close")
    private BigDecimal applyMnyBeforeClose;

    /**
     * 关闭状态
     */
    @TableField("close_state")
    private String closeState;

    /**
     * 关闭时间
     */
    @TableField("close_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date closeTime;

    /**
     * 关闭人
     */
    @TableField("close_user")
    private String closeUser;

    /**
     * 是否关闭
     */
    @TableField("close_flag")
    private Boolean closeFlag;

    public BigDecimal getApplyMnyBeforeClose() {
        return applyMnyBeforeClose;
    }

    public void setApplyMnyBeforeClose(BigDecimal applyMnyBeforeClose) {
        this.applyMnyBeforeClose = applyMnyBeforeClose;
    }

    public String getCloseState() {
        return closeState;
    }

    public void setCloseState(String closeState) {
        this.closeState = closeState;
    }

    public Date getCloseTime() {
        return closeTime;
    }

    public void setCloseTime(Date closeTime) {
        this.closeTime = closeTime;
    }

    public String getCloseUser() {
        return closeUser;
    }

    public void setCloseUser(String closeUser) {
        this.closeUser = closeUser;
    }

    public Boolean getCloseFlag() {
        return closeFlag;
    }

    public void setCloseFlag(Boolean closeFlag) {
        this.closeFlag = closeFlag;
    }

    public String getApplyMnyCn() {
        return applyMnyCn;
    }

    public void setApplyMnyCn(String applyMnyCn) {
        this.applyMnyCn = applyMnyCn;
    }
    public BigDecimal getProApplyUnpayMny() {
        return proApplyUnpayMny;
    }

    public void setProApplyUnpayMny(BigDecimal proApplyUnpayMny) {
        this.proApplyUnpayMny = proApplyUnpayMny;
    }
    public BigDecimal getProContractMny() {
        return proContractMny;
    }

    public void setProContractMny(BigDecimal proContractMny) {
        this.proContractMny = proContractMny;
    }

    public BigDecimal getProOutputMny() {
        return proOutputMny;
    }

    public void setProOutputMny(BigDecimal proOutputMny) {
        this.proOutputMny = proOutputMny;
    }

    public BigDecimal getProDateProgress() {
        return proDateProgress;
    }

    public void setProDateProgress(BigDecimal proDateProgress) {
        this.proDateProgress = proDateProgress;
    }

    public BigDecimal getProOutputProgress() {
        return proOutputProgress;
    }

    public void setProOutputProgress(BigDecimal proOutputProgress) {
        this.proOutputProgress = proOutputProgress;
    }

    public BigDecimal getProContractReceiveMny() {
        return proContractReceiveMny;
    }

    public void setProContractReceiveMny(BigDecimal proContractReceiveMny) {
        this.proContractReceiveMny = proContractReceiveMny;
    }

    public BigDecimal getProReceiveMny() {
        return proReceiveMny;
    }

    public void setProReceiveMny(BigDecimal proReceiveMny) {
        this.proReceiveMny = proReceiveMny;
    }

    public BigDecimal getProPayMny() {
        return proPayMny;
    }

    public void setProPayMny(BigDecimal proPayMny) {
        this.proPayMny = proPayMny;
    }

    public BigDecimal getProCostListSurplus() {
        return proCostListSurplus;
    }

    public void setProCostListSurplus(BigDecimal proCostListSurplus) {
        this.proCostListSurplus = proCostListSurplus;
    }

    public BigDecimal getProTransferSurplus() {
        return proTransferSurplus;
    }

    public void setProTransferSurplus(BigDecimal proTransferSurplus) {
        this.proTransferSurplus = proTransferSurplus;
    }

    public BigDecimal getProRiskMarginSurplus() {
        return proRiskMarginSurplus;
    }

    public void setProRiskMarginSurplus(BigDecimal proRiskMarginSurplus) {
        this.proRiskMarginSurplus = proRiskMarginSurplus;
    }

    public BigDecimal getProLoanBalance() {
        return proLoanBalance;
    }

    public void setProLoanBalance(BigDecimal proLoanBalance) {
        this.proLoanBalance = proLoanBalance;
    }

    public BigDecimal getProLoanInterest() {
        return proLoanInterest;
    }

    public void setProLoanInterest(BigDecimal proLoanInterest) {
        this.proLoanInterest = proLoanInterest;
    }

    public BigDecimal getProOtherFeeDeduct() {
        return proOtherFeeDeduct;
    }

    public void setProOtherFeeDeduct(BigDecimal proOtherFeeDeduct) {
        this.proOtherFeeDeduct = proOtherFeeDeduct;
    }

    public BigDecimal getProOtherFeeBack() {
        return proOtherFeeBack;
    }

    public void setProOtherFeeBack(BigDecimal proOtherFeeBack) {
        this.proOtherFeeBack = proOtherFeeBack;
    }

    public BigDecimal getProSurplusMny() {
        return proSurplusMny;
    }

    public void setProSurplusMny(BigDecimal proSurplusMny) {
        this.proSurplusMny = proSurplusMny;
    }

    public BigDecimal getProSurplusApplyMny() {
        return proSurplusApplyMny;
    }

    public void setProSurplusApplyMny(BigDecimal proSurplusApplyMny) {
        this.proSurplusApplyMny = proSurplusApplyMny;
    }

    public BigDecimal getProPettyCash() {
        return proPettyCash;
    }

    public void setProPettyCash(BigDecimal proPettyCash) {
        this.proPettyCash = proPettyCash;
    }

    public BigDecimal getProManageScale() {
        return proManageScale;
    }

    public void setProManageScale(BigDecimal proManageScale) {
        this.proManageScale = proManageScale;
    }

    public BigDecimal getProManageFee() {
        return proManageFee;
    }

    public void setProManageFee(BigDecimal proManageFee) {
        this.proManageFee = proManageFee;
    }

    public BigDecimal getProAmerce() {
        return proAmerce;
    }

    public void setProAmerce(BigDecimal proAmerce) {
        this.proAmerce = proAmerce;
    }

    /**
     *************end************************项目资金改造***************************end*******************************
     */



    public Long getSubjectId() {
        return subjectId;
    }

    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public String getRelationFlag() {
        return relationFlag;
    }

    public void setRelationFlag(String relationFlag) {
        this.relationFlag = relationFlag;
    }

    public String getProportionFlag() {
        return proportionFlag;
    }

    public void setProportionFlag(String proportionFlag) {
        this.proportionFlag = proportionFlag;
    }

    public String getDependOnProject() {
        return dependOnProject;
    }

    public void setDependOnProject(String dependOnProject) {
        this.dependOnProject = dependOnProject;
    }

    public Date getApproveTime() {
        return approveTime;
    }

    public void setApproveTime(Date approveTime) {
        this.approveTime = approveTime;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Date getConfirmTime() {
        return confirmTime;
    }

    public void setConfirmTime(Date confirmTime) {
        this.confirmTime = confirmTime;
    }

    public Integer getPayType() {
        return payType;
    }

    public void setPayType(Integer payType) {
        this.payType = payType;
    }

    public Integer getPayStatus() {
        return payStatus;
    }

    public void setPayStatus(Integer payStatus) {
        this.payStatus = payStatus;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getFeeType() {
        return feeType;
    }

    public void setFeeType(Long feeType) {
        this.feeType = feeType;
    }

    public Long getBearDeptId() {
        return bearDeptId;
    }

    public void setBearDeptId(Long bearDeptId) {
        this.bearDeptId = bearDeptId;
    }

    public String getBearDept() {
        return bearDept;
    }

    public void setBearDept(String bearDept) {
        this.bearDept = bearDept;
    }

    public Long getPayUnitId() {
        return payUnitId;
    }

    public void setPayUnitId(Long payUnitId) {
        this.payUnitId = payUnitId;
    }

    public String getPayUnitName() {
        return payUnitName;
    }

    public void setPayUnitName(String payUnitName) {
        this.payUnitName = payUnitName;
    }

    public String getPayReason() {
        return payReason;
    }

    public void setPayReason(String payReason) {
        this.payReason = payReason;
    }

    public Long getApplyUserId() {
        return applyUserId;
    }

    public void setApplyUserId(Long applyUserId) {
        this.applyUserId = applyUserId;
    }

    public String getApplyUserName() {
        return applyUserName;
    }

    public void setApplyUserName(String applyUserName) {
        this.applyUserName = applyUserName;
    }

    public Date getApplyTime() {
        return applyTime;
    }

    public void setApplyTime(Date applyTime) {
        this.applyTime = applyTime;
    }

    public BigDecimal getApplyMny() {
        return applyMny;
    }

    public void setApplyMny(BigDecimal applyMny) {
        this.applyMny = applyMny;
    }

    public BigDecimal getPayMny() {
        return payMny;
    }

    public void setPayMny(BigDecimal payMny) {
        this.payMny = payMny;
    }

    public BigDecimal getInvoiceMny() {
        return invoiceMny;
    }

    public void setInvoiceMny(BigDecimal invoiceMny) {
        this.invoiceMny = invoiceMny;
    }

    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getAccountNum() {
        return accountNum;
    }

    public void setAccountNum(String accountNum) {
        this.accountNum = accountNum;
    }

    public String getAccountBank() {
        return accountBank;
    }

    public void setAccountBank(String accountBank) {
        this.accountBank = accountBank;
    }

    public String getBackReason() {
        return backReason;
    }

    public void setBackReason(String backReason) {
        this.backReason = backReason;
    }

    public Date getBackTime() {
        return backTime;
    }

    public void setBackTime(Date backTime) {
        this.backTime = backTime;
    }

    public Integer getIsShareFlag() {
        return isShareFlag;
    }

    public void setIsShareFlag(Integer isShareFlag) {
        this.isShareFlag = isShareFlag;
    }

    public String getInvoiceFlag() {
        return invoiceFlag;
    }

    public void setInvoiceFlag(String invoiceFlag) {
        this.invoiceFlag = invoiceFlag;
    }
    /**
     * 报销费用（报销费用=付款申请中的报销费用+备用金报销）
     */
    public BigDecimal getReimburseMmy() {
        return reimburseMmy;
    }

    /**
     * 报销费用（报销费用=付款申请中的报销费用+备用金报销）
     */
    public void setReimburseMmy(BigDecimal reimburseMmy) {
        this.reimburseMmy = reimburseMmy;
    }
    /**
     *  管理费(预算中的管理费)
     */
    public BigDecimal getManageMmy() {
        return manageMmy;
    }

    /**
     *  管理费(预算中的管理费)
     */
    public void setManageMmy(BigDecimal manageMmy) {
        this.manageMmy = manageMmy;
    }
    /**
     *  累计报销
     */
    public BigDecimal getCumulativeMny() {
        return cumulativeMny;
    }
    /**
     *  累计报销
     */
    public void setCumulativeMny(BigDecimal cumulativeMny) {
        this.cumulativeMny = cumulativeMny;
    }

    public BigDecimal getCountShareMny() {
        return countShareMny;
    }

    public void setCountShareMny(BigDecimal countShareMny) {
        this.countShareMny = countShareMny;
    }

}
