package com.ejianc.business.finance.bean;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * <p>
 * 项目资金设置
 * </p>
 *
 * @author liyj
 * @since 2021-05-11
 */
@TableName("ejc_finance_project_capital_set")
public class ProjectCapitalSetEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 项目id
     */
    @TableField("project_id")
    private Long projectId;
    
    /**
     * 项目部id
     */
    @TableField("project_department_id")
    private Long projectDepartmentId;

    /**
     * 项目名称
     */
    @TableField("project_name")
    private String projectName;

    /**
     * 项目收入
     */
    @TableField("project_income")
    private BigDecimal projectIncome;

    /**
     * 项目支出
     */
    @TableField("project_expenditure")
    private BigDecimal projectExpenditure;

    /**
     * 其他
     */
    @TableField("other")
    private BigDecimal other;

    /**
     * 可用余额
     */
    @TableField("available_balance")
    private BigDecimal availableBalance;

    /**
     * 子表
     */
    @TableField(exist = false)
    @SubEntity(serviceName = "projectCapitalSetCostService", pidName="projectCapitalSetId")
    private List<ProjectCapitalSetCostEntity> projectCapitalSetList = new ArrayList<>();

	public Long getProjectId() {
		return projectId;
	}

	public void setProjectId(Long projectId) {
		this.projectId = projectId;
	}

	public String getProjectName() {
		return projectName;
	}

	public void setProjectName(String projectName) {
		this.projectName = projectName;
	}

	public BigDecimal getProjectIncome() {
		return projectIncome;
	}

	public void setProjectIncome(BigDecimal projectIncome) {
		this.projectIncome = projectIncome;
	}

	public BigDecimal getProjectExpenditure() {
		return projectExpenditure;
	}

	public void setProjectExpenditure(BigDecimal projectExpenditure) {
		this.projectExpenditure = projectExpenditure;
	}

	public BigDecimal getOther() {
		return other;
	}

	public void setOther(BigDecimal other) {
		this.other = other;
	}

	public BigDecimal getAvailableBalance() {
		return availableBalance;
	}

	public void setAvailableBalance(BigDecimal availableBalance) {
		this.availableBalance = availableBalance;
	}

	public List<ProjectCapitalSetCostEntity> getProjectCapitalSetList() {
		return projectCapitalSetList;
	}

	public void setProjectCapitalSetList(List<ProjectCapitalSetCostEntity> projectCapitalSetList) {
		this.projectCapitalSetList = projectCapitalSetList;
	}

	public Long getProjectDepartmentId() {
		return projectDepartmentId;
	}

	public void setProjectDepartmentId(Long projectDepartmentId) {
		this.projectDepartmentId = projectDepartmentId;
	}

}
