/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.ejianc.business.accplat.consts.SystemCodeEnum;
import com.ejianc.business.finance.bean.BondUpBackEntity;
import com.ejianc.business.finance.bean.BondUpEntity;
import com.ejianc.business.finance.mapper.BondUpBackMapper;
import com.ejianc.business.finance.service.IBondUpBackService;
import com.ejianc.business.finance.service.IBondUpService;
import com.ejianc.business.finance.vo.BondUpBackVO;
import com.ejianc.business.finance.vo.BondUpDealRentVO;
import com.ejianc.business.voucher.api.IVoucherApi;
import com.ejianc.business.voucher.callable.AccplatVoucherCallable;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.IBaseService;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;

@Service
public class BondUpBackServiceImpl
extends BaseServiceImpl<BondUpBackMapper, BondUpBackEntity>
implements IBondUpBackService {
    private static final String BONGUP_BACK = "BONGUP_BACK";
    @Autowired
    private IBondUpService bondUpService;
    @Autowired
    private IBondUpBackService bondUpBackService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IVoucherApi voucherApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String VOUCHER_PARAM = "P-h5UC6769";
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private HttpServletRequest request;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BondUpBackVO insertOrUpdate(BondUpBackVO bondUpBackVO) {
        Long projectId;
        ParamRegisterSetVO paramRegisterSetVO;
        String valueData;
        BigDecimal applyMny;
        LambdaQueryWrapper lambda;
        Long tenantId = InvocationInfoProxy.getTenantid();
        List entities = null;
        if (StringUtils.isEmpty((CharSequence)bondUpBackVO.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BONGUP_BACK, tenantId);
            if (billCode.isSuccess()) {
                bondUpBackVO.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        BondUpBackEntity entity = (BondUpBackEntity)((Object)BeanMapper.map((Object)bondUpBackVO, BondUpBackEntity.class));
        if (null != bondUpBackVO.getId() && bondUpBackVO.getId() > 0L) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BondUpBackEntity::getBillCode, (Object)bondUpBackVO.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)bondUpBackVO.getId());
            entities = super.list((Wrapper)lambda);
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(BondUpBackEntity::getBillCode, (Object)bondUpBackVO.getBillCode());
            entities = super.list((Wrapper)lambda);
        }
        if (entities != null && entities.size() > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        entity.setBackTime(new Date());
        super.saveOrUpdate((Object)entity, false);
        BondUpEntity upentity = (BondUpEntity)((Object)this.bondUpService.selectById(bondUpBackVO.getBondId()));
        BigDecimal sumBackMny = upentity.getBackMny() == null ? BigDecimal.ZERO : upentity.getBackMny();
        BigDecimal bigDecimal = applyMny = upentity.getApplyMny() == null ? BigDecimal.ZERO : upentity.getApplyMny();
        if (applyMny.compareTo(sumBackMny.add(entity.getBackMny())) < 0) {
            throw new BusinessException("\u672c\u6b21\u9000\u8fd8\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7\u5269\u4f59\u91d1\u989d!");
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)entity.getBondId());
        updateWrapper.set(BondUpEntity::getBackMny, (Object)sumBackMny.add(entity.getBackMny()));
        this.bondUpService.update((Wrapper)updateWrapper);
        CommonResponse byCode = this.paramConfigApi.getByCode(VOUCHER_PARAM);
        if (byCode.isSuccess() && null != byCode.getData() && ((valueData = (paramRegisterSetVO = (ParamRegisterSetVO)byCode.getData()).getValueData()).equals(String.valueOf(projectId = upentity.getProjectId())) || "\u662f".equals(valueData))) {
            ExecutorService threadPool = Executors.newFixedThreadPool(1);
            String authority = this.request.getHeader("authority");
            if (authority == null) {
                this.logger.info("request-authority\u4e3a\u7a7a");
                authority = (String)InvocationInfoProxy.getExtendAttribute((String)"authority");
            }
            try {
                VoucherParams voucherParams = VoucherParams.newInstance((String)"BT200622000000002", (Long)upentity.getOrgId(), (Object)((Object)entity), (SystemCodeEnum)SystemCodeEnum.FINANCE);
                AccplatVoucherCallable voucherCallable = new AccplatVoucherCallable(this.voucherApi, (IBaseService)this.bondUpBackService, voucherParams, "save", RequestContextHolder.getRequestAttributes(), authority);
                threadPool.submit(voucherCallable);
            }
            catch (Exception e) {
                this.logger.error("\u5bf9\u4e0a\u4fdd\u8bc1\u91d1\u9000\u8fd8\u63a8\u9001\u51ed\u8bc1\u5f02\u5e38, ", (Throwable)e);
            }
            finally {
                threadPool.shutdown();
            }
        }
        return (BondUpBackVO)BeanMapper.map((Object)((Object)entity), BondUpBackVO.class);
    }

    @Override
    public BondUpDealRentVO queryDetail(Long id) {
        BondUpDealRentVO vo = new BondUpDealRentVO();
        BondUpEntity upEntity = (BondUpEntity)((Object)this.bondUpService.selectById(id));
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(BondUpBackEntity::getBondId, (Object)id);
        lambda.orderBy(true, false, (Object[])new SFunction[]{BondUpBackEntity::getBackTime});
        List list = super.list((Wrapper)lambda);
        vo.setId(id);
        vo.setBondStatus(upEntity.getBondStatus());
        vo.setContractId(upEntity.getContractId());
        vo.setContractName(upEntity.getContractName());
        vo.setApplyMny(upEntity.getApplyMny() == null ? BigDecimal.ZERO : upEntity.getApplyMny());
        vo.setContractTaxMny(upEntity.getContractTaxMny() == null ? BigDecimal.ZERO : upEntity.getContractTaxMny());
        vo.setBackMny(upEntity.getBackMny() == null ? BigDecimal.ZERO : upEntity.getBackMny());
        vo.setSurplusMny(vo.getApplyMny().subtract(vo.getBackMny()));
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            vo.setBackRecord(BeanMapper.mapList((Iterable)list, BondUpBackVO.class));
        }
        return vo;
    }
}

