/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.ejianc.business.accplat.consts.SystemCodeEnum;
import com.ejianc.business.finance.bean.BondUpDealEntity;
import com.ejianc.business.finance.bean.BondUpEntity;
import com.ejianc.business.finance.mapper.BondUpDealMapper;
import com.ejianc.business.finance.service.IBondUpDealService;
import com.ejianc.business.finance.service.IBondUpService;
import com.ejianc.business.finance.vo.BondUpDealRentVO;
import com.ejianc.business.finance.vo.BondUpDealVO;
import com.ejianc.business.voucher.api.IVoucherApi;
import com.ejianc.business.voucher.callable.AccplatVoucherCallable;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.IBaseService;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;

@Service
public class BondUpDealServiceImpl
extends BaseServiceImpl<BondUpDealMapper, BondUpDealEntity>
implements IBondUpDealService {
    private static final String BONGUP_DEAL = "BONGUP_DEAL";
    @Autowired
    private IBondUpService bondUpService;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String VOUCHER_PARAM = "P-h5UC6769";
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IVoucherApi voucherApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private IBondUpDealService bondUpDealService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BondUpDealVO insertOrUpdate(BondUpDealVO bondUpDealVO) {
        BondUpEntity bondUpEntity;
        Long projectId;
        ParamRegisterSetVO paramRegisterSetVO;
        String valueData;
        LambdaQueryWrapper lambda;
        Long tenantId = InvocationInfoProxy.getTenantid();
        List entities = null;
        if (StringUtils.isEmpty((CharSequence)bondUpDealVO.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BONGUP_DEAL, tenantId);
            if (billCode.isSuccess()) {
                bondUpDealVO.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        BondUpDealEntity entity = (BondUpDealEntity)((Object)BeanMapper.map((Object)bondUpDealVO, BondUpDealEntity.class));
        if (null != bondUpDealVO.getId() && bondUpDealVO.getId() > 0L) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BondUpDealEntity::getBillCode, (Object)bondUpDealVO.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)bondUpDealVO.getId());
            entities = super.list((Wrapper)lambda);
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)entity.getId());
            updateWrapper.set(BondUpDealEntity::getDealStatus, (Object)"2");
            super.update((Wrapper)updateWrapper);
            entity.setId(null);
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(BondUpDealEntity::getBillCode, (Object)bondUpDealVO.getBillCode());
            entities = super.list((Wrapper)lambda);
        }
        if (entities != null && entities.size() > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        entity.setDealStatus("1");
        entity.setDealTime(new Date());
        super.saveOrUpdate((Object)entity, false);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)entity.getBondId());
        updateWrapper.set(BondUpEntity::getBondStatus, (Object)"1");
        updateWrapper.set(BondUpEntity::getBeginDate, (Object)entity.getBeginDate());
        updateWrapper.set(BondUpEntity::getEndDate, (Object)entity.getEndDate());
        updateWrapper.set(BondUpEntity::getEmployeeId, (Object)entity.getEmployeeId());
        updateWrapper.set(BondUpEntity::getEmployeeName, (Object)entity.getEmployeeName());
        updateWrapper.set(BondUpEntity::getPayMny, (Object)entity.getBondMny());
        updateWrapper.set(BondUpEntity::getBondType, (Object)entity.getBondType());
        updateWrapper.set(BondUpEntity::getDealTime, (Object)entity.getDealTime());
        this.bondUpService.update((Wrapper)updateWrapper);
        CommonResponse byCode = this.paramConfigApi.getByCode(VOUCHER_PARAM);
        if (byCode.isSuccess() && null != byCode.getData() && ((valueData = (paramRegisterSetVO = (ParamRegisterSetVO)byCode.getData()).getValueData()).equals(String.valueOf(projectId = (bondUpEntity = (BondUpEntity)((Object)this.bondUpService.selectById(entity.getBondId()))).getProjectId())) || "\u662f".equals(valueData))) {
            ExecutorService threadPool = Executors.newFixedThreadPool(1);
            String authority = this.request.getHeader("authority");
            if (authority == null) {
                this.logger.info("request-authority\u4e3a\u7a7a");
                authority = (String)InvocationInfoProxy.getExtendAttribute((String)"authority");
            }
            try {
                VoucherParams voucherParams = VoucherParams.newInstance((String)"BT200622000000001", (Long)bondUpEntity.getOrgId(), (Object)((Object)entity), (SystemCodeEnum)SystemCodeEnum.FINANCE);
                AccplatVoucherCallable voucherCallable = new AccplatVoucherCallable(this.voucherApi, (IBaseService)this.bondUpDealService, voucherParams, "save", RequestContextHolder.getRequestAttributes(), authority);
                threadPool.submit(voucherCallable);
            }
            catch (Exception e) {
                this.logger.error("\u5bf9\u4e0a\u4fdd\u8bc1\u91d1\u529e\u7406\u63a8\u9001\u51ed\u8bc1\u5f02\u5e38, ", (Throwable)e);
            }
            finally {
                threadPool.shutdown();
            }
        }
        return (BondUpDealVO)BeanMapper.map((Object)((Object)entity), BondUpDealVO.class);
    }

    @Override
    public BondUpDealRentVO queryDetail(Long id) {
        BondUpDealRentVO vo = new BondUpDealRentVO();
        BondUpEntity upEntity = (BondUpEntity)((Object)this.bondUpService.selectById(id));
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(BondUpDealEntity::getBondId, (Object)id);
        lambda.orderBy(true, true, (Object[])new SFunction[]{BondUpDealEntity::getDealStatus});
        List list = super.list((Wrapper)lambda);
        vo = (BondUpDealRentVO)BeanMapper.map((Object)((Object)upEntity), BondUpDealRentVO.class);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            vo.setDealRecord(BeanMapper.mapList((Iterable)list, BondUpDealVO.class));
        }
        return vo;
    }
}

