package com.ejianc.business.finance.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;

/**
 * <p>
 *
 * </p>
 *
 * @author yqls
 * @since 2020-06-04
 */
@TableName("ejc_finance_pay_sporadic_stock")
public class PaySporadicStockEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 付款申请单主键
     */
    @TableField("payapply_id")
    private Long payapplyId;

    /**
     * 来源入库单主键
     */
    @TableField("stock_id")
    private Long stockId;

    /**
     * 入库单编号
     */
    @TableField("stock_code")
    private String stockCode;

    /**
     * 入库物资
     */
    @TableField("stock_material_name")
    private String stockMaterialName;

    /**
     * 入库金额
     */
    @TableField("stock_mny")
    private BigDecimal stockMny;

    /**
     * 本期申请金额
     */
    @TableField("apply_mny")
    private BigDecimal applyMny;

    /**
     * 已申请金额
     */
    @TableField("sum_apply_mny")
    private BigDecimal sumApplyMny;

    /**
     * 创建者名称
     */
    @TableField("create_user_name")
    private String createUserName;

    /**
     * 剩余可申请金额
     */
    @TableField("surplus_apply_mny")
    private BigDecimal surplusApplyMny;

    public BigDecimal getSurplusApplyMny() {
        return surplusApplyMny;
    }

    public void setSurplusApplyMny(BigDecimal surplusApplyMny) {
        this.surplusApplyMny = surplusApplyMny;
    }

    public Long getPayapplyId() {
        return payapplyId;
    }

    public void setPayapplyId(Long payapplyId) {
        this.payapplyId = payapplyId;
    }

    public Long getStockId() {
        return stockId;
    }

    public void setStockId(Long stockId) {
        this.stockId = stockId;
    }

    public String getStockCode() {
        return stockCode;
    }

    public void setStockCode(String stockCode) {
        this.stockCode = stockCode;
    }

    public String getStockMaterialName() {
        return stockMaterialName;
    }

    public void setStockMaterialName(String stockMaterialName) {
        this.stockMaterialName = stockMaterialName;
    }

    public BigDecimal getStockMny() {
        return stockMny;
    }

    public void setStockMny(BigDecimal stockMny) {
        this.stockMny = stockMny;
    }

    public BigDecimal getApplyMny() {
        return applyMny;
    }

    public void setApplyMny(BigDecimal applyMny) {
        this.applyMny = applyMny;
    }

    public BigDecimal getSumApplyMny() {
        return sumApplyMny;
    }

    public void setSumApplyMny(BigDecimal sumApplyMny) {
        this.sumApplyMny = sumApplyMny;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

}
