package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.cost.vo.CostDetailVO;
import com.ejianc.business.equipment.api.ISettlementApi;
import com.ejianc.business.equipment.vo.RentSettlementVO;
import com.ejianc.business.equipment.vo.SettlementVO;
import com.ejianc.business.finance.bean.LoadReimburseEntity;
import com.ejianc.business.finance.controller.api.PayContractApi;
import com.ejianc.business.finance.mapper.LoadReimburseMapper;
import com.ejianc.business.finance.service.ILoadApplyService;
import com.ejianc.business.finance.service.ILoadReimburseService;
import com.ejianc.business.finance.service.IPayContractService;
import com.ejianc.business.finance.service.IloadInvoiceService;
import com.ejianc.business.finance.util.BillTypeCodeEnum;
import com.ejianc.business.finance.util.ValidateUtil;
import com.ejianc.business.finance.vo.*;
import com.ejianc.business.material.vo.ParamsCheckDsVO;
import com.ejianc.business.material.vo.ParamsCheckVO;
import com.ejianc.business.plan.api.IBudgetPlanApi;
import com.ejianc.business.plan.vo.BudgetTemVO;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.business.tax.vo.InvoiceReceiveFlagVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 借款报销
 *
 * @author generator
 *
 */
@Service("LoadReimburseService")
public class LoadReimburseServiceImpl extends BaseServiceImpl<LoadReimburseMapper, LoadReimburseEntity> implements ILoadReimburseService{
    private static final String BONDUP_BILL_CODE = "LOAD_REIMBURSE";
    //系统是否开启专业分包预算标志
    private static final String SYS_IS_PROBUDGET_CODE = "P-D76yn127";
    //预算单据管理费控制
    private static final String CHECK_PARAM_PROBUDGET_CODE = "P-V4416932";

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ILoadApplyService loadApplyService;

    @Autowired
    private IInvoiceApi invoiceApi;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IloadInvoiceService loadInvoiceService;

    @Autowired
    private PayContractApi payContractApi;
    @Autowired
    private IPayContractService payContractService;
    @Autowired
    private ISettlementApi iSettlementApi;

    @Autowired
    private IBudgetPlanApi iBudgetPlanApi;

    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IOrgApi orgApi;

    @Override
    public LoadReimburseVO insertOrUpdate(LoadReimburseVO loadReimburseVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(null!=loadReimburseVO&&StringUtils.isEmpty(loadReimburseVO.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BONDUP_BILL_CODE,tenantId);
            if(billCode.isSuccess()) {
                loadReimburseVO.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        LoadReimburseEntity entity = BeanMapper.map(loadReimburseVO, LoadReimburseEntity.class);
        BigDecimal surplusMny =  loadApplyService.querySurplusMny(entity.getId(),null,entity.getOrgId(),0, String.valueOf(entity.getApplyEmployeeId()));
        BigDecimal reimburseMny = entity.getReimburseMny();
        if(reimburseMny.compareTo(surplusMny)>0){
            DecimalFormat df1 = new DecimalFormat("###,###.##");
            throw new BusinessException("本次报销金额不能超过剩余可报销金额【"+df1.format(surplusMny)+"】元");
        }
        List<LoadInvoiceVO> voList = loadReimburseVO.getInvoiceVOList();

        CommonResponse<String> usedMnyRes = loadInvoiceService.updateInvoiceUsedMnyBySave(voList, entity.getId());
        if (!usedMnyRes.isSuccess()) {
            throw new BusinessException(usedMnyRes.getMsg());
        }

        entity.setSurplusMny(surplusMny);
        entity.setProportionFlag("0");
        entity.setRelationFlag("0");
        super.saveOrUpdate(entity,false);
        return BeanMapper.map(entity, LoadReimburseVO.class);
    }

    @Override
    public Map<String, Object> countAmt(Long tenantId, List<Long> projectIds) {
        QueryWrapper<LoadReimburseEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.select("ifnull(sum(reimburse_mny),0) as amt");

        queryWrapper.eq("tenant_id", tenantId);
        queryWrapper.eq("dr", BaseVO.DR_UNDELETE);
        //属于项目
        queryWrapper.eq("depend_on_project", "1");

        if(CollectionUtils.isNotEmpty(projectIds)) {
            queryWrapper.in("project_id", projectIds);
        }
//        已生效的单据
        queryWrapper.in("bill_state",
                Arrays.asList(new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()}));
        List<Long> orgIds = new ArrayList<>();
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (org.apache.commons.lang.StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse =
                    orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                            collect(Collectors.toList()));
            orgIds = authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        }  else {
            orgIds = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        }
        if(ListUtil.isNotEmpty(orgIds)){
            queryWrapper.in("org_id", orgIds);
        }
        return super.getMap(queryWrapper);
    }

    @Override
    public CommonResponse<LoadReimburseVO> pushCost(LoadReimburseVO loadReimburseVO) {
        LoadReimburseEntity loadReimburseEntity = baseMapper.selectById(loadReimburseVO.getId());
        loadReimburseEntity.setSubjectId(loadReimburseVO.getSubjectId());
        loadReimburseEntity.setSubjectName(loadReimburseVO.getSubjectName());
        super.saveOrUpdate(loadReimburseEntity,false);
        //推送数据
        costPush(loadReimburseEntity);
        return CommonResponse.success(BeanMapper.map(loadReimburseEntity, LoadReimburseVO.class));
    }
    @Override
    public void costPush(LoadReimburseEntity loadReimburseEntity) {
        if (!"1".equals(loadReimburseEntity.getDependOnProject())){
            return;
        }
        //1.判断是否关联
        Long subjectId = loadReimburseEntity.getSubjectId();
        boolean newRelationFlag = true;
        if(null == subjectId){
            newRelationFlag = false;
        }
        //更新是否关联
        LambdaUpdateWrapper<LoadReimburseEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(LoadReimburseEntity::getId, loadReimburseEntity.getId());
        updateWrapper.set(LoadReimburseEntity::getRelationFlag, newRelationFlag ? "1":"0");//(1:是，0：否)
        super.update(updateWrapper);

        //判断之前的单据是否关联
        String oldRelationFlag = loadReimburseEntity.getRelationFlag();
        //之前已关联
        if (oldRelationFlag.equals("1")){
            if (newRelationFlag){
                saveCost(loadReimburseEntity);
            }
            if (!newRelationFlag){
                //删除成本中心之前的数据
                costDetailApi.deleteSubject(loadReimburseEntity.getId());
            }
        }
        //之前未关联
        if (oldRelationFlag.equals("0")){
            if (newRelationFlag){
                //税率
                saveCost(loadReimburseEntity);
            }
        }


    }

    private void saveCost(LoadReimburseEntity loadReimburseEntity) {
        //明细
        List<CostDetailVO> costDetailVOList = new ArrayList<CostDetailVO>();
        CostDetailVO costDetailVO = new CostDetailVO();
        costDetailVO.setSubjectId(loadReimburseEntity.getSubjectId());
        costDetailVO.setSourceId(loadReimburseEntity.getId());
        costDetailVO.setSourceDetailId(loadReimburseEntity.getId());
        costDetailVO.setHappenTaxMny(loadReimburseEntity.getReimburseMny());
        costDetailVO.setHappenMny(loadReimburseEntity.getReimburseMny());
        costDetailVO.setHappenDate(loadReimburseEntity.getApplyTime());
        costDetailVO.setCreateUserName(sessionManager.getUserContext().getUserName());
        costDetailVO.setSourceType(BONDUP_BILL_CODE);
        costDetailVO.setSourceTabType(BONDUP_BILL_CODE);
        costDetailVO.setProjectId(loadReimburseEntity.getProjectId());
        costDetailVOList.add(costDetailVO);
        //成本中心
        if (ListUtil.isNotEmpty(costDetailVOList)){
            costDetailVOList.toString();
            CommonResponse<String> stringCommonResponse = costDetailApi.saveSubject(costDetailVOList);
            if (stringCommonResponse.isSuccess()){
            }else {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }
    //成本改造
    @Override
    public void pullCost(Long id) {
        ////更新关联状态为未关联
        LambdaUpdateWrapper<LoadReimburseEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(LoadReimburseEntity::getId, id);
        updateWrapper.set(LoadReimburseEntity::getRelationFlag, "0");//(1:是，0：否)
        super.update(updateWrapper);
        //删除成本中心数据
        costDetailApi.deleteSubject(id);
    }

    @Override
    public ParamsCheckSpreadVO checkParams(Long projectId, BigDecimal appMoney) {
        List<Long> projectIds = new ArrayList<>();
        projectIds.add(projectId);
        String[] paramsArray = {"none", "warn", "alert"};
        ParamsCheckSpreadVO paramsCheckVO = new ParamsCheckSpreadVO();
//        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        // 预警弹框控制
        paramsCheckVO.setWarnType(paramsArray[0]);
        // 管理费率
        BigDecimal manageRate = BigDecimal.ZERO;

        CommonResponse<ParamRegisterSetVO> byCode = paramConfigApi.getByCode(SYS_IS_PROBUDGET_CODE);
        if (byCode.isSuccess() && null != byCode.getData()) {
            ParamRegisterSetVO data = byCode.getData();
            String valueData = data.getValueData();
            if ("1".equals(valueData)) {
                CommonResponse<BillParamVO> probudgetCode = paramConfigApi.getBillParamByCode(CHECK_PARAM_PROBUDGET_CODE);
                if(probudgetCode.isSuccess() && null != probudgetCode.getData()){
                    paramsCheckVO.setWarnType(paramsArray[probudgetCode.getData().getControlType()]);
                    manageRate = probudgetCode.getData().getRoleValue();
                }else{
                    logger.info("不管控");
                    return paramsCheckVO;
                }
            }else{
                logger.info("未读取到费率配置参数！"+projectId);
                return paramsCheckVO;
            }
        }else{
            logger.info("非世纪阳光！"+projectId);
            return paramsCheckVO;
        }
        // 预警内容
        List<ParamsCheckDsSpreadVO> checkDsVOS = new ArrayList<>();
        // 累计已用额度
        BigDecimal oldSumMoney = BigDecimal.ZERO;
        // 当前总额度 (累计已用额度+本次申请额度)
        BigDecimal sumMoney = BigDecimal.ZERO;
        // 超额的值
        BigDecimal excessMoney = BigDecimal.ZERO;
        // 预警阀值
        BigDecimal endSum = BigDecimal.ZERO;
        // 管理费
        BigDecimal costbudgetMny = BigDecimal.ZERO;
        // 临时值，用于格式化费率
        BigDecimal temp = new BigDecimal(100);

        BigDecimal payReimburseMny = BigDecimal.ZERO;
        BigDecimal loadReimburseMny = BigDecimal.ZERO;
        BigDecimal rentSettleMny = BigDecimal.ZERO;
        BigDecimal purchaseSettleMny = BigDecimal.ZERO;

        List<ProjectReimburseVO> projectReimburse = payContractService.getProjectReimburse(projectIds, null);
        CommonResponse<List<SettlementVO>> settleMny = iSettlementApi.getSettleMny(projectIds);
        CommonResponse<BudgetTemVO> budget = iBudgetPlanApi.getBudget(projectId);
        if(CollectionUtils.isNotEmpty(projectReimburse)){
            payReimburseMny = projectReimburse.get(0).getPayReimburseMny();
            loadReimburseMny = projectReimburse.get(0).getLoadReimburseMny();
        }
        if(settleMny.isSuccess() && null != settleMny.getData() && settleMny.getData().size() > 0){
            rentSettleMny = settleMny.getData().get(0).getRentSettleMny();
            purchaseSettleMny = settleMny.getData().get(0).getPurchaseSettleMny();
        }
        if(budget.isSuccess() && null != budget.getData()){
            costbudgetMny = budget.getData().getManageMny();
            endSum = costbudgetMny.multiply(manageRate).divide(temp);
        }

        // 累加已用额度
        oldSumMoney = payReimburseMny.add(loadReimburseMny).add(rentSettleMny).add(purchaseSettleMny);
        // 计算当前总额度
        sumMoney = oldSumMoney.add(appMoney);
        // 计算已经超额的值
        excessMoney = sumMoney.subtract(endSum);
        //reimburseMmy 报销费用=付款申请中的报销费用+备用金报销
        BigDecimal reimburseMmy = payReimburseMny.add(loadReimburseMny).add(appMoney);
        //manageMmy  管理费
        BigDecimal manageMmy=costbudgetMny;
        paramsCheckVO.setManageMmy(manageMmy);
        paramsCheckVO.setReimburseMmy(reimburseMmy);
        if(sumMoney.compareTo(endSum) > 0){
            ParamsCheckDsSpreadVO paramsCheckDsVO = new ParamsCheckDsSpreadVO();
            paramsCheckDsVO.setWarnItem("管理费超付");
            paramsCheckDsVO.setWarnName("管理费金额大于预算中管理费金额");
            paramsCheckDsVO.setContent("本次管理费金额："+appMoney.setScale(2, BigDecimal.ROUND_HALF_UP)
                    +"元，预算管理费金额*"+manageRate.setScale(2, BigDecimal.ROUND_HALF_UP)+"%："+endSum.setScale(2, BigDecimal.ROUND_HALF_UP)
                    +"元。超出金额:"+excessMoney.setScale(2, BigDecimal.ROUND_HALF_UP)+"元。");
            checkDsVOS.add(paramsCheckDsVO);
            paramsCheckVO.setDataSource(checkDsVOS);
        }
        return paramsCheckVO;
    }
}
