package com.ejianc.business.finance.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.accplat.consts.SystemCodeEnum;
import com.ejianc.business.finance.bean.*;
import com.ejianc.business.finance.service.*;
import com.ejianc.business.finance.vo.*;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.business.voucher.consts.VoucherOptFlag;
import com.ejianc.business.voucher.utils.DataConvertUtil;
import com.ejianc.business.voucher.vo.VoucherInfo;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 付款申请记录实体
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("payRecord")
public class PayRecordController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private IPayRecordService service;

    @Autowired
    private FinanceVoucherHandleService financeVoucherHandleService;

    @Autowired
    private IPayContractService payContractService;

    @Autowired
    private IPayReimburseService payReimburseService;

    @Autowired
    private ILoadApplyService loadApplyService;

    @Autowired
    private IPayContractDeductionService contractDeductionService;

    @Autowired
    private IDeductionService deductionService;

    /**
     * @description: 推送凭证
     *
     * @param voucherInfo
     * @return {@link CommonResponse}
     * @author songlx
     * @date: 2024/1/12
     */
    @RequestMapping(value = "/pushVoucher", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse pushVoucher(@RequestBody VoucherInfo voucherInfo) {
        Long billId = voucherInfo.getBillId();
        PayRecordEntity recordEntity = service.getById(billId);
        Long payapplyId = recordEntity.getPayapplyId();
        String applyType = recordEntity.getApplyType();
        VoucherParams voucherParams = null;
        Map<String, Object> recordMap = DataConvertUtil.objToMap(recordEntity);
        // 扣款单凭证参数
        List<VoucherParams> voucherParams4DedList = new ArrayList<>();
        BigDecimal thisPayMny = recordEntity.getThisPayMny();
        String bussinesType = ComputeUtil.isLessThan(thisPayMny, BigDecimal.ZERO) ? "付款退回" : null;
        if ("合同付款".equals(applyType)) {
            PayContractEntity payContractEntity = payContractService.selectById(payapplyId);
            PayContractVO payContractVoucherVO = BeanMapper.map(payContractEntity, PayContractVO.class);
            payContractVoucherVO.setVoucherFlag(recordEntity.getVoucherFlag());
            payContractVoucherVO.setVoucherInfo(recordEntity.getVoucherInfo());
            payContractVoucherVO.set_payRecordId(recordMap);
            // 凭证平台依据此来记录了来源单据id，此处来源单据id应该是支付记录id
            payContractVoucherVO.setId(recordEntity.getId());

            LambdaUpdateWrapper<PayRecordEntity> payRecordEntityLambdaUpdateWrapper = new LambdaUpdateWrapper<>();
            payRecordEntityLambdaUpdateWrapper.eq(PayRecordEntity::getPayapplyId, payapplyId);
            payRecordEntityLambdaUpdateWrapper.lt(PayRecordEntity::getCreateTime, recordEntity.getCreateTime());
            payRecordEntityLambdaUpdateWrapper.ne(PayRecordEntity::getId, billId);
            int count = service.count(payRecordEntityLambdaUpdateWrapper);
            boolean isFirstPay = count == 0;
            // 判断是否是第一次支付
            if (isFirstPay) {
                logger.info("第一次支付推送凭证。。");
                // 第一次支付，如果是分包类型，并且吊兰费大于0，收款单位取吊兰供应商
              /*  Long contractType = payContractVoucherVO.getContractType();
                if(contractType != null && contractType.intValue() == 1){
                    Map<String, Object> customField = payContractVoucherVO.getCustomField();
                    BigDecimal diaoLanMny = customField != null ? ComputeUtil.toBigDecimal(customField.get("DLFY")) : BigDecimal.ZERO;
                    if(ComputeUtil.isGreaterThan(diaoLanMny, BigDecimal.ZERO)){
                        Long basketSupplierId = payContractVoucherVO.getBasketSupplierId();
                        String basketSupplierName = payContractVoucherVO.getBasketSupplierName();
                        payContractVoucherVO.setReceiveUnitId(basketSupplierId);
                        payContractVoucherVO.setReceiveUnitName(basketSupplierName);
                    }
                }*/

                // 如果是第一次支付：1、手动把支付金额置为0，凭证模板以此判断是否第一次支付来生成吊兰费分录
                // 如果是第一次支付2、第一次支付，如果有扣款单则推送扣款单凭证
                payContractVoucherVO.setPayMny(BigDecimal.ZERO);
                QueryWrapper wrapper = new QueryWrapper<PayContractDeductionEntity>();
                wrapper.eq("payapply_id", payapplyId);
                List<PayContractDeductionEntity> payContractDeductionEntityList = contractDeductionService.list(wrapper);
                if (CollectionUtils.isNotEmpty(payContractDeductionEntityList)) {
                    List<Long> dedIdList = payContractDeductionEntityList.stream().map(PayContractDeductionEntity::getDeductionId).collect(Collectors.toList());
                    List<DeductionEntity> deductionEntities = (List<DeductionEntity>) deductionService.listByIds(dedIdList);
                    for (int a = 0; a < deductionEntities.size(); a++) {
                        DeductionEntity deductionEntity = deductionEntities.get(a);
                        VoucherParams voucherParamsDed = VoucherParams.newInstanceByOrgId(DeductionVO.BILL_TYPE_CODE, deductionEntity, SystemCodeEnum.FINANCE);
                        voucherParams4DedList.add(voucherParamsDed);
                    }
                }
            }
            voucherParams = VoucherParams.newInstanceByOrgId(PayContractVO.BILL_TYPE_CODE, payContractVoucherVO, bussinesType, SystemCodeEnum.FINANCE);

        } else if ("报销".equals(applyType)) {
            PayReimburseEntity reimburseEntity = payReimburseService.selectById(payapplyId);
            PayReimburseVO reimburseVoucherVO = BeanMapper.map(reimburseEntity, PayReimburseVO.class);
            reimburseVoucherVO.setVoucherFlag(recordEntity.getVoucherFlag());
            reimburseVoucherVO.setVoucherInfo(recordEntity.getVoucherInfo());
            reimburseVoucherVO.set_payRecordId(recordMap);
            // 凭证平台依据此来记录了来源单据id，此处来源单据id应该是支付记录id
            reimburseVoucherVO.setId(recordEntity.getId());
            voucherParams = VoucherParams.newInstanceByOrgId(PayReimburseVO.BILL_TYPE_CODE, reimburseVoucherVO, bussinesType, SystemCodeEnum.FINANCE);
        } else if ("备用金".equals(applyType)) {
            LoadApplyEntity applyEntity = loadApplyService.selectById(payapplyId);
            LoadApplyVO loadApplyVoucherVO = BeanMapper.map(applyEntity, LoadApplyVO.class);
            loadApplyVoucherVO.setVoucherFlag(recordEntity.getVoucherFlag());
            loadApplyVoucherVO.setVoucherInfo(recordEntity.getVoucherInfo());
            loadApplyVoucherVO.set_payRecordId(recordMap);
            // 凭证平台依据此来记录了来源单据id，此处来源单据id应该是支付记录id
            loadApplyVoucherVO.setId(recordEntity.getId());
            voucherParams = VoucherParams.newInstanceByOrgId(LoadApplyVO.BILL_TYPE_CODE, loadApplyVoucherVO, bussinesType, SystemCodeEnum.FINANCE);
        }
        if (voucherParams == null) {
            throw new BusinessException("推送凭证异常：申请单不存在！");
        }
        voucherParams.setBillId(billId);

        // 支付金额>0时再生成凭证
        if (ComputeUtil.isGreaterThan(recordEntity.getThisPayMny(), BigDecimal.ZERO)) {
            CommonResponse res = financeVoucherHandleService.handleVoucherWithVoucherParams(service, voucherParams, VoucherOptFlag.SAVE);
            if (!res.isSuccess()) {
                return res;
            }
        }
        if (CollectionUtils.isNotEmpty(voucherParams4DedList)) {
            for (VoucherParams params : voucherParams4DedList) {
                CommonResponse response = financeVoucherHandleService.handleVoucherWithVoucherParams(deductionService, params, VoucherOptFlag.SAVE);
                if (!response.isSuccess()) {
                    return response;
                }
            }
        }
        return CommonResponse.success();
    }


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PayRecordVO> saveOrUpdate(@RequestBody PayRecordVO saveorUpdateVO) {
        PayRecordVO vo = service.insertOrUpdate(saveorUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PayRecordVO> queryDetail(Long id) {
    	PayRecordEntity entity = service.selectById(id);
    	PayRecordVO vo = BeanMapper.map(entity, PayRecordVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PayRecordVO> vos) {
        service.removeByIds(vos.stream().map(PayRecordVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PayRecordVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        
        IPage<PayRecordEntity> page = service.queryPage(param,false);
        IPage<PayRecordVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), PayRecordVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * 付款退回
     *
     * @param payRecordVO 付款申请记录
     *
     * @return {@link CommonResponse}<{@link PayRecordVO}>
     */
    @RequestMapping(value = "/returnPayment", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PayRecordVO> returnPayment(@RequestBody PayRecordVO payRecordVO) {
        return CommonResponse.success("付款退回成功！", service.returnPayment(payRecordVO));
    }

}
