package com.ejianc.business.finance.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.accplat.consts.SystemCodeEnum;
import com.ejianc.business.finance.bean.*;
import com.ejianc.business.finance.service.IPayContractService;
import com.ejianc.business.finance.service.IPayRecordService;
import com.ejianc.business.finance.vo.*;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.business.voucher.api.IVoucherApi;
import com.ejianc.business.voucher.consts.VoucherOptFlag;
import com.ejianc.business.voucher.utils.DataConvertUtil;
import com.ejianc.business.voucher.vo.VoucherInfo;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.formula.functions.T;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.finance.service.IMergeRecordService;

/**
 * 合并支付记录实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("mergeRecord")
public class MergeRecordController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IVoucherApi voucherApi;
    @Autowired
    private IPayRecordService payRecordService;
    @Autowired
    private IPayContractService contractService;
    @Autowired
    private IMergeRecordService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MergeRecordVO> saveOrUpdate(@RequestBody MergeRecordVO saveOrUpdateVO) {
    	return CommonResponse.success("保存或修改单据成功！",service.insertOrUpdate(saveOrUpdateVO));
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MergeRecordVO> queryDetail(Long id) {
    	MergeRecordEntity entity = service.selectById(id);
    	MergeRecordVO vo = BeanMapper.map(entity, MergeRecordVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    /**
     * @description: 推送凭证
     *
     * @param voucherInfo
     * @return {@link CommonResponse}
     * @author
     * @date:
     */
    @RequestMapping(value = "/pushVoucher", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse pushVoucher(@RequestBody VoucherInfo voucherInfo) {
        Long billId = voucherInfo.getBillId();
        Assert.notNull(billId, "单据billId不能为空！");
        MergeRecordEntity entity = service.selectById(billId);
        Map<String, Object> recordMap = DataConvertUtil.objToMap(entity);
        LambdaQueryWrapper<PayRecordEntity> payRecordEntityLambdaQueryWrapper = Wrappers.<PayRecordEntity>lambdaQuery();
        payRecordEntityLambdaQueryWrapper.eq(PayRecordEntity::getMergeConfirmId,entity.getId());
        List<PayRecordEntity> list = payRecordService.list(payRecordEntityLambdaQueryWrapper);
        PayContractEntity contract = contractService.selectById(list.get(0).getPayapplyId());
        PayContractVO payContractVoucherVO = BeanMapper.map(contract, PayContractVO.class);
        // 凭证平台依据此来记录了来源单据id，此处来源单据id应该是支付记录id
        payContractVoucherVO.setId(entity.getId());
        payContractVoucherVO.set_payRecordId(recordMap);
        //一般只合并支付一次  所以默认放0
        payContractVoucherVO.setPayMny(BigDecimal.ZERO);
        payContractVoucherVO.getCustomField().put("DLFY",entity.getDLFY());//覆盖吊篮费用
        VoucherParams voucherParams = VoucherParams.newInstanceByOrgId("BT200611000000017", payContractVoucherVO, SystemCodeEnum.FINANCE);
        CommonResponse<VoucherInfo> response = voucherApi.handleVoucher(voucherParams, VoucherOptFlag.SAVE);
        VoucherInfo voucherInfoRes = response.getData();
        if (voucherInfoRes != null) {
            Integer voucherFlag = voucherInfoRes.getVoucherFlag();
            UpdateWrapper<MergeRecordEntity> updateWrapper = new UpdateWrapper<>();
            updateWrapper.eq("id", billId);
            String voucherInfoStr = DataConvertUtil.objToString(voucherInfoRes);
            updateWrapper.set("voucher_flag", voucherFlag);
            updateWrapper.set("voucher_info", voucherInfoStr);
            service.update(updateWrapper);
        }
        return response;
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MergeRecordVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (MergeRecordVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(MergeRecordVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MergeRecordVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode","employeeName","contractName","orgName","memo","receiveUnitName"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<MergeRecordEntity> page = service.queryPage(param,false);
        IPage<MergeRecordVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), MergeRecordVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode","employeeName","contractName","orgName","memo","receiveUnitName"));
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<MergeRecordEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("MergeRecord-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refMergeRecordData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MergeRecordVO>> refMergeRecordData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<MergeRecordEntity> page = service.queryPage(param,false);
        IPage<MergeRecordVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MergeRecordVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
