/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.accplat.consts.SystemCodeEnum;
import com.ejianc.business.finance.bean.MergeRecordEntity;
import com.ejianc.business.finance.bean.PayContractEntity;
import com.ejianc.business.finance.bean.PayRecordEntity;
import com.ejianc.business.finance.mapper.MergeRecordMapper;
import com.ejianc.business.finance.service.IMergeRecordService;
import com.ejianc.business.finance.service.IPayContractService;
import com.ejianc.business.finance.service.IPayRecordService;
import com.ejianc.business.finance.vo.MergeRecordVO;
import com.ejianc.business.finance.vo.PayContractVO;
import com.ejianc.business.voucher.api.IVoucherApi;
import com.ejianc.business.voucher.callable.AccplatVoucherCallable;
import com.ejianc.business.voucher.utils.DataConvertUtil;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;

@Service(value="mergeRecordService")
public class MergeRecordServiceImpl
extends BaseServiceImpl<MergeRecordMapper, MergeRecordEntity>
implements IMergeRecordService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String VOUCHER_PARAM = "P-h5UC6769";
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IMergeRecordService mergeRecordService;
    @Autowired
    private IPayRecordService payRecordService;
    @Autowired
    private IPayContractService contractService;
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private IVoucherApi voucherApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "MERGE_RECORD";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MergeRecordVO insertOrUpdate(MergeRecordVO mergeRecordVO) {
        MergeRecordEntity entity = (MergeRecordEntity)((Object)BeanMapper.map((Object)mergeRecordVO, MergeRecordEntity.class));
        BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)mergeRecordVO);
        CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
        if (!billCode.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        entity.setBillCode((String)billCode.getData());
        boolean b = super.saveOrUpdate((Object)entity, false);
        CommonResponse byCode = this.paramConfigApi.getByCode(VOUCHER_PARAM);
        if (byCode.isSuccess() && null != byCode.getData()) {
            ParamRegisterSetVO paramRegisterSetVO = (ParamRegisterSetVO)byCode.getData();
            String valueData = paramRegisterSetVO.getValueData();
            Map recordMap = DataConvertUtil.objToMap((Object)((Object)entity));
            LambdaQueryWrapper payRecordEntityLambdaQueryWrapper = Wrappers.lambdaQuery();
            payRecordEntityLambdaQueryWrapper.eq(PayRecordEntity::getMergeConfirmId, (Object)entity.getId());
            List list = this.payRecordService.list((Wrapper)payRecordEntityLambdaQueryWrapper);
            PayContractEntity contract = (PayContractEntity)((Object)this.contractService.selectById(((PayRecordEntity)((Object)list.get(0))).getPayapplyId()));
            PayContractVO payContractVoucherVO = (PayContractVO)BeanMapper.map((Object)((Object)contract), PayContractVO.class);
            payContractVoucherVO.setId(entity.getId());
            payContractVoucherVO.set_payRecordId(recordMap);
            payContractVoucherVO.setPayMny(BigDecimal.ZERO);
            payContractVoucherVO.getCustomField().put("DLFY", entity.getDLFY());
            if ("\u662f".equals(valueData)) {
                ExecutorService threadPool = Executors.newFixedThreadPool(1);
                String authority = this.request.getHeader("authority");
                if (authority == null) {
                    this.logger.info("request-authority\u4e3a\u7a7a");
                    authority = (String)InvocationInfoProxy.getExtendAttribute((String)"authority");
                }
                try {
                    VoucherParams voucherParams = VoucherParams.newInstance((String)"BT200611000000017", (Long)entity.getOrgId(), (Object)payContractVoucherVO, (SystemCodeEnum)SystemCodeEnum.FINANCE);
                    AccplatVoucherCallable voucherCallable = new AccplatVoucherCallable(this.voucherApi, (IBaseService)this.mergeRecordService, voucherParams, "save", RequestContextHolder.getRequestAttributes(), authority);
                    threadPool.submit(voucherCallable);
                }
                catch (Exception e) {
                    this.logger.error("\u5408\u5e76\u652f\u4ed8\u8bb0\u5f55\u63a8\u9001\u51ed\u8bc1\u5f02\u5e38, ", (Throwable)e);
                }
                finally {
                    threadPool.shutdown();
                }
            }
        }
        MergeRecordVO vo = (MergeRecordVO)BeanMapper.map((Object)((Object)entity), MergeRecordVO.class);
        return vo;
    }
}

