package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.accplat.consts.SystemCodeEnum;
import com.ejianc.business.finance.bean.*;
import com.ejianc.business.finance.service.IPayContractService;
import com.ejianc.business.finance.service.IPayRecordService;
import com.ejianc.business.finance.vo.DeductionVO;
import com.ejianc.business.finance.vo.MergeRecordVO;
import com.ejianc.business.finance.vo.PayContractVO;
import com.ejianc.business.finance.vo.PayReimburseVO;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.business.voucher.api.IVoucherApi;
import com.ejianc.business.voucher.callable.AccplatVoucherCallable;
import com.ejianc.business.voucher.consts.VoucherOptFlag;
import com.ejianc.business.voucher.utils.DataConvertUtil;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.finance.mapper.MergeRecordMapper;
import com.ejianc.business.finance.service.IMergeRecordService;
import org.springframework.web.context.request.RequestContextHolder;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;

/**
 * 合并支付记录实体
 * 
 * @author generator
 * 
 */
@Service("mergeRecordService")
public class MergeRecordServiceImpl extends BaseServiceImpl<MergeRecordMapper, MergeRecordEntity> implements IMergeRecordService {

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    // 是否推送凭证
    private static final String VOUCHER_PARAM = "P-h5UC6769";

    @Autowired
    private IParamConfigApi paramConfigApi;

    @Autowired
    private IMergeRecordService mergeRecordService;
    @Autowired
    private IPayRecordService payRecordService;
    @Autowired
    private IPayContractService contractService;
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private IVoucherApi voucherApi;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String BILL_CODE = "MERGE_RECORD";//此处需要根据实际修改

    @Override
    public MergeRecordVO insertOrUpdate(MergeRecordVO mergeRecordVO) {

        MergeRecordEntity entity = BeanMapper.map(mergeRecordVO, MergeRecordEntity.class);
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), mergeRecordVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        boolean b = super.saveOrUpdate(entity, false);
        CommonResponse<ParamRegisterSetVO> byCode = paramConfigApi.getByCode(VOUCHER_PARAM);
        if (byCode.isSuccess() && null != byCode.getData()) {
            ParamRegisterSetVO paramRegisterSetVO = byCode.getData();
            String valueData = paramRegisterSetVO.getValueData();
            Map<String, Object> recordMap = DataConvertUtil.objToMap(entity);
            LambdaQueryWrapper<PayRecordEntity> payRecordEntityLambdaQueryWrapper = Wrappers.<PayRecordEntity>lambdaQuery();
            payRecordEntityLambdaQueryWrapper.eq(PayRecordEntity::getMergeConfirmId,entity.getId());
            List<PayRecordEntity> list = payRecordService.list(payRecordEntityLambdaQueryWrapper);
            PayContractEntity contract = contractService.selectById(list.get(0).getPayapplyId());
            PayContractVO payContractVoucherVO = BeanMapper.map(contract, PayContractVO.class);
            // 凭证平台依据此来记录了来源单据id，此处来源单据id应该是支付记录id
            payContractVoucherVO.setId(entity.getId());
            payContractVoucherVO.set_payRecordId(recordMap);
            // 如果是第一次支付：1、手动把支付金额置为0，凭证模板以此判断是否第一次支付来生成吊兰费分录
            //一般只合并支付一次  所以默认放0
            payContractVoucherVO.setPayMny(BigDecimal.ZERO);
            payContractVoucherVO.getCustomField().put("DLFY",entity.getDLFY());//覆盖吊篮费用
            if ("是".equals(valueData)) {
                ExecutorService threadPool = Executors.newFixedThreadPool(1);
                String authority = request.getHeader("authority");
                if (authority == null) {
                    logger.info("request-authority为空");
                    authority = (String) InvocationInfoProxy.getExtendAttribute("authority");
                }
                try {
                    VoucherParams voucherParams = VoucherParams.newInstance("BT200611000000017", entity.getOrgId(), payContractVoucherVO, SystemCodeEnum.FINANCE);
                    Callable<CommonResponse> voucherCallable = new AccplatVoucherCallable(voucherApi, mergeRecordService, voucherParams, VoucherOptFlag.SAVE, RequestContextHolder.getRequestAttributes(), authority);
                    threadPool.submit(voucherCallable);
                } catch (Exception e) {
                    logger.error("合并支付记录推送凭证异常, ", e);
                } finally {
                    threadPool.shutdown();
                }

            }
        }

        MergeRecordVO vo = BeanMapper.map(entity, MergeRecordVO.class);
        return vo;
    }
}
