package com.ejianc.business.finance.service.impl;

import com.ejianc.business.finance.bean.PayInvoiceEntity;
import com.ejianc.business.finance.mapper.PayInvoiceMapper;
import com.ejianc.business.finance.service.IPayInvoiceService;
import com.ejianc.business.finance.utils.BigDecimalUtil;
import com.ejianc.business.finance.vo.PayInvoiceVO;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.business.tax.vo.InvoiceReceiveFlagVO;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author yqls
 * @since 2020-06-06
 */
@Service
public class PayInvoiceServiceImpl extends BaseServiceImpl<PayInvoiceMapper, PayInvoiceEntity> implements IPayInvoiceService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IInvoiceApi invoiceApi;


    /**
     * @param voList
     * @param id
     * @description: 保存编辑回写 收票占用金额
     * @return: com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     * @author songlx
     * @date: 2021/8/17
     */
    @Override
    public CommonResponse<String> updateInvoiceUsedMnyBySave(List<PayInvoiceVO> voList, Long id) {
        CommonResponse<String> res = CommonResponse.success();
        QueryParam param = new QueryParam();
        param.getParams().put("payapplyId", new Parameter(QueryParam.EQ, id));
        // 查询关联发票
        List<PayInvoiceEntity> oldInvoiceList = id != null ? this.queryList(param, false) : null;
        Map<Long, BigDecimal> invoiceUpdateMap = new HashMap<>();
        // 新增
        if (CollectionUtils.isNotEmpty(voList)) {
            Map<Long, BigDecimal> oldInvoiceMap = CollectionUtils.isNotEmpty(oldInvoiceList) ? oldInvoiceList.stream().collect(Collectors.toMap(PayInvoiceEntity::getInvoiceId, PayInvoiceEntity::getUsedInvoiceTaxMny)) : new HashMap<>();
            voList.forEach(t -> {
                Long invoiceId = t.getInvoiceId();
                BigDecimal nowUesdInvoiceTaxMny = invoiceUpdateMap.get(invoiceId);
                if ("del".equals(t.getRowState()) && t.getId() != null) {
                    nowUesdInvoiceTaxMny = ComputeUtil.safeAdd(nowUesdInvoiceTaxMny, BigDecimalUtil.convertToMinusNumber(oldInvoiceMap.get(invoiceId)));
                } else {
                    nowUesdInvoiceTaxMny = ComputeUtil.safeAdd(nowUesdInvoiceTaxMny, BigDecimalUtil.safeSub(t.getUsedInvoiceTaxMny(), oldInvoiceMap.get(invoiceId)));
                }
                invoiceUpdateMap.put(invoiceId, nowUesdInvoiceTaxMny);
                oldInvoiceMap.remove(invoiceId);

            });
            if (oldInvoiceMap != null && oldInvoiceMap.size() > 0) {
                for (Map.Entry<Long, BigDecimal> t : oldInvoiceMap.entrySet()) {
                    invoiceUpdateMap.put(t.getKey(), BigDecimalUtil.convertToMinusNumber(t.getValue()));
                }
            }
        } else {
            if (CollectionUtils.isNotEmpty(oldInvoiceList)) {
                oldInvoiceList.forEach(t -> invoiceUpdateMap.put(t.getInvoiceId(), BigDecimalUtil.convertToMinusNumber(t.getUsedInvoiceTaxMny())));
            }
        }
        if (!invoiceUpdateMap.isEmpty()) {
            ArrayList<InvoiceReceiveFlagVO> invoiceReceiveFlagVOS = new ArrayList<>();
            for (Map.Entry<Long, BigDecimal> t : invoiceUpdateMap.entrySet()) {
                InvoiceReceiveFlagVO v = new InvoiceReceiveFlagVO();
                v.setId(t.getKey());
                v.setNowUesdInvoiceTaxMny(t.getValue());
                invoiceReceiveFlagVOS.add(v);
            }
            res = invoiceApi.updateUsedInvoiceMny(invoiceReceiveFlagVOS);
            if (!res.isSuccess()) {
                logger.error("回写收票已使用金额失败：" + res.getMsg());
            }
        }
        return res;
    }

    /**
     * @param ids
     * @description: 申请删除 回写 收票占用金额
     * @return: com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     * @author songlx
     * @date: 2021/8/17
     */
    @Override
    public CommonResponse<String> updateInvoiceUsedMnyByDel(List<Long> ids) {
        QueryParam param = new QueryParam();
        param.getParams().put("payapplyId", new Parameter(QueryParam.IN, ids));
        // 查询关联发票
        List<PayInvoiceEntity> invoiceEntityList = this.queryList(param, false);
        if (CollectionUtils.isNotEmpty(invoiceEntityList)) {
            //收票改为占用方式
            List<InvoiceReceiveFlagVO> updates = new ArrayList<>();
            invoiceEntityList.forEach(t -> {
                InvoiceReceiveFlagVO v = new InvoiceReceiveFlagVO();
                v.setId(t.getInvoiceId());
                v.setNowUesdInvoiceTaxMny(BigDecimalUtil.convertToMinusNumber(t.getUsedInvoiceTaxMny()));
                updates.add(v);
            });
            CommonResponse<String> res = invoiceApi.updateUsedInvoiceMny(updates);
            if (!res.isSuccess()) {
                logger.error("付款申请删除逆回写收票已使用金额报错：" + res.getMsg());
            }
        }
        return CommonResponse.success();
    }
}
