/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.accplat.consts.SystemCodeEnum;
import com.ejianc.business.finance.bean.BidBondDealEntity;
import com.ejianc.business.finance.bean.BidBondEntity;
import com.ejianc.business.finance.mapper.BidBondDealMapper;
import com.ejianc.business.finance.service.IBidBondDealService;
import com.ejianc.business.finance.service.IBidBondService;
import com.ejianc.business.finance.vo.BidBondDealVO;
import com.ejianc.business.voucher.api.IVoucherApi;
import com.ejianc.business.voucher.callable.AccplatVoucherCallable;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;

@Service(value="bidBondDealService")
public class BidBondDealServiceImpl
extends BaseServiceImpl<BidBondDealMapper, BidBondDealEntity>
implements IBidBondDealService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "BIDBOND_DEL";
    @Autowired
    private IVoucherApi voucherApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String VOUCHER_PARAM = "P-h5UC6769";
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private IBidBondDealService service;
    @Autowired
    private IBidBondService bidBondService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BidBondDealVO insertOrUpdate(BidBondDealVO saveOrUpdateVO) {
        ParamRegisterSetVO paramRegisterSetVO;
        String valueData;
        LambdaQueryWrapper lambda;
        BidBondDealEntity entity = (BidBondDealEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, BidBondDealEntity.class));
        if (StringUtils.isEmpty((CharSequence)saveOrUpdateVO.getBillCode())) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        List entities = null;
        if (null != saveOrUpdateVO.getId() && saveOrUpdateVO.getId() > 0L) {
            lambda = new LambdaQueryWrapper();
            lambda.eq(BidBondDealEntity::getBillCode, (Object)saveOrUpdateVO.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
            lambda.ne(BaseEntity::getId, (Object)saveOrUpdateVO.getId());
            entities = super.list((Wrapper)lambda);
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.set(BidBondDealEntity::getDealStatus, (Object)"2");
            super.update((Wrapper)updateWrapper);
            entity.setId(null);
        } else {
            lambda = new LambdaQueryWrapper();
            lambda.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
            lambda.eq(BidBondDealEntity::getBillCode, (Object)saveOrUpdateVO.getBillCode());
            entities = super.list((Wrapper)lambda);
        }
        if (entities != null && entities.size() > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        entity.setDealStatus("1");
        this.service.saveOrUpdate((Object)entity, false);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)entity.getBondId());
        updateWrapper.set(BidBondEntity::getBondStatus, (Object)"1");
        updateWrapper.set(BidBondEntity::getBeginDate, (Object)entity.getBeginDate());
        updateWrapper.set(BidBondEntity::getEndDate, (Object)entity.getEndDate());
        updateWrapper.set(BidBondEntity::getEmployeeId, (Object)entity.getEmployeeId());
        updateWrapper.set(BidBondEntity::getEmployeeName, (Object)entity.getEmployeeName());
        updateWrapper.set(BidBondEntity::getPayMny, (Object)entity.getBondMny());
        updateWrapper.set(BidBondEntity::getDealTime, (Object)entity.getDealTime());
        this.bidBondService.update((Wrapper)updateWrapper);
        CommonResponse byCode = this.paramConfigApi.getByCode(VOUCHER_PARAM);
        if (byCode.isSuccess() && null != byCode.getData() && "\u662f".equals(valueData = (paramRegisterSetVO = (ParamRegisterSetVO)byCode.getData()).getValueData())) {
            ExecutorService threadPool = Executors.newFixedThreadPool(1);
            String authority = this.request.getHeader("authority");
            if (authority == null) {
                this.logger.info("request-authority\u4e3a\u7a7a");
                authority = (String)InvocationInfoProxy.getExtendAttribute((String)"authority");
            }
            try {
                BidBondEntity bidBondEntity = (BidBondEntity)((Object)this.bidBondService.selectById(entity.getBondId()));
                VoucherParams voucherParams = VoucherParams.newInstance((String)"BT202206000002", (Long)bidBondEntity.getOrgId(), (Object)((Object)entity), (SystemCodeEnum)SystemCodeEnum.FINANCE);
                AccplatVoucherCallable voucherCallable = new AccplatVoucherCallable(this.voucherApi, (IBaseService)this.service, voucherParams, "save", RequestContextHolder.getRequestAttributes(), authority);
                threadPool.submit(voucherCallable);
            }
            catch (Exception e) {
                this.logger.error("\u6295\u6807\u4fdd\u8bc1\u91d1\u529e\u7406\u63a8\u9001\u51ed\u8bc1\u5f02\u5e38, ", (Throwable)e);
            }
            finally {
                threadPool.shutdown();
            }
        }
        return (BidBondDealVO)BeanMapper.map((Object)((Object)entity), BidBondDealVO.class);
    }
}

