package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.finance.bean.BondUpBackEntity;
import com.ejianc.business.finance.bean.BondUpDealEntity;
import com.ejianc.business.finance.bean.BondUpEntity;
import com.ejianc.business.finance.service.IBondUpBackService;
import com.ejianc.business.finance.service.IBondUpDealService;
import com.ejianc.business.finance.service.IBondUpService;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;

/**
 * <p>
 * 对上保证金申请审批事件
 * </p>
 *
 * @author sunyj
 * @since 2020-06-04
 */
@Service("bondUp")
public class BondUpBpmServiceImpl implements ICommonBusinessService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBondUpService bondUpService;

    @Autowired
    private IBondUpDealService bondUpDealService;

    @Autowired
    private IBondUpBackService bondUpBackService;

    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state,String billTypeCode) {
        logger.info("进入弃审后回写--- billId:"+billId+"  state:"+state);
        BondUpEntity upEntity = bondUpService.selectById(billId);
        upEntity.setBondStatus("0");
        upEntity.setBackMny(BigDecimal.ZERO);
        upEntity.setPayMny(BigDecimal.ZERO);
        upEntity.setEmployeeId(null);
        upEntity.setEmployeeName(null);
        boolean res = bondUpService.saveOrUpdate(upEntity,false);
        QueryWrapper<BondUpDealEntity> dealWrapper = new QueryWrapper<>();
        dealWrapper.eq("bond_id", billId);
        bondUpDealService.remove(dealWrapper,false);

        QueryWrapper<BondUpBackEntity> backWrapper = new QueryWrapper<>();
        backWrapper.eq("bond_id", billId);
        bondUpBackService.remove(backWrapper,false);
        if(res){
            return CommonResponse.success("回退成功!");
        }else{
            return CommonResponse.error("回退出现异常，请刷新后再试!");
        }
    }

}
