package com.ejianc.business.finance.controller;

import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.List;
import java.util.stream.Collectors;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.finance.bean.PayRecordSettleEntity;
import com.ejianc.business.finance.service.IPayRecordSettleService;
import com.ejianc.business.finance.vo.PayRecordSettleVO;

/**
 * 付款申请记录结算实体
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("payRecordSettle")
public class PayRecordSettleController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private IPayRecordSettleService service;
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PayRecordSettleVO> saveOrUpdate(@RequestBody PayRecordSettleVO saveorUpdateVO) {
    	PayRecordSettleEntity entity = BeanMapper.map(saveorUpdateVO, PayRecordSettleEntity.class);
    	service.saveOrUpdate(entity, false);
    	PayRecordSettleVO vo = BeanMapper.map(entity, PayRecordSettleVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PayRecordSettleVO> queryDetail(Long id) {
    	PayRecordSettleEntity entity = service.selectById(id);
    	PayRecordSettleVO vo = BeanMapper.map(entity, PayRecordSettleVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PayRecordSettleVO> vos) {
        service.removeByIds(vos.stream().map(PayRecordSettleVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PayRecordSettleVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        
        IPage<PayRecordSettleEntity> page = service.queryPage(param,false);
        IPage<PayRecordSettleVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), PayRecordSettleVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

}
