package com.ejianc.business.finance.service.impl;

import com.ejianc.business.accplat.consts.SystemCodeEnum;
import com.ejianc.business.finance.bean.LoadReimburseEntity;
import com.ejianc.business.finance.service.ILoadReimburseService;
import com.ejianc.business.voucher.api.IVoucherApi;
import com.ejianc.business.voucher.callable.AccplatVoucherCallable;
import com.ejianc.business.voucher.consts.VoucherFlag;
import com.ejianc.business.voucher.consts.VoucherOptFlag;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;

import javax.servlet.http.HttpServletRequest;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@Service("loadReimburse")
public class LoadReimburseBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private ILoadReimburseService loadReimburseService;
	@Autowired
	private IBillTypeApi billTypeApi;
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private HttpServletRequest request;
	// 是否推送凭证
	private static final String VOUCHER_PARAM = "P-h5UC6769";
	@Autowired
	private IVoucherApi voucherApi;
	@Autowired
	private IParamConfigApi paramConfigApi;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//成本改造
		logger.info("借款报销审批后事件触发");
		logger.info("billId"+billId);
		LoadReimburseEntity loadReimburseEntity = loadReimburseService.selectById(billId);
		loadReimburseService.costPush(loadReimburseEntity);
		CommonResponse<ParamRegisterSetVO> byCode = paramConfigApi.getByCode(VOUCHER_PARAM);
		if (byCode.isSuccess() && null != byCode.getData()) {
			ParamRegisterSetVO paramRegisterSetVO = byCode.getData();
			String valueData = paramRegisterSetVO.getValueData();
			Long projectId = loadReimburseEntity.getProjectId();
			if (valueData.equals(String.valueOf(projectId)) || "是".equals(valueData)) {
				ExecutorService threadPool = Executors.newFixedThreadPool(1);
				String authority = request.getHeader("authority");
				if (authority == null) {
					logger.info("request-authority为空");
					authority = (String) InvocationInfoProxy.getExtendAttribute("authority");
				}
				try {
					VoucherParams voucherParams = VoucherParams.newInstanceByOrgId("BT200629000000002", loadReimburseEntity, SystemCodeEnum.FINANCE);
					Callable<CommonResponse> voucherCallable = new AccplatVoucherCallable(voucherApi, loadReimburseService, voucherParams, VoucherOptFlag.SAVE, RequestContextHolder.getRequestAttributes(), authority);
					threadPool.submit(voucherCallable);
				} catch (Exception e) {
					logger.error("备用金报销推送凭证异常, ", e);
				} finally {
					threadPool.shutdown();
				}

			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TO DO 结算单是否被其他引用
		CommonResponse<String>  res = billTypeApi.checkQuote(billTypeCode,billId);
		if(res.isSuccess()) {//单据未被下游单据引用
		}else{
			return CommonResponse.error(res.getMsg());
		}
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//成本改造
		//删除成本中心数据, 更新关联状态为未关联
		loadReimburseService.pullCost(billId);
		LoadReimburseEntity entity = loadReimburseService.selectById(billId);
		//更新凭证恢复到初始态
		if (!VoucherFlag.NO_NEED.equals(entity.getVoucherFlag())) {
			//有凭证则删除
			ExecutorService threadPool = Executors.newFixedThreadPool(1);
			String authority = request.getHeader("authority");
			if (authority == null) {
				logger.info("request-authority为空");
				authority = (String) InvocationInfoProxy.getExtendAttribute("authority");
			}
			try {
				VoucherParams voucherParams = VoucherParams.newInstanceByOrgId("BT200629000000002", entity, SystemCodeEnum.FINANCE);
				Callable<CommonResponse> voucherCallable = new AccplatVoucherCallable(voucherApi, loadReimburseService, voucherParams, VoucherOptFlag.DEL, RequestContextHolder.getRequestAttributes(), authority);
				threadPool.submit(voucherCallable);
			} catch (Exception e) {
				logger.error("备用金报销撤回凭证异常, ", e);
			} finally {
				threadPool.shutdown();
			}
		}
		//TODO
		return CommonResponse.success();
	}

}
