/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.finance.bean.PayInvoiceEntity;
import com.ejianc.business.finance.service.IPayInvoiceService;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/payInvoice"})
public class PayInvoiceController {
    @Autowired
    private IPayInvoiceService invoiceService;
    @Autowired
    private IInvoiceApi invoiceApi;
    @Autowired
    private IOrgApi orgApi;

    @RequestMapping(value={"/refer"})
    @ResponseBody
    public CommonResponse<JSONObject> refer(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        List invoiceList;
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("invoiceNumber");
        queryParam.getFuzzyFields().add("invoiceCode");
        queryParam.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            JSONObject obj = JSONObject.parseObject((String)condition);
            if (condition.contains("orgId")) {
                queryParam.getParams().put("orgId", new Parameter("eq", (Object)obj.getLong("orgId")));
            }
            if (condition.contains("contractId")) {
                queryParam.getParams().put("contractId", new Parameter("eq", (Object)obj.getLong("contractId")));
            }
        }
        if (!(invoiceList = this.invoiceService.list((Wrapper)new QueryWrapper().eq((Object)"use_flag", (Object)2))).isEmpty()) {
            queryParam.getParams().put("id", new Parameter("not_in", invoiceList.stream().map(PayInvoiceEntity::getInvoiceId).collect(Collectors.toList())));
        }
        CommonResponse page = this.invoiceApi.invoiceReceiveRef(queryParam);
        return page;
    }
}

