/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.finance.bean.PayReimburseEntity;
import com.ejianc.business.finance.bean.ReimburseShareDetailEntity;
import com.ejianc.business.finance.bean.ReimburseShareEntity;
import com.ejianc.business.finance.service.IPayReimburseService;
import com.ejianc.business.finance.service.IReimburseShareDetailService;
import com.ejianc.business.finance.service.IReimburseShareService;
import com.ejianc.business.finance.vo.PayReimburseVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="reimburseShare")
public class ReimburseShareBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String REIM_PAYAPPLY_BILL_CODE = "REIM_PAYAPPLY";
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IPayReimburseService payReimburseService;
    @Autowired
    private IReimburseShareService service;
    @Autowired
    private IReimburseShareDetailService reimburseShareDetailService;
    @Autowired
    private IBillCodeApi billCodeApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ReimburseShareEntity reimburseShareEntity = (ReimburseShareEntity)((Object)this.service.selectById(billId));
        if (reimburseShareEntity != null) {
            this.logger.info("\u7d2f\u52a0\u56de\u5199\u5bf9\u5e94\u8d39\u7528\u62a5\u9500\u4fe1\u606f:" + JSONObject.toJSONString((Object)((Object)reimburseShareEntity)));
            CommonResponse<PayReimburseVO> payReimburseVOCommonResponse = this.payReimburseService.updateShareMoney(reimburseShareEntity.getReimburseId(), reimburseShareEntity.getSumShareMny());
            if (!payReimburseVOCommonResponse.isSuccess()) {
                CommonResponse.success((String)payReimburseVOCommonResponse.getMsg());
            }
            this.logger.info("\u7d2f\u52a0\u56de\u5199\u5bf9\u5e94\u8d39\u7528\u62a5\u9500\u4fe1\u606f\u7ed3\u679c:" + payReimburseVOCommonResponse.isSuccess());
            List<ReimburseShareDetailEntity> reimburseShareDetailList = reimburseShareEntity.getReimburseShareDetailList();
            if (CollectionUtils.isNotEmpty(reimburseShareDetailList)) {
                for (ReimburseShareDetailEntity entity : reimburseShareDetailList) {
                    PayReimburseEntity payReimburseEntity = new PayReimburseEntity();
                    payReimburseEntity.setDependOnProject("1");
                    payReimburseEntity.setOrgId(entity.getOrgId());
                    payReimburseEntity.setOrgName(entity.getOrgName());
                    payReimburseEntity.setOrgCode(entity.getOrgCode());
                    payReimburseEntity.setProjectId(entity.getProjectId());
                    payReimburseEntity.setProjectName(entity.getProjectName());
                    payReimburseEntity.setApplyMny(entity.getBodyShareMny());
                    payReimburseEntity.setApplyMnyCn(entity.getBodyShareMnyCn());
                    payReimburseEntity.setApplyMnyCn(entity.getBodyShareMnyCn());
                    payReimburseEntity.setApplyTime(reimburseShareEntity.getBliDate());
                    payReimburseEntity.setIsShareFlag(1);
                    payReimburseEntity.setPayMny(entity.getBodyShareMny());
                    payReimburseEntity.setBillState(1);
                    payReimburseEntity.setCreateTime(entity.getCreateTime());
                    payReimburseEntity.setCreateUserCode(entity.getCreateUserCode());
                    payReimburseEntity.setFeeType(reimburseShareEntity.getFeeType());
                    payReimburseEntity.setPayType(1);
                    payReimburseEntity.setProportionFlag("0");
                    payReimburseEntity.setRelationFlag("0");
                    payReimburseEntity.setPayReason(reimburseShareEntity.getReimburseReason());
                    payReimburseEntity.setApproveTime(new Date());
                    payReimburseEntity.setApplyUserId(entity.getReimburseId());
                    payReimburseEntity.setApplyUserName(reimburseShareEntity.getEmployeeName());
                    payReimburseEntity.setEmployeeId(reimburseShareEntity.getEmployeeId());
                    payReimburseEntity.setEmployeeName(reimburseShareEntity.getEmployeeName());
                    Long tenantId = InvocationInfoProxy.getTenantid();
                    CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(REIM_PAYAPPLY_BILL_CODE, tenantId);
                    if (!billCode.isSuccess()) {
                        throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                    }
                    payReimburseEntity.setBillCode((String)billCode.getData());
                    this.logger.info(" \u63a8\u9001\u4fe1\u606f\u53c2\u6570:" + JSONObject.toJSONString((Object)((Object)payReimburseEntity)));
                    boolean b = this.payReimburseService.saveOrUpdate((Object)payReimburseEntity);
                    this.logger.info(" \u63a8\u9001\u4fe1\u606f\u7ed3\u679c:" + b);
                    Long reimburseId = payReimburseEntity.getId();
                    LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                    updateWrapper.eq(BaseEntity::getId, (Object)entity.getId());
                    updateWrapper.set(ReimburseShareDetailEntity::getReimburseId, (Object)reimburseId);
                    this.reimburseShareDetailService.update((Wrapper)updateWrapper);
                }
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        ReimburseShareEntity reimburseShareEntity = (ReimburseShareEntity)((Object)this.service.selectById(billId));
        this.logger.info("\u51cf\u5c11\u56de\u5199\u5bf9\u5e94\u8d39\u7528\u62a5\u9500\u4fe1\u606f:" + JSONObject.toJSONString((Object)((Object)reimburseShareEntity)));
        CommonResponse<PayReimburseVO> payReimburseVOCommonResponse = this.payReimburseService.updateShareMoney(reimburseShareEntity.getReimburseId(), ComputeUtil.safeSub((BigDecimal)BigDecimal.ZERO, (BigDecimal)reimburseShareEntity.getSumShareMny()));
        if (!payReimburseVOCommonResponse.isSuccess()) {
            return CommonResponse.error((String)payReimburseVOCommonResponse.getMsg());
        }
        List<ReimburseShareDetailEntity> reimburseShareDetailList = reimburseShareEntity.getReimburseShareDetailList();
        if (CollectionUtils.isNotEmpty(reimburseShareDetailList)) {
            List reimburseIds = reimburseShareDetailList.stream().map(ReimburseShareDetailEntity::getReimburseId).collect(Collectors.toList());
            this.payReimburseService.removeByIds(reimburseIds);
        }
        return CommonResponse.success();
    }
}

