package com.ejianc.business.finance.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.bean.LoadApplyEntity;
import com.ejianc.business.finance.bean.PayRecordEntity;
import com.ejianc.business.finance.service.ILoadApplyService;
import com.ejianc.business.finance.service.IPayRecordService;
import com.ejianc.business.finance.vo.LoadApplyVO;
import com.ejianc.business.finance.vo.PayRecordVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 借款申请
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("loadApply")
public class LoadApplyController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private ILoadApplyService service;

    @Autowired
    private IPayRecordService payRecordService;
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<LoadApplyVO> saveOrUpdate(@RequestBody LoadApplyVO saveorUpdateVO) {
    	LoadApplyVO vo = service.insertOrUpdate(saveorUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<LoadApplyVO> queryDetail(Long id) {
    	LoadApplyEntity entity = service.selectById(id);
        LoadApplyVO vo = BeanMapper.map(entity, LoadApplyVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("payapplyId", new Parameter(QueryParam.EQ, entity.getId()));
        queryParam.getOrderMap().put("createTime", "desc");
        // 查询付款记录
        List<PayRecordEntity> recordList = payRecordService.queryList(queryParam);
        vo.setRecordList(BeanMapper.mapList(recordList, PayRecordVO.class));

        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<LoadApplyVO> vos) {
        service.removeByIds(vos.stream().map(LoadApplyVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<LoadApplyEntity>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("applyEmployeeName");

        if (!service.canViewAll()) {
            ComplexParam c1 = new ComplexParam();
            c1.setLogic(ComplexParam.AND);
            ComplexParam c2 = new ComplexParam();
            c2.setLogic(ComplexParam.OR);
            c2.getParams().put("applyEmployeeId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getEmployeeId()));
            c1.getComplexParams().add(c2);
            ComplexParam c3 = new ComplexParam();
            c3.setLogic(ComplexParam.OR);
            c3.getParams().put("employeeId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getEmployeeId()));
            c1.getComplexParams().add(c3);
            param.getComplexParams().add(c1);
        }
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        return CommonResponse.success("查询列表数据成功！",service.queryPage(param,false));
    }

    /**
     * @Description queryList 查询个人借款台账列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryUserReportList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryUserReportList(@RequestBody QueryParam param) {
        com.alibaba.fastjson.JSONObject page = new com.alibaba.fastjson.JSONObject();
        page.put("records", service.queryUserReport());
        return CommonResponse.success("查询列表数据成功！",page);
    }

    /**
     * @Description queryList 查询个人借款台账列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryAllReportList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryAllReportList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("org_name");
        fuzzyFields.add("applyEmployeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter("eq", InvocationInfoProxy.getTenantid()));
        List<Long> commonOrgIds = new ArrayList<>();
        List<Integer> billstate = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if(!orgListResp.isSuccess()) {
            return CommonResponse.success("列表查询失败, 查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
//        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
//        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
//        param.getParams().put("bill_state",new Parameter(QueryParam.IN,billstate));
        Page<LoadApplyVO> page = new Page<>((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<LoadApplyVO> list = service.queryAllReport(page,wrapper);
        com.alibaba.fastjson.JSONObject res = new com.alibaba.fastjson.JSONObject();
        res.put("records", list);
        res.put("total", page.getTotal());
        res.put("current", page.getCurrent());
        res.put("size", page.getSize());
        res.put("pages", page.getPages());
        return CommonResponse.success("查询列表数据成功！",res);
    }


    /**
     * @Description queryList 查询台账列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryReportList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<LoadApplyEntity>> queryReportList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("applyEmployeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<Long> commonOrgIds = new ArrayList<>();
        List<Integer> billstate = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if(!orgListResp.isSuccess()) {
            return CommonResponse.success("列表查询失败, 查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("bill_state",new Parameter(QueryParam.IN,billstate));
        return CommonResponse.success("查询列表数据成功！",service.queryPage(param,false));
    }
    @RequestMapping(value = "/queryApproveList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<LoadApplyVO>> queryApproveList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("applyEmployeeName");

        param.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<LoadApplyEntity> entityIPage = service.queryPage(param, false);
        IPage<LoadApplyVO> convert = entityIPage.convert(u -> {
            LoadApplyVO loadApplyVO = new LoadApplyVO();
            BeanUtils.copyProperties(u, loadApplyVO);
            return loadApplyVO;
        });
        convert.getRecords().forEach(vo -> {
            if (null != vo.getApplyMny()) {
                vo.setUnpaidMny(vo.getApplyMny().subtract(vo.getPayMny() == null ? BigDecimal.ZERO : vo.getPayMny()));
            }
        });
        return CommonResponse.success("查询列表数据成功！",convert);
    }
    /**
     * @Description querySurplusMny 查询剩余借款
     * @param orgId,type=1查询审批通过 =0不过滤状态
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/querySurplusMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> querySurplusMny(Long rebid,Long backid,Long orgId,int type, String applyEmployeeId) {
        JSONObject json = new JSONObject();
        if(null!=orgId){
            json.put("surplusMny",service.querySurplusMny(rebid,backid,orgId,type,applyEmployeeId));
        }else{
            json.put("surplusMny",BigDecimal.ZERO);
        }
        return CommonResponse.success("查询数据成功！",json);
    }
    /**
     * 查询收款账户信息
     * @param queryParam
     * @return
     */
    @RequestMapping(value = "/queryReceiveInfo", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<LoadApplyVO> queryReceiveInfo(QueryParam queryParam) {
        queryParam.getParams().put("applyEmployeeId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getEmployeeId()));
        //已生效状态的单据
        queryParam.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
        queryParam.getOrderMap().put("createTime", QueryParam.DESC);
        List<LoadApplyEntity> entityList = service.queryList(queryParam,false);
        LoadApplyVO backVO = !entityList.isEmpty() ? BeanMapper.map( entityList.get(0), LoadApplyVO.class) : new LoadApplyVO();
        return CommonResponse.success("查询数据成功！", backVO);
    }
    /**
     * @Description queryPrint 查询打印详情
     * @param id
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryPrint", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryPrint(Long id) {
        JSONObject json = new JSONObject();
        json.put("LoadApply",service.selectById(id));
        return CommonResponse.success("查询打印数据成功！",json);
    }

    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List<LoadApplyVO> list = new ArrayList<>();
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        param.setPageIndex(1);
        param.setPageSize(-1);
        if (!service.canViewAll()) {
            ComplexParam c1 = new ComplexParam();
            c1.setLogic(ComplexParam.AND);
            ComplexParam c2 = new ComplexParam();
            c2.setLogic(ComplexParam.OR);
            c2.getParams().put("applyEmployeeId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getEmployeeId()));
            c1.getComplexParams().add(c2);
            ComplexParam c3 = new ComplexParam();
            c3.setLogic(ComplexParam.OR);
            c3.getParams().put("employeeId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getEmployeeId()));
            c1.getComplexParams().add(c3);
            param.getComplexParams().add(c1);
        }
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<LoadApplyEntity> pageData= service.queryPage(param,false);
        if(CollectionUtils.isNotEmpty(pageData.getRecords())){
            list = BeanMapper.mapList(pageData.getRecords(), LoadApplyVO.class);
        }
            list.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            });
            Map<String, Object> beans = new HashMap<>();
            beans.put("records", list);
            ExcelExport.getInstance().export("loadApplyExport.xlsx", beans, response);
    }
    @RequestMapping(value = "/excelExportApproveList", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportApproveList(@RequestBody QueryParam param, HttpServletResponse response) {
        List<LoadApplyVO> list = new ArrayList<>();
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("applyEmployeeName");

        param.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.setPageIndex(0);
        param.setPageSize(-1);
        IPage<LoadApplyEntity> entityIPage = service.queryPage(param, false);
        if(CollectionUtils.isNotEmpty(entityIPage.getRecords())){
            list = BeanMapper.mapList(entityIPage.getRecords(), LoadApplyVO.class);
        }
            list.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
                vo.setUnpaidMny(vo.getApplyMny().subtract(vo.getPayMny() == null ? BigDecimal.ZERO : vo.getPayMny()));
            });
            Map<String, Object> beans = new HashMap<>();
            beans.put("records", list);
            ExcelExport.getInstance().export("loadApplyExportApprove.xlsx", beans, response);
    }

    @RequestMapping(value = "/excelExportReport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportReport(@RequestBody QueryParam param, HttpServletResponse response) {
        List<LoadApplyVO> list = new ArrayList<>();
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("applyEmployeeName");
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<Long> commonOrgIds = new ArrayList<>();
        List<Integer> billstate = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if(!orgListResp.isSuccess()) {
           throw new BusinessException("列表查询失败, 查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("bill_state",new Parameter(QueryParam.IN,billstate));
        IPage<LoadApplyEntity> pageData= service.queryPage(param,false);
        if(CollectionUtils.isNotEmpty(pageData.getRecords())){
            list = BeanMapper.mapList(pageData.getRecords(), LoadApplyVO.class);
        }
            list.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            });
            Map<String, Object> beans = new HashMap<>();
            beans.put("records", list);
            ExcelExport.getInstance().export("loadApplyExport.xlsx", beans, response);
    }

    @RequestMapping(value = "/excelExportUserReport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportUserReport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<LoadApplyVO> list = service.queryUserReport();
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("loadAllReportExport.xlsx", beans, response);
    }

    @RequestMapping(value = "/excelExportAllReports", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportAllReports(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("applyEmployeeName");
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter("eq", InvocationInfoProxy.getTenantid()));
        List<Long> commonOrgIds = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            throw new BusinessException("列表查询失败, 查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        Page<LoadApplyVO> page = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<LoadApplyVO> list = service.queryAllReport(page, wrapper);
        list.forEach(vo -> {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
        });
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("loadAllReportExport.xlsx", beans, response);
    }

    /**
     * @param vo
     * @description: 更新是否含有发票
     * @return: com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.finance.vo.PayContractVO>
     * @author jiangyikai
     * @date: 2022/7/22
     */
    @RequestMapping(value = "/updateInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<LoadApplyVO> updateInfo(@RequestBody LoadApplyVO vo) {
        if (vo.getId() != null && vo.getInvoiceFlag() != null) {
            //更新是否含有发票
            LambdaUpdateWrapper<LoadApplyEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(LoadApplyEntity::getId, vo.getId());
            updateWrapper.set(LoadApplyEntity::getInvoiceFlag, vo.getInvoiceFlag());
            service.update(updateWrapper);
        }
        return CommonResponse.success("修改成功！", vo);
    }
}
