package com.ejianc.business.finance.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.finance.bean.LoadApplyEntity;
import com.ejianc.business.finance.service.ILoadApplyService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Controller
@RequestMapping("/PojectPetty")
public class PojectPettyController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private ILoadApplyService service;
    @RequestMapping(value = "/queryPoject", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<LoadApplyEntity>> queryPoject(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                               String condition,
                                                               String searchObject,
                                                               String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("applyEmployeeName");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if(null != conditionMap.get("projectId")) {
                Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                param.getParams().put("projectId",new Parameter(QueryParam.EQ,projectId));
            }
        }
        //过滤没审核通过的
        List<Integer> billstate = new ArrayList<>();
        //已提交 已通过 1 3
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("bill_state",new Parameter(QueryParam.IN,billstate));
        System.out.println(billstate);
        IPage<LoadApplyEntity> page = service.queryPage(param,false);
        return CommonResponse.success("查询参照数据成功！",page);
    }

}
