package com.ejianc.business.finance.controller;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.bean.ProjectCapitalSetCostEntity;
import com.ejianc.business.finance.bean.ProjectCapitalSetEntity;
import com.ejianc.business.finance.service.IProjectCapitalSetCostService;
import com.ejianc.business.finance.service.IProjectCapitalSetService;
import com.ejianc.business.finance.vo.ProjectCapitalSetCostVO;
import com.ejianc.business.finance.vo.ProjectCapitalSetVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;

/**
 * @Author liyongjia
 * @Date 2021/5/11
 * @Description ProjectCapitalSetController
 */

@Controller
@RequestMapping("/projectCapitalSet/")
public class ProjectCapitalSetController {    
	private static Logger logger = LoggerFactory.getLogger(ProjectCapitalSetController.class);

    @Autowired
    IProjectCapitalSetService projectCapitalSetService;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IProjectApi iProjectApi;
    @Autowired
    private IProjectCapitalSetCostService iProjectCapitalSetCostService;
    
    /**
     * @Author liyongjia
     * @Date 2021/5/11  保存修改
     * @Description saveOrUpdate
     * @Param [vo]
     * @Return 
     */
    @RequestMapping(value = "saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProjectCapitalSetVO> saveOrUpdate(@RequestBody ProjectCapitalSetVO vo) {
    	//检验项目是否唯一，若存在则不能新增
    	checkProject(vo);
        ProjectCapitalSetEntity entity = BeanMapper.map(vo, ProjectCapitalSetEntity.class);
		
        projectCapitalSetService.saveOrUpdate(entity,false);
        ProjectCapitalSetVO backVo = BeanMapper.map(entity, ProjectCapitalSetVO.class);
        return CommonResponse.success("保存或修改单据成功！",backVo);
    }
    
    public void checkProject(ProjectCapitalSetVO vo) {
		QueryParam queryParam = new QueryParam();
		queryParam.getParams().put("projectDepartmentId", new Parameter(QueryParam.EQ,vo.getProjectDepartmentId()));
		if(vo.getId()!=null){
			queryParam.getParams().put("id", new Parameter(QueryParam.NE,vo.getId()));
		}
		List<ProjectCapitalSetEntity> list = projectCapitalSetService.queryList(queryParam, false);
		if(list!=null&&list.size()>0){
			//已存在，不允许修改
			throw new BusinessException("项目已存在，请重新选择项目");
		}
    }
    
    /**
     * @Author liyongjia
     * @Date 2021/5/11 查询详情
     * @Description queryDetail
     * @Param [id]
     * @Return 
     */
    @RequestMapping(value = "queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProjectCapitalSetVO> queryDetail(Long id, HttpServletRequest request) {
        ProjectCapitalSetEntity entity = projectCapitalSetService.selectById(id);
        ProjectCapitalSetVO vo = BeanMapper.map(entity, ProjectCapitalSetVO.class);
        CommonResponse<JSONObject> inAndOut = projectCapitalSetService.queryIncoemAndExpendByProjectId(vo.getProjectId(), request);
        if(inAndOut.isSuccess()){
			JSONObject dataresultIncoemAndExpend = inAndOut.getData();
			if(dataresultIncoemAndExpend.get("incomeTaxRate")!=null){
				dataresultIncoemAndExpend.put("incomeTaxRate", dataresultIncoemAndExpend.getBigDecimal("incomeTaxRate").divide(new BigDecimal(100.0)));
			}
        	if(vo.getProjectCapitalSetList()!=null&&vo.getProjectCapitalSetList().size()>0){
        		List<ProjectCapitalSetCostVO> list = vo.getProjectCapitalSetList();
        		BigDecimal otherMoney = new BigDecimal(0);
        		for(ProjectCapitalSetCostVO cost : list){
        			if("value".equals(cost.getDataType())){
        				if("add".equals(cost.getAddOrDelete())){
        					if(cost.getValueOrFormula()!=null){
        						BigDecimal valueOrFormula = new BigDecimal(cost.getValueOrFormula());
        						otherMoney = otherMoney.add(valueOrFormula);
                				cost.setAmount(valueOrFormula);
        					}else{
        						cost.setAmount(new BigDecimal(0));
        					}
        				}else if("delete".equals(cost.getAddOrDelete())){
        					if(cost.getValueOrFormula()!=null){
        						BigDecimal valueOrFormula = new BigDecimal(cost.getValueOrFormula());
        						otherMoney = otherMoney.subtract(valueOrFormula);
                				cost.setAmount(new BigDecimal(0).subtract(valueOrFormula));
        					}else{
        						cost.setAmount(new BigDecimal(0));
        					}
        				}
        			}else{
        				if(cost.getFormula()!=null){
        					String evalq = cost.getFormula();
        					for (String key : dataresultIncoemAndExpend.keySet()) {
        						String value = "0";
                                value = dataresultIncoemAndExpend.getString(key)!=null?dataresultIncoemAndExpend.getString(key):"0";
                                evalq = evalq.replaceAll(key, value);
                            }
        					
        					ScriptEngineManager manager = new ScriptEngineManager();
        					ScriptEngine se = manager.getEngineByName("js");
        					BigDecimal money = new BigDecimal(0);
							try {
								money = new BigDecimal( (Double) se.eval(evalq));
							} catch (ScriptException e) {
								e.printStackTrace();
							}
        					if("delete".equals(cost.getAddOrDelete())){
        						money = new BigDecimal(0).subtract(money);
        					}
    						cost.setAmount(money);
    						otherMoney = otherMoney.add(money);
        				}else{
    						cost.setAmount(new BigDecimal(0));
        				}
        			}
        		}
                BigDecimal receiveMoney = dataresultIncoemAndExpend.getBigDecimal("receiveMoney")!=null?dataresultIncoemAndExpend.getBigDecimal("receiveMoney"):new BigDecimal(0);
                BigDecimal payMoney = dataresultIncoemAndExpend.getBigDecimal("payMoney")!=null?dataresultIncoemAndExpend.getBigDecimal("payMoney"):new BigDecimal(0);
                vo.setProjectIncome(receiveMoney == null ? BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP) : receiveMoney);
                vo.setProjectExpenditure(payMoney == null ? BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP) : payMoney);
                BigDecimal availableBalance = receiveMoney.subtract(payMoney).add(otherMoney);
            	vo.setOther(otherMoney);
            	vo.setAvailableBalance(availableBalance);
        	}
        }else{
        	vo.setProjectIncome(BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP));
        	vo.setProjectExpenditure(BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP));
        	vo.setOther(BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP));
        	vo.setAvailableBalance(BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP));
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Author liyongjia
     * @Date 2021/5/11 查询详情
     * @Description queryList
     * @Param [id]
     * @Return IPage<ProjectCapitalSetVO>
     */
    @RequestMapping(value = "queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProjectCapitalSetVO>> queryList(@RequestBody QueryParam param, HttpServletRequest request) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        /** 数据隔离 本下 */
        List<Long> orgIds = iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        param.getParams().put("projectDepartmentId",new Parameter(QueryParam.IN,orgIds));
        IPage<ProjectCapitalSetVO> page = projectCapitalSetService.queryForList(param,false);
        if(page.getRecords()!=null&&page.getRecords().size()>0){
            List<Long> projectIds = new ArrayList<>();
        	for(ProjectCapitalSetVO vo : page.getRecords()){
        		projectIds.add(vo.getProjectId());
        	}
        	Map<Long, JSONObject> projectCapital = projectCapitalSetService.queryIncoemAndExpendByProjectIds(projectIds,request);

        	for(ProjectCapitalSetVO vo : page.getRecords()){
        		JSONObject dataresultIncoemAndExpend = projectCapital.get(vo.getProjectId());
        		if(dataresultIncoemAndExpend.get("incomeTaxRate")!=null){
					dataresultIncoemAndExpend.put("incomeTaxRate", dataresultIncoemAndExpend.getBigDecimal("incomeTaxRate").divide(new BigDecimal(100.0)));
				}
                BigDecimal receiveMoney = dataresultIncoemAndExpend.getBigDecimal("receiveMoney")!=null?dataresultIncoemAndExpend.getBigDecimal("receiveMoney"):new BigDecimal(0);
                BigDecimal payMoney = dataresultIncoemAndExpend.getBigDecimal("payMoney")!=null?dataresultIncoemAndExpend.getBigDecimal("payMoney"):new BigDecimal(0);
                vo.setProjectIncome(receiveMoney == null ? BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP) : receiveMoney);
                vo.setProjectExpenditure(payMoney == null ? BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP) : payMoney);
                
				QueryWrapper<ProjectCapitalSetCostEntity> queryWrapper = new QueryWrapper<>();
				queryWrapper.eq("project_capital_set_id", vo.getId());
				queryWrapper.eq("dr", 0);
				List<ProjectCapitalSetCostEntity> projectCapitalSetList = iProjectCapitalSetCostService.list(queryWrapper);
            	if(projectCapitalSetList!=null&&projectCapitalSetList.size()>0){
            		BigDecimal otherMoney = new BigDecimal(0);
            		for(ProjectCapitalSetCostEntity cost : projectCapitalSetList){
            			if("value".equals(cost.getDataType())){
            				if("add".equals(cost.getAddOrDelete())){
            					if(cost.getValueOrFormula()!=null){
            						BigDecimal valueOrFormula = new BigDecimal(cost.getValueOrFormula());
            						otherMoney = otherMoney.add(valueOrFormula);
                    				cost.setAmount(valueOrFormula);
            					}else{
            						cost.setAmount(new BigDecimal(0));
            					}
            				}else if("delete".equals(cost.getAddOrDelete())){
            					if(cost.getValueOrFormula()!=null){
            						BigDecimal valueOrFormula = new BigDecimal(cost.getValueOrFormula());
            						otherMoney = otherMoney.subtract(valueOrFormula);
                    				cost.setAmount(new BigDecimal(0).subtract(valueOrFormula));
            					}else{
            						cost.setAmount(new BigDecimal(0));
            					}
            				}
            			}else{
            				if(cost.getFormula()!=null){
            					String evalq = cost.getFormula();
            					for (String key : dataresultIncoemAndExpend.keySet()) {
            						String value = "0";
                                    value = dataresultIncoemAndExpend.getString(key)!=null?dataresultIncoemAndExpend.getString(key):"0";
                                    evalq = evalq.replaceAll(key, value);
                                }
            					
            					ScriptEngineManager manager = new ScriptEngineManager();
            					ScriptEngine se = manager.getEngineByName("js");
            					BigDecimal money = new BigDecimal(0);
								try {
									money = new BigDecimal( (Double) se.eval(evalq));
								} catch (ScriptException e) {
									e.printStackTrace();
								}
            					if("delete".equals(cost.getAddOrDelete())){
            						money = new BigDecimal(0).subtract(money);
            					}
        						cost.setAmount(money);
        						otherMoney = otherMoney.add(money);
            				}else{
        						cost.setAmount(new BigDecimal(0));
            				}
            			}
            		}
                    BigDecimal availableBalance = receiveMoney.subtract(payMoney).add(otherMoney);
                	vo.setOther(otherMoney);
                	vo.setAvailableBalance(availableBalance);
            	}else{
                    BigDecimal availableBalance = receiveMoney.subtract(payMoney);
                	vo.setOther(new BigDecimal(0));
                	vo.setAvailableBalance(availableBalance);
            	}
        	}
        }
        return CommonResponse.success("查询列表数据成功！",page);
    }

	/**
	 * excel导出
	 *
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/excelExport", method = RequestMethod.POST)
	@ResponseBody
	public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response, HttpServletRequest request) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("projectName");
        /** 数据隔离 本下 */
        List<Long> orgIds = iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        queryParam.getParams().put("projectDepartmentId",new Parameter(QueryParam.IN,orgIds));
        List<ProjectCapitalSetEntity> list = projectCapitalSetService.queryList(queryParam,false);
        if(list!=null&&list.size()>0){
            List<Long> projectIds = new ArrayList<>();
        	for(ProjectCapitalSetEntity entity : list){
        		projectIds.add(entity.getProjectId());
        	}
        	Map<Long, JSONObject> projectCapital = projectCapitalSetService.queryIncoemAndExpendByProjectIds(projectIds,request);

        	for(ProjectCapitalSetEntity entity : list){
        		JSONObject dataresultIncoemAndExpend = projectCapital.get(entity.getProjectId());
				if(dataresultIncoemAndExpend.get("incomeTaxRate")!=null){
					dataresultIncoemAndExpend.put("incomeTaxRate", dataresultIncoemAndExpend.getBigDecimal("incomeTaxRate").divide(new BigDecimal(100.0)));
				}
                BigDecimal receiveMoney = dataresultIncoemAndExpend.getBigDecimal("receiveMoney")!=null?dataresultIncoemAndExpend.getBigDecimal("receiveMoney"):new BigDecimal(0);
                BigDecimal payMoney = dataresultIncoemAndExpend.getBigDecimal("payMoney")!=null?dataresultIncoemAndExpend.getBigDecimal("payMoney"):new BigDecimal(0);
                entity.setProjectIncome(receiveMoney == null ? BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP) : receiveMoney);
                entity.setProjectExpenditure(payMoney == null ? BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP) : payMoney);
                
				QueryWrapper<ProjectCapitalSetCostEntity> queryWrapper = new QueryWrapper<>();
				queryWrapper.eq("project_capital_set_id", entity.getId());
				queryWrapper.eq("dr", 0);
				List<ProjectCapitalSetCostEntity> projectCapitalSetList = iProjectCapitalSetCostService.list(queryWrapper);
            	if(projectCapitalSetList!=null&&projectCapitalSetList.size()>0){
            		BigDecimal otherMoney = new BigDecimal(0);
            		for(ProjectCapitalSetCostEntity cost : projectCapitalSetList){
            			if("value".equals(cost.getDataType())){
            				if("add".equals(cost.getAddOrDelete())){
            					if(cost.getValueOrFormula()!=null){
            						BigDecimal valueOrFormula = new BigDecimal(cost.getValueOrFormula());
            						otherMoney = otherMoney.add(valueOrFormula);
                    				cost.setAmount(valueOrFormula);
            					}else{
            						cost.setAmount(new BigDecimal(0));
            					}
            				}else if("delete".equals(cost.getAddOrDelete())){
            					if(cost.getValueOrFormula()!=null){
            						BigDecimal valueOrFormula = new BigDecimal(cost.getValueOrFormula());
            						otherMoney = otherMoney.subtract(valueOrFormula);
                    				cost.setAmount(new BigDecimal(0).subtract(valueOrFormula));
            					}else{
            						cost.setAmount(new BigDecimal(0));
            					}
            				}
            			}else{
            				if(cost.getFormula()!=null){
            					String evalq = cost.getFormula();
            					for (String key : dataresultIncoemAndExpend.keySet()) {
            						String value = "0";
                                    value = dataresultIncoemAndExpend.getString(key)!=null?dataresultIncoemAndExpend.getString(key):"0";
                                    evalq = evalq.replaceAll(key, value);
                                }
            					
            					ScriptEngineManager manager = new ScriptEngineManager();
            					ScriptEngine se = manager.getEngineByName("js");
            					BigDecimal money = new BigDecimal(0);
								try {
									money = new BigDecimal( (Double) se.eval(evalq));
								} catch (ScriptException e) {
									e.printStackTrace();
								}
            					if("delete".equals(cost.getAddOrDelete())){
            						money = new BigDecimal(0).subtract(money);
            					}
        						cost.setAmount(money);
        						otherMoney = otherMoney.add(money);
            				}else{
        						cost.setAmount(new BigDecimal(0));
            				}
            			}
            		}
                    BigDecimal availableBalance = receiveMoney.subtract(payMoney).add(otherMoney);
                    entity.setOther(otherMoney);
                    entity.setAvailableBalance(availableBalance);
            	}else{
                    BigDecimal availableBalance = receiveMoney.subtract(payMoney);
                    entity.setOther(new BigDecimal(0));
                	entity.setAvailableBalance(availableBalance);
            	}
        	}
        }
		Map<String, Object> beans = new HashMap<String, Object>();
		beans.put("records", list);
		ExcelExport.getInstance().export("projectCapitalSetExport.xlsx", beans, response);
	}

    /**
     * @Author liyongjia
     * @Date 2020/6/10 删除
     * @Description delete
     * @Param [vos]
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProjectCapitalSetVO> vos) {
    	projectCapitalSetService.removeByIds(vos.stream().map(ProjectCapitalSetVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Author liyj
     * @Date 2021/5/27
     * @Description queryPrint 查询打印详情
     * @param id
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryPrint", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryPrint(Long id, HttpServletRequest request) {
        JSONObject json = new JSONObject();
        JSONArray ProjectCapitalSetCost = new JSONArray();
        ProjectCapitalSetEntity entity = projectCapitalSetService.selectById(id);
        ProjectCapitalSetVO vo = BeanMapper.map(entity, ProjectCapitalSetVO.class);
        CommonResponse<JSONObject> inAndOut = projectCapitalSetService.queryIncoemAndExpendByProjectId(vo.getProjectId(), request);
        if(inAndOut.isSuccess()){
			JSONObject dataresultIncoemAndExpend = inAndOut.getData();
			if(dataresultIncoemAndExpend.get("incomeTaxRate")!=null){
				dataresultIncoemAndExpend.put("incomeTaxRate", dataresultIncoemAndExpend.getBigDecimal("incomeTaxRate").divide(new BigDecimal(100.0)));
			}
        	if(vo.getProjectCapitalSetList()!=null&&vo.getProjectCapitalSetList().size()>0){
        		List<ProjectCapitalSetCostVO> list = vo.getProjectCapitalSetList();
        		BigDecimal otherMoney = new BigDecimal(0);
        		for(ProjectCapitalSetCostVO cost : list){
        			if("value".equals(cost.getDataType())){
        				if("add".equals(cost.getAddOrDelete())){
        					if(cost.getValueOrFormula()!=null){
        						BigDecimal valueOrFormula = new BigDecimal(cost.getValueOrFormula());
        						otherMoney = otherMoney.add(valueOrFormula);
                				cost.setAmount(valueOrFormula);
        					}else{
        						cost.setAmount(new BigDecimal(0));
        					}
        				}else if("delete".equals(cost.getAddOrDelete())){
        					if(cost.getValueOrFormula()!=null){
        						BigDecimal valueOrFormula = new BigDecimal(cost.getValueOrFormula());
        						otherMoney = otherMoney.subtract(valueOrFormula);
                				cost.setAmount(new BigDecimal(0).subtract(valueOrFormula));
        					}else{
        						cost.setAmount(new BigDecimal(0));
        					}
        				}
        			}else{
        				if(cost.getFormula()!=null){
        					String evalq = cost.getFormula();
        					for (String key : dataresultIncoemAndExpend.keySet()) {
        						String value = "0";
                                value = dataresultIncoemAndExpend.getString(key)!=null?dataresultIncoemAndExpend.getString(key):"0";
                                evalq = evalq.replaceAll(key, value);
                            }
        					
        					ScriptEngineManager manager = new ScriptEngineManager();
        					ScriptEngine se = manager.getEngineByName("js");
        					BigDecimal money = new BigDecimal(0);
							try {
								money = new BigDecimal( (Double) se.eval(evalq));
							} catch (ScriptException e) {
								e.printStackTrace();
							}
        					if("delete".equals(cost.getAddOrDelete())){
        						money = new BigDecimal(0).subtract(money);
        					}
    						cost.setAmount(money);
    						otherMoney = otherMoney.add(money);
        				}else{
    						cost.setAmount(new BigDecimal(0));
        				}
        			}
    				if("add".equals(cost.getAddOrDelete())){
        				cost.setAddOrDelete("增加");
    				}else if("delete".equals(cost.getAddOrDelete())){
        				cost.setAddOrDelete("扣除");
    				}
    				if("value".equals(cost.getDataType())){
        				cost.setDataType("数值");
    				}else if("formula".equals(cost.getDataType())){
        				cost.setDataType("公式");
    				}
        			JSONObject costJson = new JSONObject();
        			costJson.put("id", cost.getId());
        			costJson.put("costName", cost.getCostName());
        			costJson.put("addOrDelete", cost.getAddOrDelete());
        			costJson.put("dataType", cost.getDataType());
        			costJson.put("valueOrFormula", cost.getValueOrFormula());
        			if(cost.getRegistrationTime()!=null){
        				String pattern = "yyyy-MM-dd";
        		        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
            			costJson.put("registrationTime", simpleDateFormat.format(cost.getRegistrationTime()));
        			}
        			costJson.put("amount", cost.getAmount());
        			if(cost.getDealUser()!=null){
        				try {
	        				JSONArray jArray = ReferObjectUtil.getReferEntityValue(cost.getDealUser().toString(), "idm-user");
	        				if(jArray!=null&&jArray.size()>0){
	        					costJson.put("dealUser", ((JSONObject) jArray.get(0)).get("name").toString());
	        				}
        				} catch (Exception e) {
//        					e.printStackTrace();
        				}
        			}
        			costJson.put("remarks", cost.getRemarks());
					ProjectCapitalSetCost.add(costJson);
        		}
                BigDecimal receiveMoney = dataresultIncoemAndExpend.getBigDecimal("receiveMoney")!=null?dataresultIncoemAndExpend.getBigDecimal("receiveMoney"):new BigDecimal(0);
                BigDecimal payMoney = dataresultIncoemAndExpend.getBigDecimal("payMoney")!=null?dataresultIncoemAndExpend.getBigDecimal("payMoney"):new BigDecimal(0);
                vo.setProjectIncome(receiveMoney == null ? BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP) : receiveMoney);
                vo.setProjectExpenditure(payMoney == null ? BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP) : payMoney);
                BigDecimal availableBalance = receiveMoney.subtract(payMoney).add(otherMoney);
            	vo.setOther(otherMoney);
            	vo.setAvailableBalance(availableBalance);
        	}
        }else{
        	vo.setProjectIncome(BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP));
        	vo.setProjectExpenditure(BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP)	);
        	vo.setOther(BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP));
        	vo.setAvailableBalance(BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP));
        }
        JSONObject ProjectCapitalSet = new JSONObject();
        ProjectCapitalSet.put("id", vo.getId());
        ProjectCapitalSet.put("projectName", vo.getProjectName());
        ProjectCapitalSet.put("projectIncome", vo.getProjectIncome());
        ProjectCapitalSet.put("projectExpenditure", vo.getProjectExpenditure());
        ProjectCapitalSet.put("other", vo.getOther());
        ProjectCapitalSet.put("availableBalance", vo.getAvailableBalance());
        ProjectCapitalSet.put("ProjectCapitalSetCost", ProjectCapitalSetCost);
        json.put("ProjectCapitalSet",ProjectCapitalSet);
        return CommonResponse.success("查询打印数据成功！",json);
    }

    @RequestMapping(value = "queryAllList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProjectCapitalSetVO>> queryAllList(@RequestBody QueryParam param, HttpServletRequest request) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        long projectstartTime = System.currentTimeMillis();    //获取开始时间
        CommonResponse<Page<ProjectRegisterVO>> response = iProjectApi.queryProjectPage(param);
        long projectendTime = System.currentTimeMillis();    //获取结束时间
        logger.info("---------------------");
        logger.info("获取项目 ---- 运行时间：" + (projectstartTime - projectendTime) + "ms");//输出程序运行时间

        IPage<ProjectCapitalSetVO> page = new Page<>();
        if(response.isSuccess()){
            IPage<ProjectRegisterVO> projectRegisterVOIPage = response.getData();
            page = new Page<>(projectRegisterVOIPage.getCurrent(),projectRegisterVOIPage.getSize(),projectRegisterVOIPage.getTotal());
            if(projectRegisterVOIPage.getTotal()>0){
                List<ProjectCapitalSetVO> setVOS = new ArrayList<>();

                List<Long> projectIds = new ArrayList<>();
            	for(ProjectRegisterVO p : projectRegisterVOIPage.getRecords()){
            		projectIds.add(p.getId());
            	}
            	Map<Long, JSONObject> projectCapital = projectCapitalSetService.queryIncoemAndExpendByProjectIds(projectIds,request);

                long operatestartTime = System.currentTimeMillis();    //获取开始时间
            	//获取当前项目在资金表中存在的数据
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("projectId", new Parameter(QueryParam.IN, projectIds));
                List<ProjectCapitalSetEntity> allExitlist = projectCapitalSetService.queryList(queryParam, false);
                Map<Long,ProjectCapitalSetEntity> exitProjectMap = new HashMap<>();
                for(ProjectCapitalSetEntity entity : allExitlist){
                	exitProjectMap.put(entity.getProjectId(), entity);
                }
                for (ProjectRegisterVO p : projectRegisterVOIPage.getRecords()) {
                    if (exitProjectMap.get(p.getId())!=null) {
                    	ProjectCapitalSetEntity vo = exitProjectMap.get(p.getId());
    					JSONObject dataresultIncoemAndExpend = projectCapital.get(p.getId());
    					if(dataresultIncoemAndExpend.get("incomeTaxRate")!=null){
    						dataresultIncoemAndExpend.put("incomeTaxRate", dataresultIncoemAndExpend.getBigDecimal("incomeTaxRate").divide(new BigDecimal(100.0)));
    					}
    					BigDecimal receiveMoney = dataresultIncoemAndExpend.getBigDecimal("receiveMoney")!=null?dataresultIncoemAndExpend.getBigDecimal("receiveMoney"):new BigDecimal(0);
                        BigDecimal payMoney = dataresultIncoemAndExpend.getBigDecimal("payMoney")!=null?dataresultIncoemAndExpend.getBigDecimal("payMoney"):new BigDecimal(0);
                        vo.setProjectIncome(receiveMoney == null ? BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP) : receiveMoney);
                        vo.setProjectExpenditure(payMoney == null ? BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP) : payMoney);
                        
    					QueryWrapper<ProjectCapitalSetCostEntity> queryWrapper = new QueryWrapper<>();
    					queryWrapper.eq("project_capital_set_id", vo.getId());
    					queryWrapper.eq("dr", 0);
    					List<ProjectCapitalSetCostEntity> projectCapitalSetList = iProjectCapitalSetCostService.list(queryWrapper);
                    	if(projectCapitalSetList!=null&&projectCapitalSetList.size()>0){
                    		BigDecimal otherMoney = new BigDecimal(0);
                    		for(ProjectCapitalSetCostEntity cost : projectCapitalSetList){
                    			if("value".equals(cost.getDataType())){
                    				if("add".equals(cost.getAddOrDelete())){
                    					if(cost.getValueOrFormula()!=null){
                    						BigDecimal valueOrFormula = new BigDecimal(cost.getValueOrFormula());
                    						otherMoney = otherMoney.add(valueOrFormula);
                            				cost.setAmount(valueOrFormula);
                    					}else{
                    						cost.setAmount(new BigDecimal(0));
                    					}
                    				}else if("delete".equals(cost.getAddOrDelete())){
                    					if(cost.getValueOrFormula()!=null){
                    						BigDecimal valueOrFormula = new BigDecimal(cost.getValueOrFormula());
                    						otherMoney = otherMoney.subtract(valueOrFormula);
                            				cost.setAmount(new BigDecimal(0).subtract(valueOrFormula));
                    					}else{
                    						cost.setAmount(new BigDecimal(0));
                    					}
                    				}
                    			}else{
                    				if(cost.getFormula()!=null){
                    					String evalq = cost.getFormula();
                    					for (String key : dataresultIncoemAndExpend.keySet()) {
                    						String value = "0";
                                            value = dataresultIncoemAndExpend.getString(key)!=null?dataresultIncoemAndExpend.getString(key):"0";
                                            evalq = evalq.replaceAll(key, value);
                                        }
                    					
                    					ScriptEngineManager manager = new ScriptEngineManager();
                    					ScriptEngine se = manager.getEngineByName("js");
                    					BigDecimal money = new BigDecimal(0);
    									try {
    										money = new BigDecimal( (Double) se.eval(evalq));
    									} catch (ScriptException e) {
    										e.printStackTrace();
    									}
                    					if("delete".equals(cost.getAddOrDelete())){
                    						money = new BigDecimal(0).subtract(money);
                    					}
                						cost.setAmount(money);
                						otherMoney = otherMoney.add(money);
                    				}else{
                						cost.setAmount(new BigDecimal(0));
                    				}
                    			}
                    		}
                            BigDecimal availableBalance = receiveMoney.subtract(payMoney).add(otherMoney);
                        	vo.setOther(otherMoney);
                        	vo.setAvailableBalance(availableBalance);
                    	}else{
                            BigDecimal availableBalance = receiveMoney.subtract(payMoney);
                        	vo.setOther(new BigDecimal(0));
                        	vo.setAvailableBalance(availableBalance);
                    	}
                        setVOS.add(BeanMapper.map(vo, ProjectCapitalSetVO.class));
                        
                    } else {
                        ProjectCapitalSetVO capitalSetVO = new ProjectCapitalSetVO();
                        capitalSetVO.setId(p.getId());
                        capitalSetVO.setProjectId(p.getId());
                        capitalSetVO.setProjectDepartmentId(p.getProjectDepartmentId());
                        capitalSetVO.setProjectName(p.getName());
                    	JSONObject dataresultIncoemAndExpend = projectCapital.get(p.getId());
                        BigDecimal receiveMoney = dataresultIncoemAndExpend.getBigDecimal("receiveMoney");
                        BigDecimal payMoney = dataresultIncoemAndExpend.getBigDecimal("payMoney");
                        capitalSetVO.setProjectIncome(receiveMoney == null ? BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP) : receiveMoney);
                        capitalSetVO.setProjectExpenditure(payMoney == null ? BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP) : payMoney);
                        capitalSetVO.setOther(BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP));
                        BigDecimal availableBalance = BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP);
                        if (receiveMoney != null && payMoney != null) {
                            availableBalance = receiveMoney.subtract(payMoney);
                        } else if (receiveMoney == null && payMoney != null) {
                            availableBalance = availableBalance.subtract(payMoney);
                        } else if (receiveMoney != null) {
                            availableBalance = receiveMoney;
                        }
                        capitalSetVO.setAvailableBalance(availableBalance);
                        setVOS.add(capitalSetVO);
                    }
                }
                page.setRecords(setVOS);
                long operateendTime = System.currentTimeMillis();    //获取开始时间
                logger.info("===============================");
                logger.info("计算 ---- 运行时间：" + (operatestartTime - operateendTime) + "ms");//输出程序运行时间
            }

        }
        return CommonResponse.success("查询列表数据成功！",page);
    }

	/**
	 * excel导出
	 *
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/excelSisExport", method = RequestMethod.POST)
	@ResponseBody
	public void excelSisExport(@RequestBody QueryParam param, HttpServletResponse response, HttpServletRequest request) {
		/** 模糊搜索配置字段示例 */
		param.setPageIndex(1);
		param.setPageSize(-1);
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        CommonResponse<Page<ProjectRegisterVO>> resultData = iProjectApi.queryProjectPage(param);
        List<ProjectCapitalSetVO> setVOS = new ArrayList<>();
        if(resultData.isSuccess()){
            IPage<ProjectRegisterVO> projectRegisterVOIPage = resultData.getData();
            if(projectRegisterVOIPage.getTotal()>100000){
            	param.setPageSize((int) projectRegisterVOIPage.getTotal());
            	resultData = iProjectApi.queryProjectPage(param);
            }
            
            List<Long> projectIds = new ArrayList<>();
        	for(ProjectRegisterVO p : projectRegisterVOIPage.getRecords()){
        		projectIds.add(p.getId());
        	}
        	Map<Long, JSONObject> projectCapital = projectCapitalSetService.queryIncoemAndExpendByProjectIds(projectIds,request);

        	//获取当前项目在资金表中存在的数据
            QueryParam queryselfParam = new QueryParam();
            queryselfParam.getParams().put("projectId", new Parameter(QueryParam.IN, projectIds));
            List<ProjectCapitalSetEntity> allExitlist = projectCapitalSetService.queryList(queryselfParam, false);
            Map<Long,ProjectCapitalSetEntity> exitProjectMap = new HashMap<>();
            for(ProjectCapitalSetEntity entity : allExitlist){
            	exitProjectMap.put(entity.getProjectId(), entity);
            }
            
            if(projectRegisterVOIPage.getTotal()>0){
                for (ProjectRegisterVO p : projectRegisterVOIPage.getRecords()) {
                    if (exitProjectMap.get(p.getId())!=null) {
                    	ProjectCapitalSetEntity vo = exitProjectMap.get(p.getId());
    					JSONObject dataresultIncoemAndExpend = projectCapital.get(p.getId());
    					if(dataresultIncoemAndExpend.get("incomeTaxRate")!=null){
    						dataresultIncoemAndExpend.put("incomeTaxRate", dataresultIncoemAndExpend.getBigDecimal("incomeTaxRate").divide(new BigDecimal(100.0)));
    					}
    					BigDecimal receiveMoney = dataresultIncoemAndExpend.getBigDecimal("receiveMoney")!=null?dataresultIncoemAndExpend.getBigDecimal("receiveMoney"):new BigDecimal(0);
                        BigDecimal payMoney = dataresultIncoemAndExpend.getBigDecimal("payMoney")!=null?dataresultIncoemAndExpend.getBigDecimal("payMoney"):new BigDecimal(0);
                        vo.setProjectIncome(receiveMoney == null ? BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP) : receiveMoney);
                        vo.setProjectExpenditure(payMoney == null ? BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP) : payMoney);
                        
    					QueryWrapper<ProjectCapitalSetCostEntity> queryWrapper = new QueryWrapper<>();
    					queryWrapper.eq("project_capital_set_id", vo.getId());
    					queryWrapper.eq("dr", 0);
    					List<ProjectCapitalSetCostEntity> projectCapitalSetList = iProjectCapitalSetCostService.list(queryWrapper);
                    	if(projectCapitalSetList!=null&&projectCapitalSetList.size()>0){
                    		BigDecimal otherMoney = new BigDecimal(0);
                    		for(ProjectCapitalSetCostEntity cost : projectCapitalSetList){
                    			if("value".equals(cost.getDataType())){
                    				if("add".equals(cost.getAddOrDelete())){
                    					if(cost.getValueOrFormula()!=null){
                    						BigDecimal valueOrFormula = new BigDecimal(cost.getValueOrFormula());
                    						otherMoney = otherMoney.add(valueOrFormula);
                            				cost.setAmount(valueOrFormula);
                    					}else{
                    						cost.setAmount(new BigDecimal(0));
                    					}
                    				}else if("delete".equals(cost.getAddOrDelete())){
                    					if(cost.getValueOrFormula()!=null){
                    						BigDecimal valueOrFormula = new BigDecimal(cost.getValueOrFormula());
                    						otherMoney = otherMoney.subtract(valueOrFormula);
                            				cost.setAmount(new BigDecimal(0).subtract(valueOrFormula));
                    					}else{
                    						cost.setAmount(new BigDecimal(0));
                    					}
                    				}
                    			}else{
                    				if(cost.getFormula()!=null){
                    					String evalq = cost.getFormula();
                    					for (String key : dataresultIncoemAndExpend.keySet()) {
                    						String value = "0";
                                            value = dataresultIncoemAndExpend.getString(key)!=null?dataresultIncoemAndExpend.getString(key):"0";
                                            evalq = evalq.replaceAll(key, value);
                                        }
                    					
                    					ScriptEngineManager manager = new ScriptEngineManager();
                    					ScriptEngine se = manager.getEngineByName("js");
                    					BigDecimal money = new BigDecimal(0);
    									try {
    										money = new BigDecimal( (Double) se.eval(evalq));
    									} catch (ScriptException e) {
    										e.printStackTrace();
    									}
                    					if("delete".equals(cost.getAddOrDelete())){
                    						money = new BigDecimal(0).subtract(money);
                    					}
                						cost.setAmount(money);
                						otherMoney = otherMoney.add(money);
                    				}else{
                						cost.setAmount(new BigDecimal(0));
                    				}
                    			}
                    		}
                            BigDecimal availableBalance = receiveMoney.subtract(payMoney).add(otherMoney);
                        	vo.setOther(otherMoney);
                        	vo.setAvailableBalance(availableBalance);
                    	}else{
                            BigDecimal availableBalance = receiveMoney.subtract(payMoney);
                        	vo.setOther(new BigDecimal(0));
                        	vo.setAvailableBalance(availableBalance);
                    	}
                        setVOS.add(BeanMapper.map(vo, ProjectCapitalSetVO.class));
                        
                    } else {
                        ProjectCapitalSetVO capitalSetVO = new ProjectCapitalSetVO();
                        capitalSetVO.setId(p.getId());
                        capitalSetVO.setProjectId(p.getId());
                        capitalSetVO.setProjectDepartmentId(p.getProjectDepartmentId());
                        capitalSetVO.setProjectName(p.getName());
                    	JSONObject object = projectCapital.get(p.getId());
                        BigDecimal receiveMoney = object.getBigDecimal("receiveMoney");
                        BigDecimal payMoney = object.getBigDecimal("payMoney");
                        capitalSetVO.setProjectIncome(receiveMoney == null ? BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP) : receiveMoney);
                        capitalSetVO.setProjectExpenditure(payMoney == null ? BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP) : payMoney);
                        capitalSetVO.setOther(BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP));
                        BigDecimal availableBalance = BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP);
                        if (receiveMoney != null && payMoney != null) {
                            availableBalance = receiveMoney.subtract(payMoney);
                        } else if (receiveMoney == null && payMoney != null) {
                            availableBalance = availableBalance.subtract(payMoney);
                        } else if (receiveMoney != null) {
                            availableBalance = receiveMoney;
                        }
                        capitalSetVO.setAvailableBalance(availableBalance);
                        setVOS.add(capitalSetVO);
                    }
                }
            }
        }
		Map<String, Object> beans = new HashMap<String, Object>();
		beans.put("records", setVOS);
		ExcelExport.getInstance().export("projectCapitalSetSisExport.xlsx", beans, response);
	}
	
    @RequestMapping(value = "querySisDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProjectCapitalSetVO> querySisDetail(Long id, HttpServletRequest request) {
        ProjectCapitalSetEntity entity = projectCapitalSetService.selectById(id);
        if(entity == null){
            ProjectCapitalSetVO capitalSetVO = new ProjectCapitalSetVO();
            capitalSetVO.setId(id);
            capitalSetVO.setProjectId(id);
            CommonResponse<List<ProjectRegisterVO>> response = iProjectApi.queryProjectByIds(Collections.singletonList(id));
            if(response.isSuccess()){
                ProjectRegisterVO p = response.getData().get(0);
                capitalSetVO.setProjectName(p.getName());
                capitalSetVO.setProjectDepartmentId(p.getProjectDepartmentId());
                CommonResponse<JSONObject> inAndOut = projectCapitalSetService.queryIncoemAndExpendByProjectId(p.getId(), request);
                if(inAndOut.isSuccess()){
                    JSONObject object = inAndOut.getData();
                    BigDecimal receiveMoney = object.getBigDecimal("receiveMoney");
                    BigDecimal payMoney = object.getBigDecimal("payMoney");
                    capitalSetVO.setProjectIncome(receiveMoney == null ? BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP) : receiveMoney);
                    capitalSetVO.setProjectExpenditure(payMoney == null ? BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP) : payMoney);
                    capitalSetVO.setOther(BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP));
                    BigDecimal availableBalance = BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP);
                    if(receiveMoney!=null && payMoney!=null){
                        availableBalance = receiveMoney.subtract(payMoney);
                    }else if(receiveMoney==null && payMoney!=null){
                        availableBalance = availableBalance.subtract(payMoney);
                    }else if(receiveMoney != null){
                        availableBalance = receiveMoney;
                    }
                    capitalSetVO.setAvailableBalance(availableBalance);
                }else {
                    capitalSetVO.setProjectExpenditure(BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP));
                    capitalSetVO.setProjectIncome(BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP));
                    capitalSetVO.setOther(BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP));
                    capitalSetVO.setAvailableBalance(BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP));
                }
                return CommonResponse.success("查询详情数据成功！",capitalSetVO);
            }else {
                return CommonResponse.error("非法查询！");
            }
        }
        ProjectCapitalSetVO vo = BeanMapper.map(entity, ProjectCapitalSetVO.class);
        CommonResponse<JSONObject> inAndOut = projectCapitalSetService.queryIncoemAndExpendByProjectId(vo.getProjectId(), request);
        if(inAndOut.isSuccess()){
			JSONObject dataresultIncoemAndExpend = inAndOut.getData();
			if(dataresultIncoemAndExpend.get("incomeTaxRate")!=null){
				dataresultIncoemAndExpend.put("incomeTaxRate", dataresultIncoemAndExpend.getBigDecimal("incomeTaxRate").divide(new BigDecimal(100.0)));
			}
        	if(vo.getProjectCapitalSetList()!=null&&vo.getProjectCapitalSetList().size()>0){
        		List<ProjectCapitalSetCostVO> list = vo.getProjectCapitalSetList();
        		BigDecimal otherMoney = new BigDecimal(0);
        		for(ProjectCapitalSetCostVO cost : list){
        			if("value".equals(cost.getDataType())){
        				if("add".equals(cost.getAddOrDelete())){
        					if(cost.getValueOrFormula()!=null){
        						BigDecimal valueOrFormula = new BigDecimal(cost.getValueOrFormula());
        						otherMoney = otherMoney.add(valueOrFormula);
                				cost.setAmount(valueOrFormula);
        					}else{
        						cost.setAmount(new BigDecimal(0));
        					}
        				}else if("delete".equals(cost.getAddOrDelete())){
        					if(cost.getValueOrFormula()!=null){
        						BigDecimal valueOrFormula = new BigDecimal(cost.getValueOrFormula());
        						otherMoney = otherMoney.subtract(valueOrFormula);
                				cost.setAmount(new BigDecimal(0).subtract(valueOrFormula));
        					}else{
        						cost.setAmount(new BigDecimal(0));
        					}
        				}
        			}else{
        				if(cost.getFormula()!=null){
        					String evalq = cost.getFormula();
        					for (String key : dataresultIncoemAndExpend.keySet()) {
        						String value = "0";
                                value = dataresultIncoemAndExpend.getString(key)!=null?dataresultIncoemAndExpend.getString(key):"0";
                                evalq = evalq.replaceAll(key, value);
                            }
        					
        					ScriptEngineManager manager = new ScriptEngineManager();
        					ScriptEngine se = manager.getEngineByName("js");
        					BigDecimal money = new BigDecimal(0);
							try {
								money = new BigDecimal( (Double) se.eval(evalq));
							} catch (ScriptException e) {
								e.printStackTrace();
							}
        					if("delete".equals(cost.getAddOrDelete())){
        						money = new BigDecimal(0).subtract(money);
        					}
    						cost.setAmount(money);
    						otherMoney = otherMoney.add(money);
        				}else{
    						cost.setAmount(new BigDecimal(0));
        				}
        			}
        		}
                BigDecimal receiveMoney = dataresultIncoemAndExpend.getBigDecimal("receiveMoney")!=null?dataresultIncoemAndExpend.getBigDecimal("receiveMoney"):new BigDecimal(0);
                BigDecimal payMoney = dataresultIncoemAndExpend.getBigDecimal("payMoney")!=null?dataresultIncoemAndExpend.getBigDecimal("payMoney"):new BigDecimal(0);
                vo.setProjectIncome(receiveMoney == null ? BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP) : receiveMoney);
                vo.setProjectExpenditure(payMoney == null ? BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP) : payMoney);
                BigDecimal availableBalance = receiveMoney.subtract(payMoney).add(otherMoney);
            	vo.setOther(otherMoney);
            	vo.setAvailableBalance(availableBalance);
        	}
        }else{
        	vo.setProjectIncome(BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP));
        	vo.setProjectExpenditure(BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP));
        	vo.setOther(BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP));
        	vo.setAvailableBalance(BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP));
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Author liyj
     * @Date 2021/5/27
     * @Description queryPrint 查询打印详情
     * @param id
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/querySisPrint", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> querySisPrint(Long id, HttpServletRequest request) {
        JSONObject json = new JSONObject();
        JSONArray ProjectCapitalSetCost = new JSONArray();
        ProjectCapitalSetEntity entity = projectCapitalSetService.selectById(id);
        if(entity == null){
            ProjectCapitalSetVO capitalSetVO = new ProjectCapitalSetVO();
            capitalSetVO.setId(id);
            capitalSetVO.setProjectId(id);
            CommonResponse<List<ProjectRegisterVO>> response = iProjectApi.queryProjectByIds(Collections.singletonList(id));
            if(response.isSuccess()){
                ProjectRegisterVO p = response.getData().get(0);
                capitalSetVO.setProjectName(p.getName());
                capitalSetVO.setProjectDepartmentId(p.getProjectDepartmentId());
                CommonResponse<JSONObject> inAndOut = projectCapitalSetService.queryIncoemAndExpendByProjectId(p.getId(), request);
                if(inAndOut.isSuccess()){
                    JSONObject object = inAndOut.getData();
                    BigDecimal receiveMoney = object.getBigDecimal("receiveMoney");
                    BigDecimal payMoney = object.getBigDecimal("payMoney");
                    capitalSetVO.setProjectIncome(receiveMoney == null ? BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP) : receiveMoney);
                    capitalSetVO.setProjectExpenditure(payMoney == null ? BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP) : payMoney);
                    capitalSetVO.setOther(BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP));
                    BigDecimal availableBalance = BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP);
                    if(receiveMoney!=null && payMoney!=null){
                        availableBalance = receiveMoney.subtract(payMoney);
                    }else if(receiveMoney==null && payMoney!=null){
                        availableBalance = availableBalance.subtract(payMoney);
                    }else if(receiveMoney != null){
                        availableBalance = receiveMoney;
                    }
                    capitalSetVO.setAvailableBalance(availableBalance);
                }else {
                    capitalSetVO.setProjectExpenditure(BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP));
                    capitalSetVO.setProjectIncome(BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP));
                    capitalSetVO.setOther(BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP));
                    capitalSetVO.setAvailableBalance(BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP));
                }
                json.put("ProjectCapitalSet",capitalSetVO);
                return CommonResponse.success("查询打印数据成功！",json);
            }else {
                return CommonResponse.error("非法查询！");
            }
        }
        ProjectCapitalSetVO vo = BeanMapper.map(entity, ProjectCapitalSetVO.class);
        CommonResponse<JSONObject> inAndOut = projectCapitalSetService.queryIncoemAndExpendByProjectId(vo.getProjectId(), request);
        if(inAndOut.isSuccess()){
			JSONObject dataresultIncoemAndExpend = inAndOut.getData();
			if(dataresultIncoemAndExpend.get("incomeTaxRate")!=null){
				dataresultIncoemAndExpend.put("incomeTaxRate", dataresultIncoemAndExpend.getBigDecimal("incomeTaxRate").divide(new BigDecimal(100.0)));
			}
        	if(vo.getProjectCapitalSetList()!=null&&vo.getProjectCapitalSetList().size()>0){
        		List<ProjectCapitalSetCostVO> list = vo.getProjectCapitalSetList();
        		BigDecimal otherMoney = new BigDecimal(0);
        		for(ProjectCapitalSetCostVO cost : list){
        			if("value".equals(cost.getDataType())){
        				if("add".equals(cost.getAddOrDelete())){
        					if(cost.getValueOrFormula()!=null){
        						BigDecimal valueOrFormula = new BigDecimal(cost.getValueOrFormula());
        						otherMoney = otherMoney.add(valueOrFormula);
                				cost.setAmount(valueOrFormula);
        					}else{
        						cost.setAmount(new BigDecimal(0));
        					}
        				}else if("delete".equals(cost.getAddOrDelete())){
        					if(cost.getValueOrFormula()!=null){
        						BigDecimal valueOrFormula = new BigDecimal(cost.getValueOrFormula());
        						otherMoney = otherMoney.subtract(valueOrFormula);
                				cost.setAmount(new BigDecimal(0).subtract(valueOrFormula));
        					}else{
        						cost.setAmount(new BigDecimal(0));
        					}
        				}
        			}else{
        				if(cost.getFormula()!=null){
        					String evalq = cost.getFormula();
        					for (String key : dataresultIncoemAndExpend.keySet()) {
        						String value = "0";
                                value = dataresultIncoemAndExpend.getString(key)!=null?dataresultIncoemAndExpend.getString(key):"0";
                                evalq = evalq.replaceAll(key, value);
                            }
        					
        					ScriptEngineManager manager = new ScriptEngineManager();
        					ScriptEngine se = manager.getEngineByName("js");
        					BigDecimal money = new BigDecimal(0);
							try {
								money = new BigDecimal( (Double) se.eval(evalq));
							} catch (ScriptException e) {
								e.printStackTrace();
							}
        					if("delete".equals(cost.getAddOrDelete())){
        						money = new BigDecimal(0).subtract(money);
        					}
    						cost.setAmount(money);
    						otherMoney = otherMoney.add(money);
        				}else{
    						cost.setAmount(new BigDecimal(0));
        				}
        			}
    				if("add".equals(cost.getAddOrDelete())){
        				cost.setAddOrDelete("增加");
    				}else if("delete".equals(cost.getAddOrDelete())){
        				cost.setAddOrDelete("扣除");
    				}
    				if("value".equals(cost.getDataType())){
        				cost.setDataType("数值");
    				}else if("formula".equals(cost.getDataType())){
        				cost.setDataType("公式");
    				}
        			JSONObject costJson = new JSONObject();
        			costJson.put("id", cost.getId());
        			costJson.put("costName", cost.getCostName());
        			costJson.put("addOrDelete", cost.getAddOrDelete());
        			costJson.put("dataType", cost.getDataType());
        			costJson.put("valueOrFormula", cost.getValueOrFormula());
        			if(cost.getRegistrationTime()!=null){
        				String pattern = "yyyy-MM-dd";
        		        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
            			costJson.put("registrationTime", simpleDateFormat.format(cost.getRegistrationTime()));
        			}
        			costJson.put("amount", cost.getAmount());
        			if(cost.getDealUser()!=null){
        				try {
	        				JSONArray jArray = ReferObjectUtil.getReferEntityValue(cost.getDealUser().toString(), "idm-user");
	        				if(jArray!=null&&jArray.size()>0){
	        					costJson.put("dealUser", ((JSONObject) jArray.get(0)).get("name").toString());
	        				}
        				} catch (Exception e) {
//        					e.printStackTrace();
        				}
        			}
        			costJson.put("remarks", cost.getRemarks());
					ProjectCapitalSetCost.add(costJson);
        		}
                BigDecimal receiveMoney = dataresultIncoemAndExpend.getBigDecimal("receiveMoney")!=null?dataresultIncoemAndExpend.getBigDecimal("receiveMoney"):new BigDecimal(0);
                BigDecimal payMoney = dataresultIncoemAndExpend.getBigDecimal("payMoney")!=null?dataresultIncoemAndExpend.getBigDecimal("payMoney"):new BigDecimal(0);
                vo.setProjectIncome(receiveMoney == null ? BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP) : receiveMoney);
                vo.setProjectExpenditure(payMoney == null ? BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP) : payMoney);
                BigDecimal availableBalance = receiveMoney.subtract(payMoney).add(otherMoney);
            	vo.setOther(otherMoney);
            	vo.setAvailableBalance(availableBalance);
        	}
        }else{
        	vo.setProjectIncome(BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP));
        	vo.setProjectExpenditure(BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP));
        	vo.setOther(BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP));
        	vo.setAvailableBalance(BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP));
        }
        JSONObject ProjectCapitalSet = new JSONObject();
        ProjectCapitalSet.put("id", vo.getId());
        ProjectCapitalSet.put("projectName", vo.getProjectName());
        ProjectCapitalSet.put("projectIncome", vo.getProjectIncome());
        ProjectCapitalSet.put("projectExpenditure", vo.getProjectExpenditure());
        ProjectCapitalSet.put("other", vo.getOther());
        ProjectCapitalSet.put("availableBalance", vo.getAvailableBalance());
        ProjectCapitalSet.put("ProjectCapitalSetCost", ProjectCapitalSetCost);
        json.put("ProjectCapitalSet",ProjectCapitalSet);
        return CommonResponse.success("查询打印数据成功！",json);
    }
}
