package com.ejianc.business.finance.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.accplat.consts.SystemCodeEnum;
import com.ejianc.business.finance.bean.DeductionEntity;
import com.ejianc.business.finance.service.IDeductionService;
import com.ejianc.business.finance.vo.DeductionVO;
import com.ejianc.business.voucher.api.IVoucherApi;
import com.ejianc.business.voucher.consts.VoucherOptFlag;
import com.ejianc.business.voucher.utils.DataConvertUtil;
import com.ejianc.business.voucher.vo.VoucherInfo;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;


/**
 * 扣款单
 *
 * @author generator
 */
@Controller
@RequestMapping("deduction")
public class DeductionController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "finance_Deduction_CHANGE";//此处需要根据实际修改
    @Autowired
    private IVoucherApi voucherApi;
    @Autowired
    private IDeductionService service;


    /**
     * @Description saveOrUpdate 新增或者修改
     * 项目累计扣款金额，供应商累计扣款金额 不含本期
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DeductionVO> saveOrUpdate(@RequestBody DeductionVO saveorUpdateVO) {
        DeductionEntity entity = BeanMapper.map(saveorUpdateVO, DeductionEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        entity.setIsUse(0);
//        if (entity.getProjectId() != null) {
//            QueryParam queryParam = new QueryParam();
//            queryParam.getParams().put("project_id", new Parameter(QueryParam.EQ, entity.getProjectId()));
//            List<Integer> billstate = new ArrayList<>();
//            billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
//            billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
//            queryParam.getParams().put("bill_state", new Parameter(QueryParam.IN, billstate));
//            List<DeductionEntity> list = service.queryList(queryParam, false);
//            if (CollectionUtils.isNotEmpty(list)) {
//                BigDecimal totalPenaltyMoney = list.stream().map(DeductionEntity::getPenaltyMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
//                entity.setTotalPenaltyMoney(totalPenaltyMoney);
//                if (entity.getSupplierId() != null) {
//                    BigDecimal supReduce = list.stream().filter(s -> s.getSupplierId().equals(entity.getSupplierId())).map(DeductionEntity::getPenaltyMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
//                    entity.setSupplierTotalPenaltyMoney(supReduce);
//                }
//            } else {
//                entity.setTotalPenaltyMoney(BigDecimal.ZERO);
//                entity.setSupplierTotalPenaltyMoney(BigDecimal.ZERO);
//            }
//        }
        service.saveOrUpdate(entity, false);
        DeductionVO vo = BeanMapper.map(entity, DeductionVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DeductionVO> queryDetail(Long id) {
        DeductionEntity entity = service.selectById(id);
        DeductionVO vo = BeanMapper.map(entity, DeductionVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DeductionVO> vos) {
        service.removeByIds(vos.stream().map(DeductionVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DeductionVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("subjectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("dealPersonName");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<DeductionEntity> page = service.queryPage(param, false);
        IPage<DeductionVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DeductionVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }
    /**
     * @description: 推送凭证
     *
     * @param voucherInfo
     * @return {@link CommonResponse}
     * @author songlx
     * @date: 2024/1/12
     */
    @RequestMapping(value = "/pushVoucher", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse pushVoucher(@RequestBody VoucherInfo voucherInfo) {
        Long billId = voucherInfo.getBillId();
        Assert.notNull(billId, "单据billId不能为空！");
        DeductionEntity entity = service.selectById(billId);
        VoucherParams voucherParams = VoucherParams.newInstanceByOrgId("BT210924000000001", entity, SystemCodeEnum.FINANCE);
        CommonResponse<VoucherInfo> response = voucherApi.handleVoucher(voucherParams, VoucherOptFlag.SAVE);
        if (response.isSuccess()) {
            logger.info("response: {}", DataConvertUtil.toPrettyFormat(response));
            voucherInfo = response.getData();
            LambdaUpdateWrapper<DeductionEntity> lambda = new LambdaUpdateWrapper<>();
            lambda.eq(DeductionEntity::getId, entity.getId());
            lambda.set(DeductionEntity::getVoucherInfo, DataConvertUtil.objToString(voucherInfo));
            lambda.set(DeductionEntity::getVoucherFlag, voucherInfo.getVoucherFlag());
            boolean update = service.update(lambda);
            logger.info("update: {}", update);
        }
        return response;
    }

    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<DeductionEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Deduction-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refDeductionData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<DeductionVO>> refDeductionData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                               String condition,
                                                               String searchObject,
                                                               String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);

            if (condition.contains("projectId")) {
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, _con.getLong("projectId")));
            }
            if (condition.contains("supplierId")) {
                param.getParams().put("supplierId", new Parameter(QueryParam.EQ, _con.getLong("supplierId")));
            }
        }
        param.getParams().put("isSettle", new Parameter(QueryParam.EQ, 0));
        param.getParams().put("isUse", new Parameter(QueryParam.EQ, 0));
        List<Integer> billstate = new ArrayList<>();
        //已提交 已通过
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("bill_state", new Parameter(QueryParam.IN, billstate));

        IPage<DeductionEntity> page = service.queryPage(param, false);
        IPage<DeductionVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DeductionVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    //查询项目、项目+供应商累计的扣款金额
    @RequestMapping(value = "/getTotalPenaltyMoney", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DeductionVO> getTotalPenaltyMoney(@RequestBody DeductionVO vo) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("project_id", new Parameter(QueryParam.EQ, vo.getProjectId()));
        if(vo.getSupplierId() != null){
            queryParam.getParams().put("supplier_id", new Parameter(QueryParam.EQ, vo.getSupplierId()));
        }
        List<Integer> billstate = new ArrayList<>();
        //已提交 已通过
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        queryParam.getParams().put("bill_state", new Parameter(QueryParam.IN, billstate));
        List<DeductionEntity> list = service.queryList(queryParam, false);
        vo.setPenaltyMoney(BigDecimal.ZERO);
        if (CollectionUtils.isNotEmpty(list)){
            BigDecimal totalPenaltyMoney = list.stream().map(DeductionEntity::getPenaltyMoney).collect(Collectors.toList()).stream().reduce(BigDecimal.ZERO, BigDecimal::add);
            vo.setPenaltyMoney(totalPenaltyMoney);
        }

        return CommonResponse.success("查询详情数据成功！", vo);
    }
    //查询项目+供应商没有被使用的扣款金额合计
    @RequestMapping(value = "/queryLatsDeductMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BigDecimal> queryLatsDeductMny(Long supplierId,Long projectId) {
        List<Integer> billstate = new ArrayList<>();
        //已提交 已通过
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        QueryWrapper<DeductionEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.select("IFNULL(SUM(penalty_money),0) penaltyMoney");
        queryWrapper.eq("supplier_id",supplierId);
        queryWrapper.eq("project_id",projectId);
        queryWrapper.eq("is_use",0);
        queryWrapper.in("bill_state",billstate);
        DeductionEntity one = service.getOne(queryWrapper);
        return CommonResponse.success("查询详情数据成功！", one.getPenaltyMoney());
    }

    //查询支出合同已签订的供应商
    @RequestMapping(value = "/querySupplierIds", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> querySupplierIds(Long projectId) {
        String supplierIds = service.querySupplierIds(projectId);
        return CommonResponse.success("查询详情数据成功！", supplierIds);
    }

}
