/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.accplat.consts.SystemCodeEnum;
import com.ejianc.business.finance.bean.ReceiveEntity;
import com.ejianc.business.finance.bean.ReceiveQuteDetailEntity;
import com.ejianc.business.finance.service.IReceiveInvoiceService;
import com.ejianc.business.finance.service.IReceiveQuteDetailService;
import com.ejianc.business.finance.service.IReceiveService;
import com.ejianc.business.finance.vo.ReceiveQuteDetailVO;
import com.ejianc.business.income.api.IIncomeContractApi;
import com.ejianc.business.income.vo.QuoteVo;
import com.ejianc.business.prjfinance.api.IPrjRiskMarginApi;
import com.ejianc.business.prjfinance.vo.RiskMarginTransVO;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.business.voucher.api.IVoucherApi;
import com.ejianc.business.voucher.callable.AccplatVoucherCallable;
import com.ejianc.business.voucher.consts.VoucherFlag;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.IBaseService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;

@Service(value="receive")
public class ReceiveBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IIncomeContractApi incomApi;
    @Autowired
    private IReceiveService receiveService;
    @Autowired
    private IVoucherApi voucherApi;
    @Autowired
    private IPrjRiskMarginApi prjRiskMarginApi;
    @Autowired
    private IReceiveInvoiceService invoiceService;
    @Autowired
    private IIncomeContractApi iIncomeContractApi;
    @Autowired
    private IReceiveQuteDetailService receiveQuteDetailService;
    @Autowired
    private IInvoiceApi invoiceApi;
    private static final String VOUCHER_PARAM = "P-h5UC6769";
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private HttpServletRequest request;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        Long projectId;
        ParamRegisterSetVO paramRegisterSetVO;
        String valueData;
        CommonResponse byCode;
        ReceiveEntity entity = (ReceiveEntity)((Object)this.receiveService.selectById(billId));
        this.logger.info("\u5ba1\u6279\u901a\u8fc7\u540e\u56de\u5199--- entity:" + (Object)((Object)entity));
        if (entity.getContractId() != null) {
            this.incomApi.updateCollectMny(entity.getContractId(), entity.getReceiveMny(), Boolean.valueOf(true));
        }
        if (entity.getReceiveType() != null && String.valueOf(entity.getReceiveType()).equals("1275321308270993409")) {
            RiskMarginTransVO vo = this.getRiskMarginTransVO(entity);
            CommonResponse res = this.prjRiskMarginApi.generateByRecRecord(vo);
            Object data = res.getData();
            JSONObject json = (JSONObject)JSONObject.toJSON((Object)data);
            if (res.isSuccess()) {
                this.logger.info("\u6536\u6b3e\u767b\u8bb0\u81ea\u52a8\u751f\u6210\u98ce\u9669\u4fdd\u8bc1\u91d1(\u6263)\u8fd4\u56de\u4fe1\u606f\uff1a" + json.getString("msg"));
            } else {
                this.logger.error("\u6536\u6b3e\u767b\u8bb0\u81ea\u52a8\u751f\u6210\u98ce\u9669\u4fdd\u8bc1\u91d1(\u6263)\u5931\u8d25\uff1a" + json.getString("msg"));
            }
        }
        List<ReceiveQuteDetailEntity> receiveQuteDetailList = entity.getReceiveQuteDetailList();
        ArrayList list = new ArrayList();
        if (CollectionUtil.isNotEmpty(receiveQuteDetailList)) {
            List vos = BeanMapper.mapList(receiveQuteDetailList, ReceiveQuteDetailVO.class);
            List<ReceiveQuteDetailVO> receiveQuteDetailVOS = this.receiveService.getLastReceiveTaxMny(vos);
            receiveQuteDetailVOS.forEach(item -> {
                QuoteVo quoteVo = new QuoteVo();
                quoteVo.setId(item.getQuoteId());
                quoteVo.setContractId(item.getContractId());
                quoteVo.setTotalReceiveTaxMny(item.getTotalReceiveTaxMny());
                quoteVo.setTotalContractReceiveTaxMny(item.getTotalContractReceiveTaxMny());
                list.add(quoteVo);
            });
        }
        if (CollectionUtil.isNotEmpty(list)) {
            CommonResponse commonResponse = this.iIncomeContractApi.updateReceiveTaxMny(list);
            this.logger.error("\u56de\u5199\u5199\u7532\u65b9\u62a5\u91cf\uff1a" + commonResponse.isSuccess());
        }
        if ((byCode = this.paramConfigApi.getByCode(VOUCHER_PARAM)).isSuccess() && null != byCode.getData() && ((valueData = (paramRegisterSetVO = (ParamRegisterSetVO)byCode.getData()).getValueData()).equals(String.valueOf(projectId = entity.getProjectId())) || "\u662f".equals(valueData))) {
            ExecutorService threadPool = Executors.newFixedThreadPool(1);
            String authority = this.request.getHeader("authority");
            if (authority == null) {
                this.logger.info("request-authority\u4e3a\u7a7a");
                authority = (String)InvocationInfoProxy.getExtendAttribute((String)"authority");
            }
            try {
                VoucherParams voucherParams = VoucherParams.newInstanceByOrgId((String)"BT200622000000005", (Object)((Object)entity), (SystemCodeEnum)SystemCodeEnum.FINANCE);
                AccplatVoucherCallable voucherCallable = new AccplatVoucherCallable(this.voucherApi, (IBaseService)this.receiveService, voucherParams, "save", RequestContextHolder.getRequestAttributes(), authority);
                threadPool.submit(voucherCallable);
            }
            catch (Exception e) {
                this.logger.error("\u6536\u6b3e\u767b\u8bb0\u63a8\u9001\u51ed\u8bc1\u5f02\u5e38, ", (Throwable)e);
            }
            finally {
                threadPool.shutdown();
            }
        }
        return CommonResponse.success((String)"\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    private RiskMarginTransVO getRiskMarginTransVO(ReceiveEntity entity) {
        RiskMarginTransVO riskMarginTransVO = new RiskMarginTransVO();
        riskMarginTransVO.setOperatorId(entity.getEmployeeId());
        riskMarginTransVO.setOperatorName(entity.getEmployeeName());
        riskMarginTransVO.setOrgId(entity.getOrgId());
        riskMarginTransVO.setOrgName(entity.getOrgName());
        riskMarginTransVO.setProjectId(entity.getProjectId());
        riskMarginTransVO.setProjectName(entity.getProjectName());
        riskMarginTransVO.setApplyAmt(entity.getReceiveMny());
        riskMarginTransVO.setApplyDate(entity.getConfirmTime());
        riskMarginTransVO.setSourceId(entity.getId());
        return riskMarginTransVO;
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        ReceiveEntity entity = (ReceiveEntity)((Object)this.receiveService.selectById(billId));
        if (!this.validateCreateTime(entity)) {
            return CommonResponse.error((String)"\u8be5\u5408\u540c\u5df2\u5b58\u5728\u540e\u7eed\u5355\u636e,\u4e0d\u80fd\u5f03\u5ba1!");
        }
        if (!this.validateEffective(entity)) {
            return CommonResponse.error((String)"\u8be5\u652f\u51fa\u5355\u636e\u6570\u636e\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u53ef\u8fdb\u884c\u64a4\u56de\u64cd\u4f5c!");
        }
        return CommonResponse.success((String)"\u6821\u9a8c\u901a\u8fc7");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        ReceiveEntity entity = (ReceiveEntity)((Object)this.receiveService.selectById(billId));
        this.logger.info("\u5f03\u5ba1\u540e\u56de\u5199--- entity:" + (Object)((Object)entity));
        if (entity.getContractId() != null) {
            this.incomApi.updateCollectMny(entity.getContractId(), entity.getReceiveMny(), Boolean.valueOf(false));
        }
        if (entity.getReceiveType() != null && String.valueOf(entity.getReceiveType()).equals("1275321308270993409")) {
            CommonResponse res = this.prjRiskMarginApi.delBySourceIds(Collections.singletonList(billId));
            if (res.isSuccess()) {
                this.logger.info("\u6536\u6b3e\u767b\u8bb0\u5f03\u5ba1\u81ea\u52a8\u5220\u9664\u751f\u6210\u7684\u98ce\u9669\u4fdd\u8bc1\u91d1(\u6263)\u6210\u529f\uff01");
            } else {
                this.logger.error("\u6536\u6b3e\u767b\u8bb0\u5f03\u5ba1\u81ea\u52a8\u5220\u9664\u751f\u6210\u7684\u98ce\u9669\u4fdd\u8bc1\u91d1(\u6263)\u5931\u8d25\uff01");
            }
        }
        List<ReceiveQuteDetailEntity> receiveQuteDetailList = entity.getReceiveQuteDetailList();
        ArrayList list = new ArrayList();
        if (CollectionUtil.isNotEmpty(receiveQuteDetailList)) {
            List vos = BeanMapper.mapList(receiveQuteDetailList, ReceiveQuteDetailVO.class);
            List<ReceiveQuteDetailVO> receiveQuteDetailVOS = this.receiveService.getLastReceiveTaxMny(vos);
            receiveQuteDetailVOS.forEach(item -> {
                QuoteVo quoteVo = new QuoteVo();
                quoteVo.setId(item.getQuoteId());
                quoteVo.setContractId(item.getContractId());
                quoteVo.setTotalReceiveTaxMny(item.getTotalReceiveTaxMny());
                quoteVo.setTotalContractReceiveTaxMny(item.getTotalContractReceiveTaxMny());
                list.add(quoteVo);
            });
        }
        if (CollectionUtil.isNotEmpty(list)) {
            CommonResponse commonResponse = this.iIncomeContractApi.updateReceiveTaxMny(list);
            this.logger.error("\u56de\u5199\u5199\u7532\u65b9\u62a5\u91cf\uff1a" + commonResponse.isSuccess());
        }
        if (VoucherFlag.SUCCESS.equals(entity.getVoucherFlag())) {
            ExecutorService threadPool = Executors.newFixedThreadPool(1);
            String authority = this.request.getHeader("authority");
            if (authority == null) {
                this.logger.info("request-authority\u4e3a\u7a7a");
                authority = (String)InvocationInfoProxy.getExtendAttribute((String)"authority");
            }
            try {
                VoucherParams voucherParams = VoucherParams.newInstanceByOrgId((String)"BT200622000000005", (Object)((Object)entity), (SystemCodeEnum)SystemCodeEnum.FINANCE);
                AccplatVoucherCallable voucherCallable = new AccplatVoucherCallable(this.voucherApi, (IBaseService)this.receiveService, voucherParams, "del", RequestContextHolder.getRequestAttributes(), authority);
                threadPool.submit(voucherCallable);
            }
            catch (Exception e) {
                this.logger.error("\u6536\u6b3e\u767b\u8bb0\u64a4\u56de\u51ed\u8bc1\u5f02\u5e38, ", (Throwable)e);
            }
            finally {
                threadPool.shutdown();
            }
        }
        return CommonResponse.success((String)"\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    private boolean validateEffective(ReceiveEntity entity) {
        Long contractId = entity.getContractId();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"contract_id", (Object)contractId);
        wrapper.eq((Object)"org_id", (Object)entity.getOrgId());
        wrapper.ne((Object)"bill_state", (Object)1);
        wrapper.ne((Object)"bill_state", (Object)3);
        List list = this.receiveService.list((Wrapper)wrapper);
        return list.isEmpty();
    }

    private boolean validateCreateTime(ReceiveEntity entity) {
        Long contractId = entity.getContractId();
        Date createTime = entity.getCreateTime();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"contract_id", (Object)contractId);
        wrapper.eq((Object)"org_id", (Object)entity.getOrgId());
        wrapper.gt((Object)"create_time", (Object)createTime);
        List list = this.receiveService.list((Wrapper)wrapper);
        return list.isEmpty();
    }
}

