/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.bean.PayContractEntity;
import com.ejianc.business.finance.bean.PayFocusEntity;
import com.ejianc.business.finance.service.IPayContractService;
import com.ejianc.business.finance.service.IPayFocusService;
import com.ejianc.business.finance.utils.DateUtil;
import com.ejianc.business.finance.vo.PayFocusVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"payFocus"})
public class PayFocusController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "PAY_FUCOS";
    @Autowired
    private IPayFocusService service;
    @Autowired
    private IPayContractService payContractService;
    @Autowired
    private ICommonBusinessService payFocus;
    @Autowired
    private EnvironmentTools environmentTools;
    private static final String DEFAULT_TEMPLATE_CODE = "SMS_273725524";
    private static final String TEMPLATE_CODE = "templateCode";

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PayFocusVO> saveOrUpdate(@RequestBody PayFocusVO saveOrUpdateVO) {
        PayFocusVO backVO = this.service.insertOrUpdate(saveOrUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)backVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PayFocusVO> queryDetail(Long id) {
        PayFocusEntity entity = (PayFocusEntity)((Object)this.service.selectById(id));
        PayFocusVO vo = (PayFocusVO)BeanMapper.map((Object)((Object)entity), PayFocusVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PayFocusVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (PayFocusVO payFocusVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PayFocusVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("receiveUnitName");
        fuzzyFields.add("applyUserName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PayFocusVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List vos = BeanMapper.mapList((Iterable)list, PayFocusVO.class);
        for (PayFocusVO vo : vos) {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", vos);
        ExcelExport.getInstance().export("focus-payapply-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refPayFocusData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PayFocusVO>> refPayFocusData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PayFocusVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/checkPayFocus"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> checkPayFocus(HttpServletRequest request) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BaseEntity::getTenantId, (Object)1438754657728655362L);
        wrapper.in(PayFocusEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        wrapper.gt(BaseEntity::getUpdateTime, (Object)DateUtil.getCurrentDay(null));
        List list = this.service.list((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            this.logger.info("start" + DateUtil.getCurrentDay("yyyy-MM-dd HH:mm:ss") + "\u4eca\u5929\u6709" + list.size() + "\u4e2a\u5ba1\u6279\u901a\u8fc7\u7684\u5355\u636e\uff01");
            for (PayFocusEntity payFocusEntity : list) {
                Long focusEntityId = payFocusEntity.getId();
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(PayContractEntity::getPayFocusId, (Object)focusEntityId);
                int count = this.payContractService.count((Wrapper)queryWrapper);
                if (count != 0) continue;
                this.logger.info("\u96c6\u4e2d\u4ed8\u6b3eid\u4e3a\uff1a" + focusEntityId + "\uff0c\u6ca1\u6709\u751f\u6210\u5355\u636e\uff01");
                try {
                    this.sendVerifyCode("13598006631", "\u4e16\u7eaa\u9633\u5149", DateUtil.getCurrentDay(null), "\u96c6\u4e2d\u4ed8\u6b3e\u672a\u751f\u6210payFocusIds:" + focusEntityId, "0", null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.logger.info("end" + DateUtil.getCurrentDay("yyyy-MM-dd HH:mm:ss") + "\u4eca\u5929\u6709" + list.size() + "\u4e2a\u5ba1\u6279\u901a\u8fc7\u7684\u5355\u636e\uff01");
        } else {
            this.logger.info(DateUtil.getCurrentDay("yyyy-MM-dd HH:mm:ss") + "\u4eca\u5929\u6ca1\u6709\u5ba1\u6279\u901a\u8fc7\u7684\u5355\u636e\uff01");
        }
        return CommonResponse.success((String)"\u96c6\u4e2d\u4ed8\u6b3e\u63a8\u9001\u4ed8\u6b3e\u7533\u8bf7\u68c0\u67e5\u4efb\u52a1\u6267\u884c\u6210\u529f\uff01");
    }

    public void sendVerifyCode(String phone, String userName, String publishTime, String title, String amount, String templateCode) throws Exception {
        Assert.hasText((String)phone, (String)"\u7535\u8bdd\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject messageParam = new JSONObject();
        messageParam.put("phone", (Object)phone);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userName", userName);
        params.put("publishTime", publishTime);
        params.put("title", title);
        params.put("amount", amount);
        messageParam.put("params", params);
        if (StringUtils.isBlank((CharSequence)templateCode)) {
            messageParam.put(TEMPLATE_CODE, (Object)DEFAULT_TEMPLATE_CODE);
        } else {
            messageParam.put(TEMPLATE_CODE, (Object)templateCode);
        }
        this.logger.info("\u53d1\u9001\u77ed\u4fe1\u53c2\u6570\uff1a[{}]", (Object)messageParam);
        String messageUrl = this.environmentTools.getBaseHost() + "/ejc-message-web/no_auth/sms/sendMessage";
        String responseStr = HttpTookit.postByJson((String)messageUrl, (String)JSON.toJSONString((Object)messageParam));
        this.logger.info("\u5411\u624b\u673a\u53f7[{}]\u53d1\u9001\u77ed\u4fe1\u7ed3\u679c\uff1a[{}]", (Object)phone, (Object)responseStr);
        CommonResponse response = (CommonResponse)JSON.parseObject((String)responseStr, CommonResponse.class);
        if (!response.isSuccess()) {
            throw new BusinessException("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff01");
        }
    }
}

