package com.ejianc.business.finance.bean;

import java.math.BigDecimal;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.io.Serializable;

/**
 * <p>
 * 保证金办理表
 * </p>
 *
 * @author sunyj
 * @since 2020-06-16
 */
@TableName("ejc_finance_bond_up_deal")
public class BondUpDealEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 保证金主键
     */
    @TableField("bond_id")
    private Long bondId;

    /**
     * 保证函编号
     */
    @TableField("bill_code")
    private String billCode;

    /**
     * 保证金类型 1-投标保证金，2-履约保证金，3-质量保证金
     */
    @TableField("bond_type")
    private Long bondType;


    /**
     * 保证金金额
     */
    @TableField("bond_mny")
    private BigDecimal bondMny;

    /**
     * 开具银行
     */
    @TableField("bank_names")
    private String bankNames;

    /**
     * 开立时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField("begin_date")
    private Date beginDate;
    /**
     * 推送凭证标识
     */
    @TableField("voucher_flag")
    private Integer voucherFlag;

    /**
     * 凭证信息json
     */
    @TableField("voucher_info")
    private String voucherInfo;

    /**
     * 有效期至
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField("end_date")
    private Date endDate;

    /**
     * 账户名
     */
    @TableField("account_name")
    private String accountName;

    /**
     * 银行账号
     */
    @TableField("bank_account")
    private String bankAccount;

    /**
     * 开户行
     */
    @TableField("bank_name")
    private String bankName;

    /**
     * 备注
     */
    @TableField("memo")
    private String memo;

    /**
     * 办理时间
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @TableField("deal_date")
    private Date dealDate;

    /**
     * 办理状态:1-生效，2-已作废
     */
    @TableField("deal_status")
    private String dealStatus;

    /**
     * 经办人
     */
    @TableField("employee_id")
    private Long employeeId;
    @TableField(value="pay_account_name")
    private String payAccountName; // 账户名
    @TableField(value="pay_account_num")
    private String payAccountNum; // 银行账号
    @TableField(value="pay_account_bank")
    private String payAccountBank; // 开户行
    @TableField(value="pay_account_id")
    private Long payAccountId; // 账户名
    /**
     * 经办人名称
     */
    @TableField("employee_name")
    private String employeeName;

    /**
     * 办理时间
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @TableField("deal_time")
    private Date dealTime;

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Long getBondId() {
        return bondId;
    }

    public void setBondId(Long bondId) {
        this.bondId = bondId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Long getBondType() {
        return bondType;
    }

    public void setBondType(Long bondType) {
        this.bondType = bondType;
    }

    public BigDecimal getBondMny() {
        return bondMny;
    }

    public String getPayAccountName() {
        return payAccountName;
    }

    public void setPayAccountName(String payAccountName) {
        this.payAccountName = payAccountName;
    }

    public String getPayAccountNum() {
        return payAccountNum;
    }

    public void setPayAccountNum(String payAccountNum) {
        this.payAccountNum = payAccountNum;
    }

    public String getPayAccountBank() {
        return payAccountBank;
    }

    public void setPayAccountBank(String payAccountBank) {
        this.payAccountBank = payAccountBank;
    }

    public Long getPayAccountId() {
        return payAccountId;
    }

    public void setPayAccountId(Long payAccountId) {
        this.payAccountId = payAccountId;
    }

    public Integer getVoucherFlag() {
        return voucherFlag;
    }

    public void setVoucherFlag(Integer voucherFlag) {
        this.voucherFlag = voucherFlag;
    }

    public String getVoucherInfo() {
        return voucherInfo;
    }

    public void setVoucherInfo(String voucherInfo) {
        this.voucherInfo = voucherInfo;
    }

    public void setBondMny(BigDecimal bondMny) {
        this.bondMny = bondMny;
    }
    public String getBankNames() {
        return bankNames;
    }

    public void setBankNames(String bankNames) {
        this.bankNames = bankNames;
    }
    public Date getBeginDate() {
        return beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }
    public String getBankAccount() {
        return bankAccount;
    }

    public void setBankAccount(String bankAccount) {
        this.bankAccount = bankAccount;
    }
    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Date getDealDate() {
        return dealDate;
    }

    public void setDealDate(Date dealDate) {
        this.dealDate = dealDate;
    }
    public String getDealStatus() {
        return dealStatus;
    }

    public void setDealStatus(String dealStatus) {
        this.dealStatus = dealStatus;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public Date getDealTime() {
        return dealTime;
    }

    public void setDealTime(Date dealTime) {
        this.dealTime = dealTime;
    }

}
