package com.ejianc.business.finance.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.bean.PayContractEntity;
import com.ejianc.business.finance.bean.PayFocusEntity;
import com.ejianc.business.finance.service.IPayContractService;
import com.ejianc.business.finance.service.IPayFocusService;
import com.ejianc.business.finance.utils.DateUtil;
import com.ejianc.business.finance.vo.PayFocusVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 集中付款申请实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("payFocus")
public class PayFocusController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "PAY_FUCOS";//此处需要根据实际修改

    @Autowired
    private IPayFocusService service;

    @Autowired
    private IPayContractService payContractService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PayFocusVO> saveOrUpdate(@RequestBody PayFocusVO saveOrUpdateVO) {
        PayFocusVO backVO = service.insertOrUpdate(saveOrUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！",backVO);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PayFocusVO> queryDetail(Long id) {
    	PayFocusEntity entity = service.selectById(id);
    	PayFocusVO vo = BeanMapper.map(entity, PayFocusVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PayFocusVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (PayFocusVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(PayFocusVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PayFocusVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("receiveUnitName");
        fuzzyFields.add("applyUserName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<PayFocusEntity> page = service.queryPage(param,false);
        IPage<PayFocusVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), PayFocusVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<PayFocusEntity> list = service.queryList(param);
        List<PayFocusVO> vos = BeanMapper.mapList(list, PayFocusVO.class);
        for (PayFocusVO vo : vos) {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", vos);
        ExcelExport.getInstance().export("focus-payapply-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refPayFocusData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PayFocusVO>> refPayFocusData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<PayFocusEntity> page = service.queryPage(param,false);
        IPage<PayFocusVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PayFocusVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }


    @Autowired
    private ICommonBusinessService payFocus;

    @Autowired
    private EnvironmentTools environmentTools;

    private static final String DEFAULT_TEMPLATE_CODE = "SMS_273725524";
    private static final String TEMPLATE_CODE = "templateCode";


    /**
     * @description: 定时任务：集中付款推送付款申请检查任务
     *
     * @param request
     * @return {@link CommonResponse< String>}
     * @author songlx
     * @date: 2024/11/25
     */
    @RequestMapping(value = "/checkPayFocus", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> checkPayFocus(HttpServletRequest request) {
        LambdaQueryWrapper<PayFocusEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(PayFocusEntity::getTenantId, 1438754657728655362L);
        wrapper.in(PayFocusEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        wrapper.gt(PayFocusEntity::getUpdateTime, DateUtil.getCurrentDay(null));
        List<PayFocusEntity> list = service.list(wrapper);
        if (CollectionUtils.isNotEmpty(list)) {
            logger.info("start" + DateUtil.getCurrentDay(DateUtil.DATE_TIME) + "今天有" + list.size() + "个审批通过的单据！");
            for (PayFocusEntity payFocusEntity : list) {
                Long focusEntityId = payFocusEntity.getId();
                LambdaQueryWrapper<PayContractEntity> queryWrapper = new LambdaQueryWrapper<>();
                queryWrapper.eq(PayContractEntity::getPayFocusId, focusEntityId);
                int count = payContractService.count(queryWrapper);
                if (count == 0) {
                    logger.info("集中付款id为：" + focusEntityId + "，没有生成单据！");
                    try {
                        sendVerifyCode("13598006631", "世纪阳光", DateUtil.getCurrentDay(null), "集中付款未生成payFocusIds:" + focusEntityId,
                                "0", null);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                    //payFocus.afterApprovalProcessor(focusEntityId, null, null);
                }
            }
            logger.info("end" + DateUtil.getCurrentDay(DateUtil.DATE_TIME) + "今天有" + list.size() + "个审批通过的单据！");
        } else {
            logger.info(DateUtil.getCurrentDay(DateUtil.DATE_TIME) + "今天没有审批通过的单据！");
        }
        return CommonResponse.success("集中付款推送付款申请检查任务执行成功！");
    }

    /**
     *  发送短信
     * @param phone 手机号
     * @param userName 联系人姓名
     * @param publishTime 时间
     * @param title 询价主题
     * @param amount 金额
     * @param templateCode 模板编号
     * @throws Exception 异常
     */
    public void sendVerifyCode(String phone, String userName, String publishTime, String title, String amount, String templateCode) throws Exception {
        Assert.hasText(phone, "电话号码不能为空！");
        JSONObject messageParam = new JSONObject();
        messageParam.put("phone", phone);
        Map<String, String> params = new HashMap<>();
        params.put("userName", userName);
        params.put("publishTime", publishTime);
        params.put("title", title);
        params.put("amount", amount);
        messageParam.put("params", params);
        if (StringUtils.isBlank(templateCode)) {
            messageParam.put(TEMPLATE_CODE, DEFAULT_TEMPLATE_CODE);
        } else {
            messageParam.put(TEMPLATE_CODE, templateCode);
        }
        logger.info("发送短信参数：[{}]", messageParam);
        String messageUrl = environmentTools.getBaseHost() + "/ejc-message-web/no_auth/sms/sendMessage";
        String responseStr = HttpTookit.postByJson(messageUrl, JSON.toJSONString(messageParam));
        logger.info("向手机号[{}]发送短信结果：[{}]", phone, responseStr);
        CommonResponse<String> response = JSON.parseObject(responseStr, CommonResponse.class);
        if (!response.isSuccess()) {
            throw new BusinessException("短信发送失败！");
        }
    }


}
