package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.finance.bean.BondDownBackEntity;
import com.ejianc.business.finance.bean.BondDownEntity;
import com.ejianc.business.finance.mapper.BondDownBackMapper;
import com.ejianc.business.finance.service.IBondDownBackService;
import com.ejianc.business.finance.service.IBondDownService;
import com.ejianc.business.finance.vo.BondDownBackVO;
import com.ejianc.business.finance.vo.BondDownDealRentVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 保证金退还表 服务实现类
 * </p>
 *
 * @author sunyj
 * @since 2020-06-16
 */
@Service
public class BondDownBackServiceImpl extends BaseServiceImpl<BondDownBackMapper, BondDownBackEntity> implements IBondDownBackService {
    private static final String BONGDOWN_BACK = "BONGDOWN_BACK";

    @Autowired
    private IBondDownService bondDownService;

    @Autowired
    private IBillCodeApi billCodeApi;

    @Override
    public BondDownBackVO insertOrUpdate(BondDownBackVO bondDownBackVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<BondDownBackEntity> entities = null;
        if(StringUtils.isEmpty(bondDownBackVO.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BONGDOWN_BACK,tenantId);
            if(billCode.isSuccess()) {
                bondDownBackVO.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        BondDownBackEntity entity = BeanMapper.map(bondDownBackVO, BondDownBackEntity.class);
        if(null!=bondDownBackVO.getId()&&bondDownBackVO.getId()>0){
            //编辑
            LambdaQueryWrapper<BondDownBackEntity> lambda = Wrappers.<BondDownBackEntity>lambdaQuery();
            lambda.eq(BondDownBackEntity::getBillCode, bondDownBackVO.getBillCode());
            lambda.eq(BondDownBackEntity::getTenantId, tenantId);
            lambda.ne(BondDownBackEntity::getId, bondDownBackVO.getId());
            entities = super.list(lambda);
        }else{
            //新增
            //校验合同编号是否重复
            LambdaQueryWrapper<BondDownBackEntity> lambda = Wrappers.<BondDownBackEntity>lambdaQuery();
            lambda.eq(BondDownBackEntity::getTenantId, tenantId);
            lambda.eq(BondDownBackEntity::getBillCode, bondDownBackVO.getBillCode());
            entities = super.list(lambda);
        }
        if(entities != null && entities.size() > 0 ) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }
        entity.setBackTime(new Date());
        super.saveOrUpdate(entity,false);
        //回写申请单
        BondDownEntity upentity= bondDownService.selectById(bondDownBackVO.getBondId());
        BigDecimal sumBackMny = upentity.getBackMny()==null?BigDecimal.ZERO:upentity.getBackMny();
        BigDecimal applyMny = upentity.getApplyMny()==null?BigDecimal.ZERO:upentity.getApplyMny();
        if(applyMny.compareTo(sumBackMny.add(entity.getBackMny()))<0){
            throw new BusinessException("本次退还金额不能超过剩余金额!");
        }
        LambdaUpdateWrapper<BondDownEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(BondDownEntity::getId,entity.getBondId());
        updateWrapper.set(BondDownEntity::getBackMny,sumBackMny.add(entity.getBackMny()));
        bondDownService.update(updateWrapper);
        return BeanMapper.map(entity, BondDownBackVO.class);
    }

    @Override
    public BondDownDealRentVO queryDetail(Long id) {
        BondDownDealRentVO vo = new BondDownDealRentVO();
        BondDownEntity upEntity = bondDownService.selectById(id);
        LambdaQueryWrapper<BondDownBackEntity> lambda = Wrappers.<BondDownBackEntity>lambdaQuery();
        lambda.eq(BondDownBackEntity::getBondId, id);
        lambda.orderBy(true,false,BondDownBackEntity::getBackTime);
        List<BondDownBackEntity> list = super.list(lambda);
        vo.setId(id);
        vo.setBondStatus(upEntity.getBondStatus());
        vo.setContractId(upEntity.getContractId());
        vo.setContractName(upEntity.getContractName());
        vo.setApplyMny(upEntity.getApplyMny()==null?BigDecimal.ZERO:upEntity.getApplyMny());
        vo.setContractTaxMny(upEntity.getContractTaxMny()==null?BigDecimal.ZERO:upEntity.getContractTaxMny());
        vo.setBackMny(upEntity.getBackMny()==null?BigDecimal.ZERO:upEntity.getBackMny());
        vo.setSurplusMny(vo.getApplyMny().subtract(vo.getBackMny()));
        if(CollectionUtils.isNotEmpty(list)){
            vo.setBackRecord(BeanMapper.mapList(list,BondDownBackVO.class));
        }
        return vo;
    }

}
