package com.ejianc.business.finance.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.finance.bean.DeductionEntity;
import com.ejianc.business.finance.mapper.DeductionMapper;
import com.ejianc.business.finance.service.IDeductionService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import jodd.util.StringUtil;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * 扣款单
 *
 * @author generator
 *
 */
@Service("deductionService")
public class DeductionServiceImpl extends BaseServiceImpl<DeductionMapper, DeductionEntity> implements IDeductionService {
    @Autowired
    private DeductionMapper deductionMapper;
    private final static String INDEX_NAME_PAY_CONTRACT ="pay_contract";
    @Autowired(required = false)
    private RestHighLevelClient client;
    private final static Integer QUERY_TIMEOUT = 60;


    @Override
    public String querySupplierIds(Long projectId) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        boolQuery.must(QueryBuilders.termQuery("tenantId", InvocationInfoProxy.getTenantid().toString()));
        boolQuery.must(QueryBuilders.termQuery("projectId", projectId));
        SearchRequest searchRequest = new SearchRequest(INDEX_NAME_PAY_CONTRACT);
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.from(0);
        sourceBuilder.size(10000);
        sourceBuilder.query(boolQuery);
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue(QUERY_TIMEOUT, TimeUnit.SECONDS)); //设置超时时间
        searchRequest.source(sourceBuilder);
        HashSet hashSet = new HashSet();
        SearchResponse response = null;
        try {
            response = client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = response.getHits();
            for (SearchHit hit : hits) {
                String sourceAsString = hit.getSourceAsString();
                JSONObject jsonObject = JSON.parseObject(sourceAsString);
                hashSet.add(jsonObject.get("supplierId"));
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        String supplierIds = StringUtil.join(hashSet, ",");
        return supplierIds;


    }
}
