package com.ejianc.business.finance.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.finance.bean.ReimburseShareDetailEntity;
/**
 * 报销费用分摊
 * 
 * @author generator
 * 
 */
 @TableName("ejc_finance_reimburse_share")
public class ReimburseShareEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
    @TableField(value="reimburse_id")
    private Long reimburseId; // 费用报销主表id
    @TableField(value="reimburse_code")
    private String reimburseCode; // 费用报销编码
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="fee_type")
    private Long feeType; // 费用类别
    @TableField(value="fee_type_name")
    private String feeTypeName; // 费用类别名称
    @TableField(value="reimburse_date")
    private Date reimburseDate; // 报销日期
    @TableField(value="reimburse_reason")
    private String reimburseReason; // 报销事由
    @TableField(value="reimburse_mny")
    private BigDecimal reimburseMny; // 报销金额
    @TableField(value="reimburse_mny_cn")
    private String reimburseMnyCn; // 报销金额大写
    @TableField(value="bli_date")
    private Date bliDate; // 单据日期
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="last_share_mny")
    private BigDecimal lastShareMny; // 已分摊金额(不含本次)
    @TableField(value="total_share_mny")
    private BigDecimal totalShareMny; // 已分摊金额(含本次)
    @TableField(value="surplus_share_mny")
    private BigDecimal surplusShareMny; // 本次可分摊金额
    @TableField(value="sum_share_mny")
    private BigDecimal sumShareMny; // 本次分摊金额合计
    @TableField(value="share_ratio")
    private BigDecimal shareRatio; // 本次分摊比例
    @TableField(value="memo")
    private String memo; // 备注
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="reimburseShareDetailService",pidName ="shareId")//此处有pid="xxx"，默认值pid="pid"
    private List<ReimburseShareDetailEntity> reimburseShareDetailList = new ArrayList<>(); // 报销费用分摊子表
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getReimburseId() {
        return reimburseId;
    }

    public void setReimburseId(Long reimburseId) {
        this.reimburseId = reimburseId;
    }
    public String getReimburseCode() {
        return reimburseCode;
    }

    public void setReimburseCode(String reimburseCode) {
        this.reimburseCode = reimburseCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getFeeType() {
        return feeType;
    }

    public void setFeeType(Long feeType) {
        this.feeType = feeType;
    }
    public String getFeeTypeName() {
        return feeTypeName;
    }

    public void setFeeTypeName(String feeTypeName) {
        this.feeTypeName = feeTypeName;
    }
    public Date getReimburseDate() {
        return reimburseDate;
    }

    public void setReimburseDate(Date reimburseDate) {
        this.reimburseDate = reimburseDate;
    }
    public String getReimburseReason() {
        return reimburseReason;
    }

    public void setReimburseReason(String reimburseReason) {
        this.reimburseReason = reimburseReason;
    }
    public BigDecimal getReimburseMny() {
        return reimburseMny;
    }

    public void setReimburseMny(BigDecimal reimburseMny) {
        this.reimburseMny = reimburseMny;
    }
    public String getReimburseMnyCn() {
        return reimburseMnyCn;
    }

    public void setReimburseMnyCn(String reimburseMnyCn) {
        this.reimburseMnyCn = reimburseMnyCn;
    }
    public Date getBliDate() {
        return bliDate;
    }

    public void setBliDate(Date bliDate) {
        this.bliDate = bliDate;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public BigDecimal getLastShareMny() {
        return lastShareMny;
    }

    public void setLastShareMny(BigDecimal lastShareMny) {
        this.lastShareMny = lastShareMny;
    }
    public BigDecimal getTotalShareMny() {
        return totalShareMny;
    }

    public void setTotalShareMny(BigDecimal totalShareMny) {
        this.totalShareMny = totalShareMny;
    }
    public BigDecimal getSurplusShareMny() {
        return surplusShareMny;
    }

    public void setSurplusShareMny(BigDecimal surplusShareMny) {
        this.surplusShareMny = surplusShareMny;
    }
    public BigDecimal getSumShareMny() {
        return sumShareMny;
    }

    public void setSumShareMny(BigDecimal sumShareMny) {
        this.sumShareMny = sumShareMny;
    }
    public BigDecimal getShareRatio() {
        return shareRatio;
    }

    public void setShareRatio(BigDecimal shareRatio) {
        this.shareRatio = shareRatio;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
    public List<ReimburseShareDetailEntity> getReimburseShareDetailList() {
        return reimburseShareDetailList;
    }

    public void setReimburseShareDetailList(List<ReimburseShareDetailEntity> reimburseShareDetailList) {
        this.reimburseShareDetailList = reimburseShareDetailList;
    }
}
